/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.BreakpointStepMethodFilter;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.LightOrRealThreadInfo;
import com.intellij.debugger.engine.RealThreadInfo;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextListener;
import com.intellij.debugger.impl.DebuggerManagerImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.ui.breakpoints.AnyExceptionBreakpoint;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointCategory;
import com.intellij.debugger.ui.breakpoints.BreakpointDefaults;
import com.intellij.debugger.ui.breakpoints.BreakpointLogMessageListener;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.debugger.ui.breakpoints.CollectionBreakpoint;
import com.intellij.debugger.ui.breakpoints.ExceptionBreakpoint;
import com.intellij.debugger.ui.breakpoints.FieldBreakpoint;
import com.intellij.debugger.ui.breakpoints.JavaBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaBreakpointsUsageCollector;
import com.intellij.debugger.ui.breakpoints.JavaCollectionBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaExceptionBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaFieldBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaMethodBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaWildcardMethodBreakpointType;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.debugger.ui.breakpoints.MethodBreakpoint;
import com.intellij.debugger.ui.breakpoints.RunToCursorBreakpoint;
import com.intellij.debugger.ui.breakpoints.StepIntoBreakpoint;
import com.intellij.debugger.ui.breakpoints.SyntheticBreakpoint;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.platform.debugger.impl.shared.proxy.XBreakpointProxy;
import com.intellij.psi.PsiField;
import com.intellij.util.CoroutineScopeKt;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.actions.EditBreakpointAction;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XDependentBreakpointManager;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import com.intellij.xdebugger.impl.proxy.MonolithBreakpointProxyKt;
import com.jetbrains.jdi.EventRequestManagerImpl;
import com.sun.jdi.InternalException;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.InvalidRequestStateException;
import java.util.EventListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.stream.Stream;
import kotlinx.coroutines.CoroutineScope;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaExceptionBreakpointProperties;
import org.jetbrains.java.debugger.breakpoints.properties.JavaLineBreakpointProperties;
import org.jetbrains.java.debugger.breakpoints.properties.JavaMethodBreakpointProperties;

public class BreakpointManager {
    private static final Logger LOG = Logger.getInstance(BreakpointManager.class);
    @NonNls
    private static final String MASTER_BREAKPOINT_TAG_NAME = "master_breakpoint";
    @NonNls
    private static final String SLAVE_BREAKPOINT_TAG_NAME = "slave_breakpoint";
    @NonNls
    private static final String DEFAULT_SUSPEND_POLICY_ATTRIBUTE_NAME = "default_suspend_policy";
    @NonNls
    private static final String DEFAULT_CONDITION_STATE_ATTRIBUTE_NAME = "default_condition_enabled";
    @NonNls
    private static final String RULES_GROUP_NAME = "breakpoint_rules";
    private static final String CONVERTED_PARAM = "converted";
    private final Project myProject;
    private final Map<String, String> myUIProperties;
    private final EventDispatcher<BreakpointLogMessageListener> myLogMessageDispatcher;
    private final Map<String, Element> myOriginalBreakpointsNodes;

    public BreakpointManager(@NotNull Project project, @NotNull DebuggerManagerImpl debuggerManager) {
        if (project == null) {
            BreakpointManager.$$$reportNull$$$0(0);
        }
        if (debuggerManager == null) {
            BreakpointManager.$$$reportNull$$$0(1);
        }
        this.myUIProperties = new LinkedHashMap<String, String>();
        this.myLogMessageDispatcher = EventDispatcher.create(BreakpointLogMessageListener.class);
        this.myOriginalBreakpointsNodes = new LinkedHashMap<String, Element>();
        this.myProject = project;
        debuggerManager.getContextManager().addListener(new DebuggerContextListener(){
            private DebuggerSession myPreviousSession;

            @Override
            public void changeEvent(@NotNull DebuggerContextImpl newContext, DebuggerSession.Event event) {
                if (newContext == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (event == DebuggerSession.Event.ATTACHED) {
                    for (XBreakpoint breakpoint : BreakpointManager.this.getXBreakpointManager().getAllBreakpoints()) {
                        if (BreakpointManager.checkAndNotifyPossiblySlowBreakpoint(breakpoint)) break;
                    }
                }
                if (newContext.getDebuggerSession() != this.myPreviousSession || event == DebuggerSession.Event.DETACHED) {
                    BreakpointManager.this.updateBreakpointsUI();
                    this.myPreviousSession = newContext.getDebuggerSession();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newContext", "com/intellij/debugger/ui/breakpoints/BreakpointManager$1", "changeEvent"));
            }
        });
    }

    private static boolean checkAndNotifyPossiblySlowBreakpoint(XBreakpoint breakpoint) {
        XBreakpointProperties properties = breakpoint.getProperties();
        if (breakpoint.isEnabled() && properties instanceof JavaMethodBreakpointProperties) {
            JavaMethodBreakpointProperties javaProperties = (JavaMethodBreakpointProperties)properties;
            if (!javaProperties.EMULATED) {
                XDebuggerManagerImpl.getNotificationGroup().createNotification(JavaDebuggerBundle.message((String)"method.breakpoints.slowness.warning", (Object[])new Object[0]), MessageType.WARNING).notify(((XBreakpointBase)breakpoint).getProject());
                return true;
            }
        }
        return false;
    }

    public void addListeners(@NotNull MessageBusConnection busConnection) {
        if (busConnection == null) {
            BreakpointManager.$$$reportNull$$$0(2);
        }
        busConnection.subscribe(XBreakpointListener.TOPIC, (Object)new XBreakpointListener<XBreakpoint<?>>(this){

            public void breakpointAdded(@NotNull XBreakpoint<?> xBreakpoint) {
                Breakpoint<?> breakpoint;
                if (xBreakpoint == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((breakpoint = BreakpointManager.getJavaBreakpoint(xBreakpoint)) != null) {
                    BreakpointManager.addBreakpoint(breakpoint);
                    JavaBreakpointsUsageCollector.reportNewBreakpoint(breakpoint, xBreakpoint.getType());
                }
            }

            public void breakpointChanged(@NotNull XBreakpoint xBreakpoint) {
                Breakpoint<?> breakpoint;
                if (xBreakpoint == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ((breakpoint = BreakpointManager.getJavaBreakpoint(xBreakpoint)) != null) {
                    ReadAction.run(() -> {
                        breakpoint.scheduleReload();
                        breakpoint.updateUI();
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "xBreakpoint";
                objectArray2[1] = "com/intellij/debugger/ui/breakpoints/BreakpointManager$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "breakpointAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "breakpointChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private XBreakpointManager getXBreakpointManager() {
        return XDebuggerManager.getInstance((Project)this.myProject).getBreakpointManager();
    }

    public void editBreakpoint(Breakpoint breakpoint, Editor editor) {
        DebuggerInvocationUtil.invokeLaterAnyModality(this.myProject, () -> {
            GutterIconRenderer renderer;
            XLineBreakpointImpl xLineBreakpoint;
            RangeHighlighter highlighter;
            XBreakpoint xBreakpoint = breakpoint.myXBreakpoint;
            if (xBreakpoint instanceof XLineBreakpointImpl && (highlighter = (xLineBreakpoint = (XLineBreakpointImpl)xBreakpoint).getHighlighter()) != null && (renderer = highlighter.getGutterIconRenderer()) != null) {
                EditBreakpointAction.HANDLER.editBreakpoint(this.myProject, editor, (XBreakpointProxy)MonolithBreakpointProxyKt.asProxy((XLineBreakpointImpl)xLineBreakpoint), renderer);
            }
        });
    }

    public void setBreakpointDefaults(Key<? extends Breakpoint> category, BreakpointDefaults defaults) {
        Class typeCls = null;
        if (LineBreakpoint.CATEGORY.toString().equals(category.toString())) {
            typeCls = JavaLineBreakpointType.class;
        } else if (MethodBreakpoint.CATEGORY.toString().equals(category.toString())) {
            typeCls = JavaMethodBreakpointType.class;
        } else if (FieldBreakpoint.CATEGORY.toString().equals(category.toString())) {
            typeCls = JavaFieldBreakpointType.class;
        } else if (ExceptionBreakpoint.CATEGORY.toString().equals(category.toString())) {
            typeCls = JavaExceptionBreakpointType.class;
        } else if (CollectionBreakpoint.CATEGORY.toString().equals(category.toString())) {
            typeCls = JavaCollectionBreakpointType.class;
        }
        if (typeCls != null) {
            XBreakpointType type = XDebuggerUtil.getInstance().findBreakpointType(typeCls);
            ((XBreakpointManagerImpl)this.getXBreakpointManager()).getBreakpointDefaults(type).setSuspendPolicy(Breakpoint.transformSuspendPolicy(defaults.getSuspendPolicy()));
        }
    }

    @Nullable
    public RunToCursorBreakpoint addRunToCursorBreakpoint(@NotNull XSourcePosition position, boolean ignoreBreakpoints) {
        if (position == null) {
            BreakpointManager.$$$reportNull$$$0(3);
        }
        return RunToCursorBreakpoint.create(this.myProject, position, ignoreBreakpoints);
    }

    @Nullable
    public StepIntoBreakpoint addStepIntoBreakpoint(@NotNull BreakpointStepMethodFilter filter) {
        if (filter == null) {
            BreakpointManager.$$$reportNull$$$0(4);
        }
        return StepIntoBreakpoint.create(this.myProject, filter);
    }

    @Nullable
    public LineBreakpoint<?> addLineBreakpoint(Document document, int lineIndex, Consumer<JavaLineBreakpointProperties> setupAction) {
        ThreadingAssertions.assertEventDispatchThread();
        if (!LineBreakpoint.canAddLineBreakpoint(this.myProject, document, lineIndex)) {
            return null;
        }
        XLineBreakpoint xLineBreakpoint = this.addXLineBreakpoint(JavaLineBreakpointType.class, document, lineIndex, p -> setupAction.accept((JavaLineBreakpointProperties)((Object)p)));
        Breakpoint<?> breakpoint = BreakpointManager.getJavaBreakpoint(xLineBreakpoint);
        if (breakpoint instanceof LineBreakpoint) {
            LineBreakpoint lineBreakpoint = (LineBreakpoint)breakpoint;
            BreakpointManager.addBreakpoint(breakpoint);
            return lineBreakpoint;
        }
        return null;
    }

    @Nullable
    public LineBreakpoint<?> addLineBreakpoint(Document document, int lineIndex) {
        return this.addLineBreakpoint(document, lineIndex, p -> {});
    }

    @Nullable
    public FieldBreakpoint addFieldBreakpoint(@NotNull Document document, int offset) {
        PsiField field;
        if (document == null) {
            BreakpointManager.$$$reportNull$$$0(5);
        }
        if ((field = FieldBreakpoint.findField(this.myProject, document, offset)) == null) {
            return null;
        }
        int line = document.getLineNumber(offset);
        if (document.getLineNumber(field.getNameIdentifier().getTextOffset()) < line) {
            return null;
        }
        return this.addFieldBreakpoint(document, line, field.getName());
    }

    @Nullable
    public FieldBreakpoint addFieldBreakpoint(Document document, int lineIndex, String fieldName) {
        ThreadingAssertions.assertEventDispatchThread();
        XLineBreakpoint xBreakpoint = this.addXLineBreakpoint(JavaFieldBreakpointType.class, document, lineIndex);
        Breakpoint<?> javaBreakpoint = BreakpointManager.getJavaBreakpoint(xBreakpoint);
        if (javaBreakpoint instanceof FieldBreakpoint) {
            FieldBreakpoint fieldBreakpoint = (FieldBreakpoint)javaBreakpoint;
            fieldBreakpoint.setFieldName(fieldName);
            BreakpointManager.addBreakpoint(javaBreakpoint);
            return fieldBreakpoint;
        }
        return null;
    }

    @Nullable
    public ExceptionBreakpoint addExceptionBreakpoint(@NotNull String exceptionClassName) {
        if (exceptionClassName == null) {
            BreakpointManager.$$$reportNull$$$0(6);
        }
        ThreadingAssertions.assertEventDispatchThread();
        JavaExceptionBreakpointType type = (JavaExceptionBreakpointType)XDebuggerUtil.getInstance().findBreakpointType(JavaExceptionBreakpointType.class);
        return (ExceptionBreakpoint)WriteAction.compute(() -> {
            XBreakpoint xBreakpoint = XDebuggerManager.getInstance((Project)this.myProject).getBreakpointManager().addBreakpoint((XBreakpointType)type, (XBreakpointProperties)new JavaExceptionBreakpointProperties(exceptionClassName));
            Breakpoint<?> patt0$temp = BreakpointManager.getJavaBreakpoint(xBreakpoint);
            if (patt0$temp instanceof ExceptionBreakpoint) {
                ExceptionBreakpoint exceptionBreakpoint = (ExceptionBreakpoint)patt0$temp;
                LOG.assertTrue(exceptionClassName.equals(((JavaExceptionBreakpointProperties)((Object)((Object)exceptionBreakpoint.getProperties()))).myQualifiedName));
                BreakpointManager.addBreakpoint(exceptionBreakpoint);
                LOG.debug("ExceptionBreakpoint Added");
                return exceptionBreakpoint;
            }
            return null;
        });
    }

    @Nullable
    public MethodBreakpoint addMethodBreakpoint(Document document, int lineIndex) {
        ThreadingAssertions.assertEventDispatchThread();
        XLineBreakpoint xBreakpoint = this.addXLineBreakpoint(JavaMethodBreakpointType.class, document, lineIndex);
        Breakpoint<?> breakpoint = BreakpointManager.getJavaBreakpoint(xBreakpoint);
        if (breakpoint instanceof MethodBreakpoint) {
            MethodBreakpoint methodBreakpoint = (MethodBreakpoint)breakpoint;
            BreakpointManager.addBreakpoint(methodBreakpoint);
            return methodBreakpoint;
        }
        return null;
    }

    private <B extends XBreakpoint<?>> XLineBreakpoint addXLineBreakpoint(Class<? extends XBreakpointType<B, ?>> typeCls, Document document, int lineIndex, Consumer<XBreakpointProperties> propertiesSetup) {
        XBreakpointType type = XDebuggerUtil.getInstance().findBreakpointType(typeCls);
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        return (XLineBreakpoint)WriteAction.compute(() -> {
            XBreakpointProperties properties = ((XLineBreakpointType)type).createBreakpointProperties(file, lineIndex);
            propertiesSetup.accept(properties);
            return XDebuggerManager.getInstance((Project)this.myProject).getBreakpointManager().addLineBreakpoint((XLineBreakpointType)type, file.getUrl(), lineIndex, properties);
        });
    }

    private <B extends XBreakpoint<?>> XLineBreakpoint addXLineBreakpoint(Class<? extends XBreakpointType<B, ?>> typeCls, Document document, int lineIndex) {
        return this.addXLineBreakpoint(typeCls, document, lineIndex, p -> {});
    }

    @Nullable
    public <T extends BreakpointWithHighlighter> T findBreakpoint(Document document, int offset, @Nullable Key<T> category) {
        for (Breakpoint breakpoint : this.getBreakpoints()) {
            if (!(breakpoint instanceof BreakpointWithHighlighter) || !((BreakpointWithHighlighter)breakpoint).isAt(document, offset) || category != null && !category.equals(breakpoint.getCategory())) continue;
            return (T)((BreakpointWithHighlighter)breakpoint);
        }
        return null;
    }

    public void readExternal(@NotNull Element parentNode) {
        if (parentNode == null) {
            BreakpointManager.$$$reportNull$$$0(7);
        }
        this.myOriginalBreakpointsNodes.clear();
        for (Element element : parentNode.getChildren()) {
            this.myOriginalBreakpointsNodes.put(element.getName(), JDOMUtil.internElement((Element)element));
        }
        if (!this.myProject.isDefault()) {
            StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> this.doRead(parentNode));
        }
    }

    private void doRead(@NotNull Element parentNode) {
        if (parentNode == null) {
            BreakpointManager.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            Element rulesGroup;
            HashMap<String, Breakpoint> nameToBreakpointMap = new HashMap<String, Breakpoint>();
            try {
                List groups = parentNode.getChildren();
                for (Object group1 : groups) {
                    Element breakpointElement;
                    Element anyExceptionBreakpointGroup;
                    Element group = (Element)group1;
                    if (group.getName().equals(RULES_GROUP_NAME) || group.getAttribute(CONVERTED_PARAM) != null) continue;
                    String categoryName = group.getName();
                    Key breakpointCategory = BreakpointCategory.lookup(categoryName);
                    String defaultPolicy = group.getAttributeValue(DEFAULT_SUSPEND_POLICY_ATTRIBUTE_NAME);
                    boolean conditionEnabled = Boolean.parseBoolean(group.getAttributeValue(DEFAULT_CONDITION_STATE_ATTRIBUTE_NAME, "true"));
                    this.setBreakpointDefaults(breakpointCategory, new BreakpointDefaults(defaultPolicy, conditionEnabled));
                    if (!AnyExceptionBreakpoint.ANY_EXCEPTION_BREAKPOINT.equals(breakpointCategory)) {
                        anyExceptionBreakpointGroup = group.getChild(AnyExceptionBreakpoint.ANY_EXCEPTION_BREAKPOINT.toString());
                        for (Element breakpointNode : group.getChildren("breakpoint")) {
                            Breakpoint breakpoint = this.createBreakpoint(categoryName, breakpointNode);
                            breakpoint.readExternal(breakpointNode);
                            nameToBreakpointMap.put(breakpoint.getDisplayName(), breakpoint);
                        }
                    } else {
                        anyExceptionBreakpointGroup = group;
                    }
                    if (anyExceptionBreakpointGroup == null || (breakpointElement = group.getChild("breakpoint")) == null) continue;
                    XBreakpointManager manager = XDebuggerManager.getInstance((Project)this.myProject).getBreakpointManager();
                    JavaExceptionBreakpointType type = (JavaExceptionBreakpointType)XDebuggerUtil.getInstance().findBreakpointType(JavaExceptionBreakpointType.class);
                    for (XBreakpoint defaultBreakpoint : manager.getDefaultBreakpoints((XBreakpointType)type)) {
                        Breakpoint<?> breakpoint = BreakpointManager.getJavaBreakpoint(defaultBreakpoint);
                        if (breakpoint == null) continue;
                        breakpoint.readExternal(breakpointElement);
                        BreakpointManager.addBreakpoint(breakpoint);
                    }
                }
            }
            catch (InvalidDataException groups) {
                // empty catch block
            }
            if ((rulesGroup = parentNode.getChild(RULES_GROUP_NAME)) != null) {
                List rules = rulesGroup.getChildren("rule");
                for (Element rule : rules) {
                    Breakpoint slaveBreakpoint;
                    Breakpoint masterBreakpoint;
                    Element slave;
                    Element master;
                    if (rule.getAttribute(CONVERTED_PARAM) != null || (master = rule.getChild(MASTER_BREAKPOINT_TAG_NAME)) == null || (slave = rule.getChild(SLAVE_BREAKPOINT_TAG_NAME)) == null || (masterBreakpoint = (Breakpoint)nameToBreakpointMap.get(master.getAttributeValue("name"))) == null || (slaveBreakpoint = (Breakpoint)nameToBreakpointMap.get(slave.getAttributeValue("name"))) == null) continue;
                    boolean leaveEnabled = Boolean.parseBoolean(rule.getAttributeValue("leaveEnabled"));
                    XDependentBreakpointManager dependentBreakpointManager = ((XBreakpointManagerImpl)this.getXBreakpointManager()).getDependentBreakpointManager();
                    dependentBreakpointManager.setMasterBreakpoint(slaveBreakpoint.myXBreakpoint, masterBreakpoint.myXBreakpoint, leaveEnabled);
                }
            }
            this.updateBreakpointsUI();
        });
        this.myUIProperties.clear();
        Element props = parentNode.getChild("ui_properties");
        if (props != null) {
            List children = props.getChildren("property");
            for (Object child : children) {
                Element property = (Element)child;
                String name = property.getAttributeValue("name");
                String value = property.getAttributeValue("value");
                if (name == null || value == null) continue;
                this.myUIProperties.put(name, value);
            }
        }
    }

    private Breakpoint createBreakpoint(String category, Element breakpointNode) throws InvalidDataException {
        Object xBreakpoint = null;
        if (category.equals(LineBreakpoint.CATEGORY.toString())) {
            xBreakpoint = this.createXLineBreakpoint(JavaLineBreakpointType.class, breakpointNode);
        } else if (category.equals(MethodBreakpoint.CATEGORY.toString())) {
            xBreakpoint = breakpointNode.getAttribute("url") != null ? this.createXLineBreakpoint(JavaMethodBreakpointType.class, breakpointNode) : this.createXBreakpoint(JavaWildcardMethodBreakpointType.class);
        } else if (category.equals(FieldBreakpoint.CATEGORY.toString())) {
            xBreakpoint = this.createXLineBreakpoint(JavaFieldBreakpointType.class, breakpointNode);
        } else if (category.equals(ExceptionBreakpoint.CATEGORY.toString())) {
            xBreakpoint = this.createXBreakpoint(JavaExceptionBreakpointType.class);
        } else if (category.equals(CollectionBreakpoint.CATEGORY.toString())) {
            xBreakpoint = this.createXBreakpoint(JavaCollectionBreakpointType.class);
        }
        if (xBreakpoint == null) {
            throw new IllegalStateException("Unknown breakpoint category " + category);
        }
        return BreakpointManager.getJavaBreakpoint(xBreakpoint);
    }

    private <B extends XBreakpoint<?>> XBreakpoint createXBreakpoint(Class<? extends XBreakpointType<B, ?>> typeCls) {
        XBreakpointType type = XDebuggerUtil.getInstance().findBreakpointType(typeCls);
        return XDebuggerManager.getInstance((Project)this.myProject).getBreakpointManager().addBreakpoint(type, type.createProperties());
    }

    private <B extends XBreakpoint<?>> XLineBreakpoint createXLineBreakpoint(Class<? extends XBreakpointType<B, ?>> typeCls, Element breakpointNode) throws InvalidDataException {
        int line;
        String url = breakpointNode.getAttributeValue("url");
        VirtualFile vFile = VirtualFileManager.getInstance().findFileByUrl(url);
        if (vFile == null) {
            throw new InvalidDataException(JavaDebuggerBundle.message((String)"error.breakpoint.file.not.found", (Object[])new Object[]{url}));
        }
        Document doc = FileDocumentManager.getInstance().getDocument(vFile);
        if (doc == null) {
            throw new InvalidDataException(JavaDebuggerBundle.message((String)"error.cannot.load.breakpoint.file", (Object[])new Object[]{url}));
        }
        try {
            line = Integer.parseInt(breakpointNode.getAttributeValue("line"));
        }
        catch (Exception e) {
            throw new InvalidDataException("Line number is invalid for breakpoint");
        }
        return this.addXLineBreakpoint(typeCls, doc, line);
    }

    public static void addBreakpoint(@NotNull Breakpoint breakpoint) {
        if (breakpoint == null) {
            BreakpointManager.$$$reportNull$$$0(9);
        }
        assert (breakpoint.myXBreakpoint.getUserData(Breakpoint.DATA_KEY) == breakpoint);
        breakpoint.updateUI();
        BreakpointManager.checkAndNotifyPossiblySlowBreakpoint(breakpoint.myXBreakpoint);
    }

    public void removeBreakpoint(@Nullable Breakpoint breakpoint) {
        if (breakpoint == null) {
            return;
        }
        this.getXBreakpointManager().removeBreakpoint(breakpoint.myXBreakpoint);
    }

    public void writeExternal(@NotNull Element parentNode) {
        if (parentNode == null) {
            BreakpointManager.$$$reportNull$$$0(10);
        }
        for (Element group : this.myOriginalBreakpointsNodes.values()) {
            Element clone = group.clone();
            if (clone.getAttribute(CONVERTED_PARAM) == null) {
                clone.setAttribute(CONVERTED_PARAM, "true");
            }
            parentNode.addContent(clone);
        }
    }

    @NotNull
    public List<Breakpoint> getBreakpoints() {
        List list = (List)ReadAction.compute(() -> ContainerUtil.mapNotNull((Object[])this.getXBreakpointManager().getAllBreakpoints(), BreakpointManager::getJavaBreakpoint));
        if (list == null) {
            BreakpointManager.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Nullable
    public static Breakpoint<?> getJavaBreakpoint(@Nullable XBreakpoint<?> xBreakpoint) {
        Breakpoint<?> breakpoint;
        if (xBreakpoint == null) {
            return null;
        }
        Breakpoint existingBreakpoint = (Breakpoint)xBreakpoint.getUserData(Breakpoint.DATA_KEY);
        if (existingBreakpoint != null) {
            return existingBreakpoint;
        }
        if (!(xBreakpoint.getType() instanceof JavaBreakpointType)) {
            return null;
        }
        XBreakpointBase xBreakpointBase = (XBreakpointBase)xBreakpoint;
        Project project = xBreakpointBase.getProject();
        try {
            breakpoint = ((JavaBreakpointType)xBreakpoint.getType()).createJavaBreakpoint(project, xBreakpoint);
        }
        catch (Throwable e) {
            DebuggerUtilsImpl.logError(e);
            return null;
        }
        return (Breakpoint)xBreakpointBase.putUserDataIfAbsent(Breakpoint.DATA_KEY, breakpoint);
    }

    public void disableBreakpoints(@NotNull DebugProcessImpl debugProcess) {
        List<Breakpoint> breakpoints;
        if (debugProcess == null) {
            BreakpointManager.$$$reportNull$$$0(12);
        }
        if (!(breakpoints = this.getBreakpoints()).isEmpty()) {
            RequestManagerImpl requestManager = debugProcess.getRequestsManager();
            for (Breakpoint breakpoint : breakpoints) {
                breakpoint.markVerified(requestManager.isVerified(breakpoint));
                requestManager.deleteRequest(breakpoint);
            }
            this.updateBreakpointsUI();
        }
    }

    public void enableBreakpoints(DebugProcessImpl debugProcess) {
        List<Breakpoint> breakpoints = this.getBreakpoints();
        if (!breakpoints.isEmpty()) {
            for (Breakpoint breakpoint : breakpoints) {
                breakpoint.markVerified(false);
                breakpoint.createRequest(debugProcess);
            }
            this.updateBreakpointsUI();
        }
    }

    @Deprecated
    public void applyThreadFilter(@NotNull DebugProcessImpl debugProcess, @Nullable ThreadReference newFilterThread) {
        if (debugProcess == null) {
            BreakpointManager.$$$reportNull$$$0(13);
        }
        if (newFilterThread != null) {
            this.applyThreadFilter(debugProcess, new RealThreadInfo(newFilterThread));
        } else {
            this.removeThreadFilter(debugProcess);
        }
    }

    public void removeThreadFilter(@NotNull DebugProcessImpl debugProcess) {
        if (debugProcess == null) {
            BreakpointManager.$$$reportNull$$$0(14);
        }
        this.applyThreadFilter(debugProcess, (LightOrRealThreadInfo)null);
    }

    public void applyThreadFilter(@NotNull DebugProcessImpl debugProcess, @Nullable LightOrRealThreadInfo filter) {
        RequestManagerImpl requestManager;
        if (debugProcess == null) {
            BreakpointManager.$$$reportNull$$$0(15);
        }
        if (Comparing.equal((Object)filter, (Object)(requestManager = debugProcess.getRequestsManager()).getFilterThread())) {
            return;
        }
        ThreadReference oldFilterThread = requestManager.getFilterRealThread();
        ThreadReference newFilterThread = filter == null ? null : filter.getRealThread();
        requestManager.setThreadFilter(filter);
        if (!DebuggerSession.filterBreakpointsDuringSteppingUsingDebuggerEngine()) {
            return;
        }
        EventRequestManager eventRequestManager = requestManager.getVMRequestManager();
        if (DebuggerUtilsAsync.isAsyncEnabled() && eventRequestManager instanceof EventRequestManagerImpl) {
            StreamEx requests = StreamEx.of(eventRequestManager.breakpointRequests()).append(eventRequestManager.methodEntryRequests()).append(eventRequestManager.methodExitRequests()).select(EventRequestManagerImpl.ThreadVisibleEventRequestImpl.class);
            try {
                Stream<CompletableFuture> futures = requests.map(r -> newFilterThread != null ? r.addThreadFilterAsync(newFilterThread) : r.removeThreadFilterAsync(oldFilterThread));
                CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new)).join();
            }
            catch (Exception e) {
                Throwable cause = DebuggerUtilsAsync.unwrap(e);
                if (cause instanceof VMDisconnectedException) {
                    throw (VMDisconnectedException)cause;
                }
                LOG.error((Throwable)new Exception(e));
            }
        } else if (newFilterThread == null || oldFilterThread != null) {
            List<Breakpoint> breakpoints = this.getBreakpoints();
            for (Breakpoint breakpoint : breakpoints) {
                if (!LineBreakpoint.CATEGORY.equals(breakpoint.getCategory()) && !MethodBreakpoint.CATEGORY.equals(breakpoint.getCategory())) continue;
                requestManager.deleteRequest(breakpoint);
                breakpoint.createRequest(debugProcess);
            }
        } else if (eventRequestManager != null) {
            BreakpointManager.applyFilter(eventRequestManager.breakpointRequests(), request -> request.addThreadFilter(newFilterThread));
            BreakpointManager.applyFilter(eventRequestManager.methodEntryRequests(), request -> request.addThreadFilter(newFilterThread));
            BreakpointManager.applyFilter(eventRequestManager.methodExitRequests(), request -> request.addThreadFilter(newFilterThread));
        }
    }

    private static <T extends EventRequest> void applyFilter(@NotNull List<T> requests, Consumer<? super T> setter) {
        if (requests == null) {
            BreakpointManager.$$$reportNull$$$0(16);
        }
        for (EventRequest request : requests) {
            try {
                if (RequestManagerImpl.findRequestor(request) instanceof SyntheticBreakpoint) continue;
                boolean wasEnabled = request.isEnabled();
                if (wasEnabled) {
                    request.disable();
                }
                setter.accept(request);
                if (!wasEnabled) continue;
                request.enable();
            }
            catch (InternalException | InvalidRequestStateException e) {
                LOG.info((Throwable)e);
            }
        }
    }

    public void updateBreakpointsUI() {
        ReadAction.nonBlocking(this::getBreakpoints).coalesceBy(new Object[]{this}).expireWhen(() -> ((Project)this.myProject).isDisposed()).submit((Executor)AppExecutorUtil.getAppExecutorService()).onSuccess(b -> b.forEach(Breakpoint::updateUI));
    }

    @Nullable
    public Breakpoint findMasterBreakpoint(@NotNull Breakpoint dependentBreakpoint) {
        if (dependentBreakpoint == null) {
            BreakpointManager.$$$reportNull$$$0(17);
        }
        XDependentBreakpointManager dependentBreakpointManager = ((XBreakpointManagerImpl)this.getXBreakpointManager()).getDependentBreakpointManager();
        return BreakpointManager.getJavaBreakpoint(dependentBreakpointManager.getMasterBreakpoint(dependentBreakpoint.myXBreakpoint));
    }

    public String getProperty(String name) {
        return this.myUIProperties.get(name);
    }

    public String setProperty(String name, String value) {
        return this.myUIProperties.put(name, value);
    }

    public void addLogMessageListener(CoroutineScope scope, BreakpointLogMessageListener listener2) {
        this.addLogMessageListener(listener2, CoroutineScopeKt.asDisposable((CoroutineScope)scope));
    }

    private void addLogMessageListener(BreakpointLogMessageListener listener2, Disposable parentDisposable) {
        this.myLogMessageDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    void multicastLogMessage(Breakpoint<?> breakpoint, String message, DebugProcessImpl debugProcess) {
        ((BreakpointLogMessageListener)this.myLogMessageDispatcher.getMulticaster()).onLogMessage(breakpoint, message, debugProcess);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "busConnection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionClassName";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/breakpoints/BreakpointManager";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requests";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependentBreakpoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/breakpoints/BreakpointManager";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpoints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addListeners";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addRunToCursorBreakpoint";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addStepIntoBreakpoint";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addFieldBreakpoint";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addExceptionBreakpoint";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doRead";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addBreakpoint";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "disableBreakpoints";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "applyThreadFilter";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeThreadFilter";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "applyFilter";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findMasterBreakpoint";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11 -> new IllegalStateException(string);
        };
    }
}

