/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.CollectionBreakpointUtils;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.requests.LocatableEventRequestor;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.ui.breakpoints.BreakpointCategory;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.debugger.ui.breakpoints.FilteredRequestor;
import com.intellij.debugger.ui.breakpoints.FilteredRequestorImpl;
import com.intellij.debugger.ui.breakpoints.SyntheticLineBreakpoint;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.ModificationWatchpointEvent;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import com.sun.jdi.request.ModificationWatchpointRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaCollectionBreakpointProperties;

@ApiStatus.Experimental
public final class CollectionBreakpoint
extends BreakpointWithHighlighter<JavaCollectionBreakpointProperties> {
    @NonNls
    public static final Key<CollectionBreakpoint> CATEGORY = BreakpointCategory.lookup("collection_breakpoints");
    private static final String GET_INTERNAL_CLS_NAME_METHOD_NAME = "getInternalClsName";
    private static final String GET_INTERNAL_CLS_NAME_METHOD_DESC = "(Ljava/lang/String;)Ljava/lang/String;";
    private static final String EMULATE_FIELD_WATCHPOINT_METHOD_NAME = "emulateFieldWatchpoint";
    private static final String EMULATE_FIELD_WATCHPOINT_METHOD_DESC = "([Ljava/lang/String;)V";
    private static final String PUT_FIELD_TO_CAPTURE_METHOD_NAME = "putFieldToCapture";
    private static final String PUT_FIELD_TO_CAPTURE_METHOD_DESC = "(Ljava/lang/String;Ljava/lang/String;)V";
    private static final String CAPTURE_FIELD_MODIFICATION_METHOD_NAME = "captureFieldModification";
    private static final String CAPTURE_FIELD_MODIFICATION_METHOD_DESC = "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Z)V";
    private static final String CAPTURE_COLLECTION_MODIFICATION_DEFAULT_METHOD_NAME = "captureCollectionModification";
    private static final String CAPTURE_COLLECTION_MODIFICATION_DEFAULT_METHOD_DESC = "(Lcom/intellij/rt/debugger/agent/CollectionBreakpointInstrumentor$Multiset;Ljava/lang/Object;)V";
    private static final String CAPTURE_COLLECTION_MODIFICATION_SPECIAL_METHOD_NAME = "captureCollectionModification";
    private static final String CAPTURE_COLLECTION_MODIFICATION_SPECIAL_METHOD_DESC = "(ZZLjava/lang/Object;Ljava/lang/Object;Z)V";
    private static final long MAX_INSTANCES_NUMBER = 1000000L;
    private final Set<String> myUnprocessedClasses = new HashSet<String>();
    private final Set<String> myClassesNames = new HashSet<String>();
    private volatile boolean myClsPrepared = false;
    private volatile boolean myIsStatic = false;
    private volatile boolean myIsPrivate = false;
    private volatile boolean myIsFinal = false;
    private volatile boolean myAllMethodsEntryRequestIsEnabled = false;
    private String myClsTypeDesc = null;

    CollectionBreakpoint(Project project, XBreakpoint breakpoint) {
        super(project, breakpoint);
        this.initProperties();
    }

    @Override
    @RequiresBackgroundThread
    public void reload() {
        ThreadingAssertions.assertBackgroundThread();
        super.reload();
        this.initProperties();
    }

    private void initProperties() {
        PsiField field = PositionUtil.getPsiElementAt(this.myProject, PsiField.class, this.getSourcePosition());
        if (field != null) {
            ((JavaCollectionBreakpointProperties)((Object)this.getProperties())).myFieldName = field.getName();
            PsiClass psiClass = field.getContainingClass();
            if (psiClass != null) {
                ((JavaCollectionBreakpointProperties)((Object)this.getProperties())).myClassName = psiClass.getQualifiedName();
            }
            this.myIsPrivate = field.hasModifierProperty("private");
            this.myIsFinal = field.hasModifierProperty("final");
            this.myIsStatic = field.hasModifierProperty("static");
        }
        this.myClsPrepared = false;
        this.myAllMethodsEntryRequestIsEnabled = false;
    }

    @Override
    public void createRequestForPreparedClass(DebugProcessImpl debugProcess, ReferenceType refType) {
        if (this.myClsPrepared) {
            return;
        }
        this.setVariables(debugProcess);
        this.myClsTypeDesc = refType.signature();
        this.createRequestForClass(debugProcess, refType);
        if (!this.myIsFinal && !this.myIsPrivate) {
            this.createRequestForSubclasses(debugProcess, refType);
        }
        this.myClsPrepared = true;
    }

    @Override
    protected Icon getDisabledIcon(boolean isMuted) {
        if (DebuggerManagerEx.getInstanceEx(this.myProject).getBreakpointManager().findMasterBreakpoint(this) != null && isMuted) {
            return AllIcons.Debugger.Db_muted_dep_field_breakpoint;
        }
        return null;
    }

    @Override
    public String getEventMessage(LocatableEvent event) {
        return "";
    }

    @Override
    protected Icon getVerifiedIcon(boolean isMuted) {
        return this.isSuspend() ? AllIcons.Debugger.Db_verified_field_breakpoint : AllIcons.Debugger.Db_verified_no_suspend_field_breakpoint;
    }

    @Override
    protected Icon getVerifiedWarningsIcon(boolean isMuted) {
        return LayeredIcon.layeredIcon((Icon[])new Icon[]{isMuted ? AllIcons.Debugger.Db_muted_field_breakpoint : AllIcons.Debugger.Db_field_breakpoint, AllIcons.General.WarningDecorator});
    }

    @Override
    public boolean processLocatableEvent(@NotNull SuspendContextCommandImpl action, LocatableEvent event) throws LocatableEventRequestor.EventProcessingException {
        SuspendContextImpl context;
        if (action == null) {
            CollectionBreakpoint.$$$reportNull$$$0(0);
        }
        if ((context = action.getSuspendContext()) == null) {
            return false;
        }
        @NotNull DebugProcessImpl debugProcess = context.getDebugProcess();
        debugProcess.getRequestsManager().deleteRequest(this);
        this.myAllMethodsEntryRequestIsEnabled = false;
        Location location = event.location();
        if (location == null) {
            this.emulateFieldWatchpoint(debugProcess, context);
            return false;
        }
        Method method = location.method();
        String type = location.declaringType().name();
        MethodEntryPlace place2 = MethodEntryPlace.DEFAULT;
        if (method.isStaticInitializer() && this.myClassesNames.contains(type)) {
            place2 = MethodEntryPlace.STATIC_BLOCK;
        } else if (method.isConstructor() && this.myClassesNames.contains(type)) {
            place2 = MethodEntryPlace.CONSTRUCTOR;
        }
        if (this.myIsStatic) {
            this.processClassesInJVM(context, event, place2);
        } else {
            this.processInstancesInJVM(context, event, place2);
        }
        this.emulateFieldWatchpoint(debugProcess, context);
        return false;
    }

    @Override
    @Nullable
    public PsiElement getEvaluationElement() {
        return this.getPsiClass();
    }

    @Override
    @Nullable
    protected ObjectReference getThisObject(SuspendContextImpl context, LocatableEvent event) {
        try {
            return super.getThisObject(context, event);
        }
        catch (EvaluateException e) {
            return null;
        }
    }

    private void setVariables(DebugProcessImpl debugProcess) {
        CollectionBreakpointUtils.setCollectionHistorySavingEnabled(debugProcess, this.shouldSaveCollectionHistory());
    }

    private boolean shouldSaveCollectionHistory() {
        return ((JavaCollectionBreakpointProperties)((Object)this.getProperties())).SHOULD_SAVE_COLLECTION_HISTORY;
    }

    private void createRequestForClass(DebugProcessImpl debugProcess, ReferenceType refType) {
        String clsName = refType.name();
        this.myClassesNames.add(clsName);
        this.myUnprocessedClasses.add(clsName);
        if (!this.myAllMethodsEntryRequestIsEnabled) {
            this.createAllMethodsEntryRequest(debugProcess);
        }
    }

    private void processConstructorEntry(SuspendContextImpl context, LocatableEvent event) {
        if (!CollectionBreakpoint.tryPopFrame(context)) {
            Location location = event.location();
            ReferenceType declaringType = location.declaringType();
            ObjectReference thisObj = this.getThisObject(context, event);
            this.setTemporaryFieldWatchpoint(context, declaringType, thisObj, context.getThread());
        }
    }

    private void setTemporaryFieldWatchpoint(@NotNull SuspendContextImpl context, @NotNull ReferenceType declaringType, @Nullable ObjectReference thisObj, @Nullable ThreadReferenceProxyImpl thread) {
        if (context == null) {
            CollectionBreakpoint.$$$reportNull$$$0(1);
        }
        if (declaringType == null) {
            CollectionBreakpoint.$$$reportNull$$$0(2);
        }
        MyRequestor requestor2 = new MyRequestor(this.getProject());
        this.addFieldWatchpoint(requestor2, context, declaringType, thisObj);
        CollectionBreakpoint.createMethodExitRequest(requestor2, context, declaringType, thisObj, thread);
    }

    private List<ReferenceType> getTrackedClassesInJVM(SuspendContextImpl context) {
        VirtualMachineProxyImpl virtualMachineProxy = context.getVirtualMachineProxy();
        return this.myClassesNames.stream().map(name -> virtualMachineProxy.classesByName((String)name)).flatMap(list -> list.stream()).filter(cls -> cls.isPrepared()).collect(Collectors.toList());
    }

    private List<ObjectReference> getTrackedInstancesInJVM(SuspendContextImpl context) {
        return this.getTrackedClassesInJVM(context).stream().map(cls -> cls.instances(1000000L)).flatMap(list -> list.stream()).collect(Collectors.toList());
    }

    private void processInstancesInJVM(SuspendContextImpl context, LocatableEvent event, MethodEntryPlace place2) {
        List<ObjectReference> instances = this.getTrackedInstancesInJVM(context);
        if (instances.isEmpty()) {
            return;
        }
        if (instances.size() == 1 && MethodEntryPlace.CONSTRUCTOR.equals((Object)place2)) {
            this.processConstructorEntry(context, event);
        } else {
            this.processAllInstances(context, instances);
        }
    }

    private void processClassesInJVM(SuspendContextImpl context, LocatableEvent event, MethodEntryPlace place2) {
        List<ReferenceType> classes = this.getTrackedClassesInJVM(context);
        if (classes.isEmpty()) {
            return;
        }
        if (classes.size() == 1 && MethodEntryPlace.STATIC_BLOCK.equals((Object)place2)) {
            ReferenceType declaringType = event.location().declaringType();
            ThreadReferenceProxyImpl thread = context.getThread();
            this.setTemporaryFieldWatchpoint(context, declaringType, null, thread);
        } else {
            this.processAllClasses(context, classes);
        }
    }

    private void processAllClasses(SuspendContextImpl context, List<ReferenceType> classes) {
        String fieldName = this.getFieldName();
        for (ReferenceType cls : classes) {
            Field field = DebuggerUtils.findField((ReferenceType)cls, (String)fieldName);
            if (!cls.isInitialized()) continue;
            this.captureClsField(cls, field, context.getDebugProcess(), context);
        }
        VirtualMachineProxyImpl vm = context.getVirtualMachineProxy();
        for (ThreadReferenceProxyImpl thread : vm.allThreads()) {
            try {
                if (!thread.isSuspended()) continue;
                this.processMethodEntryInAllFrames(thread, context, classes);
            }
            catch (EvaluateException e) {
                DebuggerUtilsImpl.logError(e);
            }
        }
    }

    private void processMethodEntryInAllFrames(ThreadReferenceProxyImpl thread, SuspendContextImpl context, List<ReferenceType> classes) throws EvaluateException {
        HashSet<ReferenceType> classesCopy = new HashSet<ReferenceType>(classes);
        List<StackFrameProxyImpl> frames = thread.frames();
        for (StackFrameProxyImpl frame : frames) {
            Method method = frame.location().method();
            ReferenceType declaringType = method.declaringType();
            boolean shouldCapture = !this.myIsFinal || method.isStaticInitializer();
            if (!shouldCapture || !classesCopy.contains(declaringType)) continue;
            ObjectReference thisObject = frame.thisObject();
            this.setTemporaryFieldWatchpoint(context, declaringType, thisObject, thread);
            classesCopy.remove(declaringType);
        }
    }

    private void processAllInstances(SuspendContextImpl context, List<ObjectReference> instances) {
        String fieldName = this.getFieldName();
        for (ObjectReference instance : instances) {
            Field field = DebuggerUtils.findField((ReferenceType)instance.referenceType(), (String)fieldName);
            this.captureInstanceField(instance, field, context.getDebugProcess(), context);
        }
        VirtualMachineProxyImpl vm = context.getVirtualMachineProxy();
        for (ThreadReferenceProxyImpl thread : vm.allThreads()) {
            try {
                if (!thread.isSuspended()) continue;
                this.processNonStaticMethodEntryInAllFrames(thread, context, instances);
            }
            catch (EvaluateException e) {
                DebuggerUtilsImpl.logError(e);
            }
        }
    }

    private void processNonStaticMethodEntryInAllFrames(ThreadReferenceProxyImpl thread, SuspendContextImpl context, List<ObjectReference> instances) throws EvaluateException {
        HashSet<ObjectReference> instancesCopy = new HashSet<ObjectReference>(instances);
        List<StackFrameProxyImpl> frames = thread.frames();
        for (StackFrameProxyImpl frame : frames) {
            Method method = frame.location().method();
            ObjectReference thisObject = frame.thisObject();
            boolean shouldCapture = !this.myIsFinal || method.isConstructor();
            if (!shouldCapture || method.isStatic() || !instancesCopy.contains(thisObject)) continue;
            this.setTemporaryFieldWatchpoint(context, method.declaringType(), thisObject, thread);
            instancesCopy.remove(thisObject);
        }
    }

    private void captureClsField(ReferenceType cls, Field field, DebugProcessImpl debugProcess, SuspendContextImpl context) {
        Value value = cls.getValue(field);
        if (value != null) {
            this.captureFieldModification(value, null, false, debugProcess, context);
        }
    }

    private void captureInstanceField(ObjectReference instance, Field field, DebugProcessImpl debugProcess, SuspendContextImpl context) {
        Value value = instance.getValue(field);
        if (value != null) {
            this.captureFieldModification(value, instance, false, debugProcess, context);
        }
    }

    private void addFieldWatchpoint(MyRequestor requestor2, SuspendContextImpl context, ReferenceType declaringType, @Nullable ObjectReference thisObj) {
        DebugProcessImpl debugProcess = context.getDebugProcess();
        Field field = DebuggerUtils.findField((ReferenceType)declaringType, (String)this.getFieldName());
        ModificationWatchpointRequest request = debugProcess.getRequestsManager().createModificationWatchpointRequest(requestor2, field);
        request.addClassFilter(declaringType);
        if (thisObj != null) {
            request.addInstanceFilter(thisObj);
        }
        request.enable();
    }

    private void createRequestForSubclasses(DebugProcessImpl debugProcess, @NotNull ReferenceType baseType) {
        if (baseType == null) {
            CollectionBreakpoint.$$$reportNull$$$0(3);
        }
        baseType.virtualMachine().allClasses().stream().filter(type -> DebuggerUtilsImpl.instanceOf(type, baseType) && !type.name().equals(baseType.name())).forEach(derivedType -> this.createRequestForClass(debugProcess, (ReferenceType)derivedType));
        RequestManagerImpl requestManager = debugProcess.getRequestsManager();
        ClassPrepareRequest request = requestManager.createClassPrepareRequest((debuggerProcess, derivedType) -> this.createRequestForClass(debugProcess, derivedType), null);
        if (request != null) {
            requestManager.registerRequest(this, request);
            request.addClassFilter(baseType);
            request.enable();
        }
    }

    @Override
    public Key<CollectionBreakpoint> getCategory() {
        return CATEGORY;
    }

    @Override
    @Nullable
    public String getClassName() {
        return ((JavaCollectionBreakpointProperties)((Object)this.getProperties())).myClassName;
    }

    @Override
    @NotNull
    public synchronized Project getProject() {
        Project project = super.getProject();
        if (project == null) {
            CollectionBreakpoint.$$$reportNull$$$0(4);
        }
        return project;
    }

    @Override
    public String getDisplayName() {
        return "";
    }

    public synchronized String getFieldName() {
        return ((JavaCollectionBreakpointProperties)((Object)this.getProperties())).myFieldName;
    }

    private void createAllMethodsEntryRequest(DebugProcessImpl debugProcess) {
        RequestManagerImpl requestManager = debugProcess.getRequestsManager();
        MethodEntryRequest request = requestManager.createMethodEntryRequest(this);
        request.enable();
    }

    private void captureFieldModification(Value valueToBe, Value obj, boolean shouldSaveStack, DebugProcessImpl debugProcess, SuspendContextImpl context) {
        StackFrameProxyImpl frameProxy = context.getFrameProxy();
        if (frameProxy == null) {
            return;
        }
        Value internalClsName = this.getInternalClsName(debugProcess, context);
        if (internalClsName == null) {
            return;
        }
        StringReference fieldName = DebuggerUtilsEx.mirrorOfString(this.getFieldName(), context);
        BooleanValue shouldSave = frameProxy.getVirtualMachine().mirrorOf(shouldSaveStack);
        ArrayList<Value> args = new ArrayList<Value>();
        args.add(valueToBe);
        args.add(obj);
        args.add(internalClsName);
        args.add(fieldName);
        args.add(shouldSave);
        CollectionBreakpointUtils.invokeInstrumentorMethod(debugProcess, context, CAPTURE_FIELD_MODIFICATION_METHOD_NAME, CAPTURE_FIELD_MODIFICATION_METHOD_DESC, args);
    }

    private Value getInternalClsName(DebugProcessImpl debugProcess, SuspendContextImpl context) {
        String clsTypeDesc = this.myClsTypeDesc;
        StackFrameProxyImpl frameProxy = context.getFrameProxy();
        if (clsTypeDesc == null || frameProxy == null) {
            return null;
        }
        StringReference clsTypeDescRef = DebuggerUtilsEx.mirrorOfString(clsTypeDesc, context);
        return CollectionBreakpointUtils.invokeInstrumentorMethod(debugProcess, context, GET_INTERNAL_CLS_NAME_METHOD_NAME, GET_INTERNAL_CLS_NAME_METHOD_DESC, Collections.singletonList(clsTypeDescRef));
    }

    private void emulateFieldWatchpoint(DebugProcessImpl debugProcess, SuspendContextImpl context) {
        try {
            this.putFieldToCapture(debugProcess, context);
            this.transformClassesToEmulateFieldWatchpoint(debugProcess, context);
            if (this.suspendOnBreakpointHit()) {
                this.setLineBreakpoints(context);
            }
        }
        catch (EvaluateException e) {
            DebuggerUtilsImpl.logError(e);
        }
    }

    private void putFieldToCapture(DebugProcessImpl debugProcess, SuspendContextImpl context) {
        StackFrameProxyImpl frameProxy = context.getFrameProxy();
        if (frameProxy == null) {
            return;
        }
        String clsTypeDesc = this.myClsTypeDesc;
        if (clsTypeDesc == null) {
            return;
        }
        StringReference clsTypeDescRef = DebuggerUtilsEx.mirrorOfString(clsTypeDesc, context);
        StringReference fieldName = DebuggerUtilsEx.mirrorOfString(this.getFieldName(), context);
        CollectionBreakpointUtils.invokeInstrumentorMethod(debugProcess, context, PUT_FIELD_TO_CAPTURE_METHOD_NAME, PUT_FIELD_TO_CAPTURE_METHOD_DESC, List.of(clsTypeDescRef, fieldName));
    }

    private void transformClassesToEmulateFieldWatchpoint(DebugProcessImpl debugProcess, SuspendContextImpl context) throws EvaluateException {
        StackFrameProxyImpl frameProxy = context.getFrameProxy();
        if (frameProxy == null) {
            return;
        }
        List args = ContainerUtil.map(this.myUnprocessedClasses, clsName -> DebuggerUtilsEx.mirrorOfString(clsName, context));
        this.myUnprocessedClasses.clear();
        CollectionBreakpointUtils.invokeInstrumentorMethod(debugProcess, context, EMULATE_FIELD_WATCHPOINT_METHOD_NAME, EMULATE_FIELD_WATCHPOINT_METHOD_DESC, args);
    }

    private void setLineBreakpoints(SuspendContextImpl context) {
        DebugProcessImpl debugProcess = context.getDebugProcess();
        EvaluationContextImpl evalContext = new EvaluationContextImpl(context, context.getFrameProxy());
        evalContext = evalContext.withAutoLoadClasses(false);
        ClassType instrumentorCls = CollectionBreakpointUtils.getInstrumentorClass(debugProcess, evalContext);
        List<Location> locations = CollectionBreakpoint.findLocationsInInstrumentorMethods(instrumentorCls);
        for (Location location : locations) {
            SourcePosition position = CollectionBreakpoint.locationToPosition(context.getDebugProcess(), location);
            MyLineBreakpoint breakpoint = new MyLineBreakpoint(this, location, position);
            breakpoint.createBreakpointRequest(context);
        }
    }

    private boolean suspendOnBreakpointHit() {
        return !"SuspendNone".equals(this.getSuspendPolicy());
    }

    private static void createMethodExitRequest(FilteredRequestor requestor2, SuspendContextImpl context, @NotNull ReferenceType declaringType, @Nullable ObjectReference thisObj, @Nullable ThreadReferenceProxyImpl thread) {
        if (declaringType == null) {
            CollectionBreakpoint.$$$reportNull$$$0(5);
        }
        DebugProcessImpl debugProcess = context.getDebugProcess();
        RequestManagerImpl requestManager = debugProcess.getRequestsManager();
        MethodExitRequest request = requestManager.createMethodExitRequest(requestor2);
        request.addClassFilter(declaringType);
        if (thisObj != null) {
            request.addInstanceFilter(thisObj);
        }
        if (thread != null) {
            request.addThreadFilter(thread.getThreadReference());
        }
        request.enable();
    }

    private static boolean tryPopFrame(SuspendContextImpl suspendContext) {
        StackFrameProxyImpl frameProxy = suspendContext.getFrameProxy();
        if (frameProxy == null) {
            return false;
        }
        try {
            frameProxy.threadProxy().popFrames(frameProxy);
            return true;
        }
        catch (EvaluateException e) {
            return false;
        }
    }

    private static Location findLocationInMethod(ClassType instrumentorCls, String methodName, String methodDesc, int lineNumber) {
        try {
            List<Location> lines;
            Method method = DebuggerUtils.findMethod((ReferenceType)instrumentorCls, (String)methodName, (String)methodDesc);
            if (method != null && (lines = method.allLineLocations()).size() >= lineNumber + 1) {
                return lines.get(lineNumber);
            }
        }
        catch (AbsentInformationException e) {
            DebuggerUtilsImpl.logError(e);
        }
        return null;
    }

    private static Location findLocationInCaptureFieldModificationMethod(ClassType instrumentorCls) {
        return CollectionBreakpoint.findLocationInMethod(instrumentorCls, CAPTURE_FIELD_MODIFICATION_METHOD_NAME, CAPTURE_FIELD_MODIFICATION_METHOD_DESC, 5);
    }

    private static Location findLocationInDefaultCaptureCollectionModificationMethod(ClassType instrumentorCls) {
        return CollectionBreakpoint.findLocationInMethod(instrumentorCls, "captureCollectionModification", CAPTURE_COLLECTION_MODIFICATION_DEFAULT_METHOD_DESC, 5);
    }

    private static Location findLocationInSpecialCaptureCollectionModificationMethod(ClassType instrumentorCls) {
        return CollectionBreakpoint.findLocationInMethod(instrumentorCls, "captureCollectionModification", CAPTURE_COLLECTION_MODIFICATION_SPECIAL_METHOD_DESC, 2);
    }

    @NotNull
    private static List<Location> findLocationsInInstrumentorMethods(ClassType instrumentorCls) {
        ArrayList<Location> locations = new ArrayList<Location>();
        Location location = CollectionBreakpoint.findLocationInCaptureFieldModificationMethod(instrumentorCls);
        if (location != null) {
            locations.add(location);
        }
        if ((location = CollectionBreakpoint.findLocationInDefaultCaptureCollectionModificationMethod(instrumentorCls)) != null) {
            locations.add(location);
        }
        if ((location = CollectionBreakpoint.findLocationInSpecialCaptureCollectionModificationMethod(instrumentorCls)) != null) {
            locations.add(location);
        }
        ArrayList<Location> arrayList = locations;
        if (arrayList == null) {
            CollectionBreakpoint.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Nullable
    private static SourcePosition locationToPosition(DebugProcessImpl debugProcess, @Nullable Location location) {
        return location == null ? null : debugProcess.getPositionManager().getSourcePosition(location);
    }

    private static boolean stackContainsAnyObsoleteMethod(SuspendContextImpl context, ReferenceType declaringType, ObjectReference thisObj) {
        ThreadReferenceProxyImpl thread = context.getThread();
        if (thread == null) {
            return false;
        }
        try {
            List<StackFrameProxyImpl> frames = thread.frames();
            if (frames.size() == 1) {
                return false;
            }
            for (StackFrameProxyImpl frame : frames.subList(1, frames.size())) {
                Method method = frame.location().method();
                if (!method.isObsolete() || !method.declaringType().equals(declaringType)) continue;
                return thisObj == null || thisObj.equals(frame.thisObject());
            }
        }
        catch (EvaluateException e) {
            DebuggerUtilsImpl.logError(e);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaringType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseType";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/breakpoints/CollectionBreakpoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/breakpoints/CollectionBreakpoint";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findLocationsInInstrumentorMethods";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processLocatableEvent";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setTemporaryFieldWatchpoint";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createRequestForSubclasses";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createMethodExitRequest";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6 -> new IllegalStateException(string);
        };
    }

    private static enum MethodEntryPlace {
        STATIC_BLOCK,
        CONSTRUCTOR,
        DEFAULT;

    }

    private class MyRequestor
    extends FilteredRequestorImpl {
        private MyRequestor(Project project) {
            if (project == null) {
                MyRequestor.$$$reportNull$$$0(0);
            }
            super(project);
        }

        @Override
        public boolean processLocatableEvent(@NotNull SuspendContextCommandImpl action, LocatableEvent event) throws LocatableEventRequestor.EventProcessingException {
            SuspendContextImpl context;
            if (action == null) {
                MyRequestor.$$$reportNull$$$0(1);
            }
            if ((context = action.getSuspendContext()) == null) {
                return false;
            }
            DebugProcessImpl debugProcess = context.getDebugProcess();
            ObjectReference thisObj = CollectionBreakpoint.this.getThisObject(context, event);
            if (event instanceof ModificationWatchpointEvent) {
                Value valueToBe = ((ModificationWatchpointEvent)event).valueToBe();
                CollectionBreakpoint.this.captureFieldModification(valueToBe, thisObj, true, debugProcess, context);
            } else {
                ReferenceType declaringType = event.location().declaringType();
                if (!CollectionBreakpoint.stackContainsAnyObsoleteMethod(context, declaringType, thisObj)) {
                    debugProcess.getRequestsManager().deleteRequest(this);
                }
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/debugger/ui/breakpoints/CollectionBreakpoint$MyRequestor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processLocatableEvent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyLineBreakpoint
    extends SyntheticLineBreakpoint {
        @Nullable
        private final SourcePosition myPosition;
        @Nullable
        private final Location myLocation;

        private MyLineBreakpoint(@Nullable CollectionBreakpoint collectionBreakpoint, @Nullable Location location, SourcePosition position) {
            super(collectionBreakpoint.getProject());
            this.myLocation = location;
            this.myPosition = position;
            this.setSuspendPolicy(collectionBreakpoint.getSuspendPolicy());
        }

        private void createBreakpointRequest(SuspendContextImpl suspendContext) {
            if (this.myLocation != null) {
                MyLineBreakpoint.createLocationBreakpointRequest(this, this.myLocation, suspendContext.getDebugProcess());
            }
        }

        @Override
        public boolean processLocatableEvent(@NotNull SuspendContextCommandImpl action, LocatableEvent event) throws LocatableEventRequestor.EventProcessingException {
            if (action == null) {
                MyLineBreakpoint.$$$reportNull$$$0(0);
            }
            return this.processBreakpointHit(action);
        }

        private boolean processBreakpointHit(@NotNull SuspendContextCommandImpl action) {
            SuspendContextImpl context;
            if (action == null) {
                MyLineBreakpoint.$$$reportNull$$$0(1);
            }
            if ((context = action.getSuspendContext()) == null) {
                return false;
            }
            try {
                DebugProcessImpl debugProcess = context.getDebugProcess();
                DebugProcessImpl.ResumeCommand stepOutCommand = debugProcess.createStepOutCommand(context);
                context.getManagerThread().schedule(stepOutCommand);
            }
            catch (Exception e) {
                DebuggerUtilsImpl.logError(e);
                return false;
            }
            return true;
        }

        @Override
        @Nullable
        public SourcePosition getSourcePosition() {
            return this.myPosition;
        }

        @Override
        public int getLineIndex() {
            return this.myPosition == null ? -1 : this.myPosition.getLine();
        }

        @Override
        public String getEventMessage(LocatableEvent event) {
            return "";
        }

        @Override
        protected String getFileName() {
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "action";
            objectArray2[1] = "com/intellij/debugger/ui/breakpoints/CollectionBreakpoint$MyLineBreakpoint";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processLocatableEvent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processBreakpointHit";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

