/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.AnActionLink;
import com.intellij.ui.components.JBBox;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.messages.XDebuggerImplBundle;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaCollectionBreakpointProperties;

@ApiStatus.Experimental
public class CollectionBreakpointPropertiesPanel
extends XBreakpointCustomPropertiesPanel<XLineBreakpoint<JavaCollectionBreakpointProperties>> {
    private static final int PREFERRED_PANEL_HEIGHT = 40;
    @Nullable
    private String myClsName = null;
    @Nullable
    private String myFieldName = null;
    private JCheckBox mySaveCollectionHistoryCheckBox;

    @NotNull
    public JComponent getComponent() {
        this.mySaveCollectionHistoryCheckBox = new JCheckBox(JavaDebuggerBundle.message((String)"label.collection.breakpoint.properties.save.history", (Object[])new Object[0]));
        AnActionLink button = new AnActionLink(XDebuggerImplBundle.message((String)"action.Debugger.ShowCollectionHistory.text", (Object[])new Object[0]), (AnAction)new MyShowCollectionHistoryAction());
        JBBox box = JBBox.createVerticalBox();
        BorderLayoutPanel panel = JBUI.Panels.simplePanel();
        panel.add((Component)this.mySaveCollectionHistoryCheckBox, "North");
        this.mySaveCollectionHistoryCheckBox.setPreferredSize(new Dimension(panel.getPreferredSize().width, 40));
        box.add((Component)panel);
        panel = JBUI.Panels.simplePanel();
        panel.add((Component)button);
        button.setPreferredSize(new Dimension(panel.getPreferredSize().width, 40));
        box.add((Component)panel);
        panel = JBUI.Panels.simplePanel();
        panel.add((Component)box);
        BorderLayoutPanel borderLayoutPanel = panel;
        if (borderLayoutPanel == null) {
            CollectionBreakpointPropertiesPanel.$$$reportNull$$$0(0);
        }
        return borderLayoutPanel;
    }

    public void saveTo(@NotNull XLineBreakpoint<JavaCollectionBreakpointProperties> breakpoint) {
        if (breakpoint == null) {
            CollectionBreakpointPropertiesPanel.$$$reportNull$$$0(1);
        }
        boolean changed = ((JavaCollectionBreakpointProperties)breakpoint.getProperties()).SHOULD_SAVE_COLLECTION_HISTORY != this.mySaveCollectionHistoryCheckBox.isSelected();
        ((JavaCollectionBreakpointProperties)breakpoint.getProperties()).SHOULD_SAVE_COLLECTION_HISTORY = this.mySaveCollectionHistoryCheckBox.isSelected();
        if (changed) {
            ((XBreakpointBase)breakpoint).fireBreakpointChanged();
        }
    }

    public void loadFrom(@NotNull XLineBreakpoint<JavaCollectionBreakpointProperties> breakpoint) {
        if (breakpoint == null) {
            CollectionBreakpointPropertiesPanel.$$$reportNull$$$0(2);
        }
        JavaCollectionBreakpointProperties properties = (JavaCollectionBreakpointProperties)breakpoint.getProperties();
        this.myClsName = properties.myClassName;
        this.myFieldName = properties.myFieldName;
        this.mySaveCollectionHistoryCheckBox.setSelected(properties.SHOULD_SAVE_COLLECTION_HISTORY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/breakpoints/CollectionBreakpointPropertiesPanel";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/breakpoints/CollectionBreakpointPropertiesPanel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "saveTo";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadFrom";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    private class MyShowCollectionHistoryAction
    extends AnAction {
        private MyShowCollectionHistoryAction() {
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyShowCollectionHistoryAction.$$$reportNull$$$0(0);
            }
            String clsName = CollectionBreakpointPropertiesPanel.this.myClsName;
            String fieldName = CollectionBreakpointPropertiesPanel.this.myFieldName;
            if (clsName == null || fieldName == null) {
                return;
            }
            Project project = MyShowCollectionHistoryAction.getEventProject((AnActionEvent)e);
            if (project == null) {
                return;
            }
            XDebugSession session = XDebuggerManager.getInstance((Project)project).getCurrentSession();
            if (session == null) {
                return;
            }
            DebuggerUtilsEx.addCollectionHistoryTab(session, clsName, fieldName, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/debugger/ui/breakpoints/CollectionBreakpointPropertiesPanel$MyShowCollectionHistoryAction", "actionPerformed"));
        }
    }
}

