/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointIntentionAction;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.JavaBreakpointType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.JavaDebuggerEditorsProvider;
import org.jetbrains.java.debugger.breakpoints.JavaBreakpointFiltersPanel;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;

public abstract class JavaBreakpointTypeBase<T extends JavaBreakpointProperties>
extends XBreakpointType<XBreakpoint<T>, T>
implements JavaBreakpointType<T> {
    protected JavaBreakpointTypeBase(@NonNls @NotNull String id, @Nls @NotNull String title) {
        if (id == null) {
            JavaBreakpointTypeBase.$$$reportNull$$$0(0);
        }
        if (title == null) {
            JavaBreakpointTypeBase.$$$reportNull$$$0(1);
        }
        super(id, title, true);
    }

    public final boolean isAddBreakpointButtonVisible() {
        return true;
    }

    @NotNull
    public final XBreakpointCustomPropertiesPanel<XBreakpoint<T>> createCustomRightPropertiesPanel(@NotNull Project project) {
        if (project == null) {
            JavaBreakpointTypeBase.$$$reportNull$$$0(2);
        }
        return new JavaBreakpointFiltersPanel(project);
    }

    @NotNull
    public final XDebuggerEditorsProvider getEditorsProvider(@NotNull XBreakpoint<T> breakpoint, @NotNull Project project) {
        if (breakpoint == null) {
            JavaBreakpointTypeBase.$$$reportNull$$$0(3);
        }
        if (project == null) {
            JavaBreakpointTypeBase.$$$reportNull$$$0(4);
        }
        return new JavaDebuggerEditorsProvider();
    }

    @Nullable
    public XSourcePosition getSourcePosition(@NotNull XBreakpoint<T> breakpoint) {
        PsiClass aClass;
        Breakpoint<?> javaBreakpoint;
        if (breakpoint == null) {
            JavaBreakpointTypeBase.$$$reportNull$$$0(5);
        }
        if ((javaBreakpoint = BreakpointManager.getJavaBreakpoint(breakpoint)) != null && (aClass = javaBreakpoint.getPsiClass()) != null) {
            return (XSourcePosition)ReadAction.compute(() -> XDebuggerUtil.getInstance().createPositionByElement((PsiElement)aClass));
        }
        return null;
    }

    public List<? extends AnAction> getAdditionalPopupMenuActions(@NotNull XBreakpoint<T> breakpoint, @Nullable XDebugSession currentSession) {
        if (breakpoint == null) {
            JavaBreakpointTypeBase.$$$reportNull$$$0(6);
        }
        return BreakpointIntentionAction.getIntentions(breakpoint, currentSession);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/ui/breakpoints/JavaBreakpointTypeBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createCustomRightPropertiesPanel";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getEditorsProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getSourcePosition";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getAdditionalPopupMenuActions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

