/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.debugger.breakpoints.properties.JavaLineBreakpointProperties;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0011H\u0007J\b\u0010\u0012\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/debugger/ui/breakpoints/JavaBreakpointsUsageCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "LINE_BREAKPOINT_KIND_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/EnumEventField;", "Lcom/intellij/debugger/ui/breakpoints/JavaBreakpointsUsageCollector$LineBreakpointKind;", "LINE_BREAKPOINT_ADDED", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "Lcom/intellij/internal/statistic/utils/PluginInfo;", "reportNewBreakpoint", "", "breakpoint", "Lcom/intellij/debugger/ui/breakpoints/Breakpoint;", "type", "Lcom/intellij/xdebugger/breakpoints/XBreakpointType;", "getGroup", "LineBreakpointKind", "intellij.java.debugger.impl"})
@SourceDebugExtension(value={"SMAP\nJavaBreakpointsUsageCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaBreakpointsUsageCollector.kt\ncom/intellij/debugger/ui/breakpoints/JavaBreakpointsUsageCollector\n+ 2 EventFields.kt\ncom/intellij/internal/statistic/eventLog/events/EventFields\n*L\n1#1,43:1\n261#2,3:44\n*S KotlinDebug\n*F\n+ 1 JavaBreakpointsUsageCollector.kt\ncom/intellij/debugger/ui/breakpoints/JavaBreakpointsUsageCollector\n*L\n20#1:44,3\n*E\n"})
public final class JavaBreakpointsUsageCollector
extends CounterUsagesCollector {
    @NotNull
    public static final JavaBreakpointsUsageCollector INSTANCE;
    @NotNull
    private static final EventLogGroup GROUP;
    @NotNull
    private static final EnumEventField<LineBreakpointKind> LINE_BREAKPOINT_KIND_FIELD;
    @NotNull
    private static final EventId2<PluginInfo, LineBreakpointKind> LINE_BREAKPOINT_ADDED;

    private JavaBreakpointsUsageCollector() {
    }

    @JvmStatic
    public static final void reportNewBreakpoint(@NotNull Breakpoint<?> breakpoint, @NotNull XBreakpointType<?, ?> type) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Object properties = breakpoint.getProperties();
        if (type instanceof JavaLineBreakpointType && properties instanceof JavaLineBreakpointProperties) {
            PluginInfo pluginInfo = PluginInfoDetectorKt.getPluginInfo(type.getClass());
            Integer lambdaOrdinal = ((JavaLineBreakpointProperties)((Object)properties)).getLambdaOrdinal();
            LineBreakpointKind kind = ((JavaLineBreakpointProperties)((Object)properties)).isConditionalReturn() ? LineBreakpointKind.RETURN : (lambdaOrdinal == null ? LineBreakpointKind.LINE_AND_LAMBDAS : (lambdaOrdinal >= 0 ? LineBreakpointKind.LAMBDA : LineBreakpointKind.LINE));
            LINE_BREAKPOINT_ADDED.log(breakpoint.getProject(), (Object)pluginInfo, (Object)kind);
        }
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$iv;
        INSTANCE = new JavaBreakpointsUsageCollector();
        GROUP = new EventLogGroup("debugger.breakpoints.usage.java", 1, null, 4, null);
        EventFields eventFields = EventFields.INSTANCE;
        String name$iv = "kind";
        Function1 transform$iv = $this$iv.getDefaultEnumTransform();
        boolean $i$f$Enum = false;
        LINE_BREAKPOINT_KIND_FIELD = new EnumEventField(name$iv, LineBreakpointKind.class, null, transform$iv);
        LINE_BREAKPOINT_ADDED = GROUP.registerEvent("line.breakpoint.added", (EventField)EventFields.PluginInfo, (EventField)LINE_BREAKPOINT_KIND_FIELD);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/debugger/ui/breakpoints/JavaBreakpointsUsageCollector$LineBreakpointKind;", "", "<init>", "(Ljava/lang/String;I)V", "LINE", "LAMBDA", "LINE_AND_LAMBDAS", "RETURN", "intellij.java.debugger.impl"})
    private static final class LineBreakpointKind
    extends Enum<LineBreakpointKind> {
        public static final /* enum */ LineBreakpointKind LINE = new LineBreakpointKind();
        public static final /* enum */ LineBreakpointKind LAMBDA = new LineBreakpointKind();
        public static final /* enum */ LineBreakpointKind LINE_AND_LAMBDAS = new LineBreakpointKind();
        public static final /* enum */ LineBreakpointKind RETURN = new LineBreakpointKind();
        private static final /* synthetic */ LineBreakpointKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static LineBreakpointKind[] values() {
            return (LineBreakpointKind[])$VALUES.clone();
        }

        public static LineBreakpointKind valueOf(String value) {
            return Enum.valueOf(LineBreakpointKind.class, value);
        }

        @NotNull
        public static EnumEntries<LineBreakpointKind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = lineBreakpointKindArray = new LineBreakpointKind[]{LineBreakpointKind.LINE, LineBreakpointKind.LAMBDA, LineBreakpointKind.LINE_AND_LAMBDAS, LineBreakpointKind.RETURN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

