/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.ui.breakpoints.AddFieldBreakpointDialog;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.CollectionBreakpoint;
import com.intellij.debugger.ui.breakpoints.CollectionBreakpointPropertiesPanel;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointTypeBase;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.siyeh.ig.psiutils.CollectionUtils;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaCollectionBreakpointProperties;
import org.jetbrains.java.debugger.breakpoints.properties.JavaFieldBreakpointProperties;

@ApiStatus.Experimental
public final class JavaCollectionBreakpointType
extends JavaLineBreakpointTypeBase<JavaCollectionBreakpointProperties> {
    public JavaCollectionBreakpointType() {
        super("java-collection", JavaDebuggerBundle.message((String)"collection.watchpoints.tab.title", (Object[])new Object[0]));
    }

    @ApiStatus.Internal
    public static boolean isEnabled() {
        return Registry.is((String)"debugger.collection.watchpoints.enabled");
    }

    public boolean isAddBreakpointButtonVisible() {
        return JavaCollectionBreakpointType.isEnabled();
    }

    @NotNull
    public Icon getEnabledIcon() {
        Icon icon = AllIcons.Debugger.Db_field_breakpoint;
        if (icon == null) {
            JavaCollectionBreakpointType.$$$reportNull$$$0(0);
        }
        return icon;
    }

    @NotNull
    public Icon getDisabledIcon() {
        Icon icon = AllIcons.Debugger.Db_disabled_field_breakpoint;
        if (icon == null) {
            JavaCollectionBreakpointType.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @NotNull
    public Icon getSuspendNoneIcon() {
        Icon icon = AllIcons.Debugger.Db_no_suspend_field_breakpoint;
        if (icon == null) {
            JavaCollectionBreakpointType.$$$reportNull$$$0(2);
        }
        return icon;
    }

    @NotNull
    public Icon getMutedEnabledIcon() {
        Icon icon = AllIcons.Debugger.Db_muted_field_breakpoint;
        if (icon == null) {
            JavaCollectionBreakpointType.$$$reportNull$$$0(3);
        }
        return icon;
    }

    @NotNull
    public Icon getMutedDisabledIcon() {
        Icon icon = AllIcons.Debugger.Db_muted_disabled_field_breakpoint;
        if (icon == null) {
            JavaCollectionBreakpointType.$$$reportNull$$$0(4);
        }
        return icon;
    }

    @NotNull
    public Icon getInactiveDependentIcon() {
        Icon icon = AllIcons.Debugger.Db_dep_field_breakpoint;
        if (icon == null) {
            JavaCollectionBreakpointType.$$$reportNull$$$0(5);
        }
        return icon;
    }

    @Nullable
    public XBreakpointCustomPropertiesPanel<XLineBreakpoint<JavaCollectionBreakpointProperties>> createCustomConditionsPanel() {
        return new CollectionBreakpointPropertiesPanel();
    }

    private static String getHelpID() {
        return "debugging.collectionWatchpoint";
    }

    public String getDisplayName() {
        return JavaDebuggerBundle.message((String)"collection.watchpoints.tab.title", (Object[])new Object[0]);
    }

    @Nls
    @NotNull
    protected String getGeneralDescription(XLineBreakpointType.XLineBreakpointVariant variant) {
        String string = JavaDebuggerBundle.message((String)"collection.watchpoint.description", (Object[])new Object[0]);
        if (string == null) {
            JavaCollectionBreakpointType.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nls
    public String getGeneralDescription(XLineBreakpoint<JavaCollectionBreakpointProperties> breakpoint) {
        return JavaDebuggerBundle.message((String)"collection.watchpoint.description", (Object[])new Object[0]);
    }

    @Nls
    public String getText(XLineBreakpoint<JavaFieldBreakpointProperties> breakpoint) {
        JavaFieldBreakpointProperties properties = (JavaFieldBreakpointProperties)breakpoint.getProperties();
        String className = properties.myClassName;
        return className != null && !className.isEmpty() ? className + "." + properties.myFieldName : properties.myFieldName;
    }

    @Nullable
    public JavaCollectionBreakpointProperties createProperties() {
        return new JavaCollectionBreakpointProperties();
    }

    @Nullable
    public JavaCollectionBreakpointProperties createBreakpointProperties(@NotNull VirtualFile file, int line) {
        if (file == null) {
            JavaCollectionBreakpointType.$$$reportNull$$$0(7);
        }
        return new JavaCollectionBreakpointProperties();
    }

    @Override
    @NotNull
    public Breakpoint<JavaCollectionBreakpointProperties> createJavaBreakpoint(Project project, XBreakpoint breakpoint) {
        return new CollectionBreakpoint(project, breakpoint);
    }

    public boolean canBeHitInOtherPlaces() {
        return true;
    }

    public boolean canPutAt(@NotNull VirtualFile file, int line, @NotNull Project project) {
        if (file == null) {
            JavaCollectionBreakpointType.$$$reportNull$$$0(8);
        }
        if (project == null) {
            JavaCollectionBreakpointType.$$$reportNull$$$0(9);
        }
        if (!JavaCollectionBreakpointType.isEnabled()) {
            return false;
        }
        return JavaCollectionBreakpointType.canPutAtElement(file, line, project, (element, document) -> {
            if (element instanceof PsiField) {
                boolean isFinal = ((PsiField)element).hasModifierProperty("final");
                boolean isPrivate = ((PsiField)element).hasModifierProperty("private");
                boolean isProtected = ((PsiField)element).hasModifierProperty("protected");
                boolean hasValidModifiers = isFinal || isPrivate || isProtected;
                PsiType type = ((PsiField)element).getType();
                return hasValidModifiers && CollectionUtils.isCollectionClassOrInterface((PsiType)type);
            }
            return false;
        });
    }

    @Nullable
    public XLineBreakpoint<JavaCollectionBreakpointProperties> addBreakpoint(final Project project, JComponent parentComponent) {
        final Ref result = Ref.create(null);
        AddFieldBreakpointDialog dialog = new AddFieldBreakpointDialog(project){

            @Override
            protected boolean validateData() {
                PsiField field;
                PsiFile psiFile;
                Document document;
                String className = this.getClassName();
                if (className.isEmpty()) {
                    return false;
                }
                String fieldName = this.getFieldName();
                if (fieldName.isEmpty()) {
                    return false;
                }
                PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(className, GlobalSearchScope.allScope((Project)project));
                if (psiClass != null && (document = (psiFile = psiClass.getContainingFile()).getViewProvider().getDocument()) != null && (field = psiClass.findFieldByName(fieldName, false)) != null) {
                    int line = document.getLineNumber(field.getTextOffset());
                    WriteAction.run(() -> {
                        XLineBreakpoint fieldBreakpoint = XDebuggerManager.getInstance((Project)project).getBreakpointManager().addLineBreakpoint((XLineBreakpointType)JavaCollectionBreakpointType.this, psiFile.getVirtualFile().getUrl(), line, (XBreakpointProperties)new JavaCollectionBreakpointProperties(fieldName, className));
                        result.set((Object)fieldBreakpoint);
                    });
                    return true;
                }
                return false;
            }
        };
        dialog.show();
        return (XLineBreakpoint)result.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 7, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/breakpoints/JavaCollectionBreakpointType";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuspendNoneIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutedEnabledIcon";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutedDisabledIcon";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInactiveDependentIcon";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getGeneralDescription";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/breakpoints/JavaCollectionBreakpointType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createBreakpointProperties";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "canPutAt";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 7, 8, 9 -> new IllegalArgumentException(string);
        };
    }
}

