/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.ui.breakpoints.AnyExceptionBreakpoint;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.ExceptionBreakpoint;
import com.intellij.debugger.ui.breakpoints.ExceptionBreakpointPropertiesPanel;
import com.intellij.debugger.ui.breakpoints.JavaBreakpointTypeBase;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaExceptionBreakpointProperties;

public final class JavaExceptionBreakpointType
extends JavaBreakpointTypeBase<JavaExceptionBreakpointProperties> {
    public JavaExceptionBreakpointType() {
        super("java-exception", JavaDebuggerBundle.message((String)"exception.breakpoints.tab.title", (Object[])new Object[0]));
    }

    @NotNull
    public Icon getEnabledIcon() {
        Icon icon = AllIcons.Debugger.Db_exception_breakpoint;
        if (icon == null) {
            JavaExceptionBreakpointType.$$$reportNull$$$0(0);
        }
        return icon;
    }

    @NotNull
    public Icon getDisabledIcon() {
        Icon icon = AllIcons.Debugger.Db_disabled_exception_breakpoint;
        if (icon == null) {
            JavaExceptionBreakpointType.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @NotNull
    public Icon getMutedEnabledIcon() {
        Icon icon = AllIcons.Debugger.Db_exception_breakpoint;
        if (icon == null) {
            JavaExceptionBreakpointType.$$$reportNull$$$0(2);
        }
        return icon;
    }

    @NotNull
    public Icon getMutedDisabledIcon() {
        Icon icon = AllIcons.Debugger.Db_exception_breakpoint;
        if (icon == null) {
            JavaExceptionBreakpointType.$$$reportNull$$$0(3);
        }
        return icon;
    }

    private static String getHelpID() {
        return "debugging.exceptionBreakpoint";
    }

    public String getDisplayName() {
        return JavaDebuggerBundle.message((String)"exception.breakpoints.tab.title", (Object[])new Object[0]);
    }

    @Nls
    public String getGeneralDescription(XBreakpoint<JavaExceptionBreakpointProperties> breakpoint) {
        String name = ((JavaExceptionBreakpointProperties)breakpoint.getProperties()).myQualifiedName;
        if (name != null) {
            return JavaDebuggerBundle.message((String)"exception.breakpoint.description.with.type", (Object[])new Object[]{name});
        }
        return JavaDebuggerBundle.message((String)"exception.breakpoint.description.any", (Object[])new Object[0]);
    }

    public String getDisplayText(XBreakpoint<JavaExceptionBreakpointProperties> breakpoint) {
        String name = ((JavaExceptionBreakpointProperties)breakpoint.getProperties()).myQualifiedName;
        if (name != null) {
            return name;
        }
        return JavaDebuggerBundle.message((String)"breakpoint.any.exception.display.name", (Object[])new Object[0]);
    }

    @NotNull
    public JavaExceptionBreakpointProperties createProperties() {
        return new JavaExceptionBreakpointProperties();
    }

    @NotNull
    public XBreakpointCustomPropertiesPanel<XBreakpoint<JavaExceptionBreakpointProperties>> createCustomPropertiesPanel(@NotNull Project project) {
        if (project == null) {
            JavaExceptionBreakpointType.$$$reportNull$$$0(4);
        }
        return new ExceptionBreakpointPropertiesPanel();
    }

    @NotNull
    public XBreakpoint<JavaExceptionBreakpointProperties> createDefaultBreakpoint(@NotNull XBreakpointType.XBreakpointCreator<JavaExceptionBreakpointProperties> creator) {
        if (creator == null) {
            JavaExceptionBreakpointType.$$$reportNull$$$0(5);
        }
        XBreakpoint xBreakpoint = creator.createBreakpoint((XBreakpointProperties)new JavaExceptionBreakpointProperties());
        if (xBreakpoint == null) {
            JavaExceptionBreakpointType.$$$reportNull$$$0(6);
        }
        return xBreakpoint;
    }

    @Nullable
    public XBreakpoint<JavaExceptionBreakpointProperties> addBreakpoint(Project project, JComponent parentComponent) {
        String qName;
        PsiClass throwableClass = JavaPsiFacade.getInstance((Project)project).findClass("java.lang.Throwable", GlobalSearchScope.allScope((Project)project));
        TreeClassChooser chooser = TreeClassChooserFactory.getInstance((Project)project).createInheritanceClassChooser(JavaDebuggerBundle.message((String)"add.exception.breakpoint.classchooser.title", (Object[])new Object[0]), GlobalSearchScope.allScope((Project)project), throwableClass, true, true, null);
        chooser.showDialog();
        PsiClass selectedClass = chooser.getSelected();
        String string = qName = selectedClass == null ? null : JVMNameUtil.getClassVMName(selectedClass);
        if (qName != null && !qName.isEmpty()) {
            return XDebuggerManager.getInstance((Project)project).getBreakpointManager().addBreakpoint((XBreakpointType)this, (XBreakpointProperties)new JavaExceptionBreakpointProperties(qName));
        }
        return null;
    }

    @Override
    @NotNull
    public Breakpoint<JavaExceptionBreakpointProperties> createJavaBreakpoint(Project project, XBreakpoint<JavaExceptionBreakpointProperties> breakpoint) {
        if (!XDebuggerManager.getInstance((Project)project).getBreakpointManager().isDefaultBreakpoint(breakpoint)) {
            return new ExceptionBreakpoint(project, breakpoint);
        }
        return new AnyExceptionBreakpoint(project, breakpoint);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/breakpoints/JavaExceptionBreakpointType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutedEnabledIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutedDisabledIcon";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/breakpoints/JavaExceptionBreakpointType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultBreakpoint";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createCustomPropertiesPanel";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultBreakpoint";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

