/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.CommonBundle;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.ui.breakpoints.AddFieldBreakpointDialog;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.FieldBreakpoint;
import com.intellij.debugger.ui.breakpoints.FieldBreakpointPropertiesPanel;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointTypeBase;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaFieldBreakpointProperties;

public final class JavaFieldBreakpointType
extends JavaLineBreakpointTypeBase<JavaFieldBreakpointProperties> {
    public JavaFieldBreakpointType() {
        super("java-field", JavaDebuggerBundle.message((String)"field.watchpoints.tab.title", (Object[])new Object[0]));
    }

    public boolean isAddBreakpointButtonVisible() {
        return true;
    }

    @NotNull
    public Icon getEnabledIcon() {
        Icon icon = AllIcons.Debugger.Db_field_breakpoint;
        if (icon == null) {
            JavaFieldBreakpointType.$$$reportNull$$$0(0);
        }
        return icon;
    }

    @NotNull
    public Icon getDisabledIcon() {
        Icon icon = AllIcons.Debugger.Db_disabled_field_breakpoint;
        if (icon == null) {
            JavaFieldBreakpointType.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @NotNull
    public Icon getSuspendNoneIcon() {
        Icon icon = AllIcons.Debugger.Db_no_suspend_field_breakpoint;
        if (icon == null) {
            JavaFieldBreakpointType.$$$reportNull$$$0(2);
        }
        return icon;
    }

    @NotNull
    public Icon getMutedEnabledIcon() {
        Icon icon = AllIcons.Debugger.Db_muted_field_breakpoint;
        if (icon == null) {
            JavaFieldBreakpointType.$$$reportNull$$$0(3);
        }
        return icon;
    }

    @NotNull
    public Icon getMutedDisabledIcon() {
        Icon icon = AllIcons.Debugger.Db_muted_disabled_field_breakpoint;
        if (icon == null) {
            JavaFieldBreakpointType.$$$reportNull$$$0(4);
        }
        return icon;
    }

    @NotNull
    public Icon getInactiveDependentIcon() {
        Icon icon = AllIcons.Debugger.Db_dep_field_breakpoint;
        if (icon == null) {
            JavaFieldBreakpointType.$$$reportNull$$$0(5);
        }
        return icon;
    }

    private static String getHelpID() {
        return "debugging.fieldWatchpoint";
    }

    public String getDisplayName() {
        return JavaDebuggerBundle.message((String)"field.watchpoints.tab.title", (Object[])new Object[0]);
    }

    @Nls
    @NotNull
    protected String getGeneralDescription(XLineBreakpointType.XLineBreakpointVariant variant) {
        String string = JavaDebuggerBundle.message((String)"field.watchpoint.description", (Object[])new Object[0]);
        if (string == null) {
            JavaFieldBreakpointType.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nls
    public String getGeneralDescription(XLineBreakpoint<JavaFieldBreakpointProperties> breakpoint) {
        return JavaDebuggerBundle.message((String)"field.watchpoint.description", (Object[])new Object[0]);
    }

    @Override
    public List<@Nls String> getPropertyXMLDescriptions(XLineBreakpoint<JavaFieldBreakpointProperties> breakpoint) {
        SmartList res = new SmartList(super.getPropertyXMLDescriptions(breakpoint));
        JavaFieldBreakpointProperties props = (JavaFieldBreakpointProperties)breakpoint.getProperties();
        if (props != null) {
            JavaFieldBreakpointProperties defaults = this.createProperties();
            if (props.WATCH_ACCESS != defaults.WATCH_ACCESS || props.WATCH_MODIFICATION != defaults.WATCH_MODIFICATION) {
                res.add((Object)(JavaDebuggerBundle.message((String)"field.watchpoint.property.name.access", (Object[])new Object[0]) + "&nbsp;" + props.WATCH_ACCESS));
                res.add((Object)(JavaDebuggerBundle.message((String)"field.watchpoint.property.name.modification", (Object[])new Object[0]) + "&nbsp;" + props.WATCH_MODIFICATION));
            }
        }
        return res;
    }

    public String getShortText(XLineBreakpoint<JavaFieldBreakpointProperties> breakpoint) {
        return JavaFieldBreakpointType.getText(breakpoint, true);
    }

    @Nls
    public String getText(XLineBreakpoint<JavaFieldBreakpointProperties> breakpoint) {
        return JavaFieldBreakpointType.getText(breakpoint, false);
    }

    @Nls
    @NotNull
    private static String getText(XBreakpoint<JavaFieldBreakpointProperties> breakpoint, boolean simple) {
        JavaFieldBreakpointProperties properties = (JavaFieldBreakpointProperties)breakpoint.getProperties();
        String className = properties.myClassName;
        String fieldName = properties.myFieldName;
        if (className == null || className.isEmpty()) {
            if (fieldName == null || fieldName.isEmpty()) {
                String string = JavaDebuggerBundle.message((String)"field.watchpoint.description", (Object[])new Object[0]);
                if (string == null) {
                    JavaFieldBreakpointType.$$$reportNull$$$0(7);
                }
                return string;
            }
            String string = fieldName;
            if (string == null) {
                JavaFieldBreakpointType.$$$reportNull$$$0(8);
            }
            return string;
        }
        String displayedClassName = simple ? ClassUtil.extractClassName((String)className) : className;
        String string = displayedClassName + "." + fieldName;
        if (string == null) {
            JavaFieldBreakpointType.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    public XBreakpointCustomPropertiesPanel<XLineBreakpoint<JavaFieldBreakpointProperties>> createCustomPropertiesPanel(@NotNull Project project) {
        if (project == null) {
            JavaFieldBreakpointType.$$$reportNull$$$0(10);
        }
        return new FieldBreakpointPropertiesPanel();
    }

    @Nullable
    public JavaFieldBreakpointProperties createProperties() {
        return new JavaFieldBreakpointProperties();
    }

    @Nullable
    public JavaFieldBreakpointProperties createBreakpointProperties(@NotNull VirtualFile file, int line) {
        if (file == null) {
            JavaFieldBreakpointType.$$$reportNull$$$0(11);
        }
        return this.createProperties();
    }

    @Nullable
    public XLineBreakpoint<JavaFieldBreakpointProperties> addBreakpoint(final Project project, JComponent parentComponent) {
        final Ref result = Ref.create(null);
        AddFieldBreakpointDialog dialog = new AddFieldBreakpointDialog(project){

            @Override
            protected boolean validateData() {
                String className = this.getClassName();
                if (className.isEmpty()) {
                    Messages.showMessageDialog((Project)project, (String)JavaDebuggerBundle.message((String)"error.field.breakpoint.class.name.not.specified", (Object[])new Object[0]), (String)JavaDebuggerBundle.message((String)"add.field.breakpoint.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                    return false;
                }
                String fieldName = this.getFieldName();
                if (fieldName.isEmpty()) {
                    Messages.showMessageDialog((Project)project, (String)JavaDebuggerBundle.message((String)"error.field.breakpoint.field.name.not.specified", (Object[])new Object[0]), (String)JavaDebuggerBundle.message((String)"add.field.breakpoint.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                    return false;
                }
                PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(className, GlobalSearchScope.allScope((Project)project));
                if (psiClass == null) {
                    Messages.showMessageDialog((Project)project, (String)JavaDebuggerBundle.message((String)"error.field.breakpoint.class.sources.not.found", (Object[])new Object[]{className, fieldName, className}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                    return false;
                }
                PsiFile psiFile = psiClass.getContainingFile();
                Document document = psiFile.getViewProvider().getDocument();
                if (document == null) {
                    return false;
                }
                PsiField field = psiClass.findFieldByName(fieldName, false);
                if (field == null) {
                    Messages.showMessageDialog((Project)project, (String)JavaDebuggerBundle.message((String)"error.field.breakpoint.field.not.found", (Object[])new Object[]{className, fieldName, fieldName}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                    return false;
                }
                XLineBreakpoint fieldBreakpoint = XDebuggerManager.getInstance((Project)project).getBreakpointManager().addLineBreakpoint((XLineBreakpointType)JavaFieldBreakpointType.this, psiFile.getVirtualFile().getUrl(), document.getLineNumber(field.getTextOffset()), (XBreakpointProperties)new JavaFieldBreakpointProperties(fieldName, className));
                result.set((Object)fieldBreakpoint);
                return true;
            }
        };
        dialog.show();
        return (XLineBreakpoint)result.get();
    }

    @Override
    @NotNull
    public Breakpoint<JavaFieldBreakpointProperties> createJavaBreakpoint(Project project, XBreakpoint breakpoint) {
        return new FieldBreakpoint(project, breakpoint);
    }

    public boolean canBeHitInOtherPlaces() {
        return true;
    }

    public boolean canPutAt(@NotNull VirtualFile file, int line, @NotNull Project project) {
        if (file == null) {
            JavaFieldBreakpointType.$$$reportNull$$$0(12);
        }
        if (project == null) {
            JavaFieldBreakpointType.$$$reportNull$$$0(13);
        }
        return JavaFieldBreakpointType.canPutAtElement(file, line, project, (element, document) -> element instanceof PsiField);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 10, 11, 12, 13 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/breakpoints/JavaFieldBreakpointType";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuspendNoneIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutedEnabledIcon";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutedDisabledIcon";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInactiveDependentIcon";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getGeneralDescription";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/breakpoints/JavaFieldBreakpointType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createCustomPropertiesPanel";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createBreakpointProperties";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "canPutAt";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 10, 11, 12, 13 -> new IllegalArgumentException(string);
        };
    }
}

