/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.EvaluationUtilsKt;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.MethodBytecodeUtil;
import com.intellij.debugger.requests.RequestManager;
import com.intellij.debugger.ui.breakpoints.BreakpointCategory;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.LocatableEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;
import org.jetbrains.java.debugger.breakpoints.properties.JavaLineBreakpointProperties;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class LineBreakpoint<P extends JavaBreakpointProperties>
extends BreakpointWithHighlighter<P> {
    private final boolean myIgnoreSameLineLocations;
    private volatile String myMethodName = null;
    static final Logger LOG = Logger.getInstance(LineBreakpoint.class);
    @NonNls
    public static final Key<LineBreakpoint> CATEGORY = BreakpointCategory.lookup("line_breakpoints");
    private static final Pattern ourAnonymousPattern = Pattern.compile(".*\\$\\d*$");

    protected LineBreakpoint(Project project, XBreakpoint xBreakpoint) {
        this(project, xBreakpoint, true);
    }

    protected LineBreakpoint(Project project, XBreakpoint xBreakpoint, boolean ignoreSameLineLocations) {
        super(project, xBreakpoint);
        this.myIgnoreSameLineLocations = ignoreSameLineLocations;
    }

    @Override
    protected Icon getDisabledIcon(boolean isMuted) {
        if (DebuggerManagerEx.getInstanceEx(this.myProject).getBreakpointManager().findMasterBreakpoint(this) != null) {
            return isMuted ? AllIcons.Debugger.Db_muted_dep_line_breakpoint : AllIcons.Debugger.Db_dep_line_breakpoint;
        }
        return null;
    }

    @Override
    protected Icon getVerifiedIcon(boolean isMuted) {
        return XDebuggerUtilImpl.getVerifiedIcon((XBreakpoint)this.myXBreakpoint);
    }

    @Override
    protected Icon getVerifiedWarningsIcon(boolean isMuted) {
        return LayeredIcon.layeredIcon((Icon[])new Icon[]{isMuted ? AllIcons.Debugger.Db_muted_breakpoint : AllIcons.Debugger.Db_set_breakpoint, AllIcons.General.WarningDecorator});
    }

    @Override
    public Key<LineBreakpoint> getCategory() {
        return CATEGORY;
    }

    @Override
    protected void createOrWaitPrepare(DebugProcessImpl debugProcess, String classToBeLoaded) {
        if (this.isInScopeOf(debugProcess, classToBeLoaded)) {
            super.createOrWaitPrepare(debugProcess, classToBeLoaded);
        }
    }

    @Override
    protected void createRequestForPreparedClass(DebugProcessImpl debugProcess, ReferenceType classType) {
        if (!((Boolean)ReadAction.compute(() -> this.isInScopeOf(debugProcess, classType.name()))).booleanValue()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(classType.name() + " is out of debug-process scope, breakpoint request won't be created for line " + this.getLineIndex());
            }
            return;
        }
        try {
            Object instrumentationBreakpointState;
            XBreakpointBase xBreakpointBase;
            SourcePosition position = this.getSourcePosition();
            List<Location> locations = debugProcess.getPositionManager().locationsOfLine(classType, position);
            XBreakpoint xBreakpoint = this.myXBreakpoint;
            if (xBreakpoint instanceof XBreakpointBase && EvaluationUtilsKt.shouldInstrumentBreakpoint(xBreakpointBase = (XBreakpointBase)xBreakpoint) && (instrumentationBreakpointState = debugProcess.getRequestsManager().getInstrumentationInfo(this)) != null) {
                instrumentationBreakpointState.updateInstrumentationModeEnabled((RequestManager)debugProcess.getRequestsManager(), true);
                return;
            }
            if (!locations.isEmpty()) {
                JavaLineBreakpointProperties props;
                locations = ((StreamEx)((StreamEx)StreamEx.of(locations).peek(loc -> {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Found location [codeIndex=" + loc.codeIndex() + "] for reference type " + classType.name() + " at line " + this.getLineIndex() + "; isObsolete: " + loc.method().isObsolete());
                    }
                })).filter(l -> this.acceptLocation(debugProcess, classType, (Location)l))).toList();
                instrumentationBreakpointState = this.getProperties();
                if (instrumentationBreakpointState instanceof JavaLineBreakpointProperties && (props = (JavaLineBreakpointProperties)((Object)instrumentationBreakpointState)).isConditionalReturn()) {
                    if (DebuggerUtils.isAndroidVM((VirtualMachine)classType.virtualMachine())) {
                        XDebuggerManagerImpl.getNotificationGroup().createNotification(JavaDebuggerBundle.message((String)"message.conditional.return.breakpoint.on.android", (Object[])new Object[0]), MessageType.INFO).notify(debugProcess.getProject());
                    } else if (classType.virtualMachine().canGetBytecodes() && classType.virtualMachine().canGetConstantPool()) {
                        locations = locations.stream().map(l -> l.method()).distinct().flatMap(m -> JavaLineBreakpointType.collectInlineConditionalReturnLocations(m, position.getLine() + 1)).toList();
                    }
                } else if (this.myIgnoreSameLineLocations) {
                    locations = MethodBytecodeUtil.removeSameLineLocations(locations);
                }
                for (Location loc2 : locations) {
                    LineBreakpoint.createLocationBreakpointRequest(this, loc2, debugProcess);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Created breakpoint request for reference type " + classType.name() + " at line " + this.getLineIndex() + "; codeIndex=" + loc2.codeIndex());
                }
            } else if (DebuggerUtilsEx.allLineLocations(classType) == null) {
                debugProcess.getRequestsManager().setInvalid(this, JavaDebuggerBundle.message((String)"error.invalid.breakpoint.no.line.info", (Object[])new Object[]{classType.name()}));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No line number info in " + classType.name());
                }
            } else {
                debugProcess.getRequestsManager().setInvalid(this, JavaDebuggerBundle.message((String)"error.invalid.breakpoint.no.executable.code", (Object[])new Object[]{this.getLineIndex() + 1, classType.name()}));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No locations of type " + classType.name() + " found at line " + this.getLineIndex());
                }
            }
        }
        catch (ClassNotPreparedException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ClassNotPreparedException: " + ex.getMessage());
            }
        }
        catch (ObjectCollectedException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ObjectCollectedException: " + ex.getMessage());
            }
        }
        catch (Exception ex) {
            LOG.info((Throwable)ex);
        }
        this.updateUI();
    }

    private static boolean isAnonymousClass(ReferenceType classType) {
        if (classType instanceof ClassType) {
            return ourAnonymousPattern.matcher(classType.name()).matches();
        }
        return false;
    }

    protected boolean acceptLocation(DebugProcessImpl debugProcess, ReferenceType classType, Location loc) {
        Method method;
        if (LineBreakpoint.isAnonymousClass(classType) && ((method = loc.method()).isConstructor() && loc.codeIndex() == 0L || method.isBridge())) {
            return false;
        }
        SourcePosition position = debugProcess.getPositionManager().getSourcePosition(loc);
        if (position == null) {
            return false;
        }
        return (Boolean)ReadAction.compute(() -> {
            JavaLineBreakpointType type = this.getXBreakpointType();
            if (type == null) {
                return true;
            }
            return type.matchesPosition(this, position);
        });
    }

    @Nullable
    protected JavaLineBreakpointType getXBreakpointType() {
        XBreakpointType type = this.myXBreakpoint.getType();
        if (type instanceof JavaLineBreakpointType) {
            return (JavaLineBreakpointType)type;
        }
        return null;
    }

    private boolean isInScopeOf(DebugProcessImpl debugProcess, String className) {
        ProjectFileIndex fileIndex;
        VirtualFile breakpointFile = this.getVirtualFile();
        if (breakpointFile != null && (fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex()).isUnderSourceRootOfType(breakpointFile, JavaModuleSourceRootTypes.SOURCES)) {
            if (debugProcess.getSearchScope().contains(breakpointFile)) {
                return true;
            }
            Collection<VirtualFile> candidates = this.findClassCandidatesInSourceContent(className, debugProcess.getSearchScope(), fileIndex);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found " + String.valueOf(candidates == null ? "null" : Integer.valueOf(candidates.size())) + " candidate containing files for class " + className);
            }
            if (candidates == null) {
                return true;
            }
            if (LOG.isDebugEnabled()) {
                GlobalSearchScope scope = debugProcess.getSearchScope();
                boolean contains = scope.contains(breakpointFile);
                List files = ContainerUtil.map((Object[])JavaPsiFacade.getInstance((Project)this.myProject).findClasses(className, scope), aClass -> aClass.getContainingFile().getVirtualFile());
                List allFiles = ContainerUtil.map((Object[])JavaPsiFacade.getInstance((Project)this.myProject).findClasses(className, GlobalSearchScope.everythingScope((Project)this.myProject)), aClass -> aClass.getContainingFile().getVirtualFile());
                VirtualFile contentRoot = fileIndex.getContentRootForFile(breakpointFile);
                Module module = fileIndex.getModuleForFile(breakpointFile);
                LOG.debug("Did not find '" + className + "' in " + String.valueOf(scope) + "; contains=" + contains + "; contentRoot=" + String.valueOf(contentRoot) + "; module = " + String.valueOf(module) + "; all files in index are: " + String.valueOf(files) + "; all possible files are: " + String.valueOf(allFiles));
            }
            return false;
        }
        return true;
    }

    @Nullable
    private Collection<VirtualFile> findClassCandidatesInSourceContent(String className, GlobalSearchScope scope, ProjectFileIndex fileIndex) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        int dollarIndex = className.indexOf("$");
        String topLevelClassName = dollarIndex >= 0 ? className.substring(0, dollarIndex) : className;
        return (Collection)ReadAction.compute(() -> {
            PsiClass[] classes = JavaPsiFacade.getInstance((Project)this.myProject).findClasses(topLevelClassName, scope);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found " + classes.length + " classes " + topLevelClassName + " in scope " + String.valueOf(scope));
            }
            if (classes.length == 0) {
                return null;
            }
            ArrayList<VirtualFile> list = new ArrayList<VirtualFile>(classes.length);
            for (PsiClass aClass : classes) {
                PsiFile psiFile = aClass.getContainingFile();
                if (LOG.isDebugEnabled()) {
                    StringBuilder msg = new StringBuilder();
                    msg.append("Checking class ").append(aClass.getQualifiedName());
                    msg.append("\n\t").append("PsiFile=").append(psiFile);
                    if (psiFile != null) {
                        VirtualFile vFile = psiFile.getVirtualFile();
                        msg.append("\n\t").append("VirtualFile=").append(vFile);
                        if (vFile != null) {
                            msg.append("\n\t").append("isInSourceContent=").append(fileIndex.isUnderSourceRootOfType(vFile, JavaModuleSourceRootTypes.SOURCES));
                        }
                    }
                    LOG.debug(msg.toString());
                }
                if (psiFile == null) {
                    return null;
                }
                VirtualFile vFile = psiFile.getVirtualFile();
                if (vFile == null || !fileIndex.isUnderSourceRootOfType(vFile, JavaModuleSourceRootTypes.SOURCES)) {
                    return null;
                }
                list.add(vFile);
            }
            return list;
        });
    }

    @Override
    public String getShortName() {
        return this.getDisplayInfoInternal(false, 30);
    }

    @Override
    public String getDisplayName() {
        return this.getDisplayInfoInternal(true, -1);
    }

    private int getColumnNumberOrZero() {
        JavaLineBreakpointType type = this.getXBreakpointType();
        if (type == null) {
            return 0;
        }
        XBreakpoint xBreakpoint = this.getXBreakpoint();
        if (!(xBreakpoint instanceof XLineBreakpoint)) {
            return 0;
        }
        int column = type.getColumn((XLineBreakpoint)xBreakpoint);
        if (column <= 0) {
            return 0;
        }
        return column + 1;
    }

    @NlsContexts.Label
    private String getDisplayInfoInternal(boolean showPackageInfo, int totalTextLength) {
        if (this.isValid()) {
            boolean hasMethodInfo;
            int lineNumber = this.getLineIndex() + 1;
            int columnNumber = this.getColumnNumberOrZero();
            String className = this.getClassName();
            boolean hasClassInfo = className != null && !className.isEmpty();
            String methodName = this.myMethodName;
            String displayName = methodName != null ? methodName + "()" : null;
            boolean bl = hasMethodInfo = displayName != null;
            if (hasClassInfo || hasMethodInfo) {
                StringBuilder info = new StringBuilder();
                boolean isFile = this.getFileName().equals(className);
                String packageName = null;
                if (hasClassInfo) {
                    int offset;
                    int dotIndex = className.lastIndexOf(".");
                    if (dotIndex >= 0 && !isFile) {
                        packageName = className.substring(0, dotIndex);
                        className = className.substring(dotIndex + 1);
                    }
                    if (totalTextLength != -1 && className.length() + (hasMethodInfo ? displayName.length() : 0) > totalTextLength + 3 && (offset = totalTextLength - (hasMethodInfo ? displayName.length() : 0)) > 0 && offset < className.length()) {
                        className = className.substring(className.length() - offset);
                        info.append("...");
                    }
                    info.append(className);
                }
                if (hasMethodInfo) {
                    if (isFile) {
                        info.append(":");
                    } else if (hasClassInfo) {
                        info.append(".");
                    }
                    info.append(displayName);
                }
                if (showPackageInfo && packageName != null) {
                    info.append(" (").append(packageName).append(")");
                }
                if (columnNumber > 0) {
                    return JavaDebuggerBundle.message((String)"line.breakpoint.display.name.with.column.and.class.or.method", (Object[])new Object[]{lineNumber, columnNumber, info.toString()});
                }
                return JavaDebuggerBundle.message((String)"line.breakpoint.display.name.with.class.or.method", (Object[])new Object[]{lineNumber, info.toString()});
            }
            if (columnNumber > 0) {
                return JavaDebuggerBundle.message((String)"line.breakpoint.display.name.with.column", (Object[])new Object[]{lineNumber, columnNumber});
            }
            return JavaDebuggerBundle.message((String)"line.breakpoint.display.name", (Object[])new Object[]{lineNumber});
        }
        return JavaDebuggerBundle.message((String)"status.breakpoint.invalid", (Object[])new Object[0]);
    }

    @Nullable
    private static String findOwnerMethod(PsiFile file, int offset) {
        if (offset < 0 || file instanceof JspFile) {
            return null;
        }
        if (file instanceof PsiClassOwner) {
            return (String)ReadAction.compute(() -> {
                PsiMethod method = DebuggerUtilsEx.findPsiMethod(file, offset);
                return method != null ? method.getName() : null;
            });
        }
        return null;
    }

    @Override
    public String getEventMessage(LocatableEvent event) {
        Location location = event.location();
        String sourceName = DebuggerUtilsEx.getSourceName(location, e -> this.getFileName());
        return JavaDebuggerBundle.message((String)"status.line.breakpoint.reached", (Object[])new Object[]{DebuggerUtilsEx.getLocationMethodQName(location), sourceName, this.getLineIndex() + 1});
    }

    @Override
    public PsiElement getEvaluationElement() {
        return ContextUtil.getContextElement(this.getSourcePosition());
    }

    public static LineBreakpoint create(@NotNull Project project, XBreakpoint xBreakpoint) {
        if (project == null) {
            LineBreakpoint.$$$reportNull$$$0(0);
        }
        LineBreakpoint breakpoint = new LineBreakpoint(project, xBreakpoint);
        return (LineBreakpoint)breakpoint.init();
    }

    public static boolean canAddLineBreakpoint(Project project, Document document, int lineIndex) {
        if (lineIndex < 0 || lineIndex >= document.getLineCount()) {
            return false;
        }
        BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx(project).getBreakpointManager();
        LineBreakpoint breakpointAtLine = breakpointManager.findBreakpoint(document, document.getLineStartOffset(lineIndex), CATEGORY);
        if (breakpointAtLine != null) {
            return false;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        boolean[] canAdd = new boolean[]{false};
        XDebuggerUtil.getInstance().iterateLine(project, document, lineIndex, element -> {
            PsiStatement[] statements;
            PsiCodeBlock body;
            int offset;
            if (element instanceof PsiWhiteSpace || PsiTreeUtil.getParentOfType((PsiElement)element, PsiComment.class, (boolean)false) != null) {
                return true;
            }
            PsiElement child = element;
            while (element != null && ((offset = element.getTextOffset()) < 0 || document.getLineNumber(offset) == lineIndex)) {
                child = element;
                element = element.getParent();
            }
            canAdd[0] = child instanceof PsiMethod && child.getTextRange().getEndOffset() >= document.getLineEndOffset(lineIndex) ? ((body = ((PsiMethod)child).getBody()) == null ? false : (statements = body.getStatements()).length > 0 && document.getLineNumber(statements[0].getTextOffset()) == lineIndex) : true;
            return false;
        });
        return canAdd[0];
    }

    @Override
    @RequiresBackgroundThread
    @RequiresReadLock
    public void reload() {
        ThreadingAssertions.softAssertReadAccess();
        super.reload();
        this.myMethodName = this.computeMethodName();
    }

    @Nullable
    protected String computeMethodName() {
        SourcePosition position = this.getSourcePosition();
        if (position != null) {
            return LineBreakpoint.findOwnerMethod(position.getFile(), position.getOffset());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/ui/breakpoints/LineBreakpoint", "create"));
    }
}

