/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.server.BuildManager;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.IncorrectCodeFragmentException;
import com.intellij.debugger.ui.impl.watch.CompilingEvaluator;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.ClassObject;
import com.intellij.openapi.compiler.CompilationException;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.module.LanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.extractMethod.PrepareFailedException;
import com.intellij.refactoring.extractMethodObject.ExtractLightMethodObjectHandler;
import com.intellij.refactoring.extractMethodObject.LightMethodObjectExtractedData;
import com.intellij.util.lang.JavaVersion;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.frame.XSuspendContext;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.java.JavaBuilder;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.java.compiler.AnnotationProcessingConfiguration;

public class CompilingEvaluatorImpl
extends CompilingEvaluator {
    private Collection<ClassObject> myCompiledClasses;
    @Nullable
    private final Module myModule;
    @Nullable
    private final LanguageLevel myLanguageLevel;

    public CompilingEvaluatorImpl(@NotNull Project project, @NotNull PsiElement context, @NotNull LightMethodObjectExtractedData data) {
        Module module;
        if (project == null) {
            CompilingEvaluatorImpl.$$$reportNull$$$0(0);
        }
        if (context == null) {
            CompilingEvaluatorImpl.$$$reportNull$$$0(1);
        }
        if (data == null) {
            CompilingEvaluatorImpl.$$$reportNull$$$0(2);
        }
        super(project, context, data);
        this.myModule = module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
        this.myLanguageLevel = module == null ? null : LanguageLevelUtil.getEffectiveLanguageLevel((Module)module);
    }

    @Override
    @NotNull
    public Collection<ClassObject> compile(@Nullable JavaSdkVersion debuggeeVersion) throws EvaluateException {
        if (this.myCompiledClasses == null) {
            ArrayList<String> options = new ArrayList<String>();
            options.add("-encoding");
            options.add("UTF-8");
            ArrayList<File> platformClasspath = new ArrayList<File>();
            ArrayList<File> classpath = new ArrayList<File>();
            AnnotationProcessingConfiguration profile = null;
            if (this.myModule != null) {
                assert (this.myProject.equals((Object)this.myModule.getProject())) : String.valueOf(this.myModule) + " is from another project";
                profile = CompilerConfiguration.getInstance((Project)this.myProject).getAnnotationProcessingConfiguration(this.myModule);
                ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)this.myModule);
                for (String s : rootManager.orderEntries().compileOnly().recursively().exportedOnly().withoutSdk().getPathsList().getPathList()) {
                    classpath.add(new File(s));
                }
                for (String s : rootManager.orderEntries().compileOnly().sdkOnly().getPathsList().getPathList()) {
                    platformClasspath.add(new File(s));
                }
                if (this.myLanguageLevel != null && this.myLanguageLevel.isPreview()) {
                    options.add("--enable-preview");
                }
            }
            JavaBuilder.addAnnotationProcessingOptions(options, profile);
            Pair runtime = BuildManager.getJavacRuntimeSdk((Project)this.myProject);
            JavaSdkVersion buildRuntimeVersion = (JavaSdkVersion)runtime.getSecond();
            if (buildRuntimeVersion != null && debuggeeVersion != null) {
                JavaSdkVersion minVersion = debuggeeVersion.compareTo((Enum)buildRuntimeVersion) < 0 ? debuggeeVersion : buildRuntimeVersion;
                String sourceOption = JpsJavaSdkType.complianceOption((JavaVersion)minVersion.getMaxLanguageLevel().toJavaVersion());
                options.add("-source");
                options.add(sourceOption);
                options.add("-target");
                options.add(sourceOption);
            }
            CompilerManager compilerManager = CompilerManager.getInstance((Project)this.myProject);
            File sourceFile = null;
            try {
                sourceFile = this.generateTempSourceFile(compilerManager.getJavacCompilerWorkingDir());
                File srcDir = sourceFile.getParentFile();
                List sourcePath = Collections.emptyList();
                Set<File> sources = Collections.singleton(sourceFile);
                this.myCompiledClasses = compilerManager.compileJavaCode(options, platformClasspath, classpath, Collections.emptyList(), Collections.emptyList(), sourcePath, sources, srcDir);
            }
            catch (CompilationException e) {
                StringBuilder res = new StringBuilder("Compilation failed:\n");
                for (CompilationException.Message m : e.getMessages()) {
                    if (m.getCategory() != CompilerMessageCategory.ERROR) continue;
                    res.append(m.getText()).append("\n");
                }
                throw new IncorrectCodeFragmentException(res.toString());
            }
            catch (Exception e) {
                throw new EvaluateException(e.getMessage());
            }
            finally {
                if (sourceFile != null) {
                    FileUtil.delete((File)sourceFile);
                }
            }
        }
        Collection<ClassObject> collection = this.myCompiledClasses;
        if (collection == null) {
            CompilingEvaluatorImpl.$$$reportNull$$$0(3);
        }
        return collection;
    }

    private File generateTempSourceFile(File workingDir) throws IOException {
        Pair fileData = (Pair)ReadAction.compute(() -> {
            PsiFile file = this.myData.getGeneratedInnerClass().getContainingFile();
            return Pair.create((Object)file.getName(), (Object)file.getText());
        });
        if (fileData.first == null) {
            throw new IOException("Class file name not specified");
        }
        if (fileData.second == null) {
            throw new IOException("Class source code not specified");
        }
        File file = new File(workingDir, "debugger/src/" + (String)fileData.first);
        FileUtil.writeToFile((File)file, (String)((String)fileData.second));
        return file;
    }

    @Nullable
    public static CompilingEvaluator create(@NotNull Project project, @Nullable PsiElement psiContext, @NotNull Function<? super PsiElement, ? extends PsiCodeFragment> fragmentFactory) throws EvaluateException {
        if (project == null) {
            CompilingEvaluatorImpl.$$$reportNull$$$0(4);
        }
        if (fragmentFactory == null) {
            CompilingEvaluatorImpl.$$$reportNull$$$0(5);
        }
        return CompilingEvaluatorImpl.create(project, psiContext, null, fragmentFactory);
    }

    @ApiStatus.Internal
    @Nullable
    public static CompilingEvaluator create(@NotNull Project project, @Nullable PsiElement psiContext, @Nullable String generatedClassName, @NotNull Function<? super PsiElement, ? extends PsiCodeFragment> fragmentFactory) throws EvaluateException {
        if (project == null) {
            CompilingEvaluatorImpl.$$$reportNull$$$0(6);
        }
        if (fragmentFactory == null) {
            CompilingEvaluatorImpl.$$$reportNull$$$0(7);
        }
        if (Registry.is((String)"debugger.compiling.evaluator") && psiContext != null) {
            return (CompilingEvaluator)ReadAction.compute(() -> {
                try {
                    XDebugSession currentSession = XDebuggerManager.getInstance((Project)project).getCurrentSession();
                    JavaSdkVersion javaVersion = CompilingEvaluatorImpl.getJavaVersion(currentSession);
                    PsiElement physicalContext = CompilingEvaluatorImpl.findPhysicalContext(psiContext);
                    LightMethodObjectExtractedData data = ExtractLightMethodObjectHandler.extractLightMethodObject((Project)project, (PsiElement)(physicalContext != null ? physicalContext : psiContext), (PsiCodeFragment)((PsiCodeFragment)fragmentFactory.apply(psiContext)), (String)(generatedClassName != null ? generatedClassName : CompilingEvaluatorImpl.getGeneratedClassName()), (JavaSdkVersion)javaVersion, (String)generatedClassName);
                    if (data != null) {
                        return new CompilingEvaluatorImpl(project, psiContext, data);
                    }
                }
                catch (PrepareFailedException e) {
                    NodeDescriptorImpl.LOG.info((Throwable)e);
                }
                return null;
            });
        }
        return null;
    }

    @Nullable
    private static PsiElement findPhysicalContext(@NotNull PsiElement element) {
        if (element == null) {
            CompilingEvaluatorImpl.$$$reportNull$$$0(8);
        }
        while (element != null && !element.isPhysical()) {
            element = element.getContext();
        }
        return element;
    }

    @Nullable
    public static JavaSdkVersion getJavaVersion(@Nullable XDebugSession session) {
        XSuspendContext suspendContext;
        if (session != null && (suspendContext = session.getSuspendContext()) instanceof SuspendContextImpl) {
            SuspendContextImpl suspendContextImpl = (SuspendContextImpl)suspendContext;
            return JavaSdkVersion.fromVersionString((String)suspendContextImpl.getVirtualMachineProxy().version());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/impl/watch/CompilingEvaluatorImpl";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragmentFactory";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/impl/watch/CompilingEvaluatorImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "compile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findPhysicalContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

