/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.impl.descriptors.data.DescriptorKey;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import java.util.HashMap;
import java.util.Map;

public class MarkedDescriptorTree {
    private final HashMap<NodeDescriptor, Map<DescriptorKey<? extends NodeDescriptor>, NodeDescriptor>> myChildrenMap = new HashMap();
    private final Map<DescriptorKey<? extends NodeDescriptor>, NodeDescriptor> myRootChildren = new HashMap<DescriptorKey<? extends NodeDescriptor>, NodeDescriptor>();

    public <T extends NodeDescriptor> void addChild(NodeDescriptor parent, T child, DescriptorKey<T> key) {
        Map<DescriptorKey<? extends NodeDescriptor>, NodeDescriptor> children;
        if (parent == null) {
            children = this.myRootChildren;
        } else {
            children = this.myChildrenMap.get(parent);
            if (children == null) {
                children = new HashMap<DescriptorKey<? extends NodeDescriptor>, NodeDescriptor>();
                this.myChildrenMap.put(parent, children);
            }
        }
        children.put(key, child);
    }

    public <T extends NodeDescriptor> T getChild(NodeDescriptor parent, DescriptorKey<T> key) {
        if (parent == null) {
            return (T)this.myRootChildren.get(key);
        }
        Map<DescriptorKey<? extends NodeDescriptor>, NodeDescriptor> map2 = this.myChildrenMap.get(parent);
        return (T)(map2 != null ? map2.get(key) : null);
    }

    public void clear() {
        this.myChildrenMap.clear();
        this.myRootChildren.clear();
    }
}

