/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.xdebugger.XDebuggerBundle;
import java.util.function.Supplier;

public class MessageDescriptor
extends NodeDescriptorImpl {
    public static final int ERROR = 0;
    public static final int WARNING = 1;
    public static final int INFORMATION = 2;
    public static final int SPECIAL = 3;
    private final int myKind;
    private final Supplier<@NlsContexts.Label String> myMessage;
    public static final MessageDescriptor DEBUG_INFO_UNAVAILABLE = new MessageDescriptor(JavaDebuggerBundle.messagePointer((String)"message.node.debug.info.not.available", (Object[])new Object[0]));
    public static final MessageDescriptor LOCAL_VARIABLES_INFO_UNAVAILABLE = new MessageDescriptor(JavaDebuggerBundle.messagePointer((String)"message.node.local.variables.debug.info.not.available", (Object[])new Object[0]));
    public static final MessageDescriptor ARRAY_IS_EMPTY = new MessageDescriptor(JavaDebuggerBundle.messagePointer((String)"message.node.empty.array", (Object[])new Object[0]));
    public static final MessageDescriptor CLASS_HAS_NO_FIELDS = new MessageDescriptor(JavaDebuggerBundle.messagePointer((String)"message.node.class.has.no.fields", (Object[])new Object[0]));
    public static final MessageDescriptor OBJECT_COLLECTED = new MessageDescriptor(JavaDebuggerBundle.messagePointer((String)"message.node.object.collected", (Object[])new Object[0]));
    public static final MessageDescriptor EVALUATING = new MessageDescriptor(XDebuggerBundle.messagePointer((String)"xdebugger.building.tree.node.message", (Object[])new Object[0]));
    public static final MessageDescriptor THREAD_IS_RUNNING = new MessageDescriptor(JavaDebuggerBundle.messagePointer((String)"message.node.thread.running", (Object[])new Object[0]));
    public static final MessageDescriptor THREAD_IS_EMPTY = new MessageDescriptor(JavaDebuggerBundle.messagePointer((String)"message.node.thread.has.no.frames", (Object[])new Object[0]));
    public static final MessageDescriptor EVALUATION_NOT_POSSIBLE = new MessageDescriptor(JavaDebuggerBundle.messagePointer((String)"message.node.evaluation.not.possible", (Object[])new Object[]{1}));

    public MessageDescriptor(Supplier<@NlsContexts.Label String> message) {
        this(message, 2);
    }

    public MessageDescriptor(Supplier<@NlsContexts.Label String> message, int kind) {
        this.myKind = kind;
        this.myMessage = message;
    }

    public MessageDescriptor(@NlsContexts.Label String message) {
        this(message, 2);
    }

    public MessageDescriptor(@NlsContexts.Label String message, int kind) {
        this(() -> message, kind);
    }

    public int getKind() {
        return this.myKind;
    }

    @Override
    public String getLabel() {
        return this.myMessage.get();
    }

    @Override
    public boolean isExpandable() {
        return false;
    }

    @Override
    public void setContext(EvaluationContextImpl context) {
    }

    @Override
    protected String calcRepresentation(EvaluationContextImpl context, DescriptorLabelListener labelListener) throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return this.myMessage.get();
    }
}

