/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiExpression;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;

public class MethodReturnValueDescriptorImpl
extends ValueDescriptorImpl {
    private final Method myMethod;

    public MethodReturnValueDescriptorImpl(Project project, @NotNull Method method, Value value) {
        if (method == null) {
            MethodReturnValueDescriptorImpl.$$$reportNull$$$0(0);
        }
        super(project, value);
        this.myMethod = method;
    }

    @Override
    public Value calcValue(EvaluationContextImpl evaluationContext) throws EvaluateException {
        return this.getValue();
    }

    @NotNull
    public Method getMethod() {
        Method method = this.myMethod;
        if (method == null) {
            MethodReturnValueDescriptorImpl.$$$reportNull$$$0(1);
        }
        return method;
    }

    @Override
    public String getName() {
        return NodeRendererSettings.getInstance().getClassRenderer().renderTypeName(this.myMethod.declaringType().name()) + "." + DebuggerUtilsEx.methodNameWithArguments(this.myMethod);
    }

    @Override
    public Type getType() {
        Type type = super.getType();
        if (type == null) {
            try {
                type = this.myMethod.returnType();
            }
            catch (ClassNotLoadedException classNotLoadedException) {
                // empty catch block
            }
        }
        return type;
    }

    @Override
    public PsiExpression getDescriptorEvaluation(DebuggerContext context) throws EvaluateException {
        Value value = this.getValue();
        if (value instanceof ObjectReference) {
            throw new ValueDescriptorImpl.NeedMarkException((ObjectReference)value);
        }
        return null;
    }

    @Override
    public boolean canSetValue() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/impl/watch/MethodReturnValueDescriptorImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/impl/watch/MethodReturnValueDescriptorImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

