/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.sun.jdi.Method;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.Nullable;

public class MethodsTracker {
    private final Object2IntOpenHashMap<Method> myMethodCounter = new Object2IntOpenHashMap();
    private final MyCache<MethodOccurrence> myCache = new MyCache();
    private final CompletableFuture<Void> myFinished = new CompletableFuture();

    public void finish() {
        this.myFinished.complete(null);
    }

    public MethodOccurrence getMethodOccurrence(int frameIndex, @Nullable Method method) {
        return (MethodOccurrence)this.myCache.computeIfAbsent(frameIndex, __ -> {
            Object2IntOpenHashMap<Method> object2IntOpenHashMap = this.myMethodCounter;
            synchronized (object2IntOpenHashMap) {
                int occurrence = method != null ? this.myMethodCounter.addTo((Object)method, 1) : 0;
                return new MethodOccurrence(method, occurrence);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getOccurrenceCount(@Nullable Method method) {
        Object2IntOpenHashMap<Method> object2IntOpenHashMap = this.myMethodCounter;
        synchronized (object2IntOpenHashMap) {
            return this.myMethodCounter.getInt((Object)method);
        }
    }

    private CompletableFuture<Integer> getExactOccurrenceCount(@Nullable Method method) {
        return this.myFinished.thenApply(__ -> this.myMethodCounter.getInt((Object)method));
    }

    private static class MyCache<V>
    extends Int2ObjectOpenHashMap<V> {
        private volatile CompletableFuture<Void> myRehashFinished = CompletableFuture.completedFuture(null);

        private MyCache() {
        }

        public CompletableFuture<V> getExact(int key) {
            return this.myRehashFinished.thenApply(__ -> super.get(key));
        }

        protected void rehash(int newN) {
            this.myRehashFinished = new CompletableFuture();
            super.rehash(newN);
            this.myRehashFinished.complete(null);
        }
    }

    public final class MethodOccurrence {
        @Nullable
        private final Method myMethod;
        private final int myIndex;

        private MethodOccurrence(Method method, int index) {
            this.myMethod = method;
            this.myIndex = index;
        }

        @Nullable
        public Method getMethod() {
            return this.myMethod;
        }

        public CompletableFuture<Integer> getExactRecursiveIndex() {
            if (this.myMethod == null) {
                return CompletableFuture.completedFuture(0);
            }
            return MethodsTracker.this.getExactOccurrenceCount(this.myMethod).thenApply(occurrenceCount -> {
                if (occurrenceCount <= 1) {
                    return -1;
                }
                return occurrenceCount - this.myIndex;
            });
        }

        public int getIndex() {
            return MethodsTracker.this.getOccurrenceCount(this.myMethod) - this.myIndex;
        }

        public boolean isRecursive() {
            return this.myMethod != null && MethodsTracker.this.getOccurrenceCount(this.myMethod) > 1;
        }

        MethodOccurrence getMethodOccurrenceSync(int frameIndex) {
            return (MethodOccurrence)MethodsTracker.this.myCache.get(frameIndex);
        }

        CompletableFuture<MethodOccurrence> getMethodOccurrenceAsync(int frameIndex) {
            return MethodsTracker.this.myCache.getExact(frameIndex);
        }
    }
}

