/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.CompoundPositionManager;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.impl.SimpleStackFrameContext;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.settings.ThreadsViewSettings;
import com.intellij.debugger.ui.breakpoints.BreakpointIntentionAction;
import com.intellij.debugger.ui.impl.watch.CanDropFrameUtilsKt;
import com.intellij.debugger.ui.impl.watch.MethodsTracker;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.tree.StackFrameDescriptor;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiFile;
import com.intellij.util.IconUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.TypeComponent;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StackFrameDescriptorImpl
extends NodeDescriptorImpl
implements StackFrameDescriptor {
    private final StackFrameProxyImpl myFrame;
    private int myUiIndex;
    private String myName;
    private Location myLocation;
    @Nullable
    private Method myMethod;
    @Nullable
    private MethodsTracker.MethodOccurrence myMethodOccurrence;
    private boolean myIsSynthetic;
    private boolean myIsInLibraryContent;
    private boolean myIsFiltered;
    private ObjectReference myThisObject;
    private SourcePosition mySourcePosition;
    private Icon myIcon;

    public StackFrameDescriptorImpl(@NotNull StackFrameProxyImpl frame) {
        if (frame == null) {
            StackFrameDescriptorImpl.$$$reportNull$$$0(0);
        }
        this(frame, null);
    }

    @Deprecated
    public StackFrameDescriptorImpl(@NotNull StackFrameProxyImpl frame, @Nullable MethodsTracker tracker) {
        if (frame == null) {
            StackFrameDescriptorImpl.$$$reportNull$$$0(1);
        }
        this(frame, false, null, tracker, ContextUtil.getSourcePosition(new SimpleStackFrameContext(frame, frame.getVirtualMachine().getDebugProcess())));
    }

    public StackFrameDescriptorImpl(@NotNull MethodsTracker tracker, @NotNull StackFrameProxyImpl frame) {
        if (tracker == null) {
            StackFrameDescriptorImpl.$$$reportNull$$$0(2);
        }
        if (frame == null) {
            StackFrameDescriptorImpl.$$$reportNull$$$0(3);
        }
        this(frame, false, null, tracker, ContextUtil.getSourcePosition(new SimpleStackFrameContext(frame, frame.getVirtualMachine().getDebugProcess())));
    }

    private StackFrameDescriptorImpl(@NotNull StackFrameProxyImpl frame, boolean useMethod, @Nullable Method method, @Nullable MethodsTracker tracker, SourcePosition sourcePosition) {
        if (frame == null) {
            StackFrameDescriptorImpl.$$$reportNull$$$0(4);
        }
        this.myName = null;
        this.myIcon = EmptyIcon.ICON_16;
        this.myFrame = frame;
        try {
            this.myUiIndex = frame.getFrameIndex();
            this.myLocation = frame.location();
            if (!this.getValueMarkers().isEmpty()) {
                this.getThisObject();
            }
            this.myMethod = useMethod ? method : DebuggerUtilsEx.getMethod(this.myLocation);
            this.myMethodOccurrence = tracker == null ? null : tracker.getMethodOccurrence(this.myUiIndex, this.myMethod);
            this.myIsSynthetic = DebuggerUtils.isSynthetic((TypeComponent)this.myMethod);
            this.mySourcePosition = sourcePosition;
            PsiFile psiFile = this.mySourcePosition != null ? this.mySourcePosition.getFile() : null;
            this.myIsInLibraryContent = DebuggerUtilsEx.isInLibraryContent(psiFile != null ? psiFile.getVirtualFile() : null, this.getDebugProcess().getProject());
            this.myIsFiltered = DebugProcessImpl.isPositionFiltered(this.myLocation);
        }
        catch (EvaluateException | InternalException e) {
            LOG.info(e);
            this.myLocation = null;
            this.myMethodOccurrence = null;
            this.myIsSynthetic = false;
            this.myIsInLibraryContent = false;
            this.myIsFiltered = false;
        }
    }

    private static CompletableFuture<SourcePosition> getSourcePositionAsync(@NotNull Location location, @NotNull StackFrameProxyImpl frame) {
        if (location == null) {
            StackFrameDescriptorImpl.$$$reportNull$$$0(5);
        }
        if (frame == null) {
            StackFrameDescriptorImpl.$$$reportNull$$$0(6);
        }
        try {
            CompoundPositionManager positionManager = frame.getVirtualMachine().getDebugProcess().getPositionManager();
            return positionManager.getSourcePositionFuture(location);
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    public static CompletableFuture<StackFrameDescriptorImpl> createAsync(@NotNull StackFrameProxyImpl frame, @NotNull MethodsTracker tracker) {
        if (frame == null) {
            StackFrameDescriptorImpl.$$$reportNull$$$0(7);
        }
        if (tracker == null) {
            StackFrameDescriptorImpl.$$$reportNull$$$0(8);
        }
        CompletableFuture<Location> locationAsync = frame.locationAsync();
        CompletionStage positionAsync = locationAsync.thenCompose(location -> StackFrameDescriptorImpl.getSourcePositionAsync(location, frame));
        return ((CompletableFuture)((CompletableFuture)locationAsync.thenCompose(DebuggerUtilsAsync::method)).thenCombine(positionAsync, (method, position) -> {
            DebuggerManagerThreadImpl.assertIsManagerThread();
            return new StackFrameDescriptorImpl(frame, true, (Method)method, tracker, (SourcePosition)position);
        })).exceptionally(throwable -> {
            Throwable exception = DebuggerUtilsAsync.unwrap(throwable);
            if (exception instanceof EvaluateException) {
                if (!(exception.getCause() instanceof InvalidStackFrameException)) {
                    LOG.error((Throwable)new Exception(exception));
                }
                DebuggerManagerThreadImpl.assertIsManagerThread();
                return new StackFrameDescriptorImpl(frame, tracker);
            }
            throw (RuntimeException)throwable;
        });
    }

    public int getUiIndex() {
        return this.myUiIndex;
    }

    @NotNull
    public StackFrameProxyImpl getFrameProxy() {
        StackFrameProxyImpl stackFrameProxyImpl = this.myFrame;
        if (stackFrameProxyImpl == null) {
            StackFrameDescriptorImpl.$$$reportNull$$$0(9);
        }
        return stackFrameProxyImpl;
    }

    @NotNull
    public DebugProcess getDebugProcess() {
        DebugProcessImpl debugProcessImpl = this.myFrame.getVirtualMachine().getDebugProcess();
        if (debugProcessImpl == null) {
            StackFrameDescriptorImpl.$$$reportNull$$$0(10);
        }
        return debugProcessImpl;
    }

    @Nullable
    public Method getMethod() {
        return this.myMethod;
    }

    public CompletableFuture<Integer> getExactRecursiveIndex() {
        return this.myMethodOccurrence == null ? CompletableFuture.completedFuture(0) : this.myMethodOccurrence.getExactRecursiveIndex();
    }

    public int getOccurrenceIndex() {
        return this.myMethodOccurrence == null ? 0 : this.myMethodOccurrence.getIndex();
    }

    public boolean isRecursiveCall() {
        return this.myMethodOccurrence != null && this.myMethodOccurrence.isRecursive();
    }

    public ThreeState canDrop() {
        if (this.myFrame.isBottom()) {
            return ThreeState.NO;
        }
        return CanDropFrameUtilsKt.canDropFrameSync(this);
    }

    public CompletableFuture<Boolean> canDropAsync() {
        if (this.myFrame.isBottom()) {
            return CompletableFuture.completedFuture(false);
        }
        return CanDropFrameUtilsKt.canDropFrameAsync(this);
    }

    @Nullable
    MethodsTracker.MethodOccurrence getMethodOccurrence() {
        return this.myMethodOccurrence;
    }

    @Nullable
    public ValueMarkup getValueMarkup() {
        Map<?, ValueMarkup> markers = this.getValueMarkers();
        if (!markers.isEmpty() && this.myThisObject != null) {
            return markers.get(this.myThisObject);
        }
        return null;
    }

    private Map<?, ValueMarkup> getValueMarkers() {
        XValueMarkers<?, ?> markers = DebuggerUtilsImpl.getValueMarkers(this.getDebugProcess());
        return markers != null ? markers.getAllMarkers() : Collections.emptyMap();
    }

    @Override
    public String getName() {
        return this.myName;
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            StackFrameDescriptorImpl.$$$reportNull$$$0(11);
        }
        this.myName = name;
    }

    @Override
    protected String calcRepresentation(EvaluationContextImpl context, DescriptorLabelListener descriptorLabelListener) throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.calcIconLater(descriptorLabelListener);
        if (this.myLocation == null) {
            return "";
        }
        ThreadsViewSettings settings = ThreadsViewSettings.getInstance();
        @NlsSafe StringBuilder label = new StringBuilder();
        if (this.myMethod != null) {
            if (this.myName == null) {
                this.myName = this.myMethod.name();
            }
            label.append(settings.SHOW_ARGUMENTS_TYPES ? DebuggerUtilsEx.methodNameWithArguments(this.myMethod) : this.myName);
        }
        if (settings.SHOW_LINE_NUMBER) {
            label.append(':').append(DebuggerUtilsEx.getLineNumber(this.myLocation, false));
            if (Registry.is((String)"debugger.stack.frame.show.code.index")) {
                label.append(':').append(DebuggerUtilsEx.getCodeIndex(this.myLocation));
            }
        }
        if (settings.SHOW_CLASS_NAME) {
            String name;
            try {
                ReferenceType refType = this.myLocation.declaringType();
                name = refType != null ? refType.name() : null;
            }
            catch (InternalError e) {
                name = e.toString();
            }
            if (name != null) {
                label.append(", ");
                int dotIndex = name.lastIndexOf(46);
                if (dotIndex < 0) {
                    label.append(name);
                } else {
                    label.append(name.substring(dotIndex + 1));
                    if (settings.SHOW_PACKAGE_NAME) {
                        label.append(" {");
                        label.append(name, 0, dotIndex);
                        label.append("}");
                    }
                }
            }
        }
        if (settings.SHOW_SOURCE_NAME) {
            label.append(", ").append(DebuggerUtilsEx.getSourceName(this.myLocation, "Unknown Source"));
        }
        return label.toString();
    }

    @Override
    public boolean isExpandable() {
        return true;
    }

    @Override
    public final void setContext(EvaluationContextImpl context) {
    }

    public boolean isSynthetic() {
        return this.myIsSynthetic;
    }

    public boolean isInLibraryContent() {
        return this.myIsInLibraryContent;
    }

    public boolean shouldHide() {
        return this.isSynthetic() || this.isInLibraryContent() || DebugProcessImpl.shouldHideStackFramesUsingSteppingFilters() && this.myIsFiltered;
    }

    @Nullable
    public Location getLocation() {
        return this.myLocation;
    }

    public SourcePosition getSourcePosition() {
        return this.mySourcePosition;
    }

    private void calcIconLater(DescriptorLabelListener descriptorLabelListener) {
        try {
            ((CompletableFuture)this.myFrame.isObsolete().thenAccept(res -> {
                if (res.booleanValue()) {
                    this.myIcon = IconUtil.scaleByIconWidth((Icon)AllIcons.Debugger.Db_obsolete, null, (Icon)EmptyIcon.ICON_16);
                    descriptorLabelListener.labelChanged();
                }
            })).exceptionally(throwable -> (Void)DebuggerUtilsAsync.logError(throwable));
        }
        catch (EvaluateException evaluateException) {
            // empty catch block
        }
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    @Nullable
    public ObjectReference getThisObject() {
        if (this.myThisObject == null) {
            try {
                this.myThisObject = this.myFrame.thisObject();
            }
            catch (EvaluateException e) {
                LOG.info((Throwable)e);
            }
            if (this.myThisObject != null) {
                this.putUserData(BreakpointIntentionAction.THIS_ID_KEY, this.myThisObject.uniqueID());
                this.putUserData(BreakpointIntentionAction.THIS_TYPE_KEY, this.myThisObject.type().name());
            }
        }
        return this.myThisObject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracker";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/impl/watch/StackFrameDescriptorImpl";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/impl/watch/StackFrameDescriptorImpl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameProxy";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSourcePositionAsync";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createAsync";
                break;
            }
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10 -> new IllegalStateException(string);
        };
    }
}

