/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.overhead;

import com.intellij.CommonBundle;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.overhead.OverheadProducer;
import com.intellij.debugger.ui.overhead.OverheadTimings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.pom.Navigatable;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableUtil;
import com.intellij.ui.table.TableView;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SortOrder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OverheadView
extends BorderLayoutPanel
implements Disposable,
UiDataProvider {
    @NotNull
    private final DebugProcessImpl myProcess;
    static final EnabledColumnInfo ENABLED_COLUMN = new EnabledColumnInfo();
    static final NameColumnInfo NAME_COLUMN = new NameColumnInfo();
    private final TableView<OverheadProducer> myTable;
    private final ListTableModel<OverheadProducer> myModel;
    private final MergingUpdateQueue myUpdateQueue;
    private Runnable myBouncer;
    private static final SimpleTextAttributes STRIKEOUT_ATTRIBUTES = new SimpleTextAttributes(4, null);

    public OverheadView(final @NotNull DebugProcessImpl process) {
        if (process == null) {
            OverheadView.$$$reportNull$$$0(0);
        }
        this.myProcess = process;
        this.myModel = new ListTableModel(new ColumnInfo[]{ENABLED_COLUMN, NAME_COLUMN, new TimingColumnInfo(JavaDebuggerBundle.message((String)"column.name.hits", (Object[])new Object[0]), s -> OverheadTimings.getHits(this.myProcess, s)), new TimingColumnInfo(JavaDebuggerBundle.message((String)"column.name.time.ms", (Object[])new Object[0]), s -> OverheadTimings.getTime(this.myProcess, s))}, new ArrayList<OverheadProducer>(OverheadTimings.getProducers(process)), 3, SortOrder.DESCENDING);
        this.myModel.setSortable(true);
        this.myTable = new TableView(this.myModel);
        this.addToCenter(ScrollPaneFactory.createScrollPane(this.myTable, (boolean)true));
        TableUtil.setupCheckboxColumn((TableColumn)this.myTable.getColumnModel().getColumn(0));
        this.myUpdateQueue = new MergingUpdateQueue("OverheadView", 500, true, null, (Disposable)this);
        OverheadTimings.addListener(new OverheadTimings.OverheadTimingsListener(){

            @Override
            public void timingAdded(final OverheadProducer o) {
                OverheadView.this.myUpdateQueue.queue(new Update(o){

                    public void run() {
                        int idx = OverheadView.this.myModel.indexOf((Object)o);
                        if (idx != -1) {
                            OverheadView.this.myModel.fireTableRowsUpdated(idx, idx);
                            return;
                        }
                        OverheadView.this.myModel.setItems(new ArrayList<OverheadProducer>(OverheadTimings.getProducers(process)));
                    }
                });
            }

            @Override
            public void excessiveOverheadDetected() {
                if (OverheadView.this.myBouncer != null) {
                    DebuggerUIUtil.invokeLater((Runnable)OverheadView.this.myBouncer);
                }
            }
        }, process);
        new DumbAwareAction(CommonBundle.message((String)"action.text.toggle", (Object[])new Object[0])){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                e.getPresentation().setEnabled(OverheadView.this.myTable.getSelectedRowCount() == 1);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    2.$$$reportNull$$$0(1);
                }
                return actionUpdateThread;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(2);
                }
                OverheadView.this.myTable.getSelection().forEach(c -> c.setEnabled(!c.isEnabled()));
                OverheadView.this.myTable.repaint();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/debugger/ui/overhead/OverheadView$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/debugger/ui/overhead/OverheadView$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(32, 0)), this.myTable);
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                ReadAction.nonBlocking(() -> (Navigatable)ContainerUtil.getFirstItem((List)ContainerUtil.mapNotNull(OverheadView.this.getSelectedBreakpoints(), XBreakpoint::getNavigatable))).expireWith((Disposable)OverheadView.this).finishOnUiThread(ModalityState.nonModal(), navigatable -> {
                    if (navigatable != null) {
                        navigatable.navigate(true);
                    }
                }).submit((Executor)AppExecutorUtil.getAppExecutorService());
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/debugger/ui/overhead/OverheadView$3", "onDoubleClick"));
            }
        }.installOn(this.myTable);
    }

    private List<XBreakpoint> getSelectedBreakpoints() {
        return StreamEx.of((Collection)this.myTable.getSelection()).select(Breakpoint.class).map(Breakpoint::getXBreakpoint).nonNull().toList();
    }

    public JComponent getDefaultFocusedComponent() {
        return this.myTable;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            OverheadView.$$$reportNull$$$0(1);
        }
        List<XBreakpoint> selection = this.getSelectedBreakpoints();
        sink.lazy(CommonDataKeys.NAVIGATABLE_ARRAY, () -> {
            List navigatables = ContainerUtil.mapNotNull((Collection)selection, XBreakpoint::getNavigatable);
            return navigatables.isEmpty() ? null : navigatables.toArray(Navigatable.EMPTY_NAVIGATABLE_ARRAY);
        });
    }

    public void dispose() {
    }

    public void setBouncer(Runnable bouncer) {
        this.myBouncer = bouncer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/ui/overhead/OverheadView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "uiDataSnapshot";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class EnabledColumnInfo
    extends ColumnInfo<OverheadProducer, Boolean> {
        EnabledColumnInfo() {
            super("");
        }

        public Class<?> getColumnClass() {
            return Boolean.class;
        }

        @Nullable
        public Boolean valueOf(OverheadProducer item) {
            return item.isEnabled();
        }

        public boolean isCellEditable(OverheadProducer item) {
            return true;
        }

        public void setValue(OverheadProducer item, Boolean value) {
            item.setEnabled(value);
        }
    }

    private static class NameColumnInfo
    extends ColumnInfo<OverheadProducer, OverheadProducer> {
        NameColumnInfo() {
            super(CommonBundle.message((String)"title.name", (Object[])new Object[0]));
        }

        @Nullable
        public OverheadProducer valueOf(OverheadProducer aspects) {
            return aspects;
        }

        public Class<?> getColumnClass() {
            return OverheadProducer.class;
        }

        @Nullable
        public TableCellRenderer getRenderer(OverheadProducer producer) {
            return new ColoredTableCellRenderer(){

                protected void customizeCellRenderer(@NotNull JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
                    if (table == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (value instanceof OverheadProducer) {
                        OverheadProducer overheadProducer = (OverheadProducer)value;
                        if (overheadProducer.isObsolete()) {
                            this.overrideAttributes(overheadProducer, STRIKEOUT_ATTRIBUTES);
                        } else if (!overheadProducer.isEnabled()) {
                            this.overrideAttributes(overheadProducer, SimpleTextAttributes.GRAYED_ATTRIBUTES);
                        } else {
                            overheadProducer.customizeRenderer((SimpleColoredComponent)this);
                        }
                    }
                    this.setTransparentIconBackground(true);
                }

                private void overrideAttributes(OverheadProducer overhead, SimpleTextAttributes attributes) {
                    SimpleColoredComponent component = new SimpleColoredComponent();
                    overhead.customizeRenderer(component);
                    component.iterator().forEachRemaining(f -> this.append((String)f, attributes));
                    this.setIcon(component.getIcon());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/debugger/ui/overhead/OverheadView$NameColumnInfo$1", "customizeCellRenderer"));
                }
            };
        }
    }

    private static class TimingColumnInfo
    extends ColumnInfo<OverheadProducer, OverheadProducer> {
        private final Function<? super OverheadProducer, Long> myGetter;

        TimingColumnInfo(@NlsContexts.ColumnName @NotNull String name, Function<? super OverheadProducer, Long> getter) {
            if (name == null) {
                TimingColumnInfo.$$$reportNull$$$0(0);
            }
            super(name);
            this.myGetter = getter;
        }

        @Nullable
        public OverheadProducer valueOf(OverheadProducer aspects) {
            return aspects;
        }

        public Class<?> getColumnClass() {
            return OverheadProducer.class;
        }

        @Nullable
        public TableCellRenderer getRenderer(OverheadProducer producer) {
            return new ColoredTableCellRenderer(){

                protected void customizeCellRenderer(@NotNull JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
                    if (table == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (value instanceof OverheadProducer) {
                        OverheadProducer overheadProducer = (OverheadProducer)value;
                        Long val = myGetter.apply(overheadProducer);
                        this.append(val != null ? String.valueOf(val) : "", overheadProducer.isEnabled() ? SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/debugger/ui/overhead/OverheadView$TimingColumnInfo$1", "customizeCellRenderer"));
                }
            };
        }

        @Nullable
        public Comparator<OverheadProducer> getComparator() {
            return Comparator.comparing(c -> {
                Long value = this.myGetter.apply((OverheadProducer)c);
                return value != null ? value : Long.MAX_VALUE;
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/debugger/ui/overhead/OverheadView$TimingColumnInfo", "<init>"));
        }
    }
}

