/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.PossiblySyncCommand;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.managerThread.DebuggerCommand;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.impl.MethodNotFoundException;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.ui.tree.render.ToStringCommand;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.IntelliJProjectUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.rt.debugger.BatchEvaluatorServer;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.impl.evaluate.XEvaluationOrigin;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u000e2\u00020\u0001:\u0002\r\u000eB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bR:\u0010\u0004\u001a.\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005j\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/debugger/ui/tree/render/BatchEvaluator;", "", "<init>", "()V", "myBuffer", "Ljava/util/HashMap;", "Lcom/intellij/debugger/engine/SuspendContext;", "", "Lcom/intellij/debugger/ui/tree/render/ToStringCommand;", "Lkotlin/collections/HashMap;", "invoke", "", "command", "BatchEvaluatorCommand", "Companion", "intellij.java.debugger.impl"})
public final class BatchEvaluator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HashMap<SuspendContext, List<ToStringCommand>> myBuffer = new HashMap();
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Key<BatchEvaluator> BATCH_EVALUATOR_KEY;
    @JvmField
    @NotNull
    public static final Key<Boolean> REMOTE_SESSION_KEY;

    private BatchEvaluator() {
    }

    public final void invoke(@NotNull ToStringCommand command2) {
        Intrinsics.checkNotNullParameter((Object)command2, (String)"command");
        DebuggerManagerThreadImpl.Companion.assertIsManagerThread();
        EvaluationContext evaluationContext = command2.getEvaluationContext();
        SuspendContext suspendContext = evaluationContext.getSuspendContext();
        Intrinsics.checkNotNull((Object)suspendContext, (String)"null cannot be cast to non-null type com.intellij.debugger.engine.SuspendContextImpl");
        SuspendContextImpl suspendContext2 = (SuspendContextImpl)suspendContext;
        if (!(command2.getValue() instanceof ObjectReference) || !Registry.Companion.is("debugger.batch.evaluation.force") && !Registry.Companion.is("debugger.batch.evaluation")) {
            suspendContext2.getManagerThread().invokeCommand((DebuggerCommand)command2);
        } else {
            this.myBuffer.computeIfAbsent(suspendContext2, arg_0 -> BatchEvaluator.invoke$lambda$1(arg_0 -> BatchEvaluator.invoke$lambda$0(suspendContext2, this, evaluationContext, arg_0), arg_0)).add(command2);
        }
    }

    private static final List invoke$lambda$0(SuspendContextImpl $suspendContext, BatchEvaluator this$0, EvaluationContext $evaluationContext, SuspendContext it) {
        DebuggerManagerThreadImpl debuggerManagerThreadImpl = $suspendContext.getManagerThread();
        Intrinsics.checkNotNull((Object)$evaluationContext);
        debuggerManagerThreadImpl.schedule(this$0.new BatchEvaluatorCommand($evaluationContext));
        return new ArrayList();
    }

    private static final List invoke$lambda$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final BatchEvaluator getBatchEvaluator(@NotNull EvaluationContext evaluationContext) {
        return Companion.getBatchEvaluator(evaluationContext);
    }

    public /* synthetic */ BatchEvaluator(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        Logger logger = Logger.getInstance(BatchEvaluator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Key key = Key.create((String)"BatchEvaluator");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        BATCH_EVALUATOR_KEY = key;
        REMOTE_SESSION_KEY = new Key("is_remote_session_key");
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0007H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/debugger/ui/tree/render/BatchEvaluator$BatchEvaluatorCommand;", "Lcom/intellij/debugger/engine/PossiblySyncCommand;", "myEvaluationContext", "Lcom/intellij/debugger/engine/evaluation/EvaluationContext;", "<init>", "(Lcom/intellij/debugger/ui/tree/render/BatchEvaluator;Lcom/intellij/debugger/engine/evaluation/EvaluationContext;)V", "syncAction", "", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "commandCancelled", "intellij.java.debugger.impl"})
    private final class BatchEvaluatorCommand
    extends PossiblySyncCommand {
        @NotNull
        private final EvaluationContext myEvaluationContext;

        public BatchEvaluatorCommand(EvaluationContext myEvaluationContext) {
            Intrinsics.checkNotNullParameter((Object)myEvaluationContext, (String)"myEvaluationContext");
            SuspendContext suspendContext = myEvaluationContext.getSuspendContext();
            Intrinsics.checkNotNull((Object)suspendContext, (String)"null cannot be cast to non-null type com.intellij.debugger.engine.SuspendContextImpl");
            super((SuspendContextImpl)suspendContext);
            this.myEvaluationContext = myEvaluationContext;
        }

        @Override
        public void syncAction(@NotNull SuspendContextImpl suspendContext) {
            Intrinsics.checkNotNullParameter((Object)((Object)suspendContext), (String)"suspendContext");
            Object v = BatchEvaluator.this.myBuffer.remove((Object)suspendContext);
            Intrinsics.checkNotNull(v);
            List commands = (List)v;
            if (commands.size() == 1 && !Registry.Companion.is("debugger.batch.evaluation.force") || !Companion.doEvaluateBatch(commands, this.myEvaluationContext)) {
                commands.forEach(BatchEvaluatorCommand::syncAction$lambda$0);
            }
        }

        @Override
        protected void commandCancelled() {
            BatchEvaluator.this.myBuffer.remove((Object)this.getSuspendContext());
        }

        private static final void syncAction$lambda$0(ToStringCommand obj) {
            ToStringCommand toStringCommand = obj;
            Intrinsics.checkNotNull((Object)toStringCommand);
            toStringCommand.action();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u001e\u0010\u0010\u001a\u00020\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0014\u001a\u0004\u0018\u00010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J*\u0010\u001b\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001c\u001a\u00020\u00152\u000e\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0007\u001a\u0015\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\b\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/debugger/ui/tree/render/BatchEvaluator$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "BATCH_EVALUATOR_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/debugger/ui/tree/render/BatchEvaluator;", "kotlin.jvm.PlatformType", "REMOTE_SESSION_KEY", "", "getBatchEvaluator", "evaluationContext", "Lcom/intellij/debugger/engine/evaluation/EvaluationContext;", "doEvaluateBatch", "requests", "", "Lcom/intellij/debugger/ui/tree/render/ToStringCommand;", "invokeDefaultHelperMethod", "", "values", "", "Lcom/sun/jdi/Value;", "evaluationContextImpl", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "invokeHelperMethod", "helperMethodName", "args", "intellij.java.debugger.impl"})
    @SourceDebugExtension(value={"SMAP\nBatchEvaluator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BatchEvaluator.kt\ncom/intellij/debugger/ui/tree/render/BatchEvaluator$Companion\n+ 2 UserDataHolderEx.kt\ncom/intellij/openapi/util/UserDataHolderExKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,199:1\n11#2:200\n12#2:202\n1#3:201\n1586#4:203\n1661#4,3:204\n1807#4,3:207\n*S KotlinDebug\n*F\n+ 1 BatchEvaluator.kt\ncom/intellij/debugger/ui/tree/render/BatchEvaluator$Companion\n*L\n83#1:200\n83#1:202\n83#1:201\n88#1:203\n88#1:204,3\n90#1:207,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final BatchEvaluator getBatchEvaluator(@NotNull EvaluationContext evaluationContext) {
            Object object;
            void $this$getOrCreateUserData$iv;
            Intrinsics.checkNotNullParameter((Object)evaluationContext, (String)"evaluationContext");
            VirtualMachineProxyImpl virtualMachineProxyImpl = ((EvaluationContextImpl)evaluationContext).getVirtualMachineProxy();
            Intrinsics.checkNotNullExpressionValue((Object)virtualMachineProxyImpl, (String)"getVirtualMachineProxy(...)");
            VirtualMachineProxyImpl virtualMachineProxy = virtualMachineProxyImpl;
            UserDataHolderEx userDataHolderEx = (UserDataHolderEx)virtualMachineProxy;
            Key key$iv = BATCH_EVALUATOR_KEY;
            boolean $i$f$getOrCreateUserData = false;
            Object object2 = $this$getOrCreateUserData$iv.getUserData(key$iv);
            if (object2 != null) {
                Object it$iv = object2;
                boolean bl = false;
                object = it$iv;
            } else {
                Key key = key$iv;
                void var9_9 = $this$getOrCreateUserData$iv;
                boolean bl = false;
                BatchEvaluator batchEvaluator = new BatchEvaluator(null);
                Object object3 = var9_9.putUserDataIfAbsent(key, (Object)batchEvaluator);
                object = object3;
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"putUserDataIfAbsent(...)");
            }
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrCreateUserData(...)");
            return (BatchEvaluator)object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final boolean doEvaluateBatch(List<ToStringCommand> requests, EvaluationContext evaluationContext) {
            block29: {
                try {
                    Object element$iv2;
                    boolean bl;
                    List values;
                    Unit unit;
                    block28: {
                        Iterator $this$mapTo$iv$iv;
                        Iterable $this$map$iv = requests;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        unit = $this$mapTo$iv$iv.iterator();
                        while (unit.hasNext()) {
                            void it;
                            Object item$iv$iv = unit.next();
                            ToStringCommand toStringCommand = (ToStringCommand)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl2 = false;
                            collection.add(it.getValue());
                        }
                        values = (List)destination$iv$iv;
                        Iterable $this$any$iv = values;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                Value it = (Value)element$iv2;
                                boolean bl3 = false;
                                if (!(!(it instanceof ObjectReference))) continue;
                                bl = true;
                                break block28;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        LOG.error("Batch toString evaluation can only be used for object references");
                        return false;
                    }
                    Intrinsics.checkNotNull((Object)evaluationContext, (String)"null cannot be cast to non-null type com.intellij.debugger.engine.evaluation.EvaluationContextImpl");
                    EvaluationContextImpl evaluationContextImpl = (EvaluationContextImpl)evaluationContext;
                    String value = null;
                    if (values.size() > 10) {
                        value = this.invokeDefaultHelperMethod(values, evaluationContextImpl);
                    } else {
                        try {
                            value = this.invokeHelperMethod("evaluate" + values.size(), values, evaluationContextImpl);
                        }
                        catch (MethodNotFoundException e) {
                            LOG.warn("Unable to find helper method", (Throwable)((Object)e));
                            value = this.invokeDefaultHelperMethod(values, evaluationContextImpl);
                        }
                    }
                    if (value == null) break block29;
                    element$iv2 = value;
                    Charset charset = StandardCharsets.ISO_8859_1;
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"ISO_8859_1");
                    byte[] byArray = ((String)element$iv2).getBytes(charset);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                    byte[] bytes = byArray;
                    try {
                        element$iv2 = new DataInputStream(new ByteArrayInputStream(bytes));
                        Throwable throwable = null;
                        try {
                            DataInputStream dis = (DataInputStream)element$iv2;
                            boolean bl4 = false;
                            int count = 0;
                            while (dis.available() > 0) {
                                boolean error = dis.readBoolean();
                                String message = dis.readUTF();
                                if (count >= requests.size()) {
                                    Logger logger = LOG;
                                    int n = requests.size();
                                    String string = Arrays.toString(bytes);
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                                    logger.error("Invalid number of results: required " + n + ", reply = " + string);
                                    boolean bl5 = false;
                                    return bl5;
                                }
                                ToStringCommand command2 = requests.get(count++);
                                if (error) {
                                    Object[] objectArray = new Object[]{message};
                                    command2.evaluationError(JavaDebuggerBundle.message((String)"evaluation.error.method.exception", (Object[])objectArray));
                                    continue;
                                }
                                command2.evaluationResult(message);
                            }
                            unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)element$iv2, (Throwable)throwable);
                        }
                    }
                    catch (IOException e) {
                        Logger logger = LOG;
                        Throwable throwable = e;
                        String[] stringArray = new String[1];
                        String string = Arrays.toString(bytes);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                        stringArray[0] = "reply was " + string;
                        logger.error("Failed to read batch response", throwable, stringArray);
                        return false;
                    }
                    return true;
                }
                catch (ObjectCollectedException e) {
                    LOG.error((Throwable)e);
                }
                catch (MethodNotFoundException e) {
                    if (IntelliJProjectUtil.isIntelliJPlatformProject((Project)evaluationContext.getProject())) {
                        RunProfile runProfile;
                        String runProfileName = null;
                        DebugProcess debugProcess = evaluationContext.getDebugProcess();
                        Intrinsics.checkNotNull((Object)debugProcess, (String)"null cannot be cast to non-null type com.intellij.debugger.engine.DebugProcessImpl");
                        DebugProcessImpl debugProcess2 = (DebugProcessImpl)debugProcess;
                        XDebugSession session = debugProcess2.getSession().getXDebugSession();
                        if (session != null && (runProfile = session.getRunProfile()) != null) {
                            runProfileName = runProfile.getName();
                        }
                        if (runProfileName != null) {
                            String[] stringArray = new String[]{"Run configuration: " + runProfileName};
                            LOG.error("Unable to find helper method", (Throwable)((Object)e), stringArray);
                        }
                    } else {
                        LOG.error((Throwable)((Object)e));
                    }
                }
                catch (EvaluateException e) {
                    ObjectReference exceptionFromTargetVM = e.getExceptionFromTargetVM();
                    if (exceptionFromTargetVM != null && Intrinsics.areEqual((Object)"java.io.UTFDataFormatException", (Object)exceptionFromTargetVM.referenceType().name())) break block29;
                    LOG.error((Throwable)e);
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final String invokeDefaultHelperMethod(List<? extends Value> values, EvaluationContextImpl evaluationContextImpl) {
            ReferenceType referenceType = evaluationContextImpl.getDebugProcess().findClass(evaluationContextImpl, "java.lang.Object[]", evaluationContextImpl.getClassLoader());
            Intrinsics.checkNotNull((Object)referenceType, (String)"null cannot be cast to non-null type com.sun.jdi.ArrayType");
            ArrayType objectArrayClass = (ArrayType)referenceType;
            ArrayReference arrayReference = DebuggerUtilsEx.mirrorOfArray(objectArrayClass, values, (EvaluationContext)evaluationContextImpl);
            Intrinsics.checkNotNullExpressionValue((Object)arrayReference, (String)"mirrorOfArray(...)");
            ArrayReference argArray = arrayReference;
            try {
                String string = this.invokeHelperMethod("evaluate", CollectionsKt.listOf((Object)argArray), evaluationContextImpl);
                return string;
            }
            finally {
                DebuggerUtilsEx.enableCollection(argArray);
            }
        }

        private final String invokeHelperMethod(String helperMethodName, List<? extends Value> args, EvaluationContextImpl evaluationContextImpl) {
            return (String)XEvaluationOrigin.Companion.computeWithOrigin((UserDataHolder)evaluationContextImpl, XEvaluationOrigin.RENDERER, () -> Companion.invokeHelperMethod$lambda$0(evaluationContextImpl, helperMethodName, args));
        }

        private static final Value invokeHelperMethod$lambda$0$0(EvaluationContextImpl $evaluationContextImpl, String $helperMethodName, List $args) {
            return DebuggerUtilsImpl.invokeHelperMethod($evaluationContextImpl, BatchEvaluatorServer.class, $helperMethodName, $args, false, new String[0]);
        }

        private static final String invokeHelperMethod$lambda$0$1(Value it) {
            StringReference stringReference = it instanceof StringReference ? (StringReference)it : null;
            return stringReference != null ? stringReference.value() : null;
        }

        private static final String invokeHelperMethod$lambda$0$2(Function1 $tmp0, Object p0) {
            return (String)$tmp0.invoke(p0);
        }

        private static final String invokeHelperMethod$lambda$0(EvaluationContextImpl $evaluationContextImpl, String $helperMethodName, List $args) {
            return (String)DebuggerUtils.getInstance().processCollectibleValue(() -> Companion.invokeHelperMethod$lambda$0$0($evaluationContextImpl, $helperMethodName, $args), arg_0 -> Companion.invokeHelperMethod$lambda$0$2(Companion::invokeHelperMethod$lambda$0$1, arg_0), (EvaluationContext)$evaluationContextImpl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

