/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.FullValueEvaluatorProvider;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.ChildrenRenderer;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.NodeRendererImpl;
import com.intellij.debugger.ui.tree.render.ReferenceRenderer;
import com.intellij.debugger.ui.tree.render.Renderer;
import com.intellij.debugger.ui.tree.render.ToStringRenderer;
import com.intellij.debugger.ui.tree.render.ValueIconRenderer;
import com.intellij.debugger.ui.tree.render.ValueLabelRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XValueNode;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompoundReferenceRenderer
extends NodeRendererImpl
implements FullValueEvaluatorProvider {
    protected static final Logger LOG = Logger.getInstance(CompoundReferenceRenderer.class);
    private static final AutoToStringRenderer AUTO_TO_STRING_RENDERER = new AutoToStringRenderer();
    @NonNls
    public static final String UNIQUE_ID = "CompoundNodeRenderer";
    @NonNls
    public static final String UNIQUE_ID_OLD = "CompoundTypeRenderer";
    private ValueLabelRenderer myLabelRenderer;
    private ChildrenRenderer myChildrenRenderer;
    private ValueIconRenderer myIconRenderer = null;
    protected final NodeRendererSettings myRendererSettings;
    private boolean myHasOverhead = false;
    private FullValueEvaluatorProvider myFullValueEvaluatorProvider;

    public CompoundReferenceRenderer(NodeRendererSettings rendererSettings, String name, ValueLabelRenderer labelRenderer, ChildrenRenderer childrenRenderer) {
        super(name);
        this.myRendererSettings = rendererSettings;
        this.myLabelRenderer = labelRenderer;
        this.myChildrenRenderer = childrenRenderer;
        this.myProperties.setClassName("java.lang.Object");
        LOG.assertTrue(labelRenderer == null || labelRenderer instanceof ReferenceRenderer || labelRenderer instanceof ClassRenderer);
        LOG.assertTrue(childrenRenderer == null || childrenRenderer instanceof ReferenceRenderer || childrenRenderer instanceof ClassRenderer);
    }

    public CompoundReferenceRenderer(String name, ValueLabelRenderer labelRenderer, ChildrenRenderer childrenRenderer) {
        this(NodeRendererSettings.getInstance(), name, labelRenderer, childrenRenderer);
    }

    @Override
    @ApiStatus.Internal
    public boolean hasOverhead() {
        return this.myHasOverhead;
    }

    @ApiStatus.Internal
    public void setHasOverhead(boolean value) {
        this.myHasOverhead = value;
    }

    @Override
    public void buildChildren(Value value, ChildrenBuilder builder, EvaluationContext evaluationContext) {
        this.getChildrenRenderer().buildChildren(value, builder, evaluationContext);
    }

    @Override
    public PsiElement getChildValueExpression(DebuggerTreeNode node, DebuggerContext context) throws EvaluateException {
        return this.getChildrenRenderer().getChildValueExpression(node, context);
    }

    @Override
    public CompletableFuture<Boolean> isExpandableAsync(Value value, EvaluationContext evaluationContext, NodeDescriptor parentDescriptor) {
        return this.getChildrenRenderer().isExpandableAsync(value, evaluationContext, parentDescriptor);
    }

    @Override
    public String calcLabel(ValueDescriptor descriptor, EvaluationContext evaluationContext, DescriptorLabelListener listener2) throws EvaluateException {
        return this.getLabelRenderer().calcLabel(descriptor, evaluationContext, listener2);
    }

    @Override
    @Nullable
    public Icon calcValueIcon(ValueDescriptor descriptor, EvaluationContext evaluationContext, DescriptorLabelListener listener2) throws EvaluateException {
        if (this.myIconRenderer != null) {
            return this.myIconRenderer.calcValueIcon(descriptor, evaluationContext, listener2);
        }
        return null;
    }

    @Override
    @Nullable
    public Icon calcInlayIcon(ValueDescriptor descriptor, EvaluationContext evaluationContext, DescriptorLabelListener listener2) throws EvaluateException {
        if (this.myIconRenderer != null) {
            return this.myIconRenderer.calcInlayIcon(descriptor, evaluationContext, listener2);
        }
        return null;
    }

    void setIconRenderer(ValueIconRenderer iconRenderer) {
        this.myIconRenderer = iconRenderer;
    }

    @Override
    @Nullable
    public XFullValueEvaluator getFullValueEvaluator(@NotNull EvaluationContextImpl evaluationContext, @NotNull ValueDescriptorImpl valueDescriptor) {
        if (evaluationContext == null) {
            CompoundReferenceRenderer.$$$reportNull$$$0(0);
        }
        if (valueDescriptor == null) {
            CompoundReferenceRenderer.$$$reportNull$$$0(1);
        }
        if (this.myFullValueEvaluatorProvider != null) {
            return this.myFullValueEvaluatorProvider.getFullValueEvaluator(evaluationContext, valueDescriptor);
        }
        return null;
    }

    @Override
    @Nullable
    public XFullValueEvaluator getFullValueEvaluator(@NotNull XValueNode node, @NotNull EvaluationContextImpl evaluationContext, @NotNull ValueDescriptorImpl valueDescriptor) {
        if (node == null) {
            CompoundReferenceRenderer.$$$reportNull$$$0(2);
        }
        if (evaluationContext == null) {
            CompoundReferenceRenderer.$$$reportNull$$$0(3);
        }
        if (valueDescriptor == null) {
            CompoundReferenceRenderer.$$$reportNull$$$0(4);
        }
        if (this.myFullValueEvaluatorProvider != null) {
            return this.myFullValueEvaluatorProvider.getFullValueEvaluator(node, evaluationContext, valueDescriptor);
        }
        return null;
    }

    @ApiStatus.Internal
    public void setFullValueEvaluator(FullValueEvaluatorProvider fullValueEvaluatorProvider) {
        this.myFullValueEvaluatorProvider = fullValueEvaluatorProvider;
    }

    public void setLabelRenderer(ValueLabelRenderer labelRenderer) {
        ValueLabelRenderer prevRenderer = this.getLabelRenderer();
        this.myLabelRenderer = this.isBaseRenderer(labelRenderer) ? null : labelRenderer;
        ValueLabelRenderer currentRenderer = this.getLabelRenderer();
        if (prevRenderer != currentRenderer && currentRenderer instanceof ReferenceRenderer) {
            ((ReferenceRenderer)((Object)currentRenderer)).setClassName(this.getClassName());
        }
    }

    public void setChildrenRenderer(ChildrenRenderer childrenRenderer) {
        ChildrenRenderer prevRenderer = this.getChildrenRenderer();
        this.myChildrenRenderer = this.isBaseRenderer(childrenRenderer) ? null : childrenRenderer;
        ChildrenRenderer currentRenderer = this.getChildrenRenderer();
        if (prevRenderer != currentRenderer && currentRenderer instanceof ReferenceRenderer) {
            ((ReferenceRenderer)((Object)currentRenderer)).setClassName(this.getClassName());
        }
    }

    public ChildrenRenderer getChildrenRenderer() {
        return this.myChildrenRenderer != null ? this.myChildrenRenderer : this.getDefaultRenderer();
    }

    private NodeRenderer getDefaultRenderer() {
        String name = this.getClassName();
        if (TypeConversionUtil.isPrimitive((String)name)) {
            return this.myRendererSettings.getPrimitiveRenderer();
        }
        return name.endsWith("]") ? this.myRendererSettings.getArrayRenderer() : AUTO_TO_STRING_RENDERER;
    }

    public ValueLabelRenderer getLabelRenderer() {
        return this.myLabelRenderer != null ? this.myLabelRenderer : this.getDefaultRenderer();
    }

    private ChildrenRenderer getRawChildrenRenderer() {
        return this.myChildrenRenderer == this.getDefaultRenderer() ? null : this.myChildrenRenderer;
    }

    private ValueLabelRenderer getRawLabelRenderer() {
        return this.myLabelRenderer == this.getDefaultRenderer() ? null : this.myLabelRenderer;
    }

    public void setClassName(@NotNull String name) {
        if (name == null) {
            CompoundReferenceRenderer.$$$reportNull$$$0(5);
        }
        this.myProperties.setClassName(name);
        if (this.getRawLabelRenderer() != null && this.myLabelRenderer instanceof ReferenceRenderer) {
            ((ReferenceRenderer)((Object)this.myLabelRenderer)).setClassName(name);
        }
        if (this.getRawChildrenRenderer() != null && this.myChildrenRenderer instanceof ReferenceRenderer) {
            ((ReferenceRenderer)((Object)this.myChildrenRenderer)).setClassName(name);
        }
    }

    @Override
    public boolean isApplicable(Type type) {
        String className = this.getClassName();
        if (!StringUtil.isEmpty((String)className)) {
            return DebuggerUtils.instanceOf((Type)type, (String)className);
        }
        return this.getLabelRenderer().isApplicable(type) && this.getChildrenRenderer().isApplicable(type);
    }

    @NotNull
    public String getClassName() {
        String string = this.myProperties.getClassName();
        if (string == null) {
            CompoundReferenceRenderer.$$$reportNull$$$0(6);
        }
        return string;
    }

    protected final PsiElement getContext(Project project, DebuggerContext context) {
        DebugProcess process = context.getDebugProcess();
        GlobalSearchScope scope = process != null ? process.getSearchScope() : GlobalSearchScope.allScope((Project)project);
        return DebuggerUtils.findClass((String)this.getClassName(), (Project)project, (GlobalSearchScope)scope);
    }

    protected final PsiElement getChildValueExpression(String text, DebuggerTreeNode node, DebuggerContext context) {
        Project project = node.getProject();
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
        return elementFactory.createExpressionFromText(text, this.getContext(project, context));
    }

    public boolean isBaseRenderer(Renderer renderer) {
        return renderer == AUTO_TO_STRING_RENDERER || renderer == this.myRendererSettings.getClassRenderer() || renderer == this.myRendererSettings.getPrimitiveRenderer() || renderer == this.myRendererSettings.getArrayRenderer();
    }

    @Override
    public String getUniqueId() {
        return UNIQUE_ID;
    }

    @Override
    public CompoundReferenceRenderer clone() {
        CompoundReferenceRenderer renderer = (CompoundReferenceRenderer)super.clone();
        renderer.myLabelRenderer = this.myLabelRenderer != null ? (ValueLabelRenderer)this.myLabelRenderer.clone() : null;
        renderer.myChildrenRenderer = this.myChildrenRenderer != null ? (ChildrenRenderer)this.myChildrenRenderer.clone() : null;
        return renderer;
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        for (Element elem : element.getChildren("Renderer")) {
            String role = elem.getAttributeValue("role");
            if (role == null) continue;
            if ("label".equals(role)) {
                this.myLabelRenderer = (ValueLabelRenderer)this.myRendererSettings.readRenderer(elem);
                continue;
            }
            if (!"children".equals(role)) continue;
            this.myChildrenRenderer = (ChildrenRenderer)this.myRendererSettings.readRenderer(elem);
        }
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        if (this.myLabelRenderer != null) {
            Element labelRendererElement = this.myRendererSettings.writeRenderer(this.myLabelRenderer);
            labelRendererElement.setAttribute("role", "label");
            element.addContent(labelRendererElement);
        }
        if (this.myChildrenRenderer != null) {
            Element childrenRendererElement = this.myRendererSettings.writeRenderer(this.myChildrenRenderer);
            childrenRendererElement.setAttribute("role", "children");
            element.addContent(childrenRendererElement);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluationContext";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueDescriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/tree/render/CompoundReferenceRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/tree/render/CompoundReferenceRenderer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFullValueEvaluator";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setClassName";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }

    private static final class AutoToStringRenderer
    extends ToStringRenderer {
        private AutoToStringRenderer() {
            this.setIsApplicableChecker(type -> CompletableFuture.completedFuture(type instanceof ReferenceType));
        }

        @Override
        public String getUniqueId() {
            return "AutoToString";
        }

        @Override
        public boolean isOnDemand(EvaluationContext evaluationContext, ValueDescriptor valueDescriptor) {
            return NodeRendererSettings.getInstance().getToStringRenderer().isOnDemand(evaluationContext, valueDescriptor);
        }

        @Override
        public String calcLabel(ValueDescriptor descriptor, EvaluationContext evaluationContext, DescriptorLabelListener listener2) {
            NodeRendererSettings nodeRendererSettings = NodeRendererSettings.getInstance();
            ToStringRenderer toStringRenderer = nodeRendererSettings.getToStringRenderer();
            CompletableFuture<Boolean> toStringApplicable = CompletableFuture.completedFuture(false);
            if (toStringRenderer.isEnabled()) {
                toStringApplicable = toStringRenderer.isApplicableAsync(descriptor.getType());
            }
            CompletionStage renderer = toStringApplicable.thenApply(applicable -> applicable != false ? toStringRenderer : nodeRendererSettings.getClassRenderer());
            return AutoToStringRenderer.calcLabel((CompletableFuture<NodeRenderer>)renderer, descriptor, evaluationContext, listener2);
        }
    }
}

