/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.JvmDebuggerUtils;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.UserExpressionDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.render.CompoundReferenceRenderer;
import com.intellij.debugger.ui.tree.render.EnumerationChildrenRenderer;
import com.intellij.debugger.ui.tree.render.ExpressionChildrenRenderer;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.Renderer;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeInplaceEditor;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.sun.jdi.Type;
import java.awt.Rectangle;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomFieldInplaceEditor
extends XDebuggerTreeInplaceEditor {
    private final UserExpressionDescriptorImpl myDescriptor;
    protected final EnumerationChildrenRenderer myRenderer;

    public CustomFieldInplaceEditor(@NotNull XDebuggerTreeNode node, @Nullable UserExpressionDescriptorImpl descriptor, @Nullable EnumerationChildrenRenderer renderer, @NotNull DebuggerContextImpl debuggerContext) {
        if (node == null) {
            CustomFieldInplaceEditor.$$$reportNull$$$0(0);
        }
        if (debuggerContext == null) {
            CustomFieldInplaceEditor.$$$reportNull$$$0(1);
        }
        super(node, "customField");
        this.myDescriptor = descriptor;
        this.myRenderer = renderer;
        this.myExpressionEditor.setExpression(descriptor != null ? TextWithImportsImpl.toXExpression(descriptor.getEvaluationText()) : null);
        ValueDescriptorImpl parentDescriptor = JvmDebuggerUtils.getDescriptorFromNode((XValueContainerNode)node.getParent(), debuggerContext);
        if (parentDescriptor == null) {
            return;
        }
        ReadAction.nonBlocking(() -> (PsiElement)DebuggerUtilsImpl.getPsiClassAndType((String)CustomFieldInplaceEditor.getTypeName((ValueDescriptorImpl)parentDescriptor), (Project)this.getProject()).first).finishOnUiThread(ModalityState.defaultModalityState(), context -> {
            if (context != null) {
                this.myExpressionEditor.setContext(context);
            }
        }).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    @ApiStatus.Internal
    public static void editNew(final @NotNull XValueNodeImpl parentNode, DebuggerContextImpl debuggerContext) {
        ValueDescriptorImpl descriptor;
        if (parentNode == null) {
            CustomFieldInplaceEditor.$$$reportNull$$$0(2);
        }
        if ((descriptor = JvmDebuggerUtils.getDescriptorFromNode(parentNode, debuggerContext)) == null) {
            return;
        }
        EnumerationChildrenRenderer renderer = EnumerationChildrenRenderer.getCurrent(descriptor);
        final XDebuggerTreeNode newNode = parentNode.addTemporaryEditorNode(AllIcons.Debugger.Db_watch, null);
        DebuggerUIUtil.invokeLater(() -> new CustomFieldInplaceEditor(newNode, null, renderer, debuggerContext){

            public void cancelEditing() {
                super.cancelEditing();
                parentNode.removeTemporaryEditorNode(newNode);
            }

            @Override
            protected List<EnumerationChildrenRenderer.ChildInfo> getRendererChildren() {
                if (this.myRenderer != null) {
                    return this.myRenderer.getChildren();
                }
                String name = CustomFieldInplaceEditor.getTypeName(descriptor);
                EnumerationChildrenRenderer enumerationChildrenRenderer = new EnumerationChildrenRenderer();
                enumerationChildrenRenderer.setAppendDefaultChildren(true);
                Renderer lastRenderer = descriptor.getLastRenderer();
                if (lastRenderer instanceof CompoundReferenceRenderer && NodeRendererSettings.getInstance().getCustomRenderers().contains((NodeRenderer)lastRenderer) && !(((CompoundReferenceRenderer)lastRenderer).getChildrenRenderer() instanceof ExpressionChildrenRenderer)) {
                    ((CompoundReferenceRenderer)lastRenderer).setChildrenRenderer(enumerationChildrenRenderer);
                } else {
                    CompoundReferenceRenderer renderer = NodeRendererSettings.getInstance().createCompoundReferenceRenderer(name, name, null, enumerationChildrenRenderer);
                    renderer.setEnabled(true);
                    NodeRendererSettings.getInstance().getCustomRenderers().addRenderer(renderer);
                    NodeRendererSettings.getInstance().fireRenderersChanged();
                }
                return enumerationChildrenRenderer.getChildren();
            }
        }.show());
    }

    @Nullable
    private static String getTypeName(ValueDescriptorImpl descriptor) {
        Type type = descriptor.getType();
        return type != null ? type.name() : null;
    }

    protected List<EnumerationChildrenRenderer.ChildInfo> getRendererChildren() {
        return this.myRenderer.getChildren();
    }

    public void doOKAction() {
        List<EnumerationChildrenRenderer.ChildInfo> children = this.getRendererChildren();
        TextWithImports newText = TextWithImportsImpl.fromXExpression(this.myExpressionEditor.getExpression());
        if (this.myDescriptor == null) {
            children.add(0, new EnumerationChildrenRenderer.ChildInfo("", newText, false));
        } else {
            int index = this.myDescriptor.getEnumerationIndex();
            EnumerationChildrenRenderer.ChildInfo old = children.get(index);
            children.set(index, new EnumerationChildrenRenderer.ChildInfo(old.myName, newText, old.myOnDemand));
        }
        this.myTree.putClientProperty((Object)"selection.path", (Object)CustomFieldInplaceEditor.createDummySelectionTreePath(newText.getText(), (XDebuggerTreeNode)this.myNode.getParent()));
        XDebuggerUtilImpl.rebuildTreeAndViews((XDebuggerTree)this.myTree);
        super.doOKAction();
    }

    private static TreePath createDummySelectionTreePath(String name, XDebuggerTreeNode parentNode) {
        return new XValueNodeImpl(parentNode.getTree(), parentNode, name, new XValue(){

            public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place2) {
                if (node == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (place2 == null) {
                    2.$$$reportNull$$$0(1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "place";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/debugger/ui/tree/render/CustomFieldInplaceEditor$2";
                objectArray[2] = "computePresentation";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).getPath();
    }

    @Nullable
    protected Rectangle getEditorBounds() {
        Rectangle bounds = super.getEditorBounds();
        if (bounds == null) {
            return null;
        }
        int afterIconX = this.getAfterIconX();
        bounds.x += afterIconX;
        bounds.width -= afterIconX;
        return bounds;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/ui/tree/render/CustomFieldInplaceEditor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "editNew";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

