/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.PossiblySyncCommand;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeExpression;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.CachedEvaluator;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.ChildrenRenderer;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.ReferenceRenderer;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiExpression;
import com.intellij.xdebugger.impl.evaluate.XEvaluationOrigin;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.concurrent.CompletableFuture;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExpressionChildrenRenderer
extends ReferenceRenderer
implements ChildrenRenderer {
    @NonNls
    public static final String UNIQUE_ID = "ExpressionChildrenRenderer";
    private static final Key<Value> EXPRESSION_VALUE = new Key("EXPRESSION_VALUE");
    private static final Key<NodeRenderer> LAST_CHILDREN_RENDERER = new Key("LAST_CHILDREN_RENDERER");
    private CachedEvaluator myChildrenExpandable = this.createCachedEvaluator();
    private CachedEvaluator myChildrenExpression = this.createCachedEvaluator();
    private NodeRenderer myPredictedRenderer;

    @Override
    public String getUniqueId() {
        return UNIQUE_ID;
    }

    @Override
    public ExpressionChildrenRenderer clone() {
        ExpressionChildrenRenderer clone = (ExpressionChildrenRenderer)super.clone();
        clone.myChildrenExpandable = this.createCachedEvaluator();
        clone.setChildrenExpandable(this.getChildrenExpandable());
        clone.myChildrenExpression = this.createCachedEvaluator();
        clone.setChildrenExpression(this.getChildrenExpression());
        return clone;
    }

    @Override
    public void buildChildren(final Value value, final ChildrenBuilder builder, final EvaluationContext evaluationContext) {
        final EvaluationContextImpl evaluationContextImpl = (EvaluationContextImpl)evaluationContext;
        evaluationContextImpl.getManagerThread().schedule(new PossiblySyncCommand(evaluationContextImpl.getSuspendContext()){

            @Override
            public void syncAction(@NotNull SuspendContextImpl suspendContext) {
                if (suspendContext == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    ValueDescriptor parentDescriptor = builder.getParentDescriptor();
                    EvaluationContextImpl valueEvaluationContext = evaluationContextImpl.createEvaluationContext(value);
                    XEvaluationOrigin.setOrigin((UserDataHolder)valueEvaluationContext, (XEvaluationOrigin)XEvaluationOrigin.RENDERER);
                    Value childrenValue = ExpressionChildrenRenderer.this.evaluateChildren(valueEvaluationContext, parentDescriptor);
                    DebuggerUtilsAsync.type(childrenValue).thenAccept(type -> ExpressionChildrenRenderer.getChildrenRenderer(type, parentDescriptor).buildChildren(childrenValue, builder, evaluationContext));
                }
                catch (EvaluateException e) {
                    builder.setErrorMessage(JavaDebuggerBundle.message((String)"error.unable.to.evaluate.children.expression", (Object[])new Object[0]) + " " + e.getMessage());
                    DebugProcessImpl.getDefaultRenderer(value).buildChildren(value, builder, evaluationContext);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/ui/tree/render/ExpressionChildrenRenderer$1", "syncAction"));
            }
        });
    }

    @Nullable
    public static NodeRenderer getLastChildrenRenderer(ValueDescriptor descriptor) {
        return (NodeRenderer)descriptor.getUserData(LAST_CHILDREN_RENDERER);
    }

    public static void setPreferableChildrenRenderer(ValueDescriptor descriptor, NodeRenderer renderer) {
        descriptor.putUserData(LAST_CHILDREN_RENDERER, renderer);
    }

    public static Value getLastChildrenValue(NodeDescriptor descriptor) {
        return (Value)descriptor.getUserData(EXPRESSION_VALUE);
    }

    private Value evaluateChildren(EvaluationContext context, NodeDescriptor descriptor) throws EvaluateException {
        ExpressionEvaluator evaluator = this.myChildrenExpression.getEvaluator(context.getProject());
        Value value = context.computeAndKeep(() -> evaluator.evaluate(context));
        descriptor.putUserData(EXPRESSION_VALUE, (Object)value);
        return value;
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        TextWithImports childrenExpandable;
        super.readExternal(element);
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        TextWithImports childrenExpression = DebuggerUtils.getInstance().readTextWithImports(element, "CHILDREN_EXPRESSION");
        if (childrenExpression != null) {
            this.setChildrenExpression(childrenExpression);
        }
        if ((childrenExpandable = DebuggerUtils.getInstance().readTextWithImports(element, "CHILDREN_EXPANDABLE")) != null) {
            this.myChildrenExpandable.setReferenceExpression(childrenExpandable);
        }
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        DebuggerUtils.getInstance().writeTextWithImports(element, "CHILDREN_EXPANDABLE", this.getChildrenExpandable());
        DebuggerUtils.getInstance().writeTextWithImports(element, "CHILDREN_EXPRESSION", this.getChildrenExpression());
    }

    public PsiExpression getChildValueExpression(DebuggerTreeNode node, DebuggerContext context) throws EvaluateException {
        Value expressionValue = ExpressionChildrenRenderer.getLastChildrenValue(node.getParent().getDescriptor());
        if (expressionValue == null) {
            throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"error.unable.to.evaluate.children.expression", (Object[])new Object[0]));
        }
        NodeRenderer childrenRenderer = ExpressionChildrenRenderer.getChildrenRenderer(expressionValue.type(), (ValueDescriptor)node.getParent().getDescriptor());
        PsiExpression childrenPsiExpression = this.myChildrenExpression.getPsiExpression(node.getProject());
        if (childrenPsiExpression == null) {
            return null;
        }
        return DebuggerTreeNodeExpression.substituteThis(childrenRenderer.getChildValueExpression(node, context), (PsiExpression)childrenPsiExpression.copy(), expressionValue);
    }

    private static NodeRenderer getChildrenRenderer(Type type, ValueDescriptor parentDescriptor) {
        NodeRenderer renderer = ExpressionChildrenRenderer.getLastChildrenRenderer(parentDescriptor);
        if (renderer == null || type == null) {
            renderer = DebugProcessImpl.getDefaultRenderer(type);
            ExpressionChildrenRenderer.setPreferableChildrenRenderer(parentDescriptor, renderer);
        }
        return renderer;
    }

    @Override
    public CompletableFuture<Boolean> isExpandableAsync(final Value value, EvaluationContext context, final NodeDescriptor parentDescriptor) {
        final CompletableFuture<Boolean> res = new CompletableFuture<Boolean>();
        final EvaluationContextImpl evaluationContextImpl = (EvaluationContextImpl)context;
        evaluationContextImpl.getManagerThread().schedule(new PossiblySyncCommand(evaluationContextImpl.getSuspendContext()){

            @Override
            public void syncAction(@NotNull SuspendContextImpl suspendContext) {
                if (suspendContext == null) {
                    2.$$$reportNull$$$0(0);
                }
                EvaluationContextImpl evaluationContext = evaluationContextImpl.createEvaluationContext(value);
                XEvaluationOrigin.setOrigin((UserDataHolder)evaluationContext, (XEvaluationOrigin)XEvaluationOrigin.RENDERER);
                if (!StringUtil.isEmpty((String)ExpressionChildrenRenderer.this.myChildrenExpandable.getReferenceExpression().getText())) {
                    try {
                        Value expanded = ExpressionChildrenRenderer.this.myChildrenExpandable.getEvaluator(evaluationContext.getProject()).evaluate((EvaluationContext)evaluationContext);
                        if (expanded instanceof BooleanValue) {
                            res.complete(((BooleanValue)expanded).booleanValue());
                            return;
                        }
                    }
                    catch (EvaluateException expanded) {
                        // empty catch block
                    }
                }
                try {
                    Value children = ExpressionChildrenRenderer.this.evaluateChildren(evaluationContext, parentDescriptor);
                    DebugProcessImpl.getDefaultRenderer(value.type()).isExpandableAsync(children, evaluationContext, parentDescriptor).whenComplete((aBoolean, throwable) -> DebuggerUtilsAsync.completeFuture(aBoolean, throwable, res));
                }
                catch (EvaluateException e) {
                    res.complete(true);
                }
            }

            @Override
            protected void commandCancelled() {
                res.cancel(false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/ui/tree/render/ExpressionChildrenRenderer$2", "syncAction"));
            }
        });
        return res;
    }

    public TextWithImports getChildrenExpression() {
        return this.myChildrenExpression.getReferenceExpression();
    }

    public void setChildrenExpression(TextWithImports expression) {
        this.myChildrenExpression.setReferenceExpression(expression);
    }

    public TextWithImports getChildrenExpandable() {
        return this.myChildrenExpandable.getReferenceExpression();
    }

    public void setChildrenExpandable(TextWithImports childrenExpandable) {
        this.myChildrenExpandable.setReferenceExpression(childrenExpandable);
    }

    @Override
    public void setClassName(String name) {
        super.setClassName(name);
        this.myChildrenExpression.clear();
        this.myChildrenExpandable.clear();
    }

    public NodeRenderer getPredictedRenderer() {
        return this.myPredictedRenderer;
    }

    public void setPredictedRenderer(NodeRenderer predictedRenderer) {
        this.myPredictedRenderer = predictedRenderer;
    }
}

