/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.FullValueEvaluatorProvider;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.ui.tree.render.AbstractImageRenderer;
import com.intellij.debugger.ui.tree.render.ValueIconRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.registry.Registry;
import com.sun.jdi.Value;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class IconObjectRenderer
extends AbstractImageRenderer {
    IconObjectRenderer() {
    }

    @Override
    protected String getName() {
        return "Icon";
    }

    @Override
    protected String getClassName() {
        return "javax.swing.Icon";
    }

    @Override
    protected ValueIconRenderer getIconRenderer() {
        return (descriptor, evaluationContext, listener2) -> {
            final EvaluationContextImpl evalContext = (EvaluationContextImpl)evaluationContext;
            DebugProcessImpl debugProcess = evalContext.getDebugProcess();
            if (!Registry.is((String)"debugger.auto.fetch.icons") || DebuggerUtilsImpl.isRemote(debugProcess)) {
                return null;
            }
            ((EvaluationContextImpl)evaluationContext).getManagerThread().schedule(new SuspendContextCommandImpl(this, evalContext.getSuspendContext()){

                @Override
                public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                    if (suspendContext == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    String getterName = AllIcons.Debugger.Value.getIconHeight() <= 16 ? "iconToBytesPreviewNormal" : "iconToBytesPreviewRetina";
                    descriptor.setValueIcon(IconObjectRenderer.getImageIcon(evalContext, descriptor.getValue(), getterName));
                    listener2.labelChanged();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/ui/tree/render/IconObjectRenderer$1", "contextAction"));
                }
            });
            return null;
        };
    }

    @Override
    protected FullValueEvaluatorProvider getFullValueEvaluatorProvider() {
        return (evaluationContext, valueDescriptor) -> this.createImagePopupEvaluator(JavaDebuggerBundle.message((String)"message.node.show.icon", (Object[])new Object[0]), evaluationContext, valueDescriptor.getValue(), "iconToBytes");
    }

    @Nullable
    static ImageIcon getImageIcon(EvaluationContextImpl evaluationContext, Value obj, String methodName) {
        byte[] data = IconObjectRenderer.getImageBytes(evaluationContext, obj, methodName);
        return data != null ? new ImageIcon(data) : null;
    }
}

