/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.HexRenderer;
import com.intellij.debugger.ui.tree.render.NodeRendererImpl;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.sun.jdi.CharValue;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.VoidType;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class PrimitiveRenderer
extends NodeRendererImpl {
    @NonNls
    public static final String UNIQUE_ID = "PrimitiveRenderer";
    public boolean SHOW_HEX_VALUE = false;

    public PrimitiveRenderer() {
        super("Primitive");
    }

    @Override
    public String getUniqueId() {
        return UNIQUE_ID;
    }

    @Override
    public void setName(String text) {
    }

    @Override
    public final boolean isEnabled() {
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public boolean isApplicable(Type type) {
        return type == null || type instanceof PrimitiveType || type instanceof VoidType;
    }

    @Override
    public String calcLabel(ValueDescriptor valueDescriptor, EvaluationContext evaluationContext, DescriptorLabelListener labelListener) {
        Value value = valueDescriptor.getValue();
        if (value == null) {
            return "null";
        }
        if (value instanceof PrimitiveValue) {
            if (value instanceof CharValue) {
                StringBuilder buf = new StringBuilder();
                PrimitiveRenderer.appendCharValue((CharValue)value, buf);
                if (this.SHOW_HEX_VALUE) {
                    PrimitiveRenderer.appendHexValue((CharValue)value, buf);
                } else {
                    buf.append(' ').append(((PrimitiveValue)value).longValue());
                }
                return buf.toString();
            }
            if (this.SHOW_HEX_VALUE) {
                StringBuilder buf = new StringBuilder();
                buf.append(value);
                PrimitiveRenderer.appendHexValue((PrimitiveValue)value, buf);
                return buf.toString();
            }
            return value.toString();
        }
        return JavaDebuggerBundle.message((String)"label.undefined", (Object[])new Object[0]);
    }

    static void appendCharValue(CharValue value, StringBuilder buf) {
        buf.append('\'');
        String s = value.toString();
        StringUtil.escapeStringCharacters((int)s.length(), (String)s, (String)"'", (StringBuilder)buf);
        buf.append('\'');
    }

    private static void appendHexValue(PrimitiveValue value, StringBuilder buf) {
        if (NodeRendererSettings.getInstance().getHexRenderer().isApplicable(value.type())) {
            buf.append(" (");
            HexRenderer.appendHexValue(value, buf);
            buf.append(')');
        }
    }

    public boolean isShowHexValue() {
        return this.SHOW_HEX_VALUE;
    }

    public void setShowHexValue(boolean show) {
        this.SHOW_HEX_VALUE = show;
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        if (this.SHOW_HEX_VALUE) {
            JDOMExternalizerUtil.writeField((Element)element, (String)"SHOW_HEX_VALUE", (String)"true");
        }
    }
}

