/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.ui.tree.render.BasicRendererProperties;
import com.intellij.debugger.ui.tree.render.CachedEvaluator;
import com.intellij.debugger.ui.tree.render.Renderer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.sun.jdi.Type;
import java.util.concurrent.CompletableFuture;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public abstract class ReferenceRenderer
implements Renderer {
    private static final Logger LOG = Logger.getInstance(ReferenceRenderer.class);
    protected BasicRendererProperties myProperties;

    protected ReferenceRenderer() {
        this("java.lang.Object");
    }

    protected ReferenceRenderer(@NotNull String className) {
        if (className == null) {
            ReferenceRenderer.$$$reportNull$$$0(0);
        }
        this.myProperties = new BasicRendererProperties(false);
        this.myProperties.setClassName(className);
    }

    @Override
    public CompletableFuture<Boolean> isApplicableAsync(Type type) {
        return DebuggerUtilsAsync.instanceOf(type, this.getClassName());
    }

    public String getClassName() {
        return this.myProperties.getClassName();
    }

    public void setClassName(String className) {
        this.myProperties.setClassName(className);
    }

    @Override
    public Renderer clone() {
        try {
            ReferenceRenderer cloned = (ReferenceRenderer)super.clone();
            cloned.myProperties = this.myProperties.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        this.myProperties.writeExternal(element, "java.lang.Object");
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.myProperties.readExternal(element, "java.lang.Object");
    }

    protected CachedEvaluator createCachedEvaluator() {
        return new CachedEvaluator(){

            @Override
            protected String getClassName() {
                return ReferenceRenderer.this.getClassName();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/debugger/ui/tree/render/ReferenceRenderer", "<init>"));
    }
}

