/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.debugger;

import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProviderBase;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class JavaDebuggerEditorsProvider
extends XDebuggerEditorsProviderBase {
    @NotNull
    public FileType getFileType() {
        JavaFileType javaFileType = JavaFileType.INSTANCE;
        if (javaFileType == null) {
            JavaDebuggerEditorsProvider.$$$reportNull$$$0(0);
        }
        return javaFileType;
    }

    protected PsiFile createExpressionCodeFragment(@NotNull Project project, @NotNull String text, @Nullable PsiElement context, boolean isPhysical) {
        if (project == null) {
            JavaDebuggerEditorsProvider.$$$reportNull$$$0(1);
        }
        if (text == null) {
            JavaDebuggerEditorsProvider.$$$reportNull$$$0(2);
        }
        return JavaCodeFragmentFactory.getInstance((Project)project).createExpressionCodeFragment(text, context, null, isPhysical);
    }

    @NotNull
    public @Unmodifiable Collection<Language> getSupportedLanguages(@Nullable PsiElement context) {
        List list = ContainerUtil.map(DebuggerUtilsEx.getCodeFragmentFactories(context), factory -> factory.getFileType().getLanguage());
        if (list == null) {
            JavaDebuggerEditorsProvider.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public @Unmodifiable Collection<Language> getSupportedLanguages(@NotNull Project project, @Nullable XSourcePosition sourcePosition) {
        if (project == null) {
            JavaDebuggerEditorsProvider.$$$reportNull$$$0(4);
        }
        if (sourcePosition != null) {
            Collection<Language> collection = this.getSupportedLanguages(this.getContextElement(sourcePosition.getFile(), sourcePosition.getOffset(), project));
            if (collection == null) {
                JavaDebuggerEditorsProvider.$$$reportNull$$$0(5);
            }
            return collection;
        }
        List<Language> list = Collections.emptyList();
        if (list == null) {
            JavaDebuggerEditorsProvider.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public XExpression createExpression(@NotNull Project project, @NotNull Document document, @Nullable Language language, @NotNull EvaluationMode mode) {
        PsiFile psiFile;
        if (project == null) {
            JavaDebuggerEditorsProvider.$$$reportNull$$$0(7);
        }
        if (document == null) {
            JavaDebuggerEditorsProvider.$$$reportNull$$$0(8);
        }
        if (mode == null) {
            JavaDebuggerEditorsProvider.$$$reportNull$$$0(9);
        }
        if ((psiFile = (PsiFile)ReadAction.compute(() -> PsiDocumentManager.getInstance((Project)project).getPsiFile(document))) instanceof JavaCodeFragment) {
            return new XExpressionImpl(document.getText(), language, StringUtil.nullize((String)((JavaCodeFragment)psiFile).importsToString()), mode);
        }
        XExpression xExpression = super.createExpression(project, document, language, mode);
        if (xExpression == null) {
            JavaDebuggerEditorsProvider.$$$reportNull$$$0(10);
        }
        return xExpression;
    }

    protected PsiFile createExpressionCodeFragment(@NotNull Project project, @NotNull XExpression expression, @Nullable PsiElement context, boolean isPhysical) {
        TextWithImports text;
        if (project == null) {
            JavaDebuggerEditorsProvider.$$$reportNull$$$0(11);
        }
        if (expression == null) {
            JavaDebuggerEditorsProvider.$$$reportNull$$$0(12);
        }
        if ((text = TextWithImportsImpl.fromXExpression(expression)) != null) {
            CodeFragmentFactory factory = DebuggerUtilsEx.findAppropriateCodeFragmentFactory(text, context);
            return factory.createPresentationPsiCodeFragment(text, context, project);
        }
        return super.createExpressionCodeFragment(project, expression, context, isPhysical);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4, 7, 8, 9, 11, 12 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/java/debugger/JavaDebuggerEditorsProvider";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/java/debugger/JavaDebuggerEditorsProvider";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedLanguages";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpression";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createExpressionCodeFragment";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSupportedLanguages";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4, 7, 8, 9, 11, 12 -> new IllegalArgumentException(string);
        };
    }
}

