/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.debugger.breakpoints.properties;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;

public class JavaExceptionBreakpointProperties
extends JavaBreakpointProperties<JavaExceptionBreakpointProperties> {
    public boolean NOTIFY_CAUGHT = true;
    public boolean NOTIFY_UNCAUGHT = true;
    @Attribute(value="class")
    @NlsSafe
    public String myQualifiedName;
    @Attribute(value="package")
    @NlsSafe
    public String myPackageName;
    private boolean myCatchFiltersEnabled = false;
    private ClassFilter[] myCatchClassFilters;
    private ClassFilter[] myCatchClassExclusionFilters;

    public JavaExceptionBreakpointProperties(String qualifiedName) {
        this.myQualifiedName = qualifiedName;
        this.myPackageName = StringUtil.getPackageName((String)qualifiedName);
    }

    public JavaExceptionBreakpointProperties() {
    }

    @Override
    @Nullable
    public JavaExceptionBreakpointProperties getState() {
        return this;
    }

    @Override
    public void loadState(@NotNull JavaExceptionBreakpointProperties state) {
        if (state == null) {
            JavaExceptionBreakpointProperties.$$$reportNull$$$0(0);
        }
        super.loadState(state);
        this.NOTIFY_CAUGHT = state.NOTIFY_CAUGHT;
        this.NOTIFY_UNCAUGHT = state.NOTIFY_UNCAUGHT;
        this.myQualifiedName = state.myQualifiedName;
        this.myPackageName = state.myPackageName;
        this.setCatchFiltersEnabled(state.isCatchFiltersEnabled());
        this.myCatchClassFilters = state.getCatchClassFilters();
        this.myCatchClassExclusionFilters = state.getCatchClassExclusionFilters();
    }

    @OptionTag(value="catch-filters-enabled")
    public boolean isCatchFiltersEnabled() {
        return this.myCatchFiltersEnabled;
    }

    public boolean setCatchFiltersEnabled(boolean enabled) {
        boolean changed = this.myCatchFiltersEnabled != enabled;
        this.myCatchFiltersEnabled = enabled;
        return changed;
    }

    @XCollection(propertyElementName="catch-class-filters")
    public final ClassFilter[] getCatchClassFilters() {
        return this.myCatchClassFilters != null ? this.myCatchClassFilters : ClassFilter.EMPTY_ARRAY;
    }

    public final boolean setCatchClassFilters(ClassFilter[] classFilters) {
        boolean changed = !JavaExceptionBreakpointProperties.filtersEqual(this.myCatchClassFilters, classFilters);
        this.myCatchClassFilters = classFilters;
        return changed;
    }

    @XCollection(propertyElementName="catch-class-exclusion-filters")
    public ClassFilter[] getCatchClassExclusionFilters() {
        return this.myCatchClassExclusionFilters != null ? this.myCatchClassExclusionFilters : ClassFilter.EMPTY_ARRAY;
    }

    public boolean setCatchClassExclusionFilters(ClassFilter[] classExclusionFilters) {
        boolean changed = !JavaExceptionBreakpointProperties.filtersEqual(this.myCatchClassExclusionFilters, classExclusionFilters);
        this.myCatchClassExclusionFilters = classExclusionFilters;
        return changed;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof JavaExceptionBreakpointProperties)) {
            return false;
        }
        JavaExceptionBreakpointProperties that = (JavaExceptionBreakpointProperties)((Object)o);
        if (!super.equals(o)) {
            return false;
        }
        return this.NOTIFY_CAUGHT == that.NOTIFY_CAUGHT && this.NOTIFY_UNCAUGHT == that.NOTIFY_UNCAUGHT && this.myCatchFiltersEnabled == that.myCatchFiltersEnabled && Objects.equals(this.myQualifiedName, that.myQualifiedName) && Objects.equals(this.myPackageName, that.myPackageName) && JavaExceptionBreakpointProperties.filtersEqual(this.myCatchClassFilters, that.myCatchClassFilters) && JavaExceptionBreakpointProperties.filtersEqual(this.myCatchClassExclusionFilters, that.myCatchClassExclusionFilters);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.NOTIFY_CAUGHT, this.NOTIFY_UNCAUGHT, this.myQualifiedName, this.myPackageName, this.myCatchFiltersEnabled, JavaExceptionBreakpointProperties.filtersHashCode(this.myCatchClassFilters), JavaExceptionBreakpointProperties.filtersHashCode(this.myCatchClassExclusionFilters));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/java/debugger/breakpoints/properties/JavaExceptionBreakpointProperties", "loadState"));
    }
}

