/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.debugger.breakpoints.properties;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;

public class JavaLineBreakpointProperties
extends JavaBreakpointProperties<JavaLineBreakpointProperties> {
    @Nullable
    private Integer encodedInlinePosition = null;
    private static final int COND_RET_CODE = -10;
    public static final int NO_LAMBDA = -1;
    private static final int BASIC_LINE_POSITION = JavaLineBreakpointProperties.encodeInlinePosition(-1, false);

    public static int encodeInlinePosition(int lambdaOrdinal, boolean conditionalReturn) {
        return !conditionalReturn ? lambdaOrdinal : -10 - lambdaOrdinal - 1;
    }

    @Transient
    @Nullable
    public Integer getLambdaOrdinal() {
        if (this.encodedInlinePosition == null) {
            return null;
        }
        int n = this.encodedInlinePosition;
        return n <= -10 ? -10 - n - 1 : n;
    }

    public boolean isConditionalReturn() {
        return this.encodedInlinePosition != null && this.encodedInlinePosition <= -10;
    }

    public static boolean isLinePosition(Integer encodedInlinePosition) {
        return encodedInlinePosition == null || encodedInlinePosition == BASIC_LINE_POSITION;
    }

    public boolean isLinePosition() {
        return JavaLineBreakpointProperties.isLinePosition(this.encodedInlinePosition);
    }

    public boolean isInLambda() {
        Integer lambdaOrdinal = this.getLambdaOrdinal();
        return lambdaOrdinal != null && lambdaOrdinal != -1;
    }

    public boolean isAllPositions() {
        return this.encodedInlinePosition == null;
    }

    @OptionTag(value="lambda-ordinal")
    @Nullable
    public Integer getEncodedInlinePosition() {
        return this.encodedInlinePosition;
    }

    public void setEncodedInlinePosition(@Nullable Integer inlinePositionEncoded) {
        this.encodedInlinePosition = inlinePositionEncoded;
    }

    @Override
    public void loadState(@NotNull JavaLineBreakpointProperties state) {
        if (state == null) {
            JavaLineBreakpointProperties.$$$reportNull$$$0(0);
        }
        super.loadState(state);
        this.encodedInlinePosition = state.encodedInlinePosition;
    }

    @Nls
    @NotNull
    public static String getGeneralDescription(JavaLineBreakpointProperties props) {
        if (props != null) {
            if (props.isConditionalReturn()) {
                String string = JavaDebuggerBundle.message((String)"line.breakpoint.description.conditional.return", (Object[])new Object[0]);
                if (string == null) {
                    JavaLineBreakpointProperties.$$$reportNull$$$0(1);
                }
                return string;
            }
            if (props.isInLambda()) {
                String string = JavaDebuggerBundle.message((String)"line.breakpoint.description.lambda", (Object[])new Object[0]);
                if (string == null) {
                    JavaLineBreakpointProperties.$$$reportNull$$$0(2);
                }
                return string;
            }
        }
        String string = JavaDebuggerBundle.message((String)"line.breakpoint.description.basic.line", (Object[])new Object[0]);
        if (string == null) {
            JavaLineBreakpointProperties.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof JavaLineBreakpointProperties)) {
            return false;
        }
        JavaLineBreakpointProperties that = (JavaLineBreakpointProperties)((Object)o);
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.encodedInlinePosition, that.encodedInlinePosition);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.encodedInlinePosition);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/java/debugger/breakpoints/properties/JavaLineBreakpointProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/java/debugger/breakpoints/properties/JavaLineBreakpointProperties";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGeneralDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

