/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication;

import com.intellij.collaboration.auth.credentials.Credentials;
import com.intellij.collaboration.auth.credentials.SimpleCredentials;
import com.intellij.collaboration.auth.services.OAuthCredentialsAcquirer;
import com.intellij.collaboration.auth.services.OAuthCredentialsAcquirerHttp;
import com.intellij.util.Url;
import java.net.http.HttpHeaders;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.authentication.GHOAuthService;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\nB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/authentication/GHOAuthCredentialsAcquirer;", "Lcom/intellij/collaboration/auth/services/OAuthCredentialsAcquirer;", "Lcom/intellij/collaboration/auth/credentials/Credentials;", "codeVerifier", "", "<init>", "(Ljava/lang/String;)V", "acquireCredentials", "Lcom/intellij/collaboration/auth/services/OAuthCredentialsAcquirer$AcquireCredentialsResult;", "code", "Companion", "intellij.vcs.github"})
public final class GHOAuthCredentialsAcquirer
implements OAuthCredentialsAcquirer<Credentials> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String codeVerifier;

    public GHOAuthCredentialsAcquirer(@NotNull String codeVerifier) {
        Intrinsics.checkNotNullParameter((Object)codeVerifier, (String)"codeVerifier");
        this.codeVerifier = codeVerifier;
    }

    @NotNull
    public OAuthCredentialsAcquirer.AcquireCredentialsResult<Credentials> acquireCredentials(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"code", (Object)code), TuplesKt.to((Object)"code_verifier", (Object)this.codeVerifier)};
        Url url = GHOAuthCredentialsAcquirer.Companion.getACCESS_TOKEN_URL().addParameters(MapsKt.mapOf((Pair[])pairArray));
        Intrinsics.checkNotNullExpressionValue((Object)url, (String)"addParameters(...)");
        Url tokenUrl = url;
        return OAuthCredentialsAcquirerHttp.INSTANCE.requestToken(tokenUrl, GHOAuthCredentialsAcquirer::acquireCredentials$lambda$0);
    }

    private static final Credentials acquireCredentials$lambda$0(String string, HttpHeaders headers) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        String string2 = headers.firstValue("X-OAuth-Token").get();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"get(...)");
        return (Credentials)new SimpleCredentials(string2);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/github/authentication/GHOAuthCredentialsAcquirer$Companion;", "", "<init>", "()V", "ACCESS_TOKEN_URL", "Lcom/intellij/util/Url;", "getACCESS_TOKEN_URL", "()Lcom/intellij/util/Url;", "intellij.vcs.github"})
    public static final class Companion {
        private Companion() {
        }

        private final Url getACCESS_TOKEN_URL() {
            Url url = GHOAuthService.Companion.getSERVICE_URL().resolve("access_token");
            Intrinsics.checkNotNullExpressionValue((Object)url, (String)"resolve(...)");
            return url;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

