/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui;

import com.intellij.openapi.project.Project;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.authentication.AuthorizationType;
import org.jetbrains.plugins.github.authentication.GHAccountsUtil;
import org.jetbrains.plugins.github.authentication.GHLoginSource;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.exceptions.GithubAuthenticationException;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.ui.GHRetryLoadingErrorHandler;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0011B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/GHApiLoadingErrorHandler;", "Lorg/jetbrains/plugins/github/pullrequest/ui/GHRetryLoadingErrorHandler;", "project", "Lcom/intellij/openapi/project/Project;", "account", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "loginSource", "Lorg/jetbrains/plugins/github/authentication/GHLoginSource;", "resetRunnable", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;Lorg/jetbrains/plugins/github/authentication/GHLoginSource;Lkotlin/jvm/functions/Function0;)V", "getActionForError", "Ljavax/swing/Action;", "error", "", "ReLoginAction", "intellij.vcs.github"})
public class GHApiLoadingErrorHandler
extends GHRetryLoadingErrorHandler {
    @NotNull
    private final Project project;
    @NotNull
    private final GithubAccount account;
    @NotNull
    private final GHLoginSource loginSource;

    public GHApiLoadingErrorHandler(@NotNull Project project, @NotNull GithubAccount account, @NotNull GHLoginSource loginSource, @NotNull Function0<Unit> resetRunnable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)account), (String)"account");
        Intrinsics.checkNotNullParameter((Object)((Object)loginSource), (String)"loginSource");
        Intrinsics.checkNotNullParameter(resetRunnable, (String)"resetRunnable");
        super(resetRunnable);
        this.project = project;
        this.account = account;
        this.loginSource = loginSource;
    }

    @Override
    @NotNull
    public Action getActionForError(@NotNull Throwable error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        if (error instanceof GithubAuthenticationException) {
            return new ReLoginAction();
        }
        return super.getActionForError(error);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/GHApiLoadingErrorHandler$ReLoginAction;", "Ljavax/swing/AbstractAction;", "<init>", "(Lorg/jetbrains/plugins/github/pullrequest/ui/GHApiLoadingErrorHandler;)V", "actionPerformed", "", "e", "Ljava/awt/event/ActionEvent;", "intellij.vcs.github"})
    private final class ReLoginAction
    extends AbstractAction {
        public ReLoginAction() {
            super(GithubBundle.message("accounts.relogin", new Object[0]));
        }

        @Override
        public void actionPerformed(@Nullable ActionEvent e) {
            if (GHAccountsUtil.requestReLogin$default(GHApiLoadingErrorHandler.this.account, GHApiLoadingErrorHandler.this.project, null, AuthorizationType.UNDEFINED, GHApiLoadingErrorHandler.this.loginSource, 4, null) != null) {
                GHApiLoadingErrorHandler.this.getResetRunnable().invoke();
            }
        }
    }
}

