/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui;

import com.intellij.collaboration.ui.codereview.details.data.ReviewState;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GHActor;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestRequestedReviewer;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestReview;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestReviewState;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J@\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\b\u0010\b\u001a\u0004\u0018\u00010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/GHReviewersUtils;", "", "<init>", "()V", "getReviewsByReviewers", "", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestRequestedReviewer;", "Lcom/intellij/collaboration/ui/codereview/details/data/ReviewState;", "author", "Lorg/jetbrains/plugins/github/api/data/GHActor;", "reviews", "", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestReview;", "reviewers", "ghostUser", "Lorg/jetbrains/plugins/github/api/data/GHUser;", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGHReviewersUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHReviewersUtils.kt\norg/jetbrains/plugins/github/pullrequest/ui/GHReviewersUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,36:1\n1205#2,2:37\n1282#2,4:39\n1915#2,2:45\n221#3,2:43\n*S KotlinDebug\n*F\n+ 1 GHReviewersUtils.kt\norg/jetbrains/plugins/github/pullrequest/ui/GHReviewersUtils\n*L\n19#1:37,2\n19#1:39,4\n31#1:45,2\n20#1:43,2\n*E\n"})
public final class GHReviewersUtils {
    @NotNull
    public static final GHReviewersUtils INSTANCE = new GHReviewersUtils();

    private GHReviewersUtils() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<GHPullRequestRequestedReviewer, ReviewState> getReviewsByReviewers(@Nullable GHActor author, @NotNull List<GHPullRequestReview> reviews, @NotNull List<? extends GHPullRequestRequestedReviewer> reviewers2, @NotNull GHUser ghostUser) {
        Iterable $this$forEach$iv;
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter(reviews, (String)"reviews");
        Intrinsics.checkNotNullParameter(reviewers2, (String)"reviewers");
        Intrinsics.checkNotNullParameter((Object)ghostUser, (String)"ghostUser");
        Map result = new LinkedHashMap();
        Object $this$associate$iv = reviews;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            GHPullRequestReview it = (GHPullRequestReview)element$iv$iv;
            boolean bl = false;
            GHActor gHActor = it.getAuthor();
            GHPullRequestRequestedReviewer gHPullRequestRequestedReviewer = gHActor instanceof GHPullRequestRequestedReviewer ? (GHPullRequestRequestedReviewer)((Object)gHActor) : null;
            if (gHPullRequestRequestedReviewer == null) {
                gHPullRequestRequestedReviewer = ghostUser;
            }
            Pair pair = TuplesKt.to((Object)gHPullRequestRequestedReviewer, (Object)((Object)it.getState()));
            map2.put(pair.getFirst(), pair.getSecond());
        }
        $this$associate$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Map.Entry element$iv : $this$forEach$iv.entrySet()) {
            destination$iv$iv = element$iv;
            boolean bl = false;
            GHPullRequestRequestedReviewer reviewer = (GHPullRequestRequestedReviewer)destination$iv$iv.getKey();
            GHPullRequestReviewState reviewState2 = (GHPullRequestReviewState)((Object)destination$iv$iv.getValue());
            if (Intrinsics.areEqual((Object)reviewer, (Object)author)) continue;
            if (reviewState2 == GHPullRequestReviewState.APPROVED) {
                result.put(reviewer, ReviewState.ACCEPTED);
            }
            if (reviewState2 != GHPullRequestReviewState.CHANGES_REQUESTED) continue;
            result.put(reviewer, ReviewState.WAIT_FOR_UPDATES);
        }
        $this$forEach$iv = reviewers2;
        $i$f$forEach = false;
        for (Map.Entry element$iv : $this$forEach$iv) {
            GHPullRequestRequestedReviewer requestedReviewer = (GHPullRequestRequestedReviewer)((Object)element$iv);
            boolean bl = false;
            result.put(requestedReviewer, ReviewState.NEED_REVIEW);
        }
        return result;
    }
}

