/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java;

import com.intellij.openapi.util.Pair;
import com.intellij.util.SmartList;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.metadata.KmClass;
import kotlin.metadata.KmDeclarationContainer;
import kotlin.metadata.KmFunction;
import kotlin.metadata.KmPackage;
import kotlin.metadata.KmProperty;
import org.jetbrains.jps.builders.java.dependencyView.Callbacks;
import org.jetbrains.jps.dependency.GraphConfiguration;
import org.jetbrains.jps.dependency.Node;
import org.jetbrains.jps.dependency.NodeSource;
import org.jetbrains.jps.dependency.NodeSourcePathMapper;
import org.jetbrains.jps.dependency.Usage;
import org.jetbrains.jps.dependency.java.ClassUsage;
import org.jetbrains.jps.dependency.java.FieldUsage;
import org.jetbrains.jps.dependency.java.FileNode;
import org.jetbrains.jps.dependency.java.ImportPackageOnDemandUsage;
import org.jetbrains.jps.dependency.java.ImportStaticMemberUsage;
import org.jetbrains.jps.dependency.java.ImportStaticOnDemandUsage;
import org.jetbrains.jps.dependency.java.JVMClassNode;
import org.jetbrains.jps.dependency.java.JvmClass;
import org.jetbrains.jps.dependency.java.JvmClassNodeBuilder;
import org.jetbrains.jps.dependency.java.JvmNodeReferenceID;
import org.jetbrains.jps.dependency.java.KotlinMeta;
import org.jetbrains.jps.dependency.java.LookupNameUsage;
import org.jetbrains.jps.util.Iterators;
import org.jetbrains.org.objectweb.asm.ClassReader;

final class BackendCallbackToGraphDeltaAdapter
implements Callbacks.Backend {
    private static final String IMPORT_WILDCARD_SUFFIX = ".*";
    private final Map<String, Pair<Collection<String>, Collection<String>>> myImportRefs = Collections.synchronizedMap(new HashMap());
    private final Map<String, Collection<Callbacks.ConstantRef>> myConstantRefs = Collections.synchronizedMap(new HashMap());
    private final Map<String, Set<Usage>> myAdditionalUsages = Collections.synchronizedMap(new HashMap());
    private final Map<Path, Set<Usage>> myPerSourceAdditionalUsages = Collections.synchronizedMap(new HashMap());
    private final List<Pair<JvmClassNodeBuilder, Iterable<NodeSource>>> myNodeBuilders = new ArrayList<Pair<JvmClassNodeBuilder, Iterable<NodeSource>>>();
    private final List<Pair<Node<?, ?>, Iterable<NodeSource>>> myNodes = new ArrayList();
    private final GraphConfiguration myGraphConfig;
    private final boolean reportMissingOutput = Boolean.parseBoolean(System.getProperty("jps.report.registered.unexistent.output"));

    BackendCallbackToGraphDeltaAdapter(GraphConfiguration graphConfig) {
        this.myGraphConfig = graphConfig;
    }

    @Override
    public void associate(String classFileName, Collection<String> sources, ClassReader cr, boolean isGenerated) {
        if (this.reportMissingOutput && !classFileName.startsWith("$") && !new File(classFileName).exists()) {
            throw new RuntimeException("Class file '" + classFileName + "' was registered but it does not exist");
        }
        this.myNodeBuilders.add((Pair<JvmClassNodeBuilder, Iterable<NodeSource>>)Pair.create((Object)JvmClassNodeBuilder.create((String)classFileName, (ClassReader)cr, (boolean)isGenerated), (Object)Iterators.collect((Iterable)Iterators.map(sources, arg_0 -> ((NodeSourcePathMapper)this.myGraphConfig.getPathMapper()).toNodeSource(arg_0)), (Collection)new SmartList())));
    }

    public List<Pair<Node<?, ?>, Iterable<NodeSource>>> getNodes() {
        HashMap<NodeSource, Set> fileLocalUsages = new HashMap<NodeSource, Set>();
        for (Pair<JvmClassNodeBuilder, Iterable<NodeSource>> pair : this.myNodeBuilders) {
            Set<Usage> additionalUsages;
            JvmClassNodeBuilder builder = (JvmClassNodeBuilder)pair.getFirst();
            Iterable nodeSources = (Iterable)pair.getSecond();
            JvmNodeReferenceID nodeID = builder.getReferenceID();
            String nodeName = nodeID.getNodeName();
            BackendCallbackToGraphDeltaAdapter.addConstantUsages(builder, nodeName, this.myConstantRefs.remove(nodeName));
            Pair<Collection<String>, Collection<String>> imports = this.myImportRefs.remove(nodeName);
            if (imports != null) {
                BackendCallbackToGraphDeltaAdapter.addImportUsages(builder, (Collection)imports.getFirst(), (Collection)imports.getSecond());
            }
            if ((additionalUsages = this.myAdditionalUsages.remove(nodeName)) != null) {
                for (Usage usage : additionalUsages) {
                    builder.addUsage(usage);
                }
            }
            JVMClassNode node = builder.getResult();
            Iterable lookups = Iterators.flat((Iterable)Iterators.map((Iterable)node.getMetadata(KotlinMeta.class), meta -> {
                JvmNodeReferenceID owner;
                KmDeclarationContainer container = meta.getDeclarationContainer();
                LookupNameUsage clsUsage = null;
                if (container instanceof KmPackage) {
                    owner = new JvmNodeReferenceID(JvmClass.getPackageName((String)node.getName()));
                } else if (container instanceof KmClass) {
                    owner = new JvmNodeReferenceID(((KmClass)container).getName());
                    String ownerName = owner.getNodeName();
                    String scopeName = JvmClass.getPackageName((String)ownerName);
                    String symbolName = scopeName.isEmpty() ? ownerName : ownerName.substring(scopeName.length() + 1);
                    clsUsage = new LookupNameUsage(scopeName, symbolName);
                } else {
                    owner = null;
                }
                if (owner == null) {
                    return Collections.emptyList();
                }
                Iterable memberLookups = Iterators.map((Iterable)Iterators.unique((Iterable)Iterators.flat((Iterable)Iterators.map((Iterable)container.getFunctions(), KmFunction::getName), (Iterable)Iterators.map((Iterable)container.getProperties(), KmProperty::getName))), name -> new LookupNameUsage(owner, name));
                return clsUsage == null ? memberLookups : Iterators.flat((Iterable)Iterators.asIterable(clsUsage), (Iterable)memberLookups);
            }));
            for (LookupNameUsage lookup : lookups) {
                for (NodeSource src : nodeSources) {
                    fileLocalUsages.computeIfAbsent(src, s -> new HashSet()).add(lookup);
                }
            }
            this.myNodes.add(Pair.create((Object)node, (Object)nodeSources));
        }
        this.myNodeBuilders.clear();
        NodeSourcePathMapper pathMapper = this.myGraphConfig.getPathMapper();
        for (Map.Entry<Path, Set<Usage>> entry : this.myPerSourceAdditionalUsages.entrySet()) {
            NodeSource src = pathMapper.toNodeSource(entry.getKey());
            Set<Usage> usages = entry.getValue();
            Set selfUsages = (Set)fileLocalUsages.get(src);
            if (selfUsages != null) {
                usages.removeAll(selfUsages);
            }
            this.myNodes.add(new Pair((Object)new FileNode(src.toString(), usages), List.of(src)));
        }
        this.myPerSourceAdditionalUsages.clear();
        return this.myNodes;
    }

    @Override
    public void registerImports(String className, Collection<String> classImports, Collection<String> staticImports) {
        String key = className.replace('.', '/');
        if (!classImports.isEmpty() || !staticImports.isEmpty()) {
            this.myImportRefs.put(key, (Pair<Collection<String>, Collection<String>>)Pair.create(classImports, staticImports));
        } else {
            this.myImportRefs.remove(key);
        }
    }

    @Override
    public void registerConstantReferences(String className, Collection<Callbacks.ConstantRef> cRefs) {
        String key = className.replace('.', '/');
        if (!cRefs.isEmpty()) {
            this.myConstantRefs.put(key, cRefs);
        } else {
            this.myConstantRefs.remove(key);
        }
    }

    @Override
    public void registerUsage(String className, Usage usage) {
        this.myAdditionalUsages.computeIfAbsent(className.replace('.', '/'), k -> Collections.synchronizedSet(new HashSet())).add(usage);
    }

    @Override
    public void registerUsage(Path source, Usage usage) {
        this.myPerSourceAdditionalUsages.computeIfAbsent(source, k -> Collections.synchronizedSet(new HashSet())).add(usage);
    }

    private static void addImportUsages(JvmClassNodeBuilder builder, Collection<String> classImports, Collection<String> staticImports) {
        for (String anImport : classImports) {
            if (anImport.endsWith(IMPORT_WILDCARD_SUFFIX)) {
                builder.addUsage((Usage)new ImportPackageOnDemandUsage(anImport.substring(0, anImport.length() - IMPORT_WILDCARD_SUFFIX.length()).replace('.', '/')));
                continue;
            }
            builder.addUsage((Usage)new ClassUsage(anImport.replace('.', '/')));
        }
        for (String anImport : staticImports) {
            if (anImport.endsWith(IMPORT_WILDCARD_SUFFIX)) {
                String iname = anImport.substring(0, anImport.length() - IMPORT_WILDCARD_SUFFIX.length()).replace('.', '/');
                builder.addUsage((Usage)new ClassUsage(iname));
                builder.addUsage((Usage)new ImportStaticOnDemandUsage(iname));
                continue;
            }
            int i = anImport.lastIndexOf(46);
            if (i <= 0 || i >= anImport.length() - 1) continue;
            String iname = anImport.substring(0, i).replace('.', '/');
            String memberName = anImport.substring(i + 1);
            builder.addUsage((Usage)new ClassUsage(iname));
            builder.addUsage((Usage)new ImportStaticMemberUsage(iname, memberName));
        }
    }

    private static void addConstantUsages(JvmClassNodeBuilder builder, String nodeName, Collection<? extends Callbacks.ConstantRef> cRefs) {
        if (cRefs != null) {
            for (Callbacks.ConstantRef constantRef : cRefs) {
                String constantOwner = constantRef.getOwner().replace('.', '/');
                if (constantOwner.equals(nodeName)) continue;
                builder.addUsage((Usage)new FieldUsage(constantOwner, constantRef.getName(), constantRef.getDescriptor()));
            }
        }
    }
}

