/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java.dependencyView;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FastUtilHashingStrategies;
import com.intellij.util.containers.FileCollectionFactory;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntConsumer;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.annotation.RetentionPolicy;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.java.dependencyView.AnnotationsChangeTracker;
import org.jetbrains.jps.builders.java.dependencyView.Callbacks;
import org.jetbrains.jps.builders.java.dependencyView.ClassFileRepr;
import org.jetbrains.jps.builders.java.dependencyView.ClassFileReprExternalizer;
import org.jetbrains.jps.builders.java.dependencyView.ClassRepr;
import org.jetbrains.jps.builders.java.dependencyView.ClassfileAnalyzer;
import org.jetbrains.jps.builders.java.dependencyView.CloseableMaplet;
import org.jetbrains.jps.builders.java.dependencyView.DependencyContext;
import org.jetbrains.jps.builders.java.dependencyView.Difference;
import org.jetbrains.jps.builders.java.dependencyView.ElemType;
import org.jetbrains.jps.builders.java.dependencyView.FieldRepr;
import org.jetbrains.jps.builders.java.dependencyView.IntIntMultiMaplet;
import org.jetbrains.jps.builders.java.dependencyView.IntIntPersistentMultiMaplet;
import org.jetbrains.jps.builders.java.dependencyView.IntIntTransientMultiMaplet;
import org.jetbrains.jps.builders.java.dependencyView.IntObjectMultiMaplet;
import org.jetbrains.jps.builders.java.dependencyView.IntObjectPersistentMultiMaplet;
import org.jetbrains.jps.builders.java.dependencyView.IntObjectTransientMultiMaplet;
import org.jetbrains.jps.builders.java.dependencyView.LoggerWrapper;
import org.jetbrains.jps.builders.java.dependencyView.MethodRepr;
import org.jetbrains.jps.builders.java.dependencyView.ModulePackageRepr;
import org.jetbrains.jps.builders.java.dependencyView.ModuleRepr;
import org.jetbrains.jps.builders.java.dependencyView.ModuleRequiresRepr;
import org.jetbrains.jps.builders.java.dependencyView.NamingContext;
import org.jetbrains.jps.builders.java.dependencyView.NaturalIntIntPersistentMultiMaplet;
import org.jetbrains.jps.builders.java.dependencyView.ObjectObjectMultiMaplet;
import org.jetbrains.jps.builders.java.dependencyView.ObjectObjectPersistentMultiMaplet;
import org.jetbrains.jps.builders.java.dependencyView.ObjectObjectTransientMultiMaplet;
import org.jetbrains.jps.builders.java.dependencyView.Proto;
import org.jetbrains.jps.builders.java.dependencyView.ProtoFieldEntity;
import org.jetbrains.jps.builders.java.dependencyView.ProtoMember;
import org.jetbrains.jps.builders.java.dependencyView.ProtoMethodEntity;
import org.jetbrains.jps.builders.java.dependencyView.Streamable;
import org.jetbrains.jps.builders.java.dependencyView.TypeRepr;
import org.jetbrains.jps.builders.java.dependencyView.UsageConstraint;
import org.jetbrains.jps.builders.java.dependencyView.UsageRepr;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;
import org.jetbrains.jps.incremental.storage.PathStringDescriptors;
import org.jetbrains.jps.service.JpsServiceManager;
import org.jetbrains.jps.util.Iterators;
import org.jetbrains.org.objectweb.asm.ClassReader;

@ApiStatus.Internal
public class Mappings {
    private static final Logger LOG = Logger.getInstance(Mappings.class);
    private boolean myProcessConstantsIncrementally;
    private static final boolean USE_NATURAL_INT_MULTIMAP_IMPLEMENTATION = Boolean.parseBoolean(System.getProperty("jps.mappings.natural.int.multimap.impl", "true"));
    private static final String CLASS_TO_SUBCLASSES = "classToSubclasses.tab";
    private static final String CLASS_TO_CLASS = "classToClass.tab";
    private static final String SHORT_NAMES = "shortNames.tab";
    private static final String SOURCE_TO_CLASS = "sourceToClass.tab";
    private static final String CLASS_TO_SOURCE = "classToSource.tab";
    private static final int DEFAULT_SET_CAPACITY = 32;
    private static final float DEFAULT_SET_LOAD_FACTOR = 0.98f;
    private static final String IMPORT_WILDCARD_SUFFIX = ".*";
    private final boolean myIsDelta;
    private boolean myIsDifferentiated;
    private boolean myIsRebuild;
    private long myTotalDifferentiateTime;
    private long myTotalIntegrateTime;
    private final IntSet myChangedClasses;
    private final Set<File> myChangedFiles;
    private final Set<Pair<ClassFileRepr, File>> myDeletedClasses;
    private final Set<ClassRepr> myAddedClasses;
    private final Object myLock;
    private final File myRootDir;
    private DependencyContext myContext;
    private final int myInitName;
    private final int myEmptyName;
    private final int myObjectClassName;
    private LoggerWrapper<Integer> myDebugS;
    private IntIntMultiMaplet myClassToSubclasses;
    private IntIntMultiMaplet myClassToClassDependency;
    private ObjectObjectMultiMaplet<String, ClassFileRepr> myRelativeSourceFilePathToClasses;
    private IntObjectMultiMaplet<String> myClassToRelativeSourceFilePath;
    private IntIntMultiMaplet myShortClassNameIndex;
    private IntIntTransientMultiMaplet myRemovedSuperClasses;
    private IntIntTransientMultiMaplet myAddedSuperClasses;
    @Nullable
    private Collection<String> myRemovedFiles;
    private final PathRelativizerService myRelativizer;
    private final LinkedBlockingQueue<Runnable> myPostPasses;
    private static final ClassRepr MOCK_CLASS = null;
    private static final MethodRepr MOCK_METHOD = null;

    public PathRelativizerService getRelativizer() {
        return this.myRelativizer;
    }

    private Mappings(Mappings base) throws IOException {
        this.myProcessConstantsIncrementally = true;
        this.myIsDifferentiated = false;
        this.myIsRebuild = false;
        this.myPostPasses = new LinkedBlockingQueue();
        this.myLock = base.myLock;
        this.myIsDelta = true;
        this.myProcessConstantsIncrementally = base.myProcessConstantsIncrementally;
        this.myChangedClasses = new IntOpenHashSet(32, 0.98f);
        this.myChangedFiles = FileCollectionFactory.createCanonicalFileSet();
        this.myDeletedClasses = new HashSet<Pair<ClassFileRepr, File>>(32, 0.98f);
        this.myAddedClasses = new HashSet<ClassRepr>(32, 0.98f);
        this.myRootDir = new File(FileUtil.toSystemIndependentName((String)base.myRootDir.getAbsolutePath()) + File.separatorChar + "myDelta");
        this.myContext = base.myContext;
        this.myInitName = this.myContext.get("<init>");
        this.myEmptyName = this.myContext.get("");
        this.myObjectClassName = this.myContext.get("java/lang/Object");
        this.myDebugS = base.myDebugS;
        this.myRelativizer = base.myRelativizer;
        this.createImplementation();
    }

    public Mappings(File rootDir, @NotNull PathRelativizerService relativizer) throws IOException {
        if (relativizer == null) {
            Mappings.$$$reportNull$$$0(0);
        }
        this.myProcessConstantsIncrementally = true;
        this.myIsDifferentiated = false;
        this.myIsRebuild = false;
        this.myPostPasses = new LinkedBlockingQueue();
        this.myLock = new Object();
        this.myIsDelta = false;
        this.myChangedClasses = null;
        this.myChangedFiles = null;
        this.myDeletedClasses = null;
        this.myAddedClasses = null;
        this.myRootDir = rootDir;
        this.myRelativizer = relativizer;
        this.createImplementation();
        this.myInitName = this.myContext.get("<init>");
        this.myEmptyName = this.myContext.get("");
        this.myObjectClassName = this.myContext.get("java/lang/Object");
    }

    private void createImplementation() throws IOException {
        try {
            if (!this.myIsDelta) {
                this.myContext = new DependencyContext(this.myRootDir, this.myRelativizer);
                this.myDebugS = this.myContext.getLogger(LOG);
            }
            this.myRemovedSuperClasses = this.myIsDelta ? new IntIntTransientMultiMaplet() : null;
            this.myAddedSuperClasses = this.myIsDelta ? new IntIntTransientMultiMaplet() : null;
            Supplier<Collection> fileCollectionFactory = CollectionFactory::createFilePathSet;
            if (this.myIsDelta) {
                this.myClassToSubclasses = new IntIntTransientMultiMaplet();
                this.myClassToClassDependency = new IntIntTransientMultiMaplet();
                this.myShortClassNameIndex = null;
                this.myRelativeSourceFilePathToClasses = new ObjectObjectTransientMultiMaplet<String, ClassFileRepr>(FastUtilHashingStrategies.FILE_PATH_HASH_STRATEGY, () -> new HashSet(5, 0.98f));
                this.myClassToRelativeSourceFilePath = new IntObjectTransientMultiMaplet<String>(fileCollectionFactory);
            } else {
                this.myClassToSubclasses = new IntIntPersistentMultiMaplet(DependencyContext.getTableFile(this.myRootDir, CLASS_TO_SUBCLASSES), (KeyDescriptor<Integer>)EnumeratorIntegerDescriptor.INSTANCE);
                this.myClassToClassDependency = USE_NATURAL_INT_MULTIMAP_IMPLEMENTATION ? new NaturalIntIntPersistentMultiMaplet(DependencyContext.getTableFile(this.myRootDir, CLASS_TO_CLASS), (KeyDescriptor<Integer>)EnumeratorIntegerDescriptor.INSTANCE) : new IntIntPersistentMultiMaplet(DependencyContext.getTableFile(this.myRootDir, CLASS_TO_CLASS), (KeyDescriptor<Integer>)EnumeratorIntegerDescriptor.INSTANCE);
                this.myShortClassNameIndex = new IntIntPersistentMultiMaplet(DependencyContext.getTableFile(this.myRootDir, SHORT_NAMES), (KeyDescriptor<Integer>)EnumeratorIntegerDescriptor.INSTANCE);
                this.myRelativeSourceFilePathToClasses = new ObjectObjectPersistentMultiMaplet<String, ClassFileRepr>(DependencyContext.getTableFile(this.myRootDir, SOURCE_TO_CLASS), PathStringDescriptors.createPathStringDescriptor(), (DataExternalizer)new ClassFileReprExternalizer(this.myContext), () -> new HashSet(5, 0.98f)){

                    @Override
                    @NotNull
                    protected String debugString(String path) {
                        String string = SystemInfoRt.isFileSystemCaseSensitive ? path : path.toLowerCase(Locale.US);
                        if (string == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/java/dependencyView/Mappings$1", "debugString"));
                    }
                };
                this.myClassToRelativeSourceFilePath = new IntObjectPersistentMultiMaplet<String>(DependencyContext.getTableFile(this.myRootDir, CLASS_TO_SOURCE), (KeyDescriptor<Integer>)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer<String>)PathStringDescriptors.createPathStringDescriptor(), (Supplier<Collection<String>>)fileCollectionFactory);
            }
        }
        catch (Throwable e) {
            try {
                this.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw e;
        }
    }

    public void setProcessConstantsIncrementally(boolean processInc) {
        this.myProcessConstantsIncrementally = processInc;
    }

    public String valueOf(int name) {
        return this.myContext.getValue(name);
    }

    public int getName(String string) {
        return this.myContext.get(string);
    }

    public Mappings createDelta() {
        Object object = this.myLock;
        synchronized (object) {
            try {
                return new Mappings(this);
            }
            catch (IOException e) {
                throw new BuildDataCorruptedException(e);
            }
        }
    }

    private void compensateRemovedContent(@NotNull Collection<? extends File> compiled, @NotNull Collection<? extends File> compiledWithErrors) {
        if (compiled == null) {
            Mappings.$$$reportNull$$$0(1);
        }
        if (compiledWithErrors == null) {
            Mappings.$$$reportNull$$$0(2);
        }
        for (File file : compiled) {
            String relative;
            if (compiledWithErrors.contains(file) || this.myRelativeSourceFilePathToClasses.containsKey(relative = this.toRelative(file))) continue;
            this.myRelativeSourceFilePathToClasses.put(relative, new HashSet());
        }
    }

    @NotNull
    private <T extends ClassFileRepr> Iterable<T> getReprsByName(int qName, Class<T> selector) {
        Iterable iterable = Iterators.unique((Iterable)Iterators.filter((Iterable)Iterators.map((Iterable)Iterators.flat((Iterable)Iterators.map(this.myClassToRelativeSourceFilePath.get(qName), src -> this.myRelativeSourceFilePathToClasses.get((String)src))), repr -> repr.name == qName && selector.isInstance(repr) ? (ClassFileRepr)selector.cast(repr) : null), Objects::nonNull));
        if (iterable == null) {
            Mappings.$$$reportNull$$$0(3);
        }
        return iterable;
    }

    private Collection<ClassFileRepr> sourceFileToClassesGet(File unchangedSource) {
        return this.myRelativeSourceFilePathToClasses.get(this.toRelative(unchangedSource));
    }

    @NotNull
    private String toRelative(File file) {
        String string = this.myRelativizer.toRelative(file.getAbsolutePath());
        if (string == null) {
            Mappings.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    private Iterable<File> classToSourceFileGet(int qName) {
        Collection<String> get = this.myClassToRelativeSourceFilePath.get(qName);
        return get == null ? null : Iterators.map(get, s -> this.toFull((String)s));
    }

    @NotNull
    private File toFull(String relativePath) {
        return new File(this.myRelativizer.toFull(relativePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean() throws IOException {
        if (this.myRootDir != null) {
            Object object = this.myLock;
            synchronized (object) {
                this.close();
                FileUtil.delete((File)this.myRootDir);
                this.createImplementation();
            }
        }
    }

    public IntIntTransientMultiMaplet getRemovedSuperClasses() {
        return this.myRemovedSuperClasses;
    }

    public IntIntTransientMultiMaplet getAddedSuperClasses() {
        return this.myAddedSuperClasses;
    }

    private void runPostPasses() {
        Set<Pair<ClassFileRepr, File>> deleted = this.myDeletedClasses;
        if (deleted != null) {
            for (Pair<ClassFileRepr, File> pair : deleted) {
                int deletedClassName = ((ClassFileRepr)pair.first).name;
                Iterable<File> sources = this.classToSourceFileGet(deletedClassName);
                if (sources != null && !Iterators.isEmpty(sources)) continue;
                this.myChangedClasses.remove(deletedClassName);
            }
        }
        Runnable pass = this.myPostPasses.poll();
        while (pass != null) {
            pass.run();
            pass = this.myPostPasses.poll();
        }
    }

    void affectAll(int className, @NotNull File sourceFile, Collection<? super File> affectedFiles, Collection<? extends File> alreadyCompiledFiles, @Nullable DependentFilesFilter filter) {
        IntSet dependants;
        if (sourceFile == null) {
            Mappings.$$$reportNull$$$0(5);
        }
        if ((dependants = this.myClassToClassDependency.get(className)) != null) {
            dependants.forEach(depClass -> {
                Iterable<File> allSources = this.classToSourceFileGet(depClass);
                if (allSources == null || Iterators.isEmpty(allSources)) {
                    return;
                }
                boolean shouldAffect = false;
                for (File depFile : allSources) {
                    if (FileUtil.filesEqual((File)depFile, (File)sourceFile) || alreadyCompiledFiles.contains(depFile) || filter != null && !filter.accept(depFile)) continue;
                    shouldAffect = true;
                    break;
                }
                if (shouldAffect) {
                    for (File depFile : allSources) {
                        if (FileUtil.filesEqual((File)depFile, (File)sourceFile)) continue;
                        affectedFiles.add(depFile);
                    }
                }
            });
        }
    }

    private static boolean isVisibleIn(ClassRepr c, ProtoMember m, ClassRepr scope) {
        boolean privacy = m.isPrivate() && c.name != scope.name;
        boolean packageLocality = m.isPackageLocal() && !Objects.equals(c.getPackageName(), scope.getPackageName());
        return !privacy && !packageLocality;
    }

    private boolean isEmpty(int s) {
        return s == this.myEmptyName;
    }

    @NotNull
    private IntSet getAllSubclasses(int root) {
        IntSet intSet = this.addAllSubclasses(root, (IntSet)new IntOpenHashSet(32, 0.98f));
        if (intSet == null) {
            Mappings.$$$reportNull$$$0(6);
        }
        return intSet;
    }

    private IntSet addAllSubclasses(int root, IntSet acc) {
        IntSet directSubclasses;
        if (acc.add(root) && (directSubclasses = this.myClassToSubclasses.get(root)) != null) {
            directSubclasses.forEach(s -> this.addAllSubclasses(s, acc));
        }
        return acc;
    }

    private boolean incrementalDecision(int owner, Proto member, Collection<? super File> affectedFiles, Collection<? extends File> currentlyCompiled, @Nullable DependentFilesFilter filter) {
        String cName;
        int classname;
        Util self = new Util();
        int n = classname = member instanceof ClassRepr ? member.name : owner;
        if (member.isPublic()) {
            Mappings.debug("Public access, switching to a non-incremental mode");
            return false;
        }
        Set toRecompile = FileCollectionFactory.createCanonicalFileSet();
        if (member.isProtected()) {
            IntSet propagated;
            Mappings.debug("Protected access, softening non-incremental decision: adding all relevant subclasses for a recompilation");
            this.debug("Root class: ", classname);
            if (member instanceof FieldRepr) {
                propagated = self.propagateFieldAccess(member.name, classname);
            } else {
                propagated = this.getAllSubclasses(classname);
                propagated.remove(classname);
            }
            propagated.forEach(className -> {
                Iterable<File> fileNames = this.classToSourceFileGet(className);
                if (fileNames != null) {
                    if (this.myDebugS.isDebugEnabled()) {
                        for (File fileName : fileNames) {
                            this.debug("Adding ", fileName);
                        }
                    }
                    ContainerUtil.addAll((Collection)toRecompile, fileNames);
                }
            });
        }
        if ((cName = this.myContext.getValue(classname)) != null) {
            String packageName = ClassRepr.getPackageName(cName);
            Mappings.debug("Softening non-incremental decision: adding all package classes for a recompilation");
            this.debug("Package name: ", packageName);
            this.myClassToRelativeSourceFilePath.forEachEntry((relFilePaths, value) -> {
                String clsName = this.myContext.getValue(value);
                if (clsName != null && ClassRepr.getPackageName(clsName).equals(packageName)) {
                    for (String rel : relFilePaths) {
                        File file = this.toFull(rel);
                        if (filter != null && !filter.accept(file)) continue;
                        this.debug("Adding: ", rel);
                        toRecompile.add(file);
                    }
                }
            });
        }
        toRecompile.removeAll(currentlyCompiled);
        Iterator it = toRecompile.iterator();
        while (it.hasNext()) {
            File file = (File)it.next();
            if (file.exists()) continue;
            it.remove();
        }
        affectedFiles.addAll(toRecompile);
        return true;
    }

    public void differentiateOnRebuild(Mappings delta) {
        new Differential(delta).differentiate();
    }

    public void differentiateOnNonIncrementalMake(Mappings delta, Collection<String> removed, Collection<? extends File> filesToCompile) {
        new Differential(delta, removed, filesToCompile).differentiate();
    }

    public boolean differentiateOnIncrementalMake(Mappings delta, Collection<String> removed, Collection<? extends File> filesToCompile, Collection<? extends File> compiledWithErrors, Collection<? extends File> compiledFiles, Collection<? super File> affectedFiles, @NotNull DependentFilesFilter filter) {
        if (filter == null) {
            Mappings.$$$reportNull$$$0(7);
        }
        return new Differential(delta, removed, filesToCompile, compiledWithErrors, compiledFiles, affectedFiles, filter).differentiate();
    }

    private void cleanupBackDependency(int className, @Nullable Iterable<? extends UsageRepr.Usage> usages, IntIntMultiMaplet buffer) {
        if (usages == null) {
            usages = Iterators.flat((Iterable)Iterators.map(this.getReprsByName(className, ClassFileRepr.class), repr -> repr.getUsages()));
        }
        for (Integer owner : Iterators.unique((Iterable)Iterators.map(usages, usage -> usage.getOwner()))) {
            if (owner == className) continue;
            buffer.put((int)owner, className);
        }
    }

    private void cleanupRemovedClass(Mappings delta, @NotNull ClassFileRepr cr, File sourceFile, Set<? extends UsageRepr.Usage> usages, IntIntMultiMaplet dependenciesTrashBin) {
        ClassRepr _cr;
        int className;
        Iterable<File> currentlyMapped;
        if (cr == null) {
            Mappings.$$$reportNull$$$0(8);
        }
        if ((currentlyMapped = this.classToSourceFileGet(className = cr.name)) != null) {
            for (File file : currentlyMapped) {
                if (FileUtil.filesEqual((File)sourceFile, (File)file) || !file.exists()) continue;
                this.myClassToRelativeSourceFilePath.removeFrom(className, this.toRelative(sourceFile));
                return;
            }
        }
        if (cr instanceof ClassRepr) {
            for (TypeRepr.ClassType superSomething : ((ClassRepr)cr).getSuperTypes()) {
                delta.registerRemovedSuperClass(className, superSomething.className);
            }
        }
        this.cleanupBackDependency(className, usages, dependenciesTrashBin);
        this.myClassToClassDependency.remove(className);
        this.myClassToSubclasses.remove(className);
        this.myClassToRelativeSourceFilePath.remove(className);
        if (cr instanceof ClassRepr && !(_cr = (ClassRepr)cr).isLocal() && !_cr.isAnonymous()) {
            this.myShortClassNameIndex.removeFrom(this.myContext.get(_cr.getShortName()), className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void integrate(final Mappings delta) {
        Object object = this.myLock;
        synchronized (object) {
            long start = System.currentTimeMillis();
            try {
                assert (delta.isDifferentiated());
                Collection<String> removed = delta.myRemovedFiles;
                delta.runPostPasses();
                final IntIntTransientMultiMaplet dependenciesTrashBin = new IntIntTransientMultiMaplet();
                if (removed != null) {
                    for (String string : removed) {
                        File deletedFile = new File(string);
                        Set fileClasses = (Set)this.sourceFileToClassesGet(deletedFile);
                        if (fileClasses == null) continue;
                        for (ClassFileRepr aClass2 : fileClasses) {
                            this.cleanupRemovedClass(delta, aClass2, deletedFile, aClass2.getUsages(), dependenciesTrashBin);
                        }
                        this.myRelativeSourceFilePathToClasses.remove(this.myRelativizer.toRelative(string));
                    }
                }
                if (!delta.isRebuild()) {
                    for (Pair pair : delta.getDeletedClasses()) {
                        ClassFileRepr deletedClass = (ClassFileRepr)pair.first;
                        this.cleanupRemovedClass(delta, deletedClass, (File)pair.second, deletedClass.getUsages(), dependenciesTrashBin);
                    }
                    for (ClassRepr classRepr : delta.getAddedClasses()) {
                        if (classRepr.isAnonymous() || classRepr.isLocal()) continue;
                        this.myShortClassNameIndex.put(this.myContext.get(classRepr.getShortName()), classRepr.name);
                    }
                    IntOpenHashSet superClasses = new IntOpenHashSet();
                    IntIntTransientMultiMaplet intIntTransientMultiMaplet = delta.getAddedSuperClasses();
                    IntIntTransientMultiMaplet removedSuperClasses = delta.getRemovedSuperClasses();
                    Mappings.addAllKeys((IntSet)superClasses, intIntTransientMultiMaplet);
                    Mappings.addAllKeys((IntSet)superClasses, removedSuperClasses);
                    superClasses.forEach(superClass -> {
                        IntSet added = addedSuperClasses.get(superClass);
                        IntSet removed12 = removedSuperClasses.get(superClass);
                        IntSet old = this.myClassToSubclasses.get(superClass);
                        if (old == null) {
                            if (added != null && !added.isEmpty()) {
                                this.myClassToSubclasses.replace(superClass, added);
                            }
                        } else {
                            int[] addedAsArray;
                            boolean changed = false;
                            int[] nArray = addedAsArray = added == null || added.isEmpty() ? null : added.toIntArray();
                            if (removed12 != null && !removed12.isEmpty()) {
                                if (addedAsArray != null) {
                                    removed12 = new IntOpenHashSet((IntCollection)removed12);
                                    removed12.removeAll((IntCollection)IntSet.of((int[])addedAsArray));
                                }
                                if (!removed12.isEmpty()) {
                                    changed = old.removeAll((IntCollection)removed12);
                                }
                            }
                            if (addedAsArray != null) {
                                changed |= old.addAll((IntCollection)IntSet.of((int[])addedAsArray));
                            }
                            if (changed) {
                                this.myClassToSubclasses.replace(superClass, old);
                            }
                        }
                    });
                    final Set changedRelativePaths = CollectionFactory.createFilePathSet();
                    for (File file : delta.getChangedFiles()) {
                        changedRelativePaths.add(this.toRelative(file));
                    }
                    delta.getChangedClasses().forEach(new IntConsumer(){
                        final Set<String> pathsBuffer = CollectionFactory.createFilePathSet();

                        /*
                         * Unable to fully structure code
                         */
                        public void accept(int className) {
                            currentPaths = Mappings.this.myClassToRelativeSourceFilePath.get(className);
                            if (currentPaths != null && !currentPaths.isEmpty()) {
                                try {
                                    this.pathsBuffer.addAll(currentPaths);
                                    this.pathsBuffer.removeAll(changedRelativePaths);
                                    this.pathsBuffer.addAll(delta.myClassToRelativeSourceFilePath.get(className));
                                    if (this.pathsBuffer.size() == currentPaths.size() && this.pathsBuffer.containsAll(currentPaths)) ** GOTO lbl17
                                    Mappings.this.myClassToRelativeSourceFilePath.replace(className, this.pathsBuffer);
                                }
                                finally {
                                    this.pathsBuffer.clear();
                                }
                            } else {
                                Mappings.this.myClassToRelativeSourceFilePath.replace(className, delta.myClassToRelativeSourceFilePath.get(className));
                            }
lbl17:
                            // 3 sources

                            Mappings.this.cleanupBackDependency(className, null, dependenciesTrashBin);
                        }
                    });
                    for (String path : changedRelativePaths) {
                        this.myRelativeSourceFilePathToClasses.replace(path, delta.myRelativeSourceFilePathToClasses.get(path));
                    }
                    Set unchangedSources = FileCollectionFactory.createCanonicalFileSet();
                    delta.myRelativeSourceFilePathToClasses.forEachEntry((PairProcessor<String, Collection<ClassFileRepr>>)((PairProcessor)(source, b) -> {
                        unchangedSources.add(this.toFull((String)source));
                        return true;
                    }));
                    unchangedSources.removeAll(delta.getChangedFiles());
                    if (!unchangedSources.isEmpty()) {
                        unchangedSources.forEach(unchangedSource -> {
                            Collection<ClassFileRepr> updatedClasses = delta.sourceFileToClassesGet((File)unchangedSource);
                            if (updatedClasses != null && !updatedClasses.isEmpty()) {
                                ArrayList<ClassFileRepr> classesToPut = new ArrayList<ClassFileRepr>();
                                IntOpenHashSet updatedClassNames = new IntOpenHashSet();
                                for (ClassFileRepr aClass : updatedClasses) {
                                    if (!delta.getChangedClasses().contains(aClass.name)) continue;
                                    classesToPut.add(aClass);
                                    updatedClassNames.add(aClass.name);
                                }
                                Collection<ClassFileRepr> currentClasses = this.sourceFileToClassesGet((File)unchangedSource);
                                if (currentClasses != null) {
                                    for (ClassFileRepr aClass : currentClasses) {
                                        if (updatedClassNames.contains(aClass.name)) continue;
                                        classesToPut.add(aClass);
                                    }
                                }
                                this.myRelativeSourceFilePathToClasses.replace(this.toRelative((File)unchangedSource), classesToPut);
                            }
                        });
                    }
                } else {
                    this.myClassToSubclasses.putAll(delta.myClassToSubclasses);
                    this.myClassToRelativeSourceFilePath.putAll(delta.myClassToRelativeSourceFilePath);
                    this.myRelativeSourceFilePathToClasses.replaceAll(delta.myRelativeSourceFilePathToClasses);
                    delta.myRelativeSourceFilePathToClasses.forEachEntry((PairProcessor<String, Collection<ClassFileRepr>>)((PairProcessor)(src, classes) -> {
                        for (ClassFileRepr repr : classes) {
                            ClassRepr clsRepr;
                            if (!(repr instanceof ClassRepr) || (clsRepr = (ClassRepr)repr).isAnonymous() || clsRepr.isLocal()) continue;
                            this.myShortClassNameIndex.put(this.myContext.get(clsRepr.getShortName()), repr.name);
                        }
                        return true;
                    }));
                }
                IntOpenHashSet affectedClasses = new IntOpenHashSet();
                Mappings.addAllKeys((IntSet)affectedClasses, dependenciesTrashBin);
                Mappings.addAllKeys((IntSet)affectedClasses, delta.myClassToClassDependency);
                affectedClasses.forEach(aClass -> {
                    IntSet toAdd;
                    IntSet toRemove = dependenciesTrashBin.get(aClass);
                    if (toRemove != null) {
                        this.myClassToClassDependency.removeAll(aClass, toRemove);
                    }
                    if ((toAdd = delta.myClassToClassDependency.get(aClass)) != null) {
                        this.myClassToClassDependency.put(aClass, toAdd);
                    }
                });
            }
            finally {
                delta.close();
                this.myTotalIntegrateTime += System.currentTimeMillis() - start;
            }
        }
    }

    public Callbacks.Backend getCallback() {
        return new Callbacks.Backend(){
            private final Map<String, Pair<Collection<String>, Collection<String>>> myImportRefs = Collections.synchronizedMap(new HashMap());
            private final Map<String, Collection<Callbacks.ConstantRef>> myConstantRefs = Collections.synchronizedMap(new HashMap());

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void associate(String classFileName, Collection<String> sources, ClassReader cr, boolean isGenerated) {
                Object object = Mappings.this.myLock;
                synchronized (object) {
                    int classFileNameS = Mappings.this.myContext.get(classFileName);
                    ClassFileRepr result = new ClassfileAnalyzer(Mappings.this.myContext).analyze(classFileNameS, cr, isGenerated);
                    if (result != null) {
                        int className = result.name;
                        if (result instanceof ClassRepr) {
                            Pair<Collection<String>, Collection<String>> imports;
                            ClassRepr classRepr = (ClassRepr)result;
                            String classNameStr = Mappings.this.myContext.getValue(className);
                            if (this.addConstantUsages(classRepr, this.myConstantRefs.remove(classNameStr))) {
                                classRepr.setHasInlinedConstants(true);
                            }
                            if ((imports = this.myImportRefs.remove(classNameStr)) != null) {
                                this.addImportUsages(classRepr, (Collection)imports.getFirst(), (Collection)imports.getSecond());
                            }
                        }
                        for (String sourceFileName : sources) {
                            String relative = Mappings.this.myRelativizer.toRelative(sourceFileName);
                            Mappings.this.myClassToRelativeSourceFilePath.put(className, relative);
                            Mappings.this.myRelativeSourceFilePathToClasses.put(relative, result);
                        }
                        if (result instanceof ClassRepr) {
                            for (TypeRepr.ClassType s : ((ClassRepr)result).getSuperTypes()) {
                                Mappings.this.myClassToSubclasses.put(s.className, className);
                            }
                        }
                        for (UsageRepr.Usage u : result.getUsages()) {
                            int owner = u.getOwner();
                            if (owner == className) continue;
                            Mappings.this.myClassToClassDependency.put(owner, className);
                        }
                    }
                }
            }

            @Override
            public void registerImports(String className, Collection<String> classImports, Collection<String> staticImports) {
                String key = className.replace('.', '/');
                if (!classImports.isEmpty() || !staticImports.isEmpty()) {
                    this.myImportRefs.put(key, (Pair<Collection<String>, Collection<String>>)Pair.create(classImports, staticImports));
                } else {
                    this.myImportRefs.remove(key);
                }
            }

            @Override
            public void registerConstantReferences(String className, Collection<Callbacks.ConstantRef> cRefs) {
                String key = className.replace('.', '/');
                if (!cRefs.isEmpty()) {
                    this.myConstantRefs.put(key, cRefs);
                } else {
                    this.myConstantRefs.remove(key);
                }
            }

            private void addImportUsages(ClassRepr repr, Collection<String> classImports, Collection<String> staticImports) {
                for (String anImport : classImports) {
                    if (anImport.endsWith(Mappings.IMPORT_WILDCARD_SUFFIX)) continue;
                    repr.addUsage(UsageRepr.createClassUsage(Mappings.this.myContext, Mappings.this.myContext.get(anImport.replace('.', '/'))));
                }
                for (String anImport : staticImports) {
                    if (anImport.endsWith(Mappings.IMPORT_WILDCARD_SUFFIX)) {
                        int iname = Mappings.this.myContext.get(anImport.substring(0, anImport.length() - Mappings.IMPORT_WILDCARD_SUFFIX.length()).replace('.', '/'));
                        repr.addUsage(UsageRepr.createClassUsage(Mappings.this.myContext, iname));
                        repr.addUsage(UsageRepr.createImportStaticOnDemandUsage(Mappings.this.myContext, iname));
                        continue;
                    }
                    int i = anImport.lastIndexOf(46);
                    if (i <= 0 || i >= anImport.length() - 1) continue;
                    int iname = Mappings.this.myContext.get(anImport.substring(0, i).replace('.', '/'));
                    int memberName = Mappings.this.myContext.get(anImport.substring(i + 1));
                    repr.addUsage(UsageRepr.createClassUsage(Mappings.this.myContext, iname));
                    repr.addUsage(UsageRepr.createImportStaticMemberUsage(Mappings.this.myContext, memberName, iname));
                }
            }

            private boolean addConstantUsages(ClassRepr repr, Collection<? extends Callbacks.ConstantRef> cRefs) {
                boolean addedNewUsages = false;
                if (cRefs != null) {
                    for (Callbacks.ConstantRef constantRef : cRefs) {
                        int owner = Mappings.this.myContext.get(constantRef.getOwner().replace('.', '/'));
                        if (repr.name == owner) continue;
                        addedNewUsages |= repr.addUsage(UsageRepr.createFieldUsage(Mappings.this.myContext, Mappings.this.myContext.get(constantRef.getName()), owner, Mappings.this.myContext.get(constantRef.getDescriptor())));
                    }
                }
                return addedNewUsages;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Set<ClassRepr> getClasses(String sourceFileName) {
        File f = new File(sourceFileName);
        Object object = this.myLock;
        synchronized (object) {
            Collection<ClassFileRepr> reprs = this.sourceFileToClassesGet(f);
            if (reprs == null || reprs.isEmpty()) {
                return null;
            }
            HashSet<ClassRepr> result = new HashSet<ClassRepr>();
            for (ClassFileRepr repr : reprs) {
                if (!(repr instanceof ClassRepr)) continue;
                result.add((ClassRepr)repr);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Collection<File> getClassSources(int className) {
        Object object = this.myLock;
        // MONITORENTER : object
        Iterable<File> files = this.classToSourceFileGet(className);
        List list = files == null ? Collections.emptyList() : ContainerUtil.collect(files.iterator());
        // MONITOREXIT : object
        if (list != null) return list;
        Mappings.$$$reportNull$$$0(9);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        BuildDataCorruptedException error = null;
        Object object = this.myLock;
        synchronized (object) {
            for (CloseableMaplet maplet : Arrays.asList(this.myClassToSubclasses, this.myClassToClassDependency, this.myRelativeSourceFilePathToClasses, this.myClassToRelativeSourceFilePath, this.myShortClassNameIndex)) {
                if (maplet == null) continue;
                try {
                    maplet.close();
                }
                catch (BuildDataCorruptedException ex) {
                    if (error != null) continue;
                    error = ex;
                }
            }
            if (!this.myIsDelta) {
                DependencyContext context = this.myContext;
                if (context != null) {
                    block11: {
                        try {
                            context.close();
                        }
                        catch (BuildDataCorruptedException ex) {
                            if (error != null) break block11;
                            error = ex;
                        }
                    }
                    this.myContext = null;
                }
                LOG.info("Mappings total differentiate linear time " + Utils.formatDuration(this.myTotalDifferentiateTime));
                LOG.info("Mappings total integrate     linear time " + Utils.formatDuration(this.myTotalIntegrateTime));
            }
        }
        if (error != null) {
            throw error;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(boolean memoryCachesOnly) {
        Object object = this.myLock;
        synchronized (object) {
            this.myClassToSubclasses.flush(memoryCachesOnly);
            this.myClassToClassDependency.flush(memoryCachesOnly);
            this.myRelativeSourceFilePathToClasses.flush(memoryCachesOnly);
            this.myClassToRelativeSourceFilePath.flush(memoryCachesOnly);
            if (!this.myIsDelta) {
                this.myShortClassNameIndex.flush(memoryCachesOnly);
                DependencyContext context = this.myContext;
                if (context != null) {
                    context.clearMemoryCaches();
                    if (!memoryCachesOnly) {
                        context.flush();
                    }
                }
            }
        }
    }

    private static void addAllKeys(IntSet whereToAdd, IntIntMultiMaplet maplet) {
        maplet.forEachEntry((integers, value) -> whereToAdd.add(value));
    }

    private void registerAddedSuperClass(int aClass, int superClass) {
        assert (this.myAddedSuperClasses != null);
        this.myAddedSuperClasses.put(superClass, aClass);
    }

    private void registerRemovedSuperClass(int aClass, int superClass) {
        assert (this.myRemovedSuperClasses != null);
        this.myRemovedSuperClasses.put(superClass, aClass);
    }

    private boolean isDifferentiated() {
        return this.myIsDifferentiated;
    }

    private boolean isRebuild() {
        return this.myIsRebuild;
    }

    private void addDeletedClass(ClassFileRepr cr, File fileName) {
        assert (this.myDeletedClasses != null);
        this.myDeletedClasses.add((Pair<ClassFileRepr, File>)Pair.create((Object)cr, (Object)fileName));
        this.addChangedClass(cr.name);
    }

    private void addAddedClass(ClassRepr cr) {
        assert (this.myAddedClasses != null);
        this.myAddedClasses.add(cr);
        this.addChangedClass(cr.name);
    }

    private void addChangedClass(int it) {
        assert (this.myChangedClasses != null && this.myChangedFiles != null);
        this.myChangedClasses.add(it);
        Iterable<File> files = this.classToSourceFileGet(it);
        if (files != null) {
            ContainerUtil.addAll(this.myChangedFiles, files);
        }
    }

    @NotNull
    private Set<Pair<ClassFileRepr, File>> getDeletedClasses() {
        Set<Pair<ClassFileRepr, File>> set = this.myDeletedClasses == null ? Collections.emptySet() : Collections.unmodifiableSet(this.myDeletedClasses);
        if (set == null) {
            Mappings.$$$reportNull$$$0(10);
        }
        return set;
    }

    @NotNull
    private Set<ClassRepr> getAddedClasses() {
        Set<ClassRepr> set = this.myAddedClasses == null ? Collections.emptySet() : Collections.unmodifiableSet(this.myAddedClasses);
        if (set == null) {
            Mappings.$$$reportNull$$$0(11);
        }
        return set;
    }

    private IntSet getChangedClasses() {
        return this.myChangedClasses;
    }

    private Set<File> getChangedFiles() {
        return this.myChangedFiles;
    }

    private static void debug(String s) {
        LOG.debug(s);
    }

    private void debug(String comment, int s) {
        this.myDebugS.debug(comment, s);
    }

    private void debug(String comment, File f) {
        this.debug(comment, f.getPath());
    }

    private void debug(String comment, String s) {
        this.myDebugS.debug(comment, s);
    }

    private void debug(String comment, boolean s) {
        this.myDebugS.debug(comment, s);
    }

    public void toStream(PrintStream stream) {
        Streamable[] data = new Streamable[]{this.myClassToSubclasses, this.myClassToClassDependency, this.myRelativeSourceFilePathToClasses, this.myClassToRelativeSourceFilePath};
        String[] info = new String[]{"ClassToSubclasses", "ClassToClassDependency", "SourceFileToClasses", "ClassToSourceFile", "SourceFileToAnnotationUsages", "SourceFileToUsages"};
        for (int i = 0; i < data.length; ++i) {
            stream.print("Begin Of ");
            stream.println(info[i]);
            data[i].toStream(this.myContext, stream);
            stream.print("End Of ");
            stream.println(info[i]);
        }
    }

    private static <T> boolean containsAll(Collection<? extends T> collection, Iterable<? extends T> it) {
        if (collection == null || collection.isEmpty()) {
            return false;
        }
        for (T file : it) {
            if (collection.contains(file)) continue;
            return false;
        }
        return true;
    }

    private static <T> void removeAll(Collection<? extends T> collection, Iterable<? extends T> it) {
        for (T file : it) {
            collection.remove(file);
        }
    }

    private static <T> Supplier<T> lazy(final Supplier<? extends T> calculation) {
        return new Supplier<T>(){
            Ref<T> calculated;

            @Override
            public T get() {
                return (this.calculated != null ? this.calculated : (this.calculated = new Ref(calculation.get()))).get();
            }
        };
    }

    public void toStream(File outputRoot) {
        Streamable[] data = new Streamable[]{this.myClassToSubclasses, this.myClassToClassDependency, this.myRelativeSourceFilePathToClasses, this.myClassToRelativeSourceFilePath, this.myShortClassNameIndex};
        String[] info = new String[]{"ClassToSubclasses", "ClassToClassDependency", "SourceFileToClasses", "ClassToSourceFile", "ShortClassNameIndex"};
        for (int i = 0; i < data.length; ++i) {
            File file = new File(outputRoot, info[i]);
            FileUtil.createIfDoesntExist((File)file);
            try (PrintStream stream = new PrintStream(file);){
                data[i].toStream(this.myContext, stream);
                continue;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativizer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compiled";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compiledWithErrors";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/builders/java/dependencyView/Mappings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/builders/java/dependencyView/Mappings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReprsByName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toRelative";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSubclasses";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassSources";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeletedClasses";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddedClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "compensateRemovedContent";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "affectAll";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "differentiateOnIncrementalMake";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "cleanupRemovedClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface DependentFilesFilter {
        public boolean accept(File var1);

        public boolean belongsToCurrentTargetChunk(File var1);
    }

    private final class Util {
        @Nullable
        private final Mappings myMappings;

        private Util() {
            this.myMappings = null;
        }

        private Util(Mappings mappings2) {
            if (mappings2 == null) {
                Util.$$$reportNull$$$0(0);
            }
            this.myMappings = mappings2;
        }

        IntSet appendDependents(ClassFileRepr c, IntSet result) {
            return this.appendDependents(c.name, result);
        }

        @Nullable
        IntSet appendDependents(int className, IntSet result) {
            IntSet depClasses = Mappings.this.myClassToClassDependency.get(className);
            if (depClasses != null) {
                result.addAll((IntCollection)depClasses);
            }
            return depClasses;
        }

        private IntSet propagateMemberAccessRec(IntSet acc, boolean isField, boolean root, Predicate<? super ProtoMember> isSame, int reflcass) {
            if (acc.contains(reflcass)) {
                return acc;
            }
            Iterable<ClassRepr> reprs = this.reprsByName(reflcass, ClassRepr.class);
            if (!Iterators.isEmpty(reprs)) {
                IntSet subclasses;
                if (!root) {
                    Iterable reprsWithoutMatchingMember = Iterators.filter(reprs, repr -> {
                        for (ProtoMember m : isField ? repr.getFields() : repr.getMethods()) {
                            if (!isSame.test(m)) continue;
                            return false;
                        }
                        return true;
                    });
                    if (Iterators.isEmpty((Iterable)reprsWithoutMatchingMember)) {
                        return acc;
                    }
                    acc.add(reflcass);
                }
                if ((subclasses = Mappings.this.myClassToSubclasses.get(reflcass)) != null) {
                    IntIterator subclassIterator = subclasses.iterator();
                    while (subclassIterator.hasNext()) {
                        this.propagateMemberAccessRec(acc, isField, false, isSame, subclassIterator.nextInt());
                    }
                }
            }
            return acc;
        }

        IntSet propagateMemberAccess(boolean isField, Predicate<? super ProtoMember> isSame, int className) {
            return this.propagateMemberAccessRec((IntSet)new IntOpenHashSet(32, 0.98f), isField, true, isSame, className);
        }

        IntSet propagateFieldAccess(int name, int className) {
            return this.propagateMemberAccess(true, member -> member.name == name, className);
        }

        IntSet propagateMethodAccess(MethodRepr m, int className) {
            return this.propagateMemberAccess(false, member -> m.equals(member), className);
        }

        Predicate<MethodRepr> lessSpecific(MethodRepr than) {
            return m -> {
                if (m.name == Mappings.this.myInitName || m.name != than.name || m.myArgumentTypes.length != than.myArgumentTypes.length) {
                    return false;
                }
                for (int i = 0; i < than.myArgumentTypes.length; ++i) {
                    Boolean subtypeOf = this.isSubtypeOf(than.myArgumentTypes[i], m.myArgumentTypes[i]);
                    if (subtypeOf == null || subtypeOf.booleanValue()) continue;
                    return false;
                }
                return true;
            };
        }

        private void addOverridingMethods(MethodRepr m, ClassRepr methodClass, ClassRepr fromClass, Predicate<? super MethodRepr> predicate, Collection<? super Pair<MethodRepr, ClassRepr>> container, IntSet visitedClasses) {
            if (m.name == Mappings.this.myInitName) {
                return;
            }
            IntSet subClasses = Mappings.this.myClassToSubclasses.get(fromClass.name);
            if (subClasses == null) {
                return;
            }
            if (visitedClasses == null) {
                visitedClasses = new IntOpenHashSet();
            }
            if (!visitedClasses.add(fromClass.name)) {
                return;
            }
            IntSet _visitedClasses = visitedClasses;
            subClasses.forEach(subClassName -> {
                Collection reprs = Iterators.collect(this.reprsByName(subClassName, ClassRepr.class), (Collection)new SmartList());
                if (!Iterators.isEmpty((Iterable)reprs)) {
                    Iterable overriding = Iterators.flat((Iterable)Iterators.map((Iterable)reprs, r -> Mappings.isVisibleIn(methodClass, m, r) ? Iterators.map(r.findMethods(predicate), mm -> Pair.create((Object)mm, (Object)r)) : Collections.emptyList()));
                    SmartHashSet found = new SmartHashSet();
                    for (Pair pair : overriding) {
                        container.add((Pair<MethodRepr, ClassRepr>)pair);
                        found.add((ClassRepr)pair.getSecond());
                    }
                    for (ClassRepr r2 : Iterators.filter((Iterable)reprs, arg_0 -> Util.lambda$addOverridingMethods$6((Set)found, arg_0))) {
                        this.addOverridingMethods(m, methodClass, r2, predicate, container, _visitedClasses);
                    }
                }
            });
        }

        private Collection<Pair<MethodRepr, ClassRepr>> findOverriddenMethods(MethodRepr m, ClassRepr c) {
            if (m.name == Mappings.this.myInitName) {
                return Collections.emptySet();
            }
            HashSet<Pair<MethodRepr, ClassRepr>> result = new HashSet<Pair<MethodRepr, ClassRepr>>();
            this.addOverriddenMethods(c, MethodRepr.equalByJavaRules(m), result, null, c);
            return result;
        }

        private boolean hasOverriddenMethods(ClassRepr fromClass, Predicate<? super MethodRepr> predicate, IntSet visitedClasses, ClassRepr visibilityScope) {
            if (visitedClasses == null) {
                visitedClasses = new IntOpenHashSet();
                visitedClasses.add(fromClass.name);
            }
            for (TypeRepr.ClassType superName : fromClass.getSuperTypes()) {
                if (!visitedClasses.add(superName.className) || superName.className == Mappings.this.myObjectClassName) continue;
                for (ClassRepr superClass : this.reprsByName(superName.className, ClassRepr.class)) {
                    for (MethodRepr mm : superClass.findMethods(predicate)) {
                        if (!Mappings.isVisibleIn(superClass, mm, visibilityScope)) continue;
                        return true;
                    }
                    if (!this.hasOverriddenMethods(superClass, predicate, visitedClasses, visibilityScope)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean extendsLibraryClass(ClassRepr fromClass, IntSet visitedClasses) {
            if (visitedClasses == null) {
                visitedClasses = new IntOpenHashSet();
                visitedClasses.add(fromClass.name);
            }
            for (TypeRepr.ClassType superName : fromClass.getSuperTypes()) {
                if (!visitedClasses.add(superName.className) || superName.className == Mappings.this.myObjectClassName) continue;
                Iterator<ClassRepr> superClasses = this.reprsByName(superName.className, ClassRepr.class).iterator();
                if (!superClasses.hasNext()) {
                    return true;
                }
                while (superClasses.hasNext()) {
                    if (!this.extendsLibraryClass(superClasses.next(), visitedClasses)) continue;
                    return true;
                }
            }
            return false;
        }

        private void addOverriddenMethods(ClassRepr fromClass, Predicate<? super MethodRepr> predicate, Collection<? super Pair<MethodRepr, ClassRepr>> container, IntSet visitedClasses, ClassRepr visibilityScope) {
            if (visitedClasses == null) {
                visitedClasses = new IntOpenHashSet();
                visitedClasses.add(fromClass.name);
            }
            for (TypeRepr.ClassType superName : fromClass.getSuperTypes()) {
                if (!visitedClasses.add(superName.className) || superName.className == Mappings.this.myObjectClassName) continue;
                Collection superClasses = Iterators.collect(this.reprsByName(superName.className, ClassRepr.class), (Collection)new SmartList());
                if (!Iterators.isEmpty((Iterable)superClasses)) {
                    Iterable pairs = Iterators.flat((Iterable)Iterators.map((Iterable)superClasses, superClass -> Iterators.map(superClass.findMethods(mm -> predicate.test((MethodRepr)mm) && Mappings.isVisibleIn(superClass, mm, visibilityScope)), mm -> Pair.create((Object)mm, (Object)superClass))));
                    SmartHashSet found = new SmartHashSet();
                    for (Pair pair : pairs) {
                        container.add((Pair<MethodRepr, ClassRepr>)pair);
                        found.add((ClassRepr)pair.getSecond());
                    }
                    for (ClassRepr superClass2 : Iterators.filter((Iterable)superClasses, arg_0 -> Util.lambda$addOverriddenMethods$11((Set)found, arg_0))) {
                        this.addOverriddenMethods(superClass2, predicate, container, visitedClasses, visibilityScope);
                    }
                    continue;
                }
                container.add((Pair<MethodRepr, ClassRepr>)Pair.create((Object)MOCK_METHOD, (Object)MOCK_CLASS));
            }
        }

        void addOverriddenFields(FieldRepr f, ClassRepr fromClass, Collection<? super Pair<FieldRepr, ClassRepr>> container, IntSet visitedClasses, ClassRepr visibilityScope) {
            if (visitedClasses == null) {
                visitedClasses = new IntOpenHashSet();
                visitedClasses.add(fromClass.name);
            }
            for (TypeRepr.ClassType supername : fromClass.getSuperTypes()) {
                if (!visitedClasses.add(supername.className) || supername.className == Mappings.this.myObjectClassName) continue;
                for (ClassRepr superClass : this.reprsByName(supername.className, ClassRepr.class)) {
                    FieldRepr ff = superClass.findField(f.name);
                    if (ff != null && Mappings.isVisibleIn(superClass, ff, visibilityScope)) {
                        container.add((Pair<FieldRepr, ClassRepr>)Pair.create((Object)ff, (Object)superClass));
                        continue;
                    }
                    this.addOverriddenFields(f, superClass, container, visitedClasses, visibilityScope);
                }
            }
        }

        boolean hasOverriddenFields(FieldRepr f, ClassRepr fromClass, IntSet visitedClasses, ClassRepr visibilityScope) {
            if (visitedClasses == null) {
                visitedClasses = new IntOpenHashSet();
                visitedClasses.add(fromClass.name);
            }
            for (TypeRepr.ClassType supername : fromClass.getSuperTypes()) {
                if (!visitedClasses.add(supername.className) || supername.className == Mappings.this.myObjectClassName) continue;
                for (ClassRepr superClass : this.reprsByName(supername.className, ClassRepr.class)) {
                    FieldRepr ff = superClass.findField(f.name);
                    if (ff != null && Mappings.isVisibleIn(superClass, ff, visibilityScope)) {
                        return true;
                    }
                    if (!this.hasOverriddenFields(f, superClass, visitedClasses, visibilityScope)) continue;
                    return true;
                }
            }
            return false;
        }

        boolean isLambdaTarget(int name) {
            for (ClassRepr cls : this.reprsByName(name, ClassRepr.class)) {
                if (!cls.isInterface()) continue;
                int amFound = 0;
                for (MethodRepr method : this.allMethodsRecursively(cls)) {
                    if (method.isAbstract() && ++amFound > 1) break;
                }
                if (amFound != true) continue;
                return true;
            }
            return false;
        }

        private Iterable<MethodRepr> allMethodsRecursively(ClassRepr cls) {
            return Iterators.flat(this.collectRecursively(cls, c -> c.getMethods()));
        }

        private Iterable<OverloadDescriptor> findAllOverloads(ClassRepr cls, Function<? super MethodRepr, Integer> correspondenceFinder) {
            Function<ClassRepr, Iterable> converter = c -> Iterators.filter((Iterable)Iterators.map(c.getMethods(), m -> {
                Integer accessScope = (Integer)correspondenceFinder.apply((MethodRepr)m);
                return accessScope != null ? new OverloadDescriptor(accessScope, (MethodRepr)m, (ClassRepr)c) : null;
            }), Objects::nonNull);
            return Iterators.flat((Iterable)Iterators.flat(this.collectRecursively(cls, converter), (Iterable)Iterators.map((Iterable)Iterators.flat((Iterable)Iterators.map((Iterable)Mappings.this.getAllSubclasses(cls.name), subName -> subName != cls.name ? this.reprsByName((int)subName, (Class)ClassRepr.class) : Collections.emptyList())), converter)));
        }

        private <T> Iterable<T> collectRecursively(ClassRepr cls, Function<? super ClassRepr, ? extends T> mapper) {
            return Iterators.flat((Iterable)Iterators.asIterable(mapper.apply(cls)), (Iterable)Iterators.flat((Iterable)Iterators.map(cls.getSuperTypes(), st -> Iterators.flat((Iterable)Iterators.map(this.reprsByName(st.className, ClassRepr.class), cr -> this.collectRecursively((ClassRepr)cr, mapper))))));
        }

        @NotNull
        <T extends ClassFileRepr> Iterable<T> reprsByName(int name, Class<T> selector) {
            Iterable<T> r;
            if (this.myMappings != null && !Iterators.isEmpty(r = this.myMappings.getReprsByName(name, selector))) {
                Iterable<T> iterable = r;
                if (iterable == null) {
                    Util.$$$reportNull$$$0(1);
                }
                return iterable;
            }
            Iterable<T> iterable = Mappings.this.getReprsByName(name, selector);
            if (iterable == null) {
                Util.$$$reportNull$$$0(2);
            }
            return iterable;
        }

        @Nullable
        private Boolean isInheritorOf(int who, int whom, IntSet visitedClasses) {
            if (who == whom) {
                return Boolean.TRUE;
            }
            for (ClassRepr repr : this.reprsByName(who, ClassRepr.class)) {
                if (visitedClasses == null) {
                    visitedClasses = new IntOpenHashSet();
                    visitedClasses.add(who);
                }
                for (TypeRepr.ClassType s : repr.getSuperTypes()) {
                    if (!visitedClasses.add(s.className) || !Boolean.TRUE.equals(this.isInheritorOf(s.className, whom, visitedClasses))) continue;
                    return Boolean.TRUE;
                }
            }
            return null;
        }

        @Nullable
        Boolean isSubtypeOf(TypeRepr.AbstractType who, TypeRepr.AbstractType whom) {
            if (who.equals(whom)) {
                return Boolean.TRUE;
            }
            if (who instanceof TypeRepr.PrimitiveType || whom instanceof TypeRepr.PrimitiveType) {
                return Boolean.FALSE;
            }
            if (who instanceof TypeRepr.ArrayType) {
                if (whom instanceof TypeRepr.ArrayType) {
                    return this.isSubtypeOf(((TypeRepr.ArrayType)who).elementType, ((TypeRepr.ArrayType)whom).elementType);
                }
                String descr = whom.getDescr(Mappings.this.myContext);
                if (descr.equals("Ljava/lang/Cloneable") || descr.equals("Ljava/lang/Object") || descr.equals("Ljava/io/Serializable")) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (whom instanceof TypeRepr.ClassType) {
                return this.isInheritorOf(((TypeRepr.ClassType)who).className, ((TypeRepr.ClassType)whom).className, null);
            }
            return Boolean.FALSE;
        }

        boolean isMethodVisible(ClassRepr classRepr, MethodRepr m) {
            return !classRepr.findMethods(MethodRepr.equalByJavaRules(m)).isEmpty() || this.hasOverriddenMethods(classRepr, MethodRepr.equalByJavaRules(m), null, classRepr);
        }

        boolean isFieldVisible(int className, FieldRepr field) {
            Iterator<ClassRepr> reprs = this.reprsByName(className, ClassRepr.class).iterator();
            if (!reprs.hasNext()) {
                return true;
            }
            while (reprs.hasNext()) {
                ClassRepr r = reprs.next();
                if (r.getFields().contains(field)) {
                    return true;
                }
                if (!this.hasOverriddenFields(field, r, null, r)) continue;
                return true;
            }
            return false;
        }

        void collectSupersRecursively(int className, @NotNull IntSet container) {
            if (container == null) {
                Util.$$$reportNull$$$0(3);
            }
            for (ClassRepr classRepr : this.reprsByName(className, ClassRepr.class)) {
                Iterable<TypeRepr.ClassType> supers = classRepr.getSuperTypes();
                boolean added = false;
                for (TypeRepr.ClassType aSuper : supers) {
                    added |= container.add(aSuper.className);
                }
                if (!added) continue;
                for (TypeRepr.ClassType aSuper : supers) {
                    this.collectSupersRecursively(aSuper.className, container);
                }
            }
        }

        void affectSubclasses(int className, Collection<? super File> affectedFiles, Collection<? super UsageRepr.Usage> affectedUsages, IntSet dependants, boolean usages, Collection<? extends File> alreadyCompiledFiles, IntSet visitedClasses) {
            Mappings.this.debug("Affecting subclasses of class: ", className);
            Iterable<File> allSources = Mappings.this.classToSourceFileGet(className);
            if (allSources == null || Iterators.isEmpty(allSources)) {
                Mappings.this.debug("No source file detected for class ", className);
                Mappings.debug("End of affectSubclasses");
                return;
            }
            for (File fName : allSources) {
                Mappings.this.debug("Source file name: ", fName);
                if (alreadyCompiledFiles.contains(fName)) continue;
                affectedFiles.add(fName);
            }
            if (usages) {
                Mappings.debug("Class usages affection requested");
                Iterator<Object> iterator = this.reprsByName(className, ClassRepr.class).iterator();
                if (iterator.hasNext()) {
                    ClassRepr classRepr = (ClassRepr)iterator.next();
                    Mappings.this.debug("Added class usage for ", classRepr.name);
                    affectedUsages.add(classRepr.createUsage());
                }
            }
            this.appendDependents(className, dependants);
            IntSet directSubclasses = Mappings.this.myClassToSubclasses.get(className);
            if (directSubclasses != null) {
                if (visitedClasses == null) {
                    visitedClasses = new IntOpenHashSet();
                    visitedClasses.add(className);
                }
                IntSet _visitedClasses = visitedClasses;
                directSubclasses.forEach(subClass -> {
                    if (_visitedClasses.add(subClass)) {
                        this.affectSubclasses(subClass, affectedFiles, affectedUsages, dependants, usages, alreadyCompiledFiles, _visitedClasses);
                    }
                });
            }
        }

        void affectFieldUsages(FieldRepr field, IntSet classes, UsageRepr.Usage rootUsage, Set<? super UsageRepr.Usage> affectedUsages, IntSet dependents) {
            affectedUsages.add(rootUsage);
            classes.forEach(p -> {
                this.appendDependents(p, dependents);
                Mappings.this.debug("Affect field usage referenced of class ", p);
                affectedUsages.add(rootUsage instanceof UsageRepr.FieldAssignUsage ? field.createAssignUsage(Mappings.this.myContext, p) : field.createUsage(Mappings.this.myContext, p));
            });
        }

        void affectStaticMemberImportUsages(int memberName, int ownerName, IntSet classes, Set<? super UsageRepr.Usage> affectedUsages, IntSet dependents) {
            Mappings.this.debug("Affect static member import usage referenced of class ", ownerName);
            affectedUsages.add(UsageRepr.createImportStaticMemberUsage(Mappings.this.myContext, memberName, ownerName));
            classes.forEach(cls -> {
                this.appendDependents(cls, dependents);
                Mappings.this.debug("Affect static member import usage referenced of class ", cls);
                affectedUsages.add(UsageRepr.createImportStaticMemberUsage(Mappings.this.myContext, memberName, cls));
            });
        }

        void affectStaticMemberOnDemandUsages(int ownerClass, IntSet classes, Set<? super UsageRepr.Usage> affectedUsages, IntSet dependents) {
            Mappings.this.debug("Affect static member on-demand import usage referenced of class ", ownerClass);
            affectedUsages.add(UsageRepr.createImportStaticOnDemandUsage(Mappings.this.myContext, ownerClass));
            classes.forEach(cls -> {
                this.appendDependents(cls, dependents);
                Mappings.this.debug("Affect static member on-demand import usage referenced of class ", cls);
                affectedUsages.add(UsageRepr.createImportStaticOnDemandUsage(Mappings.this.myContext, cls));
            });
        }

        void affectMethodUsagesThrowing(ClassRepr aClass, TypeRepr.ClassType exceptionClass, Set<? super UsageRepr.Usage> affectedUsages, IntSet dependents) {
            boolean shouldAffect = false;
            for (MethodRepr method : aClass.getMethods()) {
                if (!method.myExceptions.contains(exceptionClass)) continue;
                shouldAffect = true;
                affectedUsages.add(method.createUsage(Mappings.this.myContext, aClass.name));
            }
            if (shouldAffect) {
                if (Mappings.this.myDebugS.isDebugEnabled()) {
                    Mappings.this.debug("Affecting usages of methods throwing " + Mappings.this.myContext.getValue(exceptionClass.className) + " exception; class ", aClass.name);
                }
                this.appendDependents(aClass, dependents);
            }
        }

        void affectMethodUsages(MethodRepr method, IntSet subclasses, UsageRepr.Usage rootUsage, Set<? super UsageRepr.Usage> affectedUsages, IntSet dependents) {
            affectedUsages.add(rootUsage);
            if (subclasses != null) {
                subclasses.forEach(p -> {
                    this.appendDependents(p, dependents);
                    Mappings.this.debug("Affect method usage referenced of class ", p);
                    UsageRepr.Usage usage = rootUsage instanceof UsageRepr.MetaMethodUsage ? method.createMetaUsage(Mappings.this.myContext, p) : method.createUsage(Mappings.this.myContext, p);
                    affectedUsages.add(usage);
                });
            }
        }

        void affectModule(ModuleRepr m, Collection<? super File> affectedFiles) {
            Iterable<File> depFiles;
            Iterable<File> iterable = depFiles = this.myMappings != null ? this.myMappings.classToSourceFileGet(m.name) : null;
            if (depFiles == null) {
                depFiles = Mappings.this.classToSourceFileGet(m.name);
            }
            if (depFiles != null) {
                Mappings.this.debug("Affecting module ", m.name);
                ContainerUtil.addAll(affectedFiles, depFiles);
            }
        }

        void affectDependentModules(final Differential.DiffState state, int moduleName, final @Nullable UsageConstraint constraint, final boolean checkTransitive) {
            new Object(){
                final IntSet visited = new IntOpenHashSet();

                void perform(int modName) {
                    IntSet depNames = Mappings.this.myClassToClassDependency.get(modName);
                    if (depNames != null && !depNames.isEmpty()) {
                        IntOpenHashSet next = new IntOpenHashSet();
                        UsageRepr.Usage moduleUsage = UsageRepr.createModuleUsage(Mappings.this.myContext, modName);
                        state.myAffectedUsages.add(moduleUsage);
                        UsageConstraint prevConstraint = state.myUsageConstraints.put(moduleUsage, constraint == null ? UsageConstraint.ANY : constraint);
                        if (prevConstraint != null) {
                            state.myUsageConstraints.put(moduleUsage, prevConstraint.or(constraint));
                        }
                        depNames.forEach(arg_0 -> this.lambda$perform$0(state, checkTransitive, modName, (IntSet)next, arg_0));
                        next.forEach(this::perform);
                    }
                }

                private /* synthetic */ void lambda$perform$0(Differential.DiffState state2, boolean checkTransitive2, int modName, IntSet next, int depName) {
                    if (this.visited.add(depName)) {
                        for (ModuleRepr depRepr : Util.this.reprsByName(depName, ModuleRepr.class)) {
                            state2.myDependants.add(depName);
                            if (!checkTransitive2 || !depRepr.requiresTransitevely(modName)) continue;
                            next.add(depName);
                            break;
                        }
                    }
                }
            }.perform(moduleName);
        }

        void affectLambdaInstantiations(Differential.DiffState state, int className) {
            Mappings.this.getAllSubclasses(className).forEach(name -> {
                if (this.isLambdaTarget(name)) {
                    Mappings.this.debug("The interface could be not a SAM interface anymore or lambda target method name has changed => affecting lambda instantiations for ", name);
                    if (state.myAffectedUsages.add(UsageRepr.createClassNewUsage(Mappings.this.myContext, name))) {
                        this.appendDependents(name, state.myDependants);
                    }
                }
            });
        }

        private static /* synthetic */ boolean lambda$addOverriddenMethods$11(Set found, ClassRepr superClass) {
            return !found.contains(superClass);
        }

        private static /* synthetic */ boolean lambda$addOverridingMethods$6(Set found, ClassRepr r) {
            return !found.contains(r);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mappings";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/jps/builders/java/dependencyView/Mappings$Util";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "container";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/jps/builders/java/dependencyView/Mappings$Util";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "reprsByName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "collectSupersRecursively";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        public final class InheritanceConstraint
        extends PackageConstraint {
            public final int rootClass;

            public InheritanceConstraint(ClassRepr rootClass) {
                super(rootClass.getPackageName());
                this.rootClass = rootClass.name;
            }

            @Override
            public boolean checkResidence(int residence) {
                Boolean inheritorOf = Util.this.isInheritorOf(residence, this.rootClass, null);
                return (inheritorOf == null || inheritorOf == false) && super.checkResidence(residence);
            }
        }

        public class PackageConstraint
        implements UsageConstraint {
            public final String packageName;

            public PackageConstraint(String packageName) {
                this.packageName = packageName;
            }

            @Override
            public boolean checkResidence(int residence) {
                String className = Mappings.this.myContext.getValue(residence);
                return className == null || !ClassRepr.getPackageName(className).equals(this.packageName);
            }
        }

        public final class FileFilterConstraint
        implements UsageConstraint {
            @NotNull
            private final DependentFilesFilter myFilter;

            public FileFilterConstraint(DependentFilesFilter filter) {
                if (filter == null) {
                    FileFilterConstraint.$$$reportNull$$$0(0);
                }
                this.myFilter = filter;
            }

            @Override
            public boolean checkResidence(int residence) {
                Iterable<File> fNames = Mappings.this.classToSourceFileGet(residence);
                if (fNames == null || Iterators.isEmpty(fNames)) {
                    return true;
                }
                for (File fName : fNames) {
                    if (!this.myFilter.accept(fName)) continue;
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "org/jetbrains/jps/builders/java/dependencyView/Mappings$Util$FileFilterConstraint", "<init>"));
            }
        }
    }

    private final class Differential {
        private static final int INLINABLE_FIELD_MODIFIERS_MASK = 16;
        final Mappings myDelta;
        final Collection<? extends File> myFilesToCompile;
        final Collection<? extends File> myCompiledFiles;
        final Collection<? extends File> myCompiledWithErrors;
        final Collection<? super File> myAffectedFiles;
        @Nullable
        final DependentFilesFilter myFilter;
        final Util myFuture;
        final Util myPresent;
        final boolean myEasyMode;
        private final Iterable<AnnotationsChangeTracker> myAnnotationChangeTracker;

        private Differential(Mappings delta) {
            this.myAnnotationChangeTracker = JpsServiceManager.getInstance().getExtensions(AnnotationsChangeTracker.class);
            this.myDelta = delta;
            this.myFilesToCompile = null;
            this.myCompiledFiles = null;
            this.myCompiledWithErrors = null;
            this.myAffectedFiles = null;
            this.myFilter = null;
            this.myFuture = null;
            this.myPresent = null;
            this.myEasyMode = true;
            delta.myIsRebuild = true;
        }

        private Differential(Mappings delta, Collection<String> removed, Collection<? extends File> filesToCompile) {
            this.myAnnotationChangeTracker = JpsServiceManager.getInstance().getExtensions(AnnotationsChangeTracker.class);
            delta.myRemovedFiles = removed;
            this.myDelta = delta;
            this.myFilesToCompile = filesToCompile;
            this.myCompiledFiles = null;
            this.myCompiledWithErrors = null;
            this.myAffectedFiles = null;
            this.myFilter = null;
            this.myFuture = new Util(delta);
            this.myPresent = new Util();
            this.myEasyMode = true;
        }

        private Differential(Mappings delta, Collection<String> removed, Collection<? extends File> filesToCompile, Collection<? extends File> compiledWithErrors, Collection<? extends File> compiledFiles, @NotNull Collection<? super File> affectedFiles, DependentFilesFilter filter) {
            if (filter == null) {
                Differential.$$$reportNull$$$0(0);
            }
            this.myAnnotationChangeTracker = JpsServiceManager.getInstance().getExtensions(AnnotationsChangeTracker.class);
            delta.myRemovedFiles = removed;
            this.myDelta = delta;
            this.myFilesToCompile = filesToCompile;
            this.myCompiledFiles = compiledFiles;
            this.myCompiledWithErrors = compiledWithErrors;
            this.myAffectedFiles = affectedFiles;
            this.myFilter = filter;
            this.myFuture = new Util(delta);
            this.myPresent = new Util();
            this.myEasyMode = false;
        }

        private void processDisappearedClasses() {
            Collection<String> removed;
            if (this.myFilesToCompile != null) {
                this.myDelta.compensateRemovedContent(this.myFilesToCompile, this.myCompiledWithErrors != null ? this.myCompiledWithErrors : Collections.emptySet());
            }
            if (!this.myEasyMode && (removed = this.myDelta.myRemovedFiles) != null) {
                for (String file : removed) {
                    File sourceFile = new File(file);
                    Collection<ClassFileRepr> classes = Mappings.this.sourceFileToClassesGet(sourceFile);
                    if (classes == null) continue;
                    for (ClassFileRepr c : classes) {
                        Mappings.this.debug("Affecting usages of removed class ", c.name);
                        Mappings.this.affectAll(c.name, sourceFile, this.myAffectedFiles, this.myCompiledFiles, this.myFilter);
                    }
                }
            }
        }

        private void processAddedMethods(DiffState state, ClassRepr.Diff diff, ClassRepr it) {
            Collection<MethodRepr> added = diff.methods().added();
            if (added.isEmpty()) {
                return;
            }
            Mappings.debug("Processing added methods: ");
            if (it.isAnnotation()) {
                Mappings.debug("Class is annotation, skipping method analysis");
                return;
            }
            assert (this.myFuture != null);
            assert (this.myPresent != null);
            assert (this.myAffectedFiles != null);
            for (MethodRepr m : added) {
                if (m.isPrivate() || !it.isInterface() && !it.isAbstract() && !m.isAbstract()) continue;
                Mappings.this.debug("Method: ", m.name);
                Mappings.debug("Class is abstract, or is interface, or added non-private method is abstract => affecting all subclasses");
                this.myFuture.affectSubclasses(it.name, this.myAffectedFiles, state.myAffectedUsages, state.myDependants, false, this.myCompiledFiles, null);
                break;
            }
            if (it.isInterface()) {
                for (MethodRepr m : added) {
                    if (m.isPrivate() || !m.isAbstract()) continue;
                    Mappings.this.debug("Added non-private abstract method: ", m.name);
                    this.myPresent.affectLambdaInstantiations(state, it.name);
                    break;
                }
            }
            for (MethodRepr addedMethod : added) {
                Mappings.this.debug("Method: ", addedMethod.name);
                Supplier<IntSet> propagated = Mappings.lazy(() -> this.myFuture.propagateMethodAccess(addedMethod, it.name));
                if (!addedMethod.isPrivate() && addedMethod.myArgumentTypes.length > 0 && !this.myPresent.hasOverriddenMethods(it, MethodRepr.equalByJavaRules(addedMethod), null, it)) {
                    Mappings.debug("Conservative case on overriding methods, affecting method usages");
                    this.myFuture.affectMethodUsages(addedMethod, addedMethod.name == Mappings.this.myInitName ? null : propagated.get(), addedMethod.createMetaUsage(Mappings.this.myContext, it.name), state.myAffectedUsages, state.myDependants);
                }
                if (addedMethod.isPrivate()) continue;
                if (addedMethod.isStatic()) {
                    this.myFuture.affectStaticMemberOnDemandUsages(it.name, propagated.get(), state.myAffectedUsages, state.myDependants);
                }
                Predicate<MethodRepr> lessSpecificCond = this.myFuture.lessSpecific(addedMethod);
                Collection<MethodRepr> removed = diff.methods().removed();
                for (MethodRepr methodRepr : it.findMethods(lessSpecificCond)) {
                    if (methodRepr.equals(addedMethod) || removed.contains(methodRepr)) continue;
                    Mappings.debug("Found less specific method, affecting method usages");
                    this.myFuture.affectMethodUsages(methodRepr, propagated.get(), methodRepr.createUsage(Mappings.this.myContext, it.name), state.myAffectedUsages, state.myDependants);
                }
                Mappings.debug("Processing overridden by specificity methods");
                HashSet overridden = new HashSet();
                this.myFuture.addOverriddenMethods(it, lessSpecificCond, overridden, null, it);
                for (Pair pair : overridden) {
                    MethodRepr method = (MethodRepr)pair.first;
                    ClassRepr methodClass = (ClassRepr)pair.second;
                    if (methodClass == MOCK_CLASS) continue;
                    Mappings.this.debug("Method: ", method.name);
                    Mappings.this.debug("Class : ", methodClass.name);
                    Mappings.debug("Affecting method usages for that found");
                    this.myFuture.affectMethodUsages(method, this.myPresent.propagateMethodAccess(method, it.name), method.createUsage(Mappings.this.myContext, it.name), state.myAffectedUsages, state.myDependants);
                }
                Mappings.debug("Processing overriding by specificity methods");
                Predicate<MethodRepr> predicate = MethodRepr.equalByJavaRules(addedMethod);
                HashSet overriding = new HashSet();
                this.myFuture.addOverridingMethods(addedMethod, it, it, lessSpecificCond, overriding, null);
                for (Pair pair : overriding) {
                    MethodRepr method = (MethodRepr)pair.first;
                    ClassRepr methodClass = (ClassRepr)pair.second;
                    Mappings.this.debug("Method: ", method.name);
                    Mappings.this.debug("Class : ", methodClass.name);
                    if (predicate.test(method)) {
                        Mappings.debug("Current method overrides the added method");
                        Iterable<File> files = Mappings.this.classToSourceFileGet(methodClass.name);
                        if (files == null || Mappings.containsAll(this.myFilesToCompile, files)) continue;
                        ContainerUtil.addAll(this.myAffectedFiles, files);
                        if (!Mappings.this.myDebugS.isDebugEnabled()) continue;
                        for (File file : files) {
                            Mappings.this.debug("Affecting file ", file);
                        }
                        continue;
                    }
                    Mappings.debug("Current method does not override the added method");
                    Mappings.debug("Affecting method usages for the method");
                    this.myPresent.appendDependents(methodClass, state.myDependants);
                    this.myFuture.affectMethodUsages(method, this.myPresent.propagateMethodAccess(method, methodClass.name), method.createUsage(Mappings.this.myContext, methodClass.name), state.myAffectedUsages, state.myDependants);
                }
                Mappings.this.getAllSubclasses(it.name).forEach(subClass -> {
                    Collection reprs = Iterators.collect(this.myFuture.reprsByName(subClass, ClassRepr.class), (Collection)new SmartList());
                    if (Iterators.isEmpty((Iterable)reprs)) {
                        return;
                    }
                    Iterable<File> sourceFileNames = Mappings.this.classToSourceFileGet(subClass);
                    if (sourceFileNames != null && !Mappings.containsAll(this.myCompiledFiles, sourceFileNames)) {
                        for (ClassRepr outerClassRepr : Iterators.flat((Iterable)Iterators.map((Iterable)reprs, r -> Mappings.this.isEmpty(r.getOuterClassName()) ? Collections.emptyList() : this.myFuture.reprsByName(r.getOuterClassName(), ClassRepr.class)))) {
                            if (!this.myFuture.isMethodVisible(outerClassRepr, addedMethod) && !this.myFuture.extendsLibraryClass(outerClassRepr, null)) continue;
                            ContainerUtil.addAll(this.myAffectedFiles, sourceFileNames);
                            for (File sourceFileName : sourceFileNames) {
                                Mappings.this.debug("Affecting file due to local overriding: ", sourceFileName);
                            }
                        }
                    }
                });
            }
            Mappings.debug("End of added methods processing");
        }

        private void processRemovedMethods(DiffState state, ClassRepr.Diff diff, ClassRepr it) {
            Collection<MethodRepr> removed = diff.methods().removed();
            if (removed.isEmpty()) {
                return;
            }
            assert (this.myFuture != null);
            assert (this.myPresent != null);
            assert (this.myAffectedFiles != null);
            assert (this.myCompiledFiles != null);
            Mappings.debug("Processing removed methods:");
            for (MethodRepr removedMethod : removed) {
                Mappings.this.debug("Method ", removedMethod.name);
                Collection<Pair<MethodRepr, ClassRepr>> overriddenMethods = this.myFuture.findOverriddenMethods(removedMethod, it);
                Supplier<IntSet> propagated = Mappings.lazy(() -> this.myFuture.propagateMethodAccess(removedMethod, it.name));
                if (!removedMethod.isPrivate() && removedMethod.isStatic()) {
                    Mappings.debug("The method was static --- affecting static method import usages");
                    this.myFuture.affectStaticMemberImportUsages(removedMethod.name, it.name, propagated.get(), state.myAffectedUsages, state.myDependants);
                }
                if (removedMethod.isPackageLocal()) {
                    Mappings.debug("Removed method is package-local, affecting method usages");
                    this.myFuture.affectMethodUsages(removedMethod, propagated.get(), removedMethod.createUsage(Mappings.this.myContext, it.name), state.myAffectedUsages, state.myDependants);
                } else if (overriddenMethods.isEmpty()) {
                    Mappings.debug("No overridden methods found, affecting method usages");
                    this.myFuture.affectMethodUsages(removedMethod, propagated.get(), removedMethod.createUsage(Mappings.this.myContext, it.name), state.myAffectedUsages, state.myDependants);
                } else {
                    boolean clearlyOverridden;
                    boolean bl = clearlyOverridden = Mappings.this.isEmpty(removedMethod.signature) && Iterators.isEmpty((Iterable)Iterators.filter(overriddenMethods, p -> p.first == MOCK_METHOD || !((MethodRepr)p.first).myType.equals(removedMethod.myType) || !Mappings.this.isEmpty(((MethodRepr)p.first).signature) || removedMethod.isMoreAccessibleThan((Proto)p.first)));
                    if (!clearlyOverridden) {
                        Mappings.debug("No clearly overridden methods found, affecting method usages");
                        this.myFuture.affectMethodUsages(removedMethod, propagated.get(), removedMethod.createUsage(Mappings.this.myContext, it.name), state.myAffectedUsages, state.myDependants);
                    }
                }
                HashSet overridingMethods = new HashSet();
                this.myFuture.addOverridingMethods(removedMethod, it, it, MethodRepr.equalByJavaRules(removedMethod), overridingMethods, null);
                for (Pair p2 : overridingMethods) {
                    Iterable<File> fNames = Mappings.this.classToSourceFileGet(((ClassRepr)p2.second).name);
                    if (fNames == null || Mappings.containsAll(this.myFilesToCompile, fNames)) continue;
                    ContainerUtil.addAll(this.myAffectedFiles, fNames);
                    if (!Mappings.this.myDebugS.isDebugEnabled()) continue;
                    for (File fName : fNames) {
                        Mappings.this.debug("Affecting file by overriding: ", fName);
                    }
                }
                if (removedMethod.isAbstract() || removedMethod.isStatic()) continue;
                propagated.get().forEach(p -> {
                    if (p != it.name) {
                        for (ClassRepr subClass : this.myFuture.reprsByName(p, ClassRepr.class)) {
                            Collection<Pair<MethodRepr, ClassRepr>> overriddenInSubclass = this.myFuture.findOverriddenMethods(removedMethod, subClass);
                            overriddenInSubclass.addAll(overriddenMethods);
                            boolean allAbstract = true;
                            boolean visited = false;
                            for (Pair<MethodRepr, ClassRepr> pp : overriddenInSubclass) {
                                ClassRepr cc = (ClassRepr)pp.second;
                                if (cc == MOCK_CLASS) {
                                    visited = true;
                                    continue;
                                }
                                if (!((MethodRepr)pp.first).isAbstract() && !((MethodRepr)pp.first).equals(removedMethod)) continue;
                                visited = true;
                                allAbstract = ((MethodRepr)pp.first).isAbstract() || cc.isInterface();
                                if (allAbstract) continue;
                                break;
                            }
                            if (!allAbstract || !visited) continue;
                            Iterable<File> sources = Mappings.this.classToSourceFileGet(p);
                            if (sources == null || Mappings.containsAll(this.myFilesToCompile, sources)) break;
                            ContainerUtil.addAll(this.myAffectedFiles, sources);
                            Mappings.this.debug("Removed method is not abstract & overrides some abstract method which is not then over-overridden in subclass ", p);
                            for (File source : sources) {
                                Mappings.this.debug("Affecting subclass source file ", source);
                            }
                        }
                    }
                });
            }
            Mappings.debug("End of removed methods processing");
        }

        private void processChangedMethods(DiffState state, ClassRepr.Diff diff, ClassRepr it) {
            Collection<Pair<MethodRepr, MethodRepr.Diff>> changed = diff.methods().changed();
            if (changed.isEmpty()) {
                return;
            }
            Mappings.debug("Processing changed methods:");
            assert (this.myPresent != null);
            assert (this.myFuture != null);
            assert (this.myAffectedFiles != null);
            if (it.isInterface()) {
                for (Pair<MethodRepr, MethodRepr.Diff> pair : changed) {
                    if ((((MethodRepr.Diff)pair.second).removedModifiers() & 0x400) == 0) continue;
                    Mappings.this.debug("Method became non-abstract: ", ((MethodRepr)pair.first).name);
                    this.myPresent.affectLambdaInstantiations(state, it.name);
                    break;
                }
            }
            ArrayList<Pair<MethodRepr, MethodRepr.Diff>> moreAccessible = new ArrayList<Pair<MethodRepr, MethodRepr.Diff>>();
            for (Pair<MethodRepr, MethodRepr.Diff> mr3 : changed) {
                MethodRepr m = (MethodRepr)mr3.first;
                MethodRepr.Diff d = (MethodRepr.Diff)mr3.second;
                boolean throwsChanged = !d.exceptions().unchanged();
                Mappings.this.debug("Method: ", m.name);
                if (d.accessExpanded()) {
                    moreAccessible.add(mr3);
                }
                if (it.isAnnotation()) {
                    if (!d.defaultRemoved()) continue;
                    Mappings.debug("Class is annotation, default value is removed => adding annotation query");
                    IntOpenHashSet l = new IntOpenHashSet(32, 0.98f);
                    l.add(m.name);
                    UsageRepr.AnnotationUsage annotationUsage = (UsageRepr.AnnotationUsage)UsageRepr.createAnnotationUsage(Mappings.this.myContext, TypeRepr.createClassType(Mappings.this.myContext, it.name), (IntSet)l, null);
                    state.myAnnotationQuery.add(annotationUsage);
                    continue;
                }
                if (d.base() == 0 && !throwsChanged) continue;
                Supplier<IntSet> propagated = Mappings.lazy(() -> this.myFuture.propagateMethodAccess(m, it.name));
                boolean affected = false;
                boolean constrained = false;
                HashSet<UsageRepr.Usage> usages = new HashSet<UsageRepr.Usage>();
                if (d.packageLocalOn()) {
                    Mappings.debug("Method became package-private, affecting method usages outside the package");
                    this.myFuture.affectMethodUsages(m, propagated.get(), m.createUsage(Mappings.this.myContext, it.name), usages, state.myDependants);
                    for (UsageRepr.Usage usage : usages) {
                        Map<UsageRepr.Usage, UsageConstraint> map = state.myUsageConstraints;
                        Util util = this.myFuture;
                        Objects.requireNonNull(util);
                        map.put(usage, util.new Util.PackageConstraint(it.getPackageName()));
                    }
                    state.myAffectedUsages.addAll(usages);
                    affected = true;
                    constrained = true;
                }
                if ((d.base() & 2) != 0 || (d.base() & 8) != 0 || throwsChanged) {
                    if (!affected) {
                        Mappings.debug("Return type, throws list or signature changed --- affecting method usages");
                        this.myFuture.affectMethodUsages(m, propagated.get(), m.createUsage(Mappings.this.myContext, it.name), usages, state.myDependants);
                        LinkedList overridingMethods = new LinkedList();
                        this.myFuture.addOverridingMethods(m, it, it, MethodRepr.equalByJavaRules(m), overridingMethods, null);
                        Iterator iterator = overridingMethods.iterator();
                        while (iterator.hasNext()) {
                            Iterable<File> fileNames;
                            Pair p = (Pair)iterator.next();
                            ClassRepr aClass = (ClassRepr)p.getSecond();
                            if (aClass == MOCK_CLASS || (fileNames = Mappings.this.classToSourceFileGet(aClass.name)) == null) continue;
                            ContainerUtil.addAll(this.myAffectedFiles, fileNames);
                        }
                        state.myAffectedUsages.addAll(usages);
                        affected = true;
                    }
                } else if ((d.base() & 1) != 0) {
                    if ((d.addedModifiers() & 0x104A) != 0 || (d.removedModifiers() & 8) != 0) {
                        if (!affected) {
                            Mappings.debug("Added {static | private | synthetic | bridge} specifier or removed static specifier --- affecting method usages");
                            this.myFuture.affectMethodUsages(m, propagated.get(), m.createUsage(Mappings.this.myContext, it.name), usages, state.myDependants);
                            state.myAffectedUsages.addAll(usages);
                            affected = true;
                        }
                        if ((d.addedModifiers() & 8) != 0) {
                            Mappings.debug("Added static specifier --- affecting subclasses");
                            this.myFuture.affectSubclasses(it.name, this.myAffectedFiles, state.myAffectedUsages, state.myDependants, false, this.myCompiledFiles, null);
                            if (!m.isPrivate()) {
                                Mappings.debug("Added static modifier --- affecting static member on-demand import usages");
                                this.myFuture.affectStaticMemberOnDemandUsages(it.name, propagated.get(), state.myAffectedUsages, state.myDependants);
                            }
                        } else if ((d.removedModifiers() & 8) != 0 && !m.isPrivate()) {
                            Mappings.debug("Removed static modifier --- affecting static method import usages");
                            this.myFuture.affectStaticMemberImportUsages(m.name, it.name, propagated.get(), state.myAffectedUsages, state.myDependants);
                        }
                    } else {
                        if ((d.addedModifiers() & 0x411) != 0) {
                            Mappings.debug("Added final, public or abstract specifier --- affecting subclasses");
                            this.myFuture.affectSubclasses(it.name, this.myAffectedFiles, state.myAffectedUsages, state.myDependants, false, this.myCompiledFiles, null);
                            if (it.isInterface() && (d.addedModifiers() & 0x400) != 0) {
                                this.myPresent.affectLambdaInstantiations(state, it.name);
                            }
                        }
                        if ((d.addedModifiers() & 4) != 0 && (d.removedModifiers() & 2) == 0) {
                            Mappings.debug("Added public or package-private method became protected --- affect method usages with protected constraint");
                            if (!affected) {
                                this.myFuture.affectMethodUsages(m, propagated.get(), m.createUsage(Mappings.this.myContext, it.name), usages, state.myDependants);
                                state.myAffectedUsages.addAll(usages);
                                affected = true;
                            }
                            for (UsageRepr.Usage usage : usages) {
                                Map<UsageRepr.Usage, UsageConstraint> map = state.myUsageConstraints;
                                Util util = this.myFuture;
                                Objects.requireNonNull(util);
                                map.put(usage, util.new Util.InheritanceConstraint(it));
                            }
                            constrained = true;
                        }
                    }
                }
                if ((d.base() & 0x40) == 0) continue;
                EnumSet<AnnotationsChangeTracker.Recompile> toRecompile = EnumSet.noneOf(AnnotationsChangeTracker.Recompile.class);
                for (Object extension : this.myAnnotationChangeTracker) {
                    if (toRecompile.containsAll(AnnotationsChangeTracker.RECOMPILE_ALL)) break;
                    Set<AnnotationsChangeTracker.Recompile> actions = ((AnnotationsChangeTracker)extension).methodAnnotationsChanged((NamingContext)Mappings.this.myContext, (ProtoMethodEntity)m, (Difference.Specifier<TypeRepr.ClassType, Difference>)d.annotations(), d.parameterAnnotations());
                    if (actions.contains((Object)AnnotationsChangeTracker.Recompile.USAGES)) {
                        Mappings.debug("Extension " + extension.getClass().getName() + " requested recompilation because of changes in annotations list --- affecting method usages");
                    }
                    if (actions.contains((Object)AnnotationsChangeTracker.Recompile.SUBCLASSES)) {
                        Mappings.debug("Extension " + extension.getClass().getName() + " requested recompilation because of changes in method annotations or method parameter annotations list --- affecting subclasses");
                    }
                    toRecompile.addAll(actions);
                }
                if (toRecompile.contains((Object)AnnotationsChangeTracker.Recompile.USAGES)) {
                    this.myFuture.affectMethodUsages(m, propagated.get(), m.createUsage(Mappings.this.myContext, it.name), usages, state.myDependants);
                    if (m.isAbstract()) {
                        Object extension;
                        HashSet hashSet = new HashSet();
                        this.myFuture.addOverridingMethods(m, it, it, MethodRepr.equalByJavaRules(m), hashSet, null);
                        extension = hashSet.iterator();
                        while (extension.hasNext()) {
                            Pair p = (Pair)extension.next();
                            usages.add(((MethodRepr)p.getFirst()).createUsage(Mappings.this.myContext, ((ClassRepr)p.getSecond()).name));
                            this.myFuture.appendDependents((ClassFileRepr)p.getSecond(), state.myDependants);
                        }
                    }
                    state.myAffectedUsages.addAll(usages);
                    if (constrained) {
                        for (UsageRepr.Usage usage3 : usages) {
                            state.myUsageConstraints.remove(usage3);
                        }
                    }
                }
                if (!toRecompile.contains((Object)AnnotationsChangeTracker.Recompile.SUBCLASSES)) continue;
                this.myFuture.affectSubclasses(it.name, this.myAffectedFiles, state.myAffectedUsages, state.myDependants, false, this.myCompiledFiles, null);
            }
            if (!moreAccessible.isEmpty()) {
                Iterable<OverloadDescriptor> iterable = this.myFuture.findAllOverloads(it, mr -> {
                    Integer result = null;
                    for (Pair pair : moreAccessible) {
                        MethodRepr m = (MethodRepr)pair.first;
                        MethodRepr.Diff d = (MethodRepr.Diff)pair.second;
                        if (mr.name != m.name || m.equals(mr)) continue;
                        int newAccess = m.access & ~d.removedModifiers() | d.addedModifiers();
                        if (result != null && !Difference.weakerAccess(result, newAccess)) continue;
                        result = newAccess;
                    }
                    return result;
                });
                for (OverloadDescriptor descr : iterable) {
                    UsageConstraint constr;
                    UsageConstraint usageConstraint;
                    Mappings.this.debug("Method became more accessible --- affect usages of overloading methods: ", descr.overloadMethod.name);
                    HashSet overloadsUsages = new HashSet();
                    this.myFuture.affectMethodUsages(descr.overloadMethod, this.myFuture.propagateMethodAccess(descr.overloadMethod, descr.overloadMethodOwner.name), descr.overloadMethod.createUsage(Mappings.this.myContext, descr.overloadMethodOwner.name), overloadsUsages, state.myDependants);
                    state.myAffectedUsages.addAll(overloadsUsages);
                    if (Difference.isPackageLocal(descr.accessScope)) {
                        Util util = this.myFuture;
                        Objects.requireNonNull(util);
                        usageConstraint = util.new Util.PackageConstraint(it.getPackageName()).negate();
                    } else if (Difference.isProtected(descr.accessScope)) {
                        Util util = this.myFuture;
                        Objects.requireNonNull(util);
                        usageConstraint = util.new Util.InheritanceConstraint(it).negate();
                    } else {
                        usageConstraint = null;
                    }
                    if ((constr = usageConstraint) == null) continue;
                    for (UsageRepr.Usage usage : overloadsUsages) {
                        state.myUsageConstraints.put(usage, constr);
                    }
                }
            }
            Mappings.debug("End of changed methods processing");
        }

        private boolean processAddedFields(DiffState state, ClassRepr.Diff diff, ClassRepr classRepr) {
            Collection<FieldRepr> added = diff.fields().added();
            if (added.isEmpty()) {
                return true;
            }
            Mappings.debug("Processing added fields");
            assert (this.myFuture != null);
            assert (this.myPresent != null);
            assert (this.myCompiledFiles != null);
            assert (this.myAffectedFiles != null);
            if (classRepr.isEnum()) {
                Mappings.this.debug("Constants added to enum, affecting class usages ", classRepr.name);
                UsageRepr.Usage usage = classRepr.createUsage();
                state.myAffectedUsages.add(usage);
                state.myUsageConstraints.put(usage, residence -> {
                    for (ClassRepr candidate : this.myPresent.reprsByName(residence, ClassRepr.class)) {
                        if (!candidate.isSynthetic()) continue;
                        return true;
                    }
                    return false;
                });
            }
            for (FieldRepr addedField : added) {
                Mappings.this.debug("Field: ", addedField.name);
                if (!addedField.isPrivate()) {
                    IntSet changedClassWithSubclasses = this.myFuture.propagateFieldAccess(addedField.name, classRepr.name);
                    changedClassWithSubclasses.add(classRepr.name);
                    changedClassWithSubclasses.forEach(subClass -> {
                        Iterable<File> sourceFileNames;
                        Collection reprs = Iterators.collect(this.myFuture.reprsByName(subClass, ClassRepr.class), (Collection)new SmartList());
                        if (!Iterators.isEmpty((Iterable)reprs) && (sourceFileNames = Mappings.this.classToSourceFileGet(subClass)) != null && !Mappings.containsAll(this.myCompiledFiles, sourceFileNames)) {
                            for (ClassRepr r : reprs) {
                                if (r.isLocal()) {
                                    for (File sourceFileName : sourceFileNames) {
                                        Mappings.this.debug("Affecting local subclass (introduced field can potentially hide surrounding method parameters/local variables): ", sourceFileName);
                                        this.myAffectedFiles.add(sourceFileName);
                                    }
                                } else {
                                    int outerClass = r.getOuterClassName();
                                    if (Mappings.this.isEmpty(outerClass) || !this.myFuture.isFieldVisible(outerClass, addedField)) continue;
                                    for (File sourceFileName : sourceFileNames) {
                                        Mappings.this.debug("Affecting inner subclass (introduced field can potentially hide surrounding class fields): ", sourceFileName);
                                        this.myAffectedFiles.add(sourceFileName);
                                    }
                                }
                                break;
                            }
                        }
                        Mappings.this.debug("Affecting field usages referenced from subclass ", subClass);
                        this.myFuture.affectFieldUsages(addedField, IntSet.of(), addedField.createUsage(Mappings.this.myContext, subClass), state.myAffectedUsages, state.myDependants);
                        if (addedField.isStatic()) {
                            this.myFuture.affectStaticMemberOnDemandUsages(subClass, IntSet.of(), state.myAffectedUsages, state.myDependants);
                        }
                        this.myFuture.appendDependents(subClass, state.myDependants);
                    });
                }
                HashSet overriddenFields = new HashSet();
                this.myFuture.addOverriddenFields(addedField, classRepr, overriddenFields, null, classRepr);
                for (Pair p : overriddenFields) {
                    FieldRepr overridden = (FieldRepr)p.first;
                    ClassRepr cc = (ClassRepr)p.second;
                    if (overridden.isPrivate()) continue;
                    Mappings.this.debug("Affecting usages of overridden field in class ", cc.name);
                    this.myFuture.affectFieldUsages(overridden, this.myPresent.propagateFieldAccess(overridden.name, cc.name), overridden.createUsage(Mappings.this.myContext, cc.name), state.myAffectedUsages, state.myDependants);
                }
            }
            Mappings.debug("End of added fields processing");
            return true;
        }

        private boolean processRemovedFields(DiffState state, ClassRepr.Diff diff, ClassRepr it) {
            Collection<FieldRepr> removed = diff.fields().removed();
            if (removed.isEmpty()) {
                return true;
            }
            assert (this.myPresent != null);
            Mappings.debug("Processing removed fields:");
            for (FieldRepr f : removed) {
                Mappings.this.debug("Field: ", f.name);
                if (!Mappings.this.myProcessConstantsIncrementally && !f.isPrivate() && (f.access & 0x10) == 16 && f.hasValue()) {
                    Mappings.debug("Field had value and was (non-private) final static => a switch to non-incremental mode requested");
                    if (!Mappings.this.incrementalDecision(it.name, f, this.myAffectedFiles, this.myFilesToCompile, this.myFilter)) {
                        Mappings.debug("End of Differentiate, returning false");
                        return false;
                    }
                }
                IntSet propagated = this.myPresent.propagateFieldAccess(f.name, it.name);
                this.myPresent.affectFieldUsages(f, propagated, f.createUsage(Mappings.this.myContext, it.name), state.myAffectedUsages, state.myDependants);
                if (f.isPrivate() || !f.isStatic()) continue;
                Mappings.debug("The field was static --- affecting static field import usages");
                this.myPresent.affectStaticMemberImportUsages(f.name, it.name, propagated, state.myAffectedUsages, state.myDependants);
            }
            Mappings.debug("End of removed fields processing");
            return true;
        }

        private boolean processChangedFields(DiffState state, ClassRepr.Diff diff, ClassRepr it) {
            Collection<Pair<FieldRepr, Difference>> changed = diff.fields().changed();
            if (changed.isEmpty()) {
                return true;
            }
            Mappings.debug("Processing changed fields:");
            assert (this.myFuture != null);
            assert (this.myPresent != null);
            for (Pair<FieldRepr, Difference> f : changed) {
                Difference d = (Difference)f.second;
                FieldRepr field = (FieldRepr)f.first;
                Mappings.this.debug("Field: ", field.name);
                Supplier<IntSet> propagated = Mappings.lazy(() -> this.myFuture.propagateFieldAccess(field.name, it.name));
                if (!field.isPrivate() && (field.access & 0x10) == 16 && d.hadValue()) {
                    boolean valueChanged;
                    int changedModifiers = d.addedModifiers() | d.removedModifiers();
                    boolean harmful = (changedModifiers & 0x18) != 0;
                    boolean bl = valueChanged = (d.base() & 4) != 0;
                    if (harmful || valueChanged || d.accessRestricted()) {
                        if (Mappings.this.myProcessConstantsIncrementally) {
                            Mappings.debug("Potentially inlined field changed its access or value => affecting field usages and static member import usages");
                            this.myFuture.affectFieldUsages(field, propagated.get(), field.createUsage(Mappings.this.myContext, it.name), state.myAffectedUsages, state.myDependants);
                            this.myFuture.affectStaticMemberImportUsages(field.name, it.name, propagated.get(), state.myAffectedUsages, state.myDependants);
                        } else {
                            Mappings.debug("Potentially inlined field changed its access or value => a switch to non-incremental mode requested");
                            if (!Mappings.this.incrementalDecision(it.name, field, this.myAffectedFiles, this.myFilesToCompile, this.myFilter)) {
                                Mappings.debug("End of Differentiate, returning false");
                                return false;
                            }
                        }
                    }
                }
                if (d.base() == 0) continue;
                if ((d.base() & 2) != 0 || (d.base() & 8) != 0) {
                    Mappings.debug("Type or signature changed --- affecting field usages");
                    this.myFuture.affectFieldUsages(field, propagated.get(), field.createUsage(Mappings.this.myContext, it.name), state.myAffectedUsages, state.myDependants);
                } else if ((d.base() & 1) != 0) {
                    if ((d.addedModifiers() & 8) != 0 || (d.removedModifiers() & 8) != 0 || (d.addedModifiers() & 2) != 0 || (d.addedModifiers() & 0x40) != 0) {
                        Mappings.debug("Added/removed static modifier or added private/volatile modifier --- affecting field usages");
                        this.myFuture.affectFieldUsages(field, propagated.get(), field.createUsage(Mappings.this.myContext, it.name), state.myAffectedUsages, state.myDependants);
                        if (!field.isPrivate()) {
                            if ((d.addedModifiers() & 8) != 0) {
                                Mappings.debug("Added static modifier --- affecting static member on-demand import usages");
                                this.myFuture.affectStaticMemberOnDemandUsages(it.name, propagated.get(), state.myAffectedUsages, state.myDependants);
                            } else if ((d.removedModifiers() & 8) != 0) {
                                Mappings.debug("Removed static modifier --- affecting static field import usages");
                                this.myFuture.affectStaticMemberImportUsages(field.name, it.name, propagated.get(), state.myAffectedUsages, state.myDependants);
                            }
                        }
                    } else {
                        HashSet usages = new HashSet();
                        if ((d.addedModifiers() & 0x10) != 0) {
                            Mappings.debug("Added final modifier --- affecting field assign usages");
                            this.myFuture.affectFieldUsages(field, propagated.get(), field.createAssignUsage(Mappings.this.myContext, it.name), usages, state.myDependants);
                            state.myAffectedUsages.addAll(usages);
                        }
                        if ((d.removedModifiers() & 1) != 0) {
                            Mappings.debug("Removed public modifier, affecting field usages with appropriate constraint");
                            this.myFuture.affectFieldUsages(field, propagated.get(), field.createUsage(Mappings.this.myContext, it.name), usages, state.myDependants);
                            state.myAffectedUsages.addAll(usages);
                            for (UsageRepr.Usage usage : usages) {
                                if ((d.addedModifiers() & 4) != 0) {
                                    Map<UsageRepr.Usage, UsageConstraint> map = state.myUsageConstraints;
                                    Util util = this.myFuture;
                                    Objects.requireNonNull(util);
                                    map.put(usage, util.new Util.InheritanceConstraint(it));
                                    continue;
                                }
                                Map<UsageRepr.Usage, UsageConstraint> map = state.myUsageConstraints;
                                Util util = this.myFuture;
                                Objects.requireNonNull(util);
                                map.put(usage, util.new Util.PackageConstraint(it.getPackageName()));
                            }
                        } else if ((d.removedModifiers() & 4) != 0 && d.accessRestricted()) {
                            Mappings.debug("Removed protected modifier and the field became less accessible, affecting field usages with package constraint");
                            this.myFuture.affectFieldUsages(field, propagated.get(), field.createUsage(Mappings.this.myContext, it.name), usages, state.myDependants);
                            state.myAffectedUsages.addAll(usages);
                            for (UsageRepr.Usage usage : usages) {
                                Map<UsageRepr.Usage, UsageConstraint> map = state.myUsageConstraints;
                                Util util = this.myFuture;
                                Objects.requireNonNull(util);
                                map.put(usage, util.new Util.PackageConstraint(it.getPackageName()));
                            }
                        }
                    }
                }
                if ((d.base() & 0x40) == 0) continue;
                EnumSet<AnnotationsChangeTracker.Recompile> toRecompile = EnumSet.noneOf(AnnotationsChangeTracker.Recompile.class);
                for (AnnotationsChangeTracker extension : this.myAnnotationChangeTracker) {
                    if (toRecompile.containsAll(AnnotationsChangeTracker.RECOMPILE_ALL)) break;
                    Set<AnnotationsChangeTracker.Recompile> res = extension.fieldAnnotationsChanged((NamingContext)Mappings.this.myContext, (ProtoFieldEntity)field, d.annotations());
                    if (res.contains((Object)AnnotationsChangeTracker.Recompile.USAGES)) {
                        Mappings.debug("Extension " + extension.getClass().getName() + " requested recompilation because of changes in annotations list --- affecting field usages");
                    }
                    if (res.contains((Object)AnnotationsChangeTracker.Recompile.SUBCLASSES)) {
                        Mappings.debug("Extension " + extension.getClass().getName() + " requested recompilation because of changes in field annotations list --- affecting subclasses");
                    }
                    toRecompile.addAll(res);
                }
                if (toRecompile.contains((Object)AnnotationsChangeTracker.Recompile.USAGES)) {
                    HashSet usages = new HashSet();
                    this.myFuture.affectFieldUsages(field, propagated.get(), field.createUsage(Mappings.this.myContext, it.name), usages, state.myDependants);
                    state.myAffectedUsages.addAll(usages);
                    for (UsageRepr.Usage usage : usages) {
                        state.myUsageConstraints.remove(usage);
                    }
                }
                if (!toRecompile.contains((Object)AnnotationsChangeTracker.Recompile.SUBCLASSES)) continue;
                this.myFuture.affectSubclasses(it.name, this.myAffectedFiles, state.myAffectedUsages, state.myDependants, false, this.myCompiledFiles, null);
            }
            Mappings.debug("End of changed fields processing");
            return true;
        }

        private boolean processChangedClasses(DiffState state) {
            Collection<Pair<ClassRepr, ClassRepr.Diff>> changedClasses = state.myClassDiff.changed();
            if (!changedClasses.isEmpty()) {
                Util.FileFilterConstraint fileFilterConstraint;
                Mappings.debug("Processing changed classes:");
                assert (this.myFuture != null);
                assert (this.myPresent != null);
                if (this.myFilter != null) {
                    Util util = this.myPresent;
                    Objects.requireNonNull(util);
                    fileFilterConstraint = util.new Util.FileFilterConstraint(this.myFilter);
                } else {
                    fileFilterConstraint = null;
                }
                Util.FileFilterConstraint fileFilterConstraint2 = fileFilterConstraint;
                for (Pair<ClassRepr, ClassRepr.Diff> changed : changedClasses) {
                    boolean recompileUsages;
                    boolean signatureChanged;
                    ClassRepr changedClass = (ClassRepr)changed.first;
                    ClassRepr.Diff diff = (ClassRepr.Diff)changed.second;
                    this.myDelta.addChangedClass(changedClass.name);
                    Mappings.this.debug("Changed: ", changedClass.name);
                    int addedModifiers = diff.addedModifiers();
                    boolean superClassChanged = (diff.base() & 0x10) != 0;
                    boolean interfacesChanged = !diff.interfaces().unchanged();
                    boolean bl = signatureChanged = (diff.base() & 8) != 0;
                    if (superClassChanged) {
                        this.myDelta.registerRemovedSuperClass(changedClass.name, changedClass.getSuperClass().className);
                        for (ClassRepr newClass : this.myDelta.getReprsByName(changedClass.name, ClassRepr.class)) {
                            this.myDelta.registerAddedSuperClass(changedClass.name, newClass.getSuperClass().className);
                        }
                    }
                    if (interfacesChanged) {
                        for (TypeRepr.ClassType typ : diff.interfaces().removed()) {
                            this.myDelta.registerRemovedSuperClass(changedClass.name, typ.className);
                        }
                        for (TypeRepr.ClassType typ : diff.interfaces().added()) {
                            this.myDelta.registerAddedSuperClass(changedClass.name, typ.className);
                        }
                    }
                    if (this.myEasyMode) continue;
                    IntSet directDeps = this.myPresent.appendDependents(changedClass, state.myDependants);
                    if (superClassChanged || interfacesChanged || signatureChanged) {
                        Mappings.this.debug("Superclass changed: ", superClassChanged);
                        Mappings.this.debug("Interfaces changed: ", interfacesChanged);
                        Mappings.this.debug("Signature changed ", signatureChanged);
                        boolean extendsChanged = superClassChanged && !diff.extendsAdded();
                        Mappings.this.debug("Extends changed: ", extendsChanged);
                        this.myFuture.affectSubclasses(changedClass.name, this.myAffectedFiles, state.myAffectedUsages, state.myDependants, extendsChanged || interfacesChanged || signatureChanged, this.myCompiledFiles, null);
                        if (extendsChanged && directDeps != null) {
                            TypeRepr.ClassType excClass = TypeRepr.createClassType(Mappings.this.myContext, changedClass.name);
                            directDeps.forEach(depClass -> {
                                for (ClassRepr depClassRepr : this.myPresent.reprsByName(depClass, ClassRepr.class)) {
                                    this.myPresent.affectMethodUsagesThrowing(depClassRepr, excClass, state.myAffectedUsages, state.myDependants);
                                }
                            });
                        }
                        if (!changedClass.isAnonymous()) {
                            IntOpenHashSet parents = new IntOpenHashSet();
                            this.myPresent.collectSupersRecursively(changedClass.name, (IntSet)parents);
                            IntOpenHashSet futureParents = new IntOpenHashSet();
                            this.myFuture.collectSupersRecursively(changedClass.name, (IntSet)futureParents);
                            parents.removeAll((IntCollection)futureParents);
                            parents.remove(Mappings.this.myObjectClassName);
                            if (!parents.isEmpty()) {
                                parents.forEach(className -> {
                                    Mappings.this.debug("Affecting usages in generic type parameter bounds of class: ", className);
                                    UsageRepr.Usage usage = UsageRepr.createClassAsGenericBoundUsage(Mappings.this.myContext, className);
                                    state.myAffectedUsages.add(usage);
                                    if (fileFilterConstraint2 != null) {
                                        state.myUsageConstraints.put(usage, fileFilterConstraint2);
                                    }
                                    this.myPresent.appendDependents(className, state.myDependants);
                                });
                            }
                        }
                    }
                    if ((diff.addedModifiers() & 0x200) != 0 || (diff.removedModifiers() & 0x200) != 0) {
                        Mappings.debug("Class-to-interface or interface-to-class conversion detected, added class usage to affected usages");
                        state.myAffectedUsages.add(changedClass.createUsage());
                    }
                    if (changedClass.isAnnotation() && changedClass.getRetentionPolicy() == RetentionPolicy.SOURCE) {
                        Mappings.debug("Annotation, retention policy = SOURCE => a switch to non-incremental mode requested");
                        if (!Mappings.this.incrementalDecision(changedClass.getOuterClassName(), changedClass, this.myAffectedFiles, this.myFilesToCompile, this.myFilter)) {
                            Mappings.debug("End of Differentiate, returning false");
                            return false;
                        }
                    }
                    if ((addedModifiers & 4) != 0) {
                        Mappings.debug("Introduction of 'protected' modifier detected, adding class usage + inheritance constraint to affected usages");
                        UsageRepr.Usage usage = changedClass.createUsage();
                        state.myAffectedUsages.add(usage);
                        Map<UsageRepr.Usage, UsageConstraint> map = state.myUsageConstraints;
                        Util util = this.myFuture;
                        Objects.requireNonNull(util);
                        map.put(usage, util.new Util.InheritanceConstraint(changedClass));
                    }
                    if (diff.packageLocalOn()) {
                        Mappings.debug("Introduction of 'package-private' access detected, adding class usage + package constraint to affected usages");
                        UsageRepr.Usage usage = changedClass.createUsage();
                        state.myAffectedUsages.add(usage);
                        Map<UsageRepr.Usage, UsageConstraint> map = state.myUsageConstraints;
                        Util util = this.myFuture;
                        Objects.requireNonNull(util);
                        map.put(usage, util.new Util.PackageConstraint(changedClass.getPackageName()));
                    }
                    if ((addedModifiers & 0x10) != 0 || (addedModifiers & 2) != 0) {
                        Mappings.debug("Introduction of 'private' or 'final' modifier(s) detected, adding class usage to affected usages");
                        state.myAffectedUsages.add(changedClass.createUsage());
                    }
                    if ((addedModifiers & 0x400) != 0 || (addedModifiers & 8) != 0) {
                        Mappings.debug("Introduction of 'abstract' or 'static' modifier(s) detected, adding class new usage to affected usages");
                        state.myAffectedUsages.add(UsageRepr.createClassNewUsage(Mappings.this.myContext, changedClass.name));
                    }
                    if (!(changedClass.isAnonymous() || Mappings.this.isEmpty(changedClass.getOuterClassName()) || changedClass.isPrivate() || addedModifiers == 0 && diff.removedModifiers() == 0)) {
                        Mappings.debug("Some modifiers (access flags) were changed for non-private inner class, adding class usage to affected usages");
                        state.myAffectedUsages.add(changedClass.createUsage());
                    }
                    if (changedClass.isAnnotation()) {
                        Mappings.debug("Class is annotation, performing annotation-specific analysis");
                        if (diff.retentionChanged()) {
                            Mappings.debug("Retention policy change detected, adding class usage to affected usages");
                            state.myAffectedUsages.add(changedClass.createUsage());
                        } else if (diff.targetAttributeCategoryMightChange()) {
                            Mappings.debug("Annotation's attribute category in bytecode might be affected because of TYPE_USE or RECORD_COMPONENT target, adding class usage to affected usages");
                            state.myAffectedUsages.add(changedClass.createUsage());
                        } else {
                            Collection<ElemType> removedtargets = diff.targets().removed();
                            if (removedtargets.contains((Object)ElemType.LOCAL_VARIABLE)) {
                                Mappings.debug("Removed target contains LOCAL_VARIABLE => a switch to non-incremental mode requested");
                                if (!Mappings.this.incrementalDecision(changedClass.getOuterClassName(), changedClass, this.myAffectedFiles, this.myFilesToCompile, this.myFilter)) {
                                    Mappings.debug("End of Differentiate, returning false");
                                    return false;
                                }
                            }
                            if (!removedtargets.isEmpty()) {
                                Mappings.debug("Removed some annotation targets, adding annotation query");
                                state.myAnnotationQuery.add((UsageRepr.AnnotationUsage)UsageRepr.createAnnotationUsage(Mappings.this.myContext, TypeRepr.createClassType(Mappings.this.myContext, changedClass.name), null, EnumSet.copyOf(removedtargets)));
                            }
                            for (MethodRepr m : diff.methods().added()) {
                                if (m.hasValue()) continue;
                                Mappings.this.debug("Added method with no default value: ", m.name);
                                Mappings.debug("Adding class usage to affected usages");
                                state.myAffectedUsages.add(changedClass.createUsage());
                            }
                        }
                        Mappings.debug("End of annotation-specific analysis");
                    }
                    this.processAddedMethods(state, diff, changedClass);
                    this.processRemovedMethods(state, diff, changedClass);
                    this.processChangedMethods(state, diff, changedClass);
                    if (!this.processAddedFields(state, diff, changedClass)) {
                        return false;
                    }
                    if (!this.processRemovedFields(state, diff, changedClass)) {
                        return false;
                    }
                    if (!this.processChangedFields(state, diff, changedClass)) {
                        return false;
                    }
                    if ((diff.base() & 0x40) == 0) continue;
                    EnumSet<AnnotationsChangeTracker.Recompile> toRecompile = EnumSet.noneOf(AnnotationsChangeTracker.Recompile.class);
                    for (AnnotationsChangeTracker extension : this.myAnnotationChangeTracker) {
                        if (toRecompile.containsAll(AnnotationsChangeTracker.RECOMPILE_ALL)) break;
                        Set<AnnotationsChangeTracker.Recompile> res = extension.classAnnotationsChanged(Mappings.this.myContext, changedClass, diff.annotations());
                        if (res.contains((Object)AnnotationsChangeTracker.Recompile.USAGES)) {
                            Mappings.debug("Extension " + extension.getClass().getName() + " requested class usages recompilation because of changes in annotations list --- adding class usage to affected usages");
                        }
                        if (res.contains((Object)AnnotationsChangeTracker.Recompile.SUBCLASSES)) {
                            Mappings.debug("Extension " + extension.getClass().getName() + " requested subclasses recompilation because of changes in annotations list --- adding subclasses to affected usages");
                        }
                        toRecompile.addAll(res);
                    }
                    if (recompileUsages = toRecompile.contains((Object)AnnotationsChangeTracker.Recompile.USAGES)) {
                        state.myAffectedUsages.add(changedClass.createUsage());
                    }
                    if (!toRecompile.contains((Object)AnnotationsChangeTracker.Recompile.SUBCLASSES)) continue;
                    this.myFuture.affectSubclasses(changedClass.name, this.myAffectedFiles, state.myAffectedUsages, state.myDependants, recompileUsages, this.myCompiledFiles, null);
                }
                Mappings.debug("End of changed classes processing");
            }
            return !this.myEasyMode;
        }

        private void processRemovedClases(DiffState state, @NotNull File fileName) {
            Collection<ClassRepr> removed;
            if (fileName == null) {
                Differential.$$$reportNull$$$0(1);
            }
            if ((removed = state.myClassDiff.removed()).isEmpty()) {
                return;
            }
            assert (this.myPresent != null);
            assert (this.myDelta.myChangedFiles != null);
            this.myDelta.myChangedFiles.add(fileName);
            Mappings.debug("Processing removed classes:");
            for (ClassRepr c : removed) {
                this.myDelta.addDeletedClass(c, fileName);
                if (this.myEasyMode) continue;
                this.myPresent.appendDependents(c, state.myDependants);
                Mappings.this.debug("Adding usages of class ", c.name);
                state.myAffectedUsages.add(c.createUsage());
                Mappings.this.debug("Affecting usages of removed class ", c.name);
                Mappings.this.affectAll(c.name, fileName, this.myAffectedFiles, this.myCompiledFiles, this.myFilter);
            }
            Mappings.debug("End of removed classes processing.");
        }

        private void processAddedClasses(DiffState state) {
            Collection<ClassRepr> addedClasses = state.myClassDiff.added();
            if (addedClasses.isEmpty()) {
                return;
            }
            Mappings.debug("Processing added classes:");
            if (!this.myEasyMode && this.myFilter != null) {
                assert (this.myCompiledFiles != null);
                assert (this.myAffectedFiles != null);
                for (ClassRepr c : addedClasses) {
                    if (c.isLocal() || c.isAnonymous() || !Mappings.this.isEmpty(c.getOuterClassName())) continue;
                    Set candidates = FileCollectionFactory.createCanonicalFileSet();
                    Iterable<File> currentlyMapped = Mappings.this.classToSourceFileGet(c.name);
                    if (currentlyMapped != null) {
                        ContainerUtil.addAll((Collection)candidates, currentlyMapped);
                    }
                    candidates.removeAll(this.myCompiledFiles);
                    Iterable<File> newSources = this.myDelta.classToSourceFileGet(c.name);
                    if (newSources != null) {
                        Mappings.removeAll(candidates, newSources);
                    }
                    Set nonExistentOrOutOfScope = FileCollectionFactory.createCanonicalFileSet();
                    Iterator iterator = candidates.iterator();
                    while (iterator.hasNext()) {
                        File candidate = (File)iterator.next();
                        if (candidate.exists() && this.myFilter.belongsToCurrentTargetChunk(candidate)) continue;
                        nonExistentOrOutOfScope.add(candidate);
                    }
                    candidates.removeAll(nonExistentOrOutOfScope);
                    if (candidates.isEmpty()) continue;
                    candidates.clear();
                    if (currentlyMapped != null) {
                        ContainerUtil.addAll((Collection)candidates, currentlyMapped);
                    }
                    if (newSources != null) {
                        ContainerUtil.addAll((Collection)candidates, newSources);
                    }
                    candidates.removeAll(nonExistentOrOutOfScope);
                    if (Mappings.this.myDebugS.isDebugEnabled()) {
                        StringBuilder msg = new StringBuilder();
                        msg.append("Possibly duplicated classes; Scheduling for recompilation sources: ");
                        Iterator iterator2 = candidates.iterator();
                        while (iterator2.hasNext()) {
                            File file = (File)iterator2.next();
                            msg.append(file.getPath()).append("; ");
                        }
                        Mappings.debug(msg.toString());
                    }
                    this.myAffectedFiles.addAll(candidates);
                    return;
                }
            }
            for (ClassRepr c : addedClasses) {
                Mappings.this.debug("Class name: ", c.name);
                this.myDelta.addAddedClass(c);
                for (TypeRepr.ClassType sup : c.getSuperTypes()) {
                    this.myDelta.registerAddedSuperClass(c.name, sup.className);
                }
                if (this.myEasyMode || c.isAnonymous() || c.isLocal()) continue;
                IntOpenHashSet toAffect = new IntOpenHashSet();
                toAffect.add(c.name);
                IntSet classes = Mappings.this.myShortClassNameIndex.get(Mappings.this.myContext.get(c.getShortName()));
                if (classes != null) {
                    toAffect.addAll((IntCollection)classes);
                }
                toAffect.forEach(qName -> {
                    IntSet depClasses = Mappings.this.myClassToClassDependency.get(qName);
                    if (depClasses != null) {
                        this.affectCorrespondingSourceFiles(depClasses);
                    }
                });
            }
            Mappings.debug("End of added classes processing.");
        }

        private void affectCorrespondingSourceFiles(IntSet toAffect) {
            assert (this.myAffectedFiles != null);
            toAffect.forEach(depClass -> {
                Iterable<File> fNames = Mappings.this.classToSourceFileGet(depClass);
                if (fNames != null) {
                    for (File fName : fNames) {
                        if (this.myFilter != null && !this.myFilter.accept(fName)) continue;
                        Mappings.this.debug("Adding dependent file ", fName);
                        this.myAffectedFiles.add(fName);
                    }
                }
            });
        }

        private boolean calculateAffectedFiles(final DiffState state) {
            Mappings.debug("Checking dependent classes:");
            assert (this.myAffectedFiles != null);
            assert (this.myCompiledFiles != null);
            if (state.myDependants.isEmpty()) {
                return true;
            }
            BiFunction<ClassFileRepr, File, Boolean> dependentReprProcessor = new BiFunction<ClassFileRepr, File, Boolean>(){
                private final Map<ClassFileRepr, Pair<Boolean, Boolean>> isAffected = new HashMap<ClassFileRepr, Pair<Boolean, Boolean>>();

                @Override
                public Boolean apply(ClassFileRepr repr, File depFile) {
                    boolean isGenerated;
                    if (repr instanceof ClassRepr) {
                        ClassRepr clsRepr = (ClassRepr)repr;
                        if (!clsRepr.hasInlinedConstants() && Differential.this.myCompiledFiles.contains(depFile)) {
                            return true;
                        }
                        isGenerated = clsRepr.isGenerated();
                    } else {
                        isGenerated = false;
                    }
                    if (Differential.this.myAffectedFiles.contains(depFile)) {
                        return !isGenerated;
                    }
                    Pair shouldAffect = this.isAffected.computeIfAbsent(repr, r -> {
                        Mappings.this.debug("Dependent class: ", r.name);
                        Set<UsageRepr.Usage> depUsages = r.getUsages();
                        if (depUsages == null || depUsages.isEmpty()) {
                            return Pair.create((Object)false, (Object)(!isGenerated ? 1 : 0));
                        }
                        for (UsageRepr.Usage usage : depUsages) {
                            if (usage instanceof UsageRepr.AnnotationUsage) {
                                UsageRepr.AnnotationUsage annotationUsage = (UsageRepr.AnnotationUsage)usage;
                                for (UsageRepr.AnnotationUsage query : state2.myAnnotationQuery) {
                                    if (!query.satisfies(annotationUsage)) continue;
                                    Mappings.debug("Added file due to annotation query");
                                    return Pair.create((Object)true, (Object)(!isGenerated ? 1 : 0));
                                }
                                continue;
                            }
                            if (!state2.myAffectedUsages.contains(usage)) continue;
                            UsageConstraint constraint = state2.myUsageConstraints.get(usage);
                            if (constraint == null) {
                                Mappings.debug("Added file with no constraints");
                                return Pair.create((Object)true, (Object)(!isGenerated ? 1 : 0));
                            }
                            if (!constraint.checkResidence(r.name)) continue;
                            Mappings.debug("Added file with satisfied constraint");
                            return Pair.create((Object)true, (Object)(!isGenerated ? 1 : 0));
                        }
                        return Pair.create((Object)false, (Object)true);
                    });
                    if (((Boolean)shouldAffect.getFirst()).booleanValue()) {
                        Differential.this.myAffectedFiles.add(depFile);
                    }
                    return (Boolean)shouldAffect.getSecond();
                }
            };
            IntIterator dependants = state.myDependants.iterator();
            while (dependants.hasNext()) {
                int depName = dependants.nextInt();
                Iterable dependentReprs = Iterators.filter((Iterable)Iterators.map((Iterable)Iterators.map(Mappings.this.myClassToRelativeSourceFilePath.get(depName), src -> Pair.create(Mappings.this.myRelativeSourceFilePathToClasses.get((String)src), (Object)Mappings.this.toFull((String)src))), p -> {
                    Collection reprs = (Collection)p.getFirst();
                    if (reprs != null) {
                        for (ClassFileRepr repr : reprs) {
                            if (repr.name != depName) continue;
                            return Pair.create((Object)repr, (Object)((File)p.getSecond()));
                        }
                    }
                    return null;
                }), Objects::nonNull);
                for (Pair pair : dependentReprs) {
                    if (((Boolean)dependentReprProcessor.apply((ClassFileRepr)pair.getFirst(), (File)pair.getSecond())).booleanValue()) continue;
                    Mappings.debug("Turning non-incremental for the BuildTarget because dependent class is annotation-processor generated");
                    return false;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean differentiate() {
            var1_1 = Mappings.this.myLock;
            synchronized (var1_1) {
                block26: {
                    block27: {
                        this.myDelta.myIsDifferentiated = true;
                        if (this.myDelta.myIsRebuild) {
                            return true;
                        }
                        start = System.currentTimeMillis();
                        Mappings.debug("Begin of Differentiate:");
                        Mappings.this.debug("Easy mode: ", this.myEasyMode);
                        this.processDisappearedClasses();
                        newClasses = new ArrayList<E>();
                        this.myDelta.myRelativeSourceFilePathToClasses.forEachEntry((PairProcessor<String, Collection<ClassFileRepr>>)(PairProcessor)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Z, lambda$differentiate$17(java.util.List java.lang.String java.util.Collection ), (Ljava/lang/String;Ljava/util/Collection;)Z)((Differential)this, newClasses));
                        var5_4 = newClasses.iterator();
                        while (true) {
                            if (var5_4.hasNext()) {
                                compiledFile = (FileClasses)var5_4.next();
                                fileName = compiledFile.myFileName;
                                pastClasses = new HashSet<ClassRepr>();
                                pastModules = new HashSet<ModuleRepr>();
                                past = Mappings.this.sourceFileToClassesGet(fileName);
                                if (past == null) break block26;
                                var11_12 = past.iterator();
                                break block27;
                            }
                            addedClasses = this.myDelta.getAddedClasses();
                            if (!addedClasses.isEmpty()) {
                                addedNames = new IntOpenHashSet();
                                for (ClassRepr repr : addedClasses) {
                                    addedNames.add(repr.name);
                                }
                                for (FileClasses compiledFile : newClasses) {
                                    for (ClassRepr aClass : compiledFile.myFileClasses) {
                                        for (TypeRepr.ClassType parent : aClass.getSuperTypes()) {
                                            if (!addedNames.contains(parent.className)) continue;
                                            this.myDelta.registerAddedSuperClass(aClass.name, parent.className);
                                        }
                                    }
                                }
                            }
                            Mappings.debug("End of Differentiate.");
                            if (this.myEasyMode) {
                                addedNames = false;
                                return addedNames;
                            }
                            if (!Differential.$assertionsDisabled && this.myAffectedFiles == null) {
                                throw new AssertionError();
                            }
                            removed = this.myDelta.myRemovedFiles;
                            if (removed != null) {
                                for (String r : removed) {
                                    this.myAffectedFiles.remove(new File(r));
                                }
                            }
                            var7_8 = true;
                            return var7_8;
                        }
                        finally {
                            if (this.myFilesToCompile != null) {
                                if (!Differential.$assertionsDisabled && this.myDelta.myChangedFiles == null) {
                                    throw new AssertionError();
                                }
                                this.myDelta.myChangedFiles.retainAll(this.myFilesToCompile);
                            }
                            Mappings.this.myTotalDifferentiateTime += System.currentTimeMillis() - start;
                        }
                    }
                    while (var11_12.hasNext()) {
                        repr = var11_12.next();
                        if (repr instanceof ClassRepr) {
                            pastClasses.add((ClassRepr)repr);
                            continue;
                        }
                        pastModules.add((ModuleRepr)repr);
                    }
                }
                state = new DiffState(Difference.make(pastClasses, compiledFile.myFileClasses), Difference.make(pastModules, compiledFile.myFileModules));
                if (!this.myEasyMode) {
                    this.processModules(state, fileName);
                }
                if (!this.processChangedClasses(state) && !this.myEasyMode) {
                    repr = false;
                    return repr;
                }
                this.processRemovedClases(state, fileName);
                this.processAddedClasses(state);
                if (this.myEasyMode || this.calculateAffectedFiles(state)) ** continue;
                repr = false;
                return repr;
            }
        }

        private void processModules(DiffState state, File fileName) {
            Difference.Specifier<ModuleRepr, ModuleRepr.Diff> modulesDiff = state.myModulesDiff;
            if (modulesDiff.unchanged()) {
                return;
            }
            for (ModuleRepr moduleRepr : modulesDiff.added()) {
                this.myDelta.addChangedClass(moduleRepr.name);
                this.myFuture.affectModule(moduleRepr, this.myAffectedFiles);
            }
            for (ModuleRepr moduleRepr : modulesDiff.removed()) {
                this.myDelta.addDeletedClass(moduleRepr, fileName);
                this.myPresent.affectDependentModules(state, moduleRepr.name, null, true);
            }
            for (Pair pair : modulesDiff.changed()) {
                final ModuleRepr moduleRepr = (ModuleRepr)pair.first;
                ModuleRepr.Diff d = (ModuleRepr.Diff)pair.second;
                boolean affectSelf = false;
                boolean affectDeps = false;
                UsageConstraint constraint = null;
                this.myDelta.addChangedClass(moduleRepr.name);
                if (d.versionChanged()) {
                    final int version = moduleRepr.getVersion();
                    this.myPresent.affectDependentModules(state, moduleRepr.name, new UsageConstraint(){

                        @Override
                        public boolean checkResidence(int dep) {
                            for (ModuleRequiresRepr requires : Iterators.flat((Iterable)Iterators.map(Differential.this.myPresent.reprsByName(dep, ModuleRepr.class), depModule -> depModule.getRequires()))) {
                                if (requires.name != moduleRepr.name || requires.getVersion() != version) continue;
                                return true;
                            }
                            return false;
                        }
                    }, false);
                }
                Difference.Specifier<ModuleRequiresRepr, ModuleRequiresRepr.Diff> requiresDiff = d.requires();
                for (ModuleRequiresRepr moduleRequiresRepr : requiresDiff.removed()) {
                    affectSelf = true;
                    if (!moduleRequiresRepr.isTransitive()) continue;
                    affectDeps = true;
                    constraint = UsageConstraint.ANY;
                    break;
                }
                for (Pair pair2 : requiresDiff.changed()) {
                    affectSelf |= ((ModuleRequiresRepr.Diff)pair2.second).versionChanged();
                    if (!((ModuleRequiresRepr.Diff)pair2.second).becameNonTransitive()) continue;
                    affectDeps = true;
                    constraint = UsageConstraint.ANY;
                }
                Difference.Specifier<ModulePackageRepr, ModulePackageRepr.Diff> exportsDiff = d.exports();
                if (!affectDeps) {
                    for (ModulePackageRepr modulePackageRepr : exportsDiff.removed()) {
                        affectDeps = true;
                        if (!modulePackageRepr.isQualified()) {
                            constraint = UsageConstraint.ANY;
                            break;
                        }
                        for (Integer name : modulePackageRepr.getModuleNames()) {
                            UsageConstraint matchName = UsageConstraint.exactMatch(name);
                            if (constraint == null) {
                                constraint = matchName;
                                continue;
                            }
                            constraint = constraint.or(matchName);
                        }
                    }
                }
                if (!affectDeps || constraint != UsageConstraint.ANY) {
                    for (Pair<ModulePackageRepr, ModulePackageRepr.Diff> pair3 : exportsDiff.changed()) {
                        Collection<Integer> removedModuleNames = ((ModulePackageRepr.Diff)pair3.second).targetModules().removed();
                        if (!(affectDeps |= !removedModuleNames.isEmpty())) continue;
                        for (Integer name : removedModuleNames) {
                            UsageConstraint matchName = UsageConstraint.exactMatch(name);
                            if (constraint == null) {
                                constraint = matchName;
                                continue;
                            }
                            constraint = constraint.or(matchName);
                        }
                    }
                }
                if (affectSelf) {
                    this.myPresent.affectModule(moduleRepr, this.myAffectedFiles);
                }
                if (!affectDeps) continue;
                this.myPresent.affectDependentModules(state, moduleRepr.name, constraint, true);
            }
        }

        private /* synthetic */ boolean lambda$differentiate$17(List newClasses, String relativeFilePath, Collection content) {
            File file = Mappings.this.toFull(relativeFilePath);
            if (this.myFilesToCompile == null || this.myFilesToCompile.contains(file)) {
                newClasses.add(new FileClasses(file, content));
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileName";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/jps/builders/java/dependencyView/Mappings$Differential";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processRemovedClases";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private final class DiffState {
            public final IntSet myDependants = new IntOpenHashSet(32, 0.98f);
            public final Set<UsageRepr.Usage> myAffectedUsages = new HashSet<UsageRepr.Usage>();
            public final Set<UsageRepr.AnnotationUsage> myAnnotationQuery = new HashSet<UsageRepr.AnnotationUsage>();
            public final Map<UsageRepr.Usage, UsageConstraint> myUsageConstraints = new HashMap<UsageRepr.Usage, UsageConstraint>();
            final Difference.Specifier<ClassRepr, ClassRepr.Diff> myClassDiff;
            final Difference.Specifier<ModuleRepr, ModuleRepr.Diff> myModulesDiff;

            DiffState(Difference.Specifier<ClassRepr, ClassRepr.Diff> classDiff, Difference.Specifier<ModuleRepr, ModuleRepr.Diff> modulesDiff) {
                this.myClassDiff = classDiff;
                this.myModulesDiff = modulesDiff;
            }
        }

        private final class FileClasses {
            final File myFileName;
            final Set<ClassRepr> myFileClasses = new HashSet<ClassRepr>();
            final Set<ModuleRepr> myFileModules = new HashSet<ModuleRepr>();

            FileClasses(File fileName, Collection<ClassFileRepr> fileContent) {
                this.myFileName = fileName;
                for (ClassFileRepr repr : fileContent) {
                    if (repr instanceof ClassRepr) {
                        this.myFileClasses.add((ClassRepr)repr);
                        continue;
                    }
                    this.myFileModules.add((ModuleRepr)repr);
                }
            }
        }
    }

    private static final class OverloadDescriptor {
        final int accessScope;
        final MethodRepr overloadMethod;
        final ClassRepr overloadMethodOwner;

        OverloadDescriptor(int accessScope, MethodRepr overloadMethod, ClassRepr overloadMethodOwner) {
            this.accessScope = accessScope;
            this.overloadMethod = overloadMethod;
            this.overloadMethodOwner = overloadMethodOwner;
        }
    }
}

