/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage.graph;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.PersistentMapBuilder;
import java.io.IOException;
import java.nio.file.Path;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;
import org.jetbrains.jps.dependency.Maplet;

public final class PersistentMaplet<K, V>
implements Maplet<K, V> {
    private final PersistentHashMap<K, V> myMap;

    public PersistentMaplet(Path mapFile, KeyDescriptor<K> keyDescriptor, DataExternalizer<V> valueExternalizer) {
        try {
            this.myMap = PersistentMapBuilder.newBuilder((Path)mapFile, keyDescriptor, valueExternalizer).build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean containsKey(K key) {
        try {
            return this.myMap.containsMapping(key);
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Nullable
    public V get(K key) {
        try {
            return (V)this.myMap.get(key);
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    public void put(K key, V value) {
        try {
            if (value == null) {
                this.myMap.remove(key);
            } else {
                this.myMap.put(key, value);
            }
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    public void remove(K key) {
        try {
            this.myMap.remove(key);
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    public Iterable<K> getKeys() {
        try {
            return this.myMap.getAllKeysWithExistingMapping();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() throws IOException {
        this.myMap.close();
    }

    public void flush() throws IOException {
        this.myMap.force();
    }
}

