/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam.reflect;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jam.JamConverter;
import com.intellij.jam.JamElement;
import com.intellij.jam.reflect.JamAnnotationAttributeMeta;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamBooleanAttributeMeta;
import com.intellij.jam.reflect.JamClassAttributeMeta;
import com.intellij.jam.reflect.JamEnumAttributeMeta;
import com.intellij.jam.reflect.JamNumberAttributeMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.jam.reflect.JamTypeAttributeMeta;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.ref.AnnotationAttributeChildLink;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public abstract class JamAttributeMeta<JamType> {
    private final AnnotationAttributeChildLink myAttributeLink;

    protected JamAttributeMeta(@NonNls String attrName) {
        this.myAttributeLink = new AnnotationAttributeChildLink(attrName);
    }

    public AnnotationAttributeChildLink getAttributeLink() {
        return this.myAttributeLink;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JamAttributeMeta that = (JamAttributeMeta)o;
        return this.myAttributeLink.equals((Object)that.myAttributeLink);
    }

    public int hashCode() {
        return this.myAttributeLink.hashCode();
    }

    @NotNull
    public <T> @Unmodifiable List<T> getCollectionJam(PsiElementRef<? extends PsiAnnotation> annoRef, NullableFunction<? super PsiAnnotationMemberValue, T> producer) {
        PsiAnnotationMemberValue attr = this.getAttributeLink().findLinkedChild((PsiAnnotation)annoRef.getPsiElement());
        List list = ContainerUtil.mapNotNull((Collection)AnnotationUtil.arrayAttributeValues((PsiAnnotationMemberValue)attr), producer);
        if (list == null) {
            JamAttributeMeta.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public abstract JamType getJam(PsiElementRef<? extends PsiAnnotation> var1);

    @NotNull
    public static JamStringAttributeMeta.Single<String> singleString(@NotNull @NonNls String attrName) {
        if (attrName == null) {
            JamAttributeMeta.$$$reportNull$$$0(1);
        }
        return JamAttributeMeta.singleString(attrName, JamConverter.DUMMY_CONVERTER);
    }

    @NotNull
    public static <T> JamStringAttributeMeta.Single<T> singleString(@NotNull @NonNls String attrName, JamConverter<T> converter) {
        if (attrName == null) {
            JamAttributeMeta.$$$reportNull$$$0(2);
        }
        return new JamStringAttributeMeta.Single<T>(attrName, converter);
    }

    @NotNull
    public static <T extends Enum<T>> JamEnumAttributeMeta.Single<T> singleEnum(@NotNull @NonNls String attrName, Class<T> modelEnum) {
        if (attrName == null) {
            JamAttributeMeta.$$$reportNull$$$0(3);
        }
        return new JamEnumAttributeMeta.Single<T>(attrName, modelEnum);
    }

    @NotNull
    public static JamStringAttributeMeta.Collection<String> collectionString(@NotNull @NonNls String attrName) {
        if (attrName == null) {
            JamAttributeMeta.$$$reportNull$$$0(4);
        }
        return JamAttributeMeta.collectionString(attrName, JamConverter.DUMMY_CONVERTER);
    }

    @NotNull
    public static <T> JamStringAttributeMeta.Collection<T> collectionString(String attrName, JamConverter<T> converter) {
        return new JamStringAttributeMeta.Collection<T>(attrName, converter);
    }

    @NotNull
    public static <T extends JamElement> JamAnnotationAttributeMeta.Single<T> singleAnno(@NotNull @NonNls String attrName, @NotNull JamAnnotationMeta annoMeta, @NotNull Function<PsiAnnotation, T> instantiator) {
        if (attrName == null) {
            JamAttributeMeta.$$$reportNull$$$0(5);
        }
        if (annoMeta == null) {
            JamAttributeMeta.$$$reportNull$$$0(6);
        }
        if (instantiator == null) {
            JamAttributeMeta.$$$reportNull$$$0(7);
        }
        return new JamAnnotationAttributeMeta.Single<JamElement>(attrName, annoMeta, ref -> (JamElement)instantiator.apply((PsiAnnotation)Objects.requireNonNull(ref.getPsiElement())));
    }

    @NotNull
    public static <T extends JamElement> JamAnnotationAttributeMeta.Collection<T> annoCollection(@NotNull @NonNls String attrName, @NotNull JamAnnotationMeta annoMeta, @NotNull Function<PsiAnnotation, T> instantiator) {
        if (attrName == null) {
            JamAttributeMeta.$$$reportNull$$$0(8);
        }
        if (annoMeta == null) {
            JamAttributeMeta.$$$reportNull$$$0(9);
        }
        if (instantiator == null) {
            JamAttributeMeta.$$$reportNull$$$0(10);
        }
        return new JamAnnotationAttributeMeta.Collection<JamElement>(attrName, annoMeta, ref -> (JamElement)instantiator.apply((PsiAnnotation)Objects.requireNonNull(ref.getPsiElement())));
    }

    @NotNull
    public static JamClassAttributeMeta.Single singleClass(String attrName) {
        return new JamClassAttributeMeta.Single(attrName);
    }

    @NotNull
    public static JamClassAttributeMeta.Collection classCollection(String attrName) {
        return new JamClassAttributeMeta.Collection(attrName);
    }

    @NotNull
    public static JamTypeAttributeMeta.Single singleType(String attrName) {
        return new JamTypeAttributeMeta.Single(attrName);
    }

    @NotNull
    public static JamTypeAttributeMeta.Collection typeCollection(String attrName) {
        return new JamTypeAttributeMeta.Collection(attrName);
    }

    @NotNull
    public static JamBooleanAttributeMeta singleBoolean(@NotNull @NonNls String attrName, boolean defaultValue) {
        if (attrName == null) {
            JamAttributeMeta.$$$reportNull$$$0(11);
        }
        return new JamBooleanAttributeMeta(attrName, defaultValue);
    }

    @NotNull
    public static JamNumberAttributeMeta.Single<Integer> singleInteger(@NotNull @NonNls String attrName) {
        if (attrName == null) {
            JamAttributeMeta.$$$reportNull$$$0(12);
        }
        return new JamNumberAttributeMeta.Single<Integer>(attrName, Integer.class);
    }

    protected static PsiAnnotationMemberValue addAttribute(PsiElementRef<? extends PsiAnnotation> annoRef, String valueText, AnnotationAttributeChildLink link) {
        PsiAnnotation annotation = (PsiAnnotation)annoRef.ensurePsiElementExists();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)annotation.getProject());
        PsiExpression literal = factory.createExpressionFromText(valueText, null);
        PsiAnnotationMemberValue attr = link.findLinkedChild(annotation);
        if (attr == null) {
            literal = (PsiAnnotationMemberValue)link.createChild(annotation).replace((PsiElement)literal);
        } else if (attr instanceof PsiArrayInitializerMemberValue) {
            literal = (PsiAnnotationMemberValue)attr.add((PsiElement)literal);
        } else {
            PsiAnnotationMemberValue arrayInit = factory.createAnnotationFromText("@Foo({})", null).findDeclaredAttributeValue(null);
            arrayInit.add((PsiElement)attr);
            arrayInit = annotation.setDeclaredAttributeValue(link.getAttributeName(), arrayInit);
            literal = (PsiAnnotationMemberValue)arrayInit.add((PsiElement)literal);
        }
        return literal;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jam/reflect/JamAttributeMeta";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrName";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annoMeta";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instantiator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCollectionJam";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jam/reflect/JamAttributeMeta";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "singleString";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "singleEnum";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectionString";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "singleAnno";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "annoCollection";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "singleBoolean";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "singleInteger";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 -> new IllegalArgumentException(string);
        };
    }
}

