/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam.view;

import com.intellij.jam.JavaJamBundle;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.view.JamUserResponse;
import com.intellij.jam.view.ui.JamUi;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;

public class DefaultUserResponse
implements JamUserResponse {
    protected final Project myProject;
    private final List<DeleteError> myErrors = new ArrayList<DeleteError>();

    public DefaultUserResponse(Project project) {
        this.myProject = project;
    }

    public DefaultUserResponse(CommonModelElement element) {
        this.myProject = element.getPsiManager().getProject();
    }

    @Override
    public Collection<PsiElement> askUserToDeletePsiElements(Collection<? extends PsiElement> ownedReferences, String elementDisplayName) {
        return JamUi.getInstance().chooseJamElementsToDelete(this.myProject, ownedReferences);
    }

    @Override
    public void logErrorWhileDeletingModelElement(IncorrectOperationException e, CommonModelElement object) {
        throw new RuntimeException((Throwable)e);
    }

    @Override
    public void logErrorWhileDeletingPsiElement(IncorrectOperationException e, String source, PsiElement current) {
        this.myErrors.add(new DeleteError((Throwable)e, source));
    }

    @Override
    public int showYesNoDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, Icon icon) {
        return ((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)title, (String)message).icon(icon)).show();
    }

    @Override
    public void onDeletingHasBeenFinished() {
        if (!this.myErrors.isEmpty()) {
            List messages = ContainerUtil.map(this.myErrors, Throwable::getLocalizedMessage);
            Messages.showErrorDialog((String)StringUtil.join((Collection)messages, (String)"\n"), (String)JavaJamBundle.message("message.title.deleting.element", this.myErrors.get(0).getSourceDisplayString()));
        }
    }

    private static class DeleteError
    extends RuntimeException {
        private final String mySourceDisplayString;

        DeleteError(Throwable cause, String sourceDisplayString) {
            super(cause);
            this.mySourceDisplayString = sourceDisplayString;
        }

        public String getSourceDisplayString() {
            return this.mySourceDisplayString;
        }
    }
}

