/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam.view;

import com.intellij.ide.DeleteProvider;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.common.CommonModelManager;
import com.intellij.jam.view.JamUserResponse;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.DataContext;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class JamDeleteProvider
implements DeleteProvider {
    private final Collection<CommonModelElement> myElements;
    private final JamUserResponse myResponse;

    public JamDeleteProvider(Collection<? extends JamDeleteProvider> providers) {
        this.myElements = new HashSet<CommonModelElement>();
        JamUserResponse response = JamUserResponse.QUIET;
        for (JamDeleteProvider jamDeleteProvider : providers) {
            this.myElements.addAll(jamDeleteProvider.myElements);
            response = jamDeleteProvider.myResponse;
        }
        this.myResponse = response;
    }

    public JamDeleteProvider(JamUserResponse response, Collection<CommonModelElement> elements) {
        this.myElements = elements;
        this.myResponse = response;
    }

    public JamDeleteProvider(CommonModelElement element, JamUserResponse response) {
        this(response, Collections.singletonList(element));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            JamDeleteProvider.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void deleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            JamDeleteProvider.$$$reportNull$$$0(1);
        }
        CommonModelManager.getInstance().deleteModelElements(this.myElements, this.myResponse);
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            JamDeleteProvider.$$$reportNull$$$0(2);
        }
        for (CommonModelElement element : this.myElements) {
            if (element == null || element.isValid()) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jam/view/JamDeleteProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jam/view/JamDeleteProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "deleteElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canDeleteElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

