/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.performancePlugin;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerTopics;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.task.ModuleBuildTask;
import com.intellij.task.ProjectTaskManager;
import com.intellij.task.impl.ProjectTaskManagerImpl;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.performancePlugin.PerformanceTestSpan;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.commands.OpenFileCommand;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.context.Scope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class BuildCommand
extends AbstractCommand {
    public static final String PREFIX = "%buildProject";
    private static final String REBUILD = "REBUILD";
    private static final String BUILD = "BUILD";
    private static final String RECOMPILE_FILES = "RECOMPILE_FILES";
    public static final String SPAN_NAME = "build_compilation_duration";

    public BuildCommand(@NotNull String text, int line) {
        if (text == null) {
            BuildCommand.$$$reportNull$$$0(0);
        }
        super(text, line);
    }

    @NotNull
    protected Promise<Object> _execute(final @NotNull PlaybackContext context) {
        if (context == null) {
            BuildCommand.$$$reportNull$$$0(1);
        }
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        ArrayList arguments = this.extractCommandList(PREFIX, " ");
        String mode = (String)arguments.remove(0);
        Project project = context.getProject();
        final MessageBusConnection connection = project.getMessageBus().connect();
        SpanBuilder span = PerformanceTestSpan.TRACER.spanBuilder(SPAN_NAME).setParent(PerformanceTestSpan.getContext());
        final Ref spanRef = new Ref();
        Ref scopeRef = new Ref();
        connection.subscribe(CompilerTopics.COMPILATION_STATUS, (Object)new CompilationStatusListener(){

            public void compilationFinished(boolean aborted, int errors, int warnings, @NotNull CompileContext compileContext) {
                if (compileContext == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (errors > 0) {
                    context.message("Compilation FAILED.", BuildCommand.this.getLine());
                    CompilerMessage[] errorMessages = compileContext.getMessages(CompilerMessageCategory.ERROR);
                    StringBuilder errorMessage = new StringBuilder("Errors happened during build: " + errors);
                    for (CompilerMessage error : errorMessages) {
                        errorMessage.append("\n").append(error);
                    }
                    context.message(errorMessage.toString(), BuildCommand.this.getLine());
                    ((Span)spanRef.get()).setAttribute("Errors", (long)errors);
                }
                if (warnings > 0) {
                    ((Span)spanRef.get()).setAttribute("Warnings", (long)warnings);
                }
                connection.disconnect();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compileContext", "com/intellij/java/performancePlugin/BuildCommand$1", "compilationFinished"));
            }
        });
        ApplicationManager.getApplication().invokeLater(() -> this.lambda$_execute$1(project, spanRef, span, scopeRef, mode, arguments, (ActionCallback)actionCallback, context));
        Promise promise = Promises.toPromise((ActionCallback)actionCallback);
        if (promise == null) {
            BuildCommand.$$$reportNull$$$0(2);
        }
        return promise;
    }

    public static boolean hasCompilationErrors(@NotNull ProjectTaskManager.Result result) {
        if (result == null) {
            BuildCommand.$$$reportNull$$$0(3);
        }
        return result.anyTaskMatches((task, state) -> task instanceof ModuleBuildTask && state.isFailed());
    }

    private static List<Module> getModules(List<String> moduleNames, Project project) {
        return moduleNames.isEmpty() ? Collections.emptyList() : Arrays.stream(ModuleManager.getInstance((Project)project).getModules()).filter(module -> moduleNames.contains(module.getName())).toList();
    }

    private static Promise<ProjectTaskManager.Result> build(List<Module> modules, ProjectTaskManager projectTaskManager) {
        return modules.isEmpty() ? projectTaskManager.buildAllModules() : projectTaskManager.build(modules.toArray(Module.EMPTY_ARRAY));
    }

    private static Promise<ProjectTaskManager.Result> rebuild(List<Module> modules, ProjectTaskManager projectTaskManager) {
        return modules.isEmpty() ? projectTaskManager.rebuildAllModules() : projectTaskManager.rebuild(modules.toArray(Module.EMPTY_ARRAY));
    }

    private static Promise<ProjectTaskManager.Result> recompileFiles(List<String> fileNames, Project project) {
        VirtualFile[] files = (VirtualFile[])fileNames.stream().map(fileName -> {
            VirtualFile file = OpenFileCommand.findFile((String)fileName, (Project)project);
            if (file == null) {
                throw new IllegalStateException("File not found : " + fileName);
            }
            return file;
        }).toArray(VirtualFile[]::new);
        if (files.length == 0) {
            throw new IllegalStateException("Enter at least one file");
        }
        return ProjectTaskManager.getInstance((Project)project).compile(files);
    }

    private /* synthetic */ void lambda$_execute$1(Project project, Ref spanRef, SpanBuilder span, Ref scopeRef, String mode, List arguments, ActionCallback actionCallback, PlaybackContext context) {
        ProjectTaskManagerImpl.putBuildOriginator((Project)project, ((Object)((Object)this)).getClass());
        ProjectTaskManager instance = ProjectTaskManager.getInstance((Project)project);
        Promise<ProjectTaskManager.Result> promise = null;
        spanRef.set((Object)span.startSpan());
        scopeRef.set((Object)((Span)spanRef.get()).makeCurrent());
        switch (mode) {
            case "BUILD": {
                promise = BuildCommand.build(BuildCommand.getModules(arguments, project), instance);
                break;
            }
            case "REBUILD": {
                promise = BuildCommand.rebuild(BuildCommand.getModules(arguments, project), instance);
                break;
            }
            case "RECOMPILE_FILES": {
                promise = BuildCommand.recompileFiles(arguments, project);
                break;
            }
            default: {
                actionCallback.reject("Specified mode is neither BUILD nor REBUILD nor RECOMPILE_FILES");
            }
        }
        if (promise != null) {
            promise.onSuccess(result -> {
                ((Span)spanRef.get()).end();
                ((Scope)scopeRef.get()).close();
                boolean failed = BuildCommand.hasCompilationErrors(result);
                if (failed) {
                    String errorMessage = PerformanceTestingBundle.message((String)"command.build.finish.with.compilation.errors", (Object[])new Object[0]);
                    context.message(errorMessage, this.getLine());
                    actionCallback.reject(errorMessage);
                } else if (result.hasErrors() || result.isAborted() || project.isDisposed()) {
                    String errorMessage = result.hasErrors() ? PerformanceTestingBundle.message((String)"command.build.finish.with.errors", (Object[])new Object[0]) : (result.isAborted() ? PerformanceTestingBundle.message((String)"command.build.aborted", (Object[])new Object[0]) : PerformanceTestingBundle.message((String)"command.build.project.disposed", (Object[])new Object[0]));
                    context.message(errorMessage, this.getLine());
                    actionCallback.reject(errorMessage);
                } else {
                    context.message(PerformanceTestingBundle.message((String)"command.build.finish", (Object[])new Object[0]), this.getLine());
                    actionCallback.setDone();
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/java/performancePlugin/BuildCommand";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/java/performancePlugin/BuildCommand";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasCompilationErrors";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

