/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.registry.cloud.notifications;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.platform.registry.cloud.CommonKt;
import com.intellij.platform.registry.cloud.Update;
import com.intellij.platform.registry.cloud.UpdateConfig;
import com.intellij.platform.registry.cloud.Updater;
import com.intellij.platform.registry.cloud.dto.ActionDto;
import com.intellij.platform.registry.cloud.dto.NotificationUpdateDto;
import com.intellij.platform.registry.cloud.dto.NotificationUpdateTypeDto;
import com.intellij.platform.registry.cloud.dto.UpdatesRoot;
import com.intellij.platform.registry.cloud.notifications.ActionsKt;
import com.intellij.platform.registry.cloud.notifications.ActionsRegistryKt;
import com.intellij.platform.registry.cloud.notifications.CloudRegistryAction;
import com.intellij.platform.registry.cloud.notifications.NotificationUpdate;
import com.intellij.platform.registry.cloud.notifications.NotificationsUpdater;
import com.intellij.platform.registry.cloud.notifications.NotificationsUpdaterKt;
import com.intellij.ui.icons.ImageDataByPathLoaderKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001c\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\rH\u0096@\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/platform/registry/cloud/notifications/NotificationsUpdater;", "Lcom/intellij/platform/registry/cloud/Updater;", "config", "Lcom/intellij/platform/registry/cloud/UpdateConfig;", "<init>", "(Lcom/intellij/platform/registry/cloud/UpdateConfig;)V", "read", "Lcom/intellij/platform/registry/cloud/Update;", "document", "Lcom/intellij/platform/registry/cloud/dto/UpdatesRoot;", "apply", "", "updates", "", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "mapType", "Lcom/intellij/notification/NotificationType;", "type", "Lcom/intellij/platform/registry/cloud/dto/NotificationUpdateTypeDto;", "intellij.platform.registry.cloud"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nNotificationsUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotificationsUpdater.kt\ncom/intellij/platform/registry/cloud/notifications/NotificationsUpdater\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n777#2:98\n873#2,2:99\n812#2,12:101\n*S KotlinDebug\n*F\n+ 1 NotificationsUpdater.kt\ncom/intellij/platform/registry/cloud/notifications/NotificationsUpdater\n*L\n35#1:98\n35#1:99,2\n41#1:101,12\n*E\n"})
public final class NotificationsUpdater
implements Updater {
    @NotNull
    private final UpdateConfig config;
    public static final int $stable = 8;

    public NotificationsUpdater(@NotNull UpdateConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Update read(@NotNull UpdatesRoot document) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Iterable $this$filter$iv = document.getNotifications();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            NotificationUpdateDto it = (NotificationUpdateDto)element$iv$iv;
            boolean bl = false;
            if (!(CommonKt.matchesProducts(this.config, it) && CommonKt.matchesDate(this.config, it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List notifications = (List)destination$iv$iv;
        return new NotificationUpdate(notifications);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object apply(@NotNull List<? extends Update> updates2, @NotNull Continuation<? super Unit> $completion) {
        List<NotificationUpdateDto> notifications;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = updates2;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof NotificationUpdate)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        NotificationUpdate notificationUpdate = (NotificationUpdate)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        List<NotificationUpdateDto> list = notifications = notificationUpdate != null ? notificationUpdate.getNotifications() : null;
        if (notifications == null) {
            return Unit.INSTANCE;
        }
        Object object = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(notifications, this, null){
            int label;
            final /* synthetic */ List<NotificationUpdateDto> $notifications;
            final /* synthetic */ NotificationsUpdater this$0;
            {
                this.$notifications = $notifications;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        for (NotificationUpdateDto alert : this.$notifications) {
                            Notification notification = NotificationGroupManager.getInstance().getNotificationGroup("System Messages").createNotification(alert.getTitle(), alert.getText(), NotificationsUpdater.access$mapType(this.this$0, alert.getType()));
                            notification.setDisplayId("cloud.config.alert");
                            notification.configureDoNotAskOption(alert.getId(), alert.getTitle());
                            if (alert.getIcon() != null) {
                                String string = alert.getIcon();
                                ClassLoader classLoader = AllIcons.class.getClassLoader();
                                Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
                                Icon swingIcon = ImageDataByPathLoaderKt.getReflectiveIcon((String)string, (ClassLoader)classLoader);
                                if (swingIcon != null) {
                                    notification.setIcon(swingIcon);
                                }
                            }
                            if (!notification.canShowFor(null)) {
                                NotificationsUpdaterKt.access$getLog$p().debug("Alert '" + alert.getId() + "' is dismissed, do not show");
                                continue;
                            }
                            notification.setSuggestionType(true);
                            notification.setImportant(true);
                            for (ActionDto action : alert.getActions()) {
                                AnAction anAction;
                                CloudRegistryAction foundAction = ActionsRegistryKt.getActionIfAllowed(action.getId());
                                if (foundAction == null) {
                                    NotificationsUpdaterKt.access$getLog$p().warn("Unknown action '" + action.getId() + "' in notification '" + alert.getId() + "'");
                                    continue;
                                }
                                String string = action.getTitle();
                                Map map = action.getContext();
                                if (map == null) {
                                    map = MapsKt.emptyMap();
                                }
                                if ((anAction = ActionsKt.asAnAction(foundAction, string, map, notification)) == null) continue;
                                notification.addAction(anAction);
                            }
                            notification.addAction((AnAction)NotificationAction.createSimpleExpiring((String)IdeBundle.message((String)"action.Anonymous.text.do.not.show.again", (Object[])new Object[0]), () -> apply.2.invokeSuspend$lambda$0(notification)));
                            Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
                            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
                            for (Project project : projectArray) {
                                Intrinsics.checkNotNull((Object)project);
                                Project p = project;
                                notification.notify(p);
                            }
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$0(Notification $notification) {
                $notification.setDoNotAskFor(null);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final NotificationType mapType(NotificationUpdateTypeDto type) {
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> NotificationType.INFORMATION;
            case 2 -> NotificationType.WARNING;
            case 3 -> NotificationType.ERROR;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static final /* synthetic */ NotificationType access$mapType(NotificationsUpdater $this, NotificationUpdateTypeDto type) {
        return $this.mapType(type);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NotificationUpdateTypeDto.values().length];
            try {
                nArray[NotificationUpdateTypeDto.INFO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotificationUpdateTypeDto.WARN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotificationUpdateTypeDto.ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

