/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.clazz;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import de.plushnikov.intellij.plugin.lombokconfig.ConfigKey;
import de.plushnikov.intellij.plugin.problem.ProblemSink;
import de.plushnikov.intellij.plugin.processor.LombokPsiElementUsage;
import de.plushnikov.intellij.plugin.processor.clazz.AbstractClassProcessor;
import de.plushnikov.intellij.plugin.processor.handler.EqualsAndHashCodeToStringHandler;
import de.plushnikov.intellij.plugin.psi.LombokLightMethodBuilder;
import de.plushnikov.intellij.plugin.quickfix.PsiQuickFixFactory;
import de.plushnikov.intellij.plugin.thirdparty.LombokAddNullAnnotations;
import de.plushnikov.intellij.plugin.util.PsiAnnotationUtil;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import de.plushnikov.intellij.plugin.util.PsiMethodUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ToStringProcessor
extends AbstractClassProcessor {
    public static final String TO_STRING_METHOD_NAME = "toString";
    private static final List<String> METHOD_LIST = List.of("toString");
    private static final String INCLUDE_ANNOTATION_METHOD = "name";
    private static final String INCLUDE_ANNOTATION_RANK = "rank";
    private static final String INCLUDE_ANNOTATION_SKIP_NULL = "skipNull";

    public ToStringProcessor() {
        super((Class<? extends PsiElement>)PsiMethod.class, "lombok.ToString");
    }

    @Override
    protected Collection<String> getNamesOfPossibleGeneratedElements(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation) {
        if (psiClass == null) {
            ToStringProcessor.$$$reportNull$$$0(0);
        }
        if (psiAnnotation == null) {
            ToStringProcessor.$$$reportNull$$$0(1);
        }
        return METHOD_LIST;
    }

    @Override
    protected boolean validate(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiClass, @NotNull ProblemSink problemSink) {
        if (psiAnnotation == null) {
            ToStringProcessor.$$$reportNull$$$0(2);
        }
        if (psiClass == null) {
            ToStringProcessor.$$$reportNull$$$0(3);
        }
        if (problemSink == null) {
            ToStringProcessor.$$$reportNull$$$0(4);
        }
        ToStringProcessor.validateAnnotationOnRightType(psiClass, problemSink);
        if (problemSink.success()) {
            ToStringProcessor.validateExistingMethods(psiClass, problemSink);
        }
        if (problemSink.deepValidation()) {
            Collection<String> excludeProperty = PsiAnnotationUtil.getAnnotationValues(psiAnnotation, "exclude", String.class, List.of());
            Collection<String> ofProperty = PsiAnnotationUtil.getAnnotationValues(psiAnnotation, "of", String.class, List.of());
            if (!excludeProperty.isEmpty() && !ofProperty.isEmpty()) {
                problemSink.addWarningMessage("inspection.message.exclude.are.mutually.exclusive.exclude.parameter.will.be.ignored", new Object[0]).withLocalQuickFixes(() -> PsiQuickFixFactory.createChangeAnnotationParameterFix(psiAnnotation, "exclude", null));
            } else {
                ToStringProcessor.validateExcludeParam(psiClass, problemSink, psiAnnotation, excludeProperty);
            }
            ToStringProcessor.validateOfParam(psiClass, problemSink, psiAnnotation, ofProperty);
        }
        return problemSink.success();
    }

    private static void validateAnnotationOnRightType(@NotNull PsiClass psiClass, @NotNull ProblemSink builder) {
        if (psiClass == null) {
            ToStringProcessor.$$$reportNull$$$0(5);
        }
        if (builder == null) {
            ToStringProcessor.$$$reportNull$$$0(6);
        }
        if (psiClass.isAnnotationType() || psiClass.isInterface() || psiClass.isRecord()) {
            builder.addErrorMessage("inspection.message.to.string.only.supported.on.class.or.enum.type", new Object[0]);
            builder.markFailed();
        }
    }

    private static void validateExistingMethods(@NotNull PsiClass psiClass, @NotNull ProblemSink builder) {
        boolean methodAlreadyExists;
        if (psiClass == null) {
            ToStringProcessor.$$$reportNull$$$0(7);
        }
        if (builder == null) {
            ToStringProcessor.$$$reportNull$$$0(8);
        }
        if (methodAlreadyExists = ToStringProcessor.hasToStringMethodDefined(psiClass)) {
            builder.addWarningMessage("inspection.message.not.generated.s.method.with.same.name.already.exists", TO_STRING_METHOD_NAME).withLocalQuickFixes(() -> PsiQuickFixFactory.createDeleteAnnotationFix(psiClass, "lombok.ToString"));
            builder.markFailed();
        }
    }

    private static boolean hasToStringMethodDefined(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            ToStringProcessor.$$$reportNull$$$0(9);
        }
        Collection<PsiMethod> classMethods = PsiClassUtil.collectClassMethodsIntern(psiClass);
        return PsiMethodUtil.hasMethodByName(classMethods, TO_STRING_METHOD_NAME, 0);
    }

    @Override
    protected void generatePsiElements(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull List<? super PsiElement> target, @Nullable String nameHint) {
        if (psiClass == null) {
            ToStringProcessor.$$$reportNull$$$0(10);
        }
        if (psiAnnotation == null) {
            ToStringProcessor.$$$reportNull$$$0(11);
        }
        if (target == null) {
            ToStringProcessor.$$$reportNull$$$0(12);
        }
        target.addAll(this.createToStringMethod(psiClass, psiAnnotation));
    }

    @NotNull
    Collection<PsiMethod> createToStringMethod(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation) {
        if (psiClass == null) {
            ToStringProcessor.$$$reportNull$$$0(13);
        }
        if (psiAnnotation == null) {
            ToStringProcessor.$$$reportNull$$$0(14);
        }
        if (ToStringProcessor.hasToStringMethodDefined(psiClass)) {
            List<PsiMethod> list = Collections.emptyList();
            if (list == null) {
                ToStringProcessor.$$$reportNull$$$0(15);
            }
            return list;
        }
        Collection<EqualsAndHashCodeToStringHandler.MemberInfo> memberInfos = EqualsAndHashCodeToStringHandler.filterMembers(psiClass, psiAnnotation, false, INCLUDE_ANNOTATION_METHOD, ConfigKey.TOSTRING_ONLY_EXPLICITLY_INCLUDED, "lombok.ToString.Include", "lombok.ToString.Exclude");
        PsiMethod stringMethod = this.createToStringMethod(psiClass, memberInfos, psiAnnotation, false);
        List<PsiMethod> list = Collections.singletonList(stringMethod);
        if (list == null) {
            ToStringProcessor.$$$reportNull$$$0(16);
        }
        return list;
    }

    @NotNull
    public PsiMethod createToStringMethod(@NotNull PsiClass psiClass, @NotNull Collection<EqualsAndHashCodeToStringHandler.MemberInfo> memberInfos, @NotNull PsiAnnotation psiAnnotation, boolean forceCallSuper) {
        if (psiClass == null) {
            ToStringProcessor.$$$reportNull$$$0(17);
        }
        if (memberInfos == null) {
            ToStringProcessor.$$$reportNull$$$0(18);
        }
        if (psiAnnotation == null) {
            ToStringProcessor.$$$reportNull$$$0(19);
        }
        PsiManager psiManager = psiClass.getManager();
        String paramString = this.createParamString(psiClass, memberInfos, psiAnnotation, forceCallSuper);
        String blockText = String.format("return \"%s(%s)\";", ToStringProcessor.getSimpleClassName(psiClass), paramString);
        LombokLightMethodBuilder methodBuilder = new LombokLightMethodBuilder(psiManager, TO_STRING_METHOD_NAME).withMethodReturnType((PsiType)PsiType.getJavaLangString((PsiManager)psiManager, (GlobalSearchScope)GlobalSearchScope.allScope((Project)psiClass.getProject()))).withContainingClass(psiClass).withNavigationElement((PsiElement)psiAnnotation).withModifier("public").withBodyText(blockText);
        LombokAddNullAnnotations.createRelevantNonNullAnnotation(psiClass, methodBuilder);
        for (EqualsAndHashCodeToStringHandler.MemberInfo memberInfo : memberInfos) {
            methodBuilder.withRelatedMember((PsiElement)memberInfo.getField());
        }
        LombokLightMethodBuilder lombokLightMethodBuilder = methodBuilder;
        if (lombokLightMethodBuilder == null) {
            ToStringProcessor.$$$reportNull$$$0(20);
        }
        return lombokLightMethodBuilder;
    }

    private static String getSimpleClassName(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            ToStringProcessor.$$$reportNull$$$0(21);
        }
        StringBuilder psiClassName = new StringBuilder();
        PsiClass containingClass = psiClass;
        do {
            if (!psiClassName.isEmpty()) {
                psiClassName.insert(0, '.');
            }
            psiClassName.insert(0, containingClass.getName());
        } while (null != (containingClass = containingClass.getContainingClass()));
        return psiClassName.toString();
    }

    private String createParamString(@NotNull PsiClass psiClass, @NotNull Collection<EqualsAndHashCodeToStringHandler.MemberInfo> memberInfos, @NotNull PsiAnnotation psiAnnotation, boolean forceCallSuper) {
        if (psiClass == null) {
            ToStringProcessor.$$$reportNull$$$0(22);
        }
        if (memberInfos == null) {
            ToStringProcessor.$$$reportNull$$$0(23);
        }
        if (psiAnnotation == null) {
            ToStringProcessor.$$$reportNull$$$0(24);
        }
        boolean callSuper = forceCallSuper || this.readCallSuperAnnotationOrConfigProperty(psiAnnotation, psiClass, ConfigKey.TOSTRING_CALL_SUPER);
        boolean doNotUseGetters = this.readAnnotationOrConfigProperty(psiAnnotation, psiClass, "doNotUseGetters", ConfigKey.TOSTRING_DO_NOT_USE_GETTERS);
        boolean includeFieldNames = this.readAnnotationOrConfigProperty(psiAnnotation, psiClass, "includeFieldNames", ConfigKey.TOSTRING_INCLUDE_FIELD_NAMES);
        StringBuilder paramString = new StringBuilder();
        if (callSuper) {
            paramString.append("super=\" + super.toString() + \", ");
        }
        for (EqualsAndHashCodeToStringHandler.MemberInfo memberInfo : memberInfos) {
            if (includeFieldNames) {
                paramString.append(memberInfo.getName()).append('=');
            }
            paramString.append("\"+");
            PsiType classFieldType = memberInfo.getType();
            if (classFieldType instanceof PsiArrayType) {
                PsiType componentType = ((PsiArrayType)classFieldType).getComponentType();
                if (componentType instanceof PsiPrimitiveType) {
                    paramString.append("java.util.Arrays.toString(");
                } else {
                    paramString.append("java.util.Arrays.deepToString(");
                }
            }
            String memberAccessor = EqualsAndHashCodeToStringHandler.getMemberAccessorName(memberInfo, doNotUseGetters, psiClass);
            paramString.append("this.").append(memberAccessor);
            if (classFieldType instanceof PsiArrayType) {
                paramString.append(")");
            }
            paramString.append("+\", ");
        }
        if (paramString.length() > 2) {
            paramString.delete(paramString.length() - 2, paramString.length());
        }
        return paramString.toString();
    }

    @Override
    @NotNull
    public Collection<PsiAnnotation> collectProcessedAnnotations(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            ToStringProcessor.$$$reportNull$$$0(25);
        }
        Collection<PsiAnnotation> result = super.collectProcessedAnnotations(psiClass);
        this.addFieldsAnnotation(result, psiClass, "lombok.ToString.Include", "lombok.ToString.Exclude");
        Collection<PsiAnnotation> collection = result;
        if (collection == null) {
            ToStringProcessor.$$$reportNull$$$0(26);
        }
        return collection;
    }

    @Override
    public LombokPsiElementUsage checkFieldUsage(@NotNull PsiField psiField, @NotNull PsiAnnotation psiAnnotation) {
        PsiClass containingClass;
        if (psiField == null) {
            ToStringProcessor.$$$reportNull$$$0(27);
        }
        if (psiAnnotation == null) {
            ToStringProcessor.$$$reportNull$$$0(28);
        }
        if (null != (containingClass = psiField.getContainingClass())) {
            String psiFieldName = psiField.getName();
            Collection<EqualsAndHashCodeToStringHandler.MemberInfo> memberInfos = EqualsAndHashCodeToStringHandler.filterMembers(containingClass, psiAnnotation, false, INCLUDE_ANNOTATION_METHOD, ConfigKey.TOSTRING_ONLY_EXPLICITLY_INCLUDED, "lombok.ToString.Include", "lombok.ToString.Exclude");
            if (memberInfos.stream().filter(EqualsAndHashCodeToStringHandler.MemberInfo::isField).map(EqualsAndHashCodeToStringHandler.MemberInfo::getName).anyMatch(psiFieldName::equals)) {
                return LombokPsiElementUsage.READ;
            }
        }
        return LombokPsiElementUsage.NONE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 15, 16, 20, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: 
            case 2: 
            case 11: 
            case 14: 
            case 19: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemSink";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 15: 
            case 16: 
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/clazz/ToStringProcessor";
                break;
            }
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberInfos";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/clazz/ToStringProcessor";
                break;
            }
            case 15: 
            case 16: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createToStringMethod";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "collectProcessedAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNamesOfPossibleGeneratedElements";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "validateAnnotationOnRightType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "validateExistingMethods";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "hasToStringMethodDefined";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "generatePsiElements";
                break;
            }
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createToStringMethod";
                break;
            }
            case 15: 
            case 16: 
            case 20: 
            case 26: {
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleClassName";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createParamString";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "collectProcessedAnnotations";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "checkFieldUsage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 15, 16, 20, 26 -> new IllegalStateException(string);
        };
    }
}

