/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.CommonBundle;
import com.intellij.codeEditor.JavaEditorFileSwapper;
import com.intellij.codeInsight.AttachSourcesProvider;
import com.intellij.codeInsight.AttachSourcesProviderFilter;
import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.java.JavaPluginDisposable;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemSourceAttachCollector;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.LibrarySourceRootDetectorUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.compiled.ClsParsingUtil;
import com.intellij.psi.util.JavaMultiReleaseUtil;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.GuiUtils;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@VisibleForTesting
public final class AttachSourcesNotificationProvider
implements EditorNotificationProvider {
    private static final ExtensionPointName<AttachSourcesProvider> EXTENSION_POINT_NAME = new ExtensionPointName("com.intellij.attachSourcesProvider");

    @Nullable
    public @Nullable Function<? super @NotNull FileEditor, ? extends @Nullable JComponent> collectNotificationData(@NotNull Project project2, @NotNull VirtualFile file) {
        VirtualFile baseSource;
        if (project2 == null) {
            AttachSourcesNotificationProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            AttachSourcesNotificationProvider.$$$reportNull$$$0(1);
        }
        if (!FileTypeRegistry.getInstance().isFileOfType(file, (FileType)JavaClassFileType.INSTANCE)) {
            return null;
        }
        String classFileInfo = AttachSourcesNotificationProvider.getTextWithClassFileInfo(file);
        Function<FileEditor, EditorNotificationPanel> notificationPanelCreator = fileEditor -> new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Info).text(classFileInfo);
        VirtualFile sourceFile = JavaEditorFileSwapper.findSourceFile((Project)project2, (VirtualFile)file);
        if (sourceFile != null) {
            return notificationPanelCreator.andThen(panel2 -> {
                AttachSourcesNotificationProvider.appendOpenFileAction(project2, panel2, sourceFile, JavaUiBundle.message("class.file.open.source.action", new Object[0]));
                return panel2;
            });
        }
        List<? extends LibraryOrderEntry> libraries = AttachSourcesNotificationProvider.findLibraryEntriesForFile(file, project2);
        if (libraries.isEmpty()) {
            return notificationPanelCreator;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(file);
        VirtualFile baseFile = JavaMultiReleaseUtil.findBaseFile((VirtualFile)file);
        if (baseFile != null && (baseSource = JavaEditorFileSwapper.findSourceFile((Project)project2, (VirtualFile)baseFile)) != null) {
            return notificationPanelCreator.andThen(panel2 -> {
                AttachSourcesNotificationProvider.appendOpenFileAction(project2, panel2, baseSource, JavaUiBundle.message("class.file.open.source.version.specific.action", new Object[0]));
                return panel2;
            });
        }
        List actionsByFile = psiFile != null ? AttachSourcesNotificationProvider.collectActions(libraries, psiFile) : List.of();
        boolean sourceFileIsInSameJar = AttachSourcesNotificationProvider.sourceFileIsInSameJar(file);
        return notificationPanelCreator.andThen(panel2 -> {
            ArrayList<AttachJarAsSourcesAction> actions = new ArrayList<AttachJarAsSourcesAction>(actionsByFile);
            Object defaultAction = sourceFileIsInSameJar ? new AttachJarAsSourcesAction(file) : new ChooseAndAttachSourcesAction(project2, (JComponent)panel2);
            actions.add((AttachJarAsSourcesAction)defaultAction);
            for (AttachSourcesProvider.AttachSourcesAction attachSourcesAction : actions) {
                panel2.createActionLabel(GuiUtils.getTextWithoutMnemonicEscaping((String)attachSourcesAction.getName()), () -> AttachSourcesNotificationProvider.findLibraryEntriesForFile(project2, file, libraries, entries -> {
                    String originalText = panel2.getText();
                    panel2.setText(action.getBusyText());
                    long started = System.currentTimeMillis();
                    ActionCallback callback = action.perform(entries);
                    callback.doWhenProcessed(() -> {
                        panel2.setText(originalText);
                        if (psiFile != null) {
                            ExternalSystemSourceAttachCollector.onSourcesAttached((Project)project2, (Class)action.getClass(), (Language)psiFile.getLanguage(), (boolean)callback.isDone(), (long)(System.currentTimeMillis() - started));
                        }
                    });
                }));
            }
            return panel2;
        });
    }

    private static void appendOpenFileAction(@NotNull Project project2, EditorNotificationPanel panel2, VirtualFile sourceFile, @NotNull @Nls String title) {
        if (project2 == null) {
            AttachSourcesNotificationProvider.$$$reportNull$$$0(2);
        }
        if (title == null) {
            AttachSourcesNotificationProvider.$$$reportNull$$$0(3);
        }
        panel2.createActionLabel(title, () -> {
            if (sourceFile.isValid()) {
                OpenFileDescriptor descriptor = new OpenFileDescriptor(project2, sourceFile);
                FileEditorManager.getInstance((Project)project2).openTextEditor(descriptor, true);
            }
        });
    }

    @RequiresEdt
    private static void findLibraryEntriesForFile(@NotNull Project project2, @NotNull VirtualFile file, @NotNull List<? extends LibraryOrderEntry> originalLibraries, @NotNull Consumer<? super List<? extends LibraryOrderEntry>> uiThreadAction) {
        if (project2 == null) {
            AttachSourcesNotificationProvider.$$$reportNull$$$0(4);
        }
        if (file == null) {
            AttachSourcesNotificationProvider.$$$reportNull$$$0(5);
        }
        if (originalLibraries == null) {
            AttachSourcesNotificationProvider.$$$reportNull$$$0(6);
        }
        if (uiThreadAction == null) {
            AttachSourcesNotificationProvider.$$$reportNull$$$0(7);
        }
        ThreadingAssertions.assertEventDispatchThread();
        ReadAction.nonBlocking(() -> {
            List<? extends LibraryOrderEntry> libraries = AttachSourcesNotificationProvider.findLibraryEntriesForFile(file, project2);
            if (Comparing.equal((Object)originalLibraries, libraries)) {
                return libraries;
            }
            throw new RuntimeException(JavaUiBundle.message("can.t.find.library.for.0", file.getName()));
        }).expireWith((Disposable)JavaPluginDisposable.getInstance((Project)project2)).expireWhen(() -> !file.isValid()).coalesceBy(new Object[]{file, project2}).finishOnUiThread(ModalityState.current(), uiThreadAction).submit((Executor)NonUrgentExecutor.getInstance()).onError(rejected -> {
            if (rejected instanceof CancellationException) {
                return;
            }
            SwingUtilities.invokeLater(() -> Messages.showErrorDialog((Project)project2, (String)rejected.getLocalizedMessage(), (String)CommonBundle.message((String)"title.error", (Object[])new Object[0])));
        });
    }

    @NotNull
    private static List<? extends AttachSourcesProvider.AttachSourcesAction> collectActions(@NotNull List<? extends LibraryOrderEntry> libraries, @NotNull PsiFile classFile) {
        if (libraries == null) {
            AttachSourcesNotificationProvider.$$$reportNull$$$0(8);
        }
        if (classFile == null) {
            AttachSourcesNotificationProvider.$$$reportNull$$$0(9);
        }
        ArrayList<AttachSourcesProvider.AttachSourcesAction> actions = new ArrayList<AttachSourcesProvider.AttachSourcesAction>();
        boolean hasNonLightAction = false;
        for (AttachSourcesProvider provider : EXTENSION_POINT_NAME.getExtensionList()) {
            if (!AttachSourcesProviderFilter.isProviderApplicable((AttachSourcesProvider)provider, libraries, (PsiFile)classFile)) continue;
            for (AttachSourcesProvider.AttachSourcesAction action : provider.getActions(libraries, classFile)) {
                if (hasNonLightAction) {
                    if (action instanceof AttachSourcesProvider.LightAttachSourcesAction) {
                        continue;
                    }
                } else if (!(action instanceof AttachSourcesProvider.LightAttachSourcesAction)) {
                    actions.clear();
                    hasNonLightAction = true;
                }
                actions.add(action);
            }
        }
        actions.sort((o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
        List list2 = Collections.unmodifiableList(actions);
        if (list2 == null) {
            AttachSourcesNotificationProvider.$$$reportNull$$$0(10);
        }
        return list2;
    }

    @NlsContexts.Label
    @RequiresBackgroundThread
    @NotNull
    private static String getTextWithClassFileInfo(@NotNull VirtualFile file) {
        StringBuilder info;
        block13: {
            if (file == null) {
                AttachSourcesNotificationProvider.$$$reportNull$$$0(11);
            }
            ThreadingAssertions.assertBackgroundThread();
            LanguageLevel level = JavaMultiReleaseUtil.getVersion((VirtualFile)file);
            info = new StringBuilder();
            if (level != null) {
                info.append(JavaUiBundle.message("class.file.multi.release.decompiled.text", level.feature()));
            } else {
                info.append(JavaUiBundle.message("class.file.decompiled.text", new Object[0]));
            }
            try {
                byte[] data = file.contentsToByteArray(false);
                if (data.length <= 8) break block13;
                try (DataInputStream stream = new DataInputStream(new ByteArrayInputStream(data));){
                    if (stream.readInt() == -889275714) {
                        int minor = stream.readUnsignedShort();
                        int major = stream.readUnsignedShort();
                        info.append(", ").append(JavaUiBundle.message("class.file.decompiled.bytecode.version.text", major, minor));
                        JavaSdkVersion sdkVersion = ClsParsingUtil.getJdkVersionByBytecode((int)major);
                        if (sdkVersion != null) {
                            info.append(" ").append(JavaUiBundle.message("class.file.decompiled.sdk.version.text", AttachSourcesNotificationProvider.getSdkDescription(sdkVersion, ClsParsingUtil.isPreviewLevel((int)minor))));
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        String string = info.toString();
        if (string == null) {
            AttachSourcesNotificationProvider.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    private static String getSdkDescription(@NotNull JavaSdkVersion sdkVersion, boolean isPreview) {
        if (sdkVersion == null) {
            AttachSourcesNotificationProvider.$$$reportNull$$$0(13);
        }
        String string = sdkVersion.getDescription() + (sdkVersion.isAtLeast(JavaSdkVersion.JDK_11) && isPreview ? "-preview" : "");
        if (string == null) {
            AttachSourcesNotificationProvider.$$$reportNull$$$0(14);
        }
        return string;
    }

    @RequiresReadLock
    @NotNull
    private static List<? extends LibraryOrderEntry> findLibraryEntriesForFile(@NotNull VirtualFile file, @NotNull Project project2) {
        if (file == null) {
            AttachSourcesNotificationProvider.$$$reportNull$$$0(15);
        }
        if (project2 == null) {
            AttachSourcesNotificationProvider.$$$reportNull$$$0(16);
        }
        ThreadingAssertions.softAssertReadAccess();
        ArrayList<LibraryOrderEntry> entries = new ArrayList<LibraryOrderEntry>();
        for (OrderEntry entry : ProjectFileIndex.getInstance((Project)project2).getOrderEntriesForFile(file)) {
            if (!(entry instanceof LibraryOrderEntry)) continue;
            entries.add((LibraryOrderEntry)entry);
        }
        ArrayList<LibraryOrderEntry> arrayList = entries;
        if (arrayList == null) {
            AttachSourcesNotificationProvider.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    private static boolean sourceFileIsInSameJar(@NotNull VirtualFile classFile) {
        String name;
        int i;
        if (classFile == null) {
            AttachSourcesNotificationProvider.$$$reportNull$$$0(18);
        }
        if ((i = (name = classFile.getName()).indexOf(36)) != -1) {
            name = name.substring(0, i);
        }
        if ((i = name.indexOf(46)) != -1) {
            name = name.substring(0, i);
        }
        return classFile.getParent().findChild(name + ".java") != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 12, 14, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalLibraries";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiThreadAction";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraries";
                break;
            }
            case 9: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFile";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/AttachSourcesNotificationProvider";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/AttachSourcesNotificationProvider";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "collectActions";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextWithClassFileInfo";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkDescription";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "findLibraryEntriesForFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectNotificationData";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "appendOpenFileAction";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findLibraryEntriesForFile";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "collectActions";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 17: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getTextWithClassFileInfo";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSdkDescription";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "sourceFileIsInSameJar";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 12, 14, 17 -> new IllegalStateException(string);
        };
    }

    private static class AttachJarAsSourcesAction
    implements AttachSourcesProvider.AttachSourcesAction {
        @NotNull
        private final VirtualFile myClassFile;

        AttachJarAsSourcesAction(@NotNull VirtualFile classFile) {
            if (classFile == null) {
                AttachJarAsSourcesAction.$$$reportNull$$$0(0);
            }
            this.myClassFile = classFile;
        }

        public String getName() {
            return JavaUiBundle.message("module.libraries.attach.sources.button", new Object[0]);
        }

        public String getBusyText() {
            return JavaUiBundle.message("library.attach.sources.action.busy.text", new Object[0]);
        }

        @NotNull
        public ActionCallback perform(@NotNull List<? extends LibraryOrderEntry> orderEntriesContainingFile) {
            if (orderEntriesContainingFile == null) {
                AttachJarAsSourcesAction.$$$reportNull$$$0(1);
            }
            ArrayList<Library.ModifiableModel> modelsToCommit = new ArrayList<Library.ModifiableModel>();
            for (LibraryOrderEntry libraryOrderEntry : orderEntriesContainingFile) {
                VirtualFile root;
                Library library = libraryOrderEntry.getLibrary();
                if (library == null || (root = this.findRoot(library)) == null) continue;
                Library.ModifiableModel model = library.getModifiableModel();
                model.addRoot(root, OrderRootType.SOURCES);
                modelsToCommit.add(model);
            }
            if (modelsToCommit.isEmpty()) {
                ActionCallback actionCallback = ActionCallback.REJECTED;
                if (actionCallback == null) {
                    AttachJarAsSourcesAction.$$$reportNull$$$0(2);
                }
                return actionCallback;
            }
            WriteAction.runAndWait(() -> {
                for (Library.ModifiableModel model : modelsToCommit) {
                    model.commit();
                }
            });
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                AttachJarAsSourcesAction.$$$reportNull$$$0(3);
            }
            return actionCallback;
        }

        @Nullable
        private VirtualFile findRoot(Library library) {
            for (VirtualFile classesRoot : library.getFiles(OrderRootType.CLASSES)) {
                if (!VfsUtilCore.isAncestor((VirtualFile)classesRoot, (VirtualFile)this.myClassFile, (boolean)true)) continue;
                return classesRoot;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "orderEntriesContainingFile";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/AttachSourcesNotificationProvider$AttachJarAsSourcesAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/AttachSourcesNotificationProvider$AttachJarAsSourcesAction";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "perform";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "perform";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class ChooseAndAttachSourcesAction
    implements AttachSourcesProvider.AttachSourcesAction {
        @NotNull
        private final Project myProject;
        @NotNull
        private final JComponent myParentComponent;

        ChooseAndAttachSourcesAction(@NotNull Project project2, @NotNull JComponent parentComponent) {
            if (project2 == null) {
                ChooseAndAttachSourcesAction.$$$reportNull$$$0(0);
            }
            if (parentComponent == null) {
                ChooseAndAttachSourcesAction.$$$reportNull$$$0(1);
            }
            this.myProject = project2;
            this.myParentComponent = parentComponent;
        }

        public String getName() {
            return JavaUiBundle.message("module.libraries.choose.sources.button", new Object[0]);
        }

        public String getBusyText() {
            return JavaUiBundle.message("library.attach.sources.action.busy.text", new Object[0]);
        }

        @NotNull
        public ActionCallback perform(@NotNull List<? extends LibraryOrderEntry> libraries) {
            if (libraries == null) {
                ChooseAndAttachSourcesAction.$$$reportNull$$$0(2);
            }
            FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createMultipleJavaPathDescriptor();
            descriptor.setTitle(JavaUiBundle.message("library.attach.sources.action", new Object[0]));
            descriptor.setDescription(JavaUiBundle.message("library.attach.sources.description", new Object[0]));
            Library firstLibrary = libraries.get(0).getLibrary();
            VirtualFile[] roots = firstLibrary != null ? firstLibrary.getFiles(OrderRootType.CLASSES) : VirtualFile.EMPTY_ARRAY;
            VirtualFile[] candidates = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)this.myProject, roots.length == 0 ? null : VfsUtil.getLocalFile((VirtualFile)roots[0]));
            if (candidates.length == 0) {
                ActionCallback actionCallback = ActionCallback.REJECTED;
                if (actionCallback == null) {
                    ChooseAndAttachSourcesAction.$$$reportNull$$$0(3);
                }
                return actionCallback;
            }
            final VirtualFile[] files = LibrarySourceRootDetectorUtil.scanAndSelectDetectedJavaSourceRoots(this.myParentComponent, candidates);
            if (files.length == 0) {
                ActionCallback actionCallback = ActionCallback.REJECTED;
                if (actionCallback == null) {
                    ChooseAndAttachSourcesAction.$$$reportNull$$$0(4);
                }
                return actionCallback;
            }
            final HashMap<Library, LibraryOrderEntry> librariesToAppendSourcesTo = new HashMap<Library, LibraryOrderEntry>();
            for (LibraryOrderEntry libraryOrderEntry : libraries) {
                librariesToAppendSourcesTo.put(libraryOrderEntry.getLibrary(), libraryOrderEntry);
            }
            if (librariesToAppendSourcesTo.size() == 1) {
                ChooseAndAttachSourcesAction.appendSources(firstLibrary, files);
            } else {
                librariesToAppendSourcesTo.put(null, null);
                String title = JavaUiBundle.message("library.choose.one.to.attach", new Object[0]);
                ArrayList arrayList = new ArrayList(librariesToAppendSourcesTo.values());
                JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<LibraryOrderEntry>(this, title, arrayList){

                    public ListSeparator getSeparatorAbove(LibraryOrderEntry value) {
                        return value == null ? new ListSeparator() : null;
                    }

                    @NotNull
                    public String getTextFor(LibraryOrderEntry value) {
                        Object object = value == null ? CommonBundle.message((String)"action.text.all", (Object[])new Object[0]) : value.getPresentableName() + " (" + value.getOwnerModule().getName() + ")";
                        if (object == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return object;
                    }

                    public PopupStep<?> onChosen(LibraryOrderEntry libraryOrderEntry, boolean finalChoice) {
                        if (libraryOrderEntry != null) {
                            ChooseAndAttachSourcesAction.appendSources(libraryOrderEntry.getLibrary(), files);
                        } else {
                            for (Library libOrderEntry : librariesToAppendSourcesTo.keySet()) {
                                if (libOrderEntry == null) continue;
                                ChooseAndAttachSourcesAction.appendSources(libOrderEntry, files);
                            }
                        }
                        return FINAL_CHOICE;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/AttachSourcesNotificationProvider$ChooseAndAttachSourcesAction$1", "getTextFor"));
                    }
                }).showCenteredInCurrentWindow(this.myProject);
            }
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                ChooseAndAttachSourcesAction.$$$reportNull$$$0(5);
            }
            return actionCallback;
        }

        private static void appendSources(Library library, VirtualFile[] files) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                Library.ModifiableModel model = library.getModifiableModel();
                for (VirtualFile virtualFile : files) {
                    model.addRoot(virtualFile, OrderRootType.SOURCES);
                }
                model.commit();
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentComponent";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "libraries";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/AttachSourcesNotificationProvider$ChooseAndAttachSourcesAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/AttachSourcesNotificationProvider$ChooseAndAttachSourcesAction";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "perform";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "perform";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

