/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui.libraries;

import com.intellij.framework.library.DownloadableLibraryFileDescription;
import com.intellij.framework.library.DownloadableLibraryType;
import com.intellij.framework.library.FrameworkLibraryVersion;
import com.intellij.framework.library.LibraryVersionProperties;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.NewLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class LibraryDownloadSettings {
    private final FrameworkLibraryVersion myVersion;
    private final DownloadableLibraryType myLibraryType;
    private final String myLibrariesPath;
    private final String myLibraryName;
    private final boolean myDownloadSources;
    private final boolean myDownloadJavaDocs;
    private final LibrariesContainer.LibraryLevel myLibraryLevel;
    private final List<? extends DownloadableLibraryFileDescription> mySelectedDownloads;

    public LibraryDownloadSettings(@NotNull FrameworkLibraryVersion libraryVersion, @Nullable DownloadableLibraryType libraryType, LibrariesContainer.LibraryLevel libraryLevel, String downloadedLibrariesPath) {
        if (libraryVersion == null) {
            LibraryDownloadSettings.$$$reportNull$$$0(0);
        }
        this(libraryVersion, libraryType, downloadedLibrariesPath, libraryVersion.getDefaultLibraryName(), libraryLevel, LibraryDownloadSettings.getRequiredFiles(libraryVersion.getFiles()), true, true);
    }

    public LibraryDownloadSettings(@NotNull FrameworkLibraryVersion libraryVersion, @Nullable DownloadableLibraryType libraryType, @NotNull String librariesPath, @NotNull String libraryName, @NotNull LibrariesContainer.LibraryLevel libraryLevel, @NotNull List<? extends DownloadableLibraryFileDescription> selectedDownloads, boolean downloadSources, boolean downloadJavaDocs) {
        if (libraryVersion == null) {
            LibraryDownloadSettings.$$$reportNull$$$0(1);
        }
        if (librariesPath == null) {
            LibraryDownloadSettings.$$$reportNull$$$0(2);
        }
        if (libraryName == null) {
            LibraryDownloadSettings.$$$reportNull$$$0(3);
        }
        if (libraryLevel == null) {
            LibraryDownloadSettings.$$$reportNull$$$0(4);
        }
        if (selectedDownloads == null) {
            LibraryDownloadSettings.$$$reportNull$$$0(5);
        }
        this.myVersion = libraryVersion;
        this.myLibraryType = libraryType;
        this.myLibrariesPath = librariesPath;
        this.myLibraryName = libraryName;
        this.myDownloadSources = downloadSources;
        this.myDownloadJavaDocs = downloadJavaDocs;
        this.myLibraryLevel = libraryLevel;
        this.mySelectedDownloads = selectedDownloads;
    }

    private static @Unmodifiable List<? extends DownloadableLibraryFileDescription> getRequiredFiles(List<? extends DownloadableLibraryFileDescription> files) {
        return ContainerUtil.filter(files, description -> !description.isOptional());
    }

    @NotNull
    public FrameworkLibraryVersion getVersion() {
        FrameworkLibraryVersion frameworkLibraryVersion = this.myVersion;
        if (frameworkLibraryVersion == null) {
            LibraryDownloadSettings.$$$reportNull$$$0(6);
        }
        return frameworkLibraryVersion;
    }

    public boolean isDownloadJavaDocs() {
        return this.myDownloadJavaDocs;
    }

    public boolean isDownloadSources() {
        return this.myDownloadSources;
    }

    public String getLibraryName() {
        return this.myLibraryName;
    }

    public String getDirectoryForDownloadedLibrariesPath() {
        return this.myLibrariesPath;
    }

    public List<? extends DownloadableLibraryFileDescription> getSelectedDownloads() {
        return this.mySelectedDownloads;
    }

    @NotNull
    public LibrariesContainer.LibraryLevel getLibraryLevel() {
        LibrariesContainer.LibraryLevel libraryLevel = this.myLibraryLevel;
        if (libraryLevel == null) {
            LibraryDownloadSettings.$$$reportNull$$$0(7);
        }
        return libraryLevel;
    }

    public DownloadableLibraryType getLibraryType() {
        return this.myLibraryType;
    }

    @Nullable
    public NewLibraryEditor download(JComponent parent, @Nullable String rootPath) {
        ArrayList<? extends DownloadableLibraryFileDescription> toDownload = new ArrayList<DownloadableLibraryFileDescription>(this.mySelectedDownloads);
        HashMap<DownloadableFileDescription, OrderRootType> rootTypes = new HashMap<DownloadableFileDescription, OrderRootType>();
        for (DownloadableLibraryFileDescription downloadableLibraryFileDescription : this.mySelectedDownloads) {
            DownloadableFileDescription sources = downloadableLibraryFileDescription.getSourcesDescription();
            if (this.myDownloadSources && sources != null) {
                toDownload.add((DownloadableLibraryFileDescription)sources);
                rootTypes.put(sources, OrderRootType.SOURCES);
            }
            DownloadableFileDescription docs = downloadableLibraryFileDescription.getDocumentationDescription();
            if (!this.myDownloadJavaDocs || docs == null) continue;
            toDownload.add((DownloadableLibraryFileDescription)docs);
            rootTypes.put(docs, JavadocOrderRootType.getInstance());
        }
        String path = rootPath != null && !FileUtil.isAbsolute((String)this.myLibrariesPath) ? new File(rootPath, this.myLibrariesPath).getPath() : this.myLibrariesPath;
        List list2 = DownloadableFileService.getInstance().createDownloader(toDownload, this.myLibraryName + " Library").downloadWithProgress(path, null, parent);
        if (list2 == null) {
            return null;
        }
        NewLibraryEditor libraryEditor = this.myLibraryType != null ? new NewLibraryEditor(this.myLibraryType, new LibraryVersionProperties(this.myVersion.getVersionString())) : new NewLibraryEditor();
        libraryEditor.setName(this.myLibraryName);
        for (Pair pair : list2) {
            OrderRootType rootType = rootTypes.getOrDefault(pair.getSecond(), OrderRootType.CLASSES);
            libraryEditor.addRoot((VirtualFile)pair.getFirst(), rootType);
        }
        return libraryEditor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryVersion";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "librariesPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryLevel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedDownloads";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/facet/impl/ui/libraries/LibraryDownloadSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/facet/impl/ui/libraries/LibraryDownloadSettings";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7 -> new IllegalStateException(string);
        };
    }
}

