/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.library;

import com.intellij.framework.library.DownloadableLibraryDescription;
import com.intellij.framework.library.DownloadableLibraryService;
import com.intellij.framework.library.LibraryVersionProperties;
import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.JarVersionDetectionUtil;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.roots.libraries.ui.LibraryEditorComponent;
import com.intellij.openapi.roots.libraries.ui.LibraryPropertiesEditor;
import com.intellij.openapi.vfs.VirtualFile;
import java.net.URL;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DownloadableLibraryType
extends LibraryType<LibraryVersionProperties> {
    private final Supplier<@Nls(capitalization=Nls.Capitalization.Title) String> myLibraryCategoryName;
    private final DownloadableLibraryDescription myLibraryDescription;

    protected DownloadableLibraryType(@NotNull Supplier<@Nls(capitalization=Nls.Capitalization.Title) String> libraryCategoryName, @NotNull String libraryTypeId, @NotNull String groupId, URL ... localUrls) {
        if (libraryCategoryName == null) {
            DownloadableLibraryType.$$$reportNull$$$0(0);
        }
        if (libraryTypeId == null) {
            DownloadableLibraryType.$$$reportNull$$$0(1);
        }
        if (groupId == null) {
            DownloadableLibraryType.$$$reportNull$$$0(2);
        }
        if (localUrls == null) {
            DownloadableLibraryType.$$$reportNull$$$0(3);
        }
        super((PersistentLibraryKind)new PersistentLibraryKind<LibraryVersionProperties>(libraryTypeId){

            @NotNull
            public LibraryVersionProperties createDefaultProperties() {
                return new LibraryVersionProperties();
            }
        });
        this.myLibraryCategoryName = libraryCategoryName;
        this.myLibraryDescription = DownloadableLibraryService.getInstance().createLibraryDescription(groupId, localUrls);
    }

    @Nullable
    private static LibraryVersionProperties detectVersion(List<? extends VirtualFile> classesRoots, String detectionClass) {
        if (!LibraryUtil.isClassAvailableInLibrary(classesRoots, (String)detectionClass)) {
            return null;
        }
        String version = JarVersionDetectionUtil.detectJarVersion((String)detectionClass, classesRoots);
        return new LibraryVersionProperties(version);
    }

    public String getCreateActionName() {
        return null;
    }

    public NewLibraryConfiguration createNewLibrary(@NotNull JComponent parentComponent, @Nullable VirtualFile contextDirectory, @NotNull Project project2) {
        if (parentComponent == null) {
            DownloadableLibraryType.$$$reportNull$$$0(4);
        }
        if (project2 == null) {
            DownloadableLibraryType.$$$reportNull$$$0(5);
        }
        return null;
    }

    @NotNull
    public DownloadableLibraryDescription getLibraryDescription() {
        DownloadableLibraryDescription downloadableLibraryDescription = this.myLibraryDescription;
        if (downloadableLibraryDescription == null) {
            DownloadableLibraryType.$$$reportNull$$$0(6);
        }
        return downloadableLibraryDescription;
    }

    public String getLibraryCategoryName() {
        return this.myLibraryCategoryName.get();
    }

    public String getDescription(@NotNull LibraryVersionProperties properties) {
        String versionString;
        if (properties == null) {
            DownloadableLibraryType.$$$reportNull$$$0(7);
        }
        int versionStringPresent = (versionString = properties.getVersionString()) != null ? 0 : 1;
        return JavaUiBundle.message("downloadable.library.type.description", this.getLibraryCategoryName(), versionString, versionStringPresent);
    }

    public LibraryPropertiesEditor createPropertiesEditor(@NotNull LibraryEditorComponent<LibraryVersionProperties> editorComponent) {
        if (editorComponent == null) {
            DownloadableLibraryType.$$$reportNull$$$0(8);
        }
        return DownloadableLibraryService.getInstance().createDownloadableLibraryEditor(this.myLibraryDescription, editorComponent, this);
    }

    @NotNull
    public abstract Icon getLibraryTypeIcon();

    @NotNull
    public Icon getIcon(LibraryVersionProperties properties) {
        Icon icon = this.getLibraryTypeIcon();
        if (icon == null) {
            DownloadableLibraryType.$$$reportNull$$$0(9);
        }
        return icon;
    }

    protected abstract String @NotNull [] getDetectionClassNames();

    public LibraryVersionProperties detect(@NotNull List<VirtualFile> classesRoots) {
        if (classesRoots == null) {
            DownloadableLibraryType.$$$reportNull$$$0(10);
        }
        for (String className : this.getDetectionClassNames()) {
            LibraryVersionProperties versionProperties = DownloadableLibraryType.detectVersion(classesRoots, className);
            if (versionProperties == null) continue;
            return versionProperties;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryCategoryName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryTypeId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localUrls";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/framework/library/DownloadableLibraryType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorComponent";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/framework/library/DownloadableLibraryType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryDescription";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createNewLibrary";
                break;
            }
            case 6: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDescription";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createPropertiesEditor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 9 -> new IllegalStateException(string);
        };
    }
}

