/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.library.impl;

import com.intellij.facet.impl.ui.libraries.DownloadingOptionsDialog;
import com.intellij.facet.impl.ui.libraries.LibraryDownloadSettings;
import com.intellij.framework.library.DownloadableLibraryDescription;
import com.intellij.framework.library.DownloadableLibraryType;
import com.intellij.framework.library.FrameworkLibraryVersion;
import com.intellij.framework.library.LibraryVersionProperties;
import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.roots.libraries.ui.LibraryEditorComponent;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditorBase;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryPropertiesEditorBase;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.NewLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.download.DownloadableFileSetVersions;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DownloadableLibraryPropertiesEditor
extends LibraryPropertiesEditorBase<LibraryVersionProperties, DownloadableLibraryType> {
    private final DownloadableLibraryDescription myDescription;
    private String myCurrentVersionString;

    public DownloadableLibraryPropertiesEditor(DownloadableLibraryDescription description, LibraryEditorComponent<LibraryVersionProperties> editorComponent, DownloadableLibraryType libraryType) {
        super(editorComponent, libraryType, JavaUiBundle.message("downloadable.library.properties.change.version.title", new Object[0]));
        this.myDescription = description;
        this.myCurrentVersionString = ((LibraryVersionProperties)this.myEditorComponent.getProperties()).getVersionString();
    }

    @Override
    protected void edit() {
        final ModalityState current = ModalityState.current();
        this.myDescription.fetchVersions((DownloadableFileSetVersions.FileSetVersionsCallback)new DownloadableFileSetVersions.FileSetVersionsCallback<FrameworkLibraryVersion>(){

            public void onSuccess(@NotNull List<? extends FrameworkLibraryVersion> versions) {
                if (versions == null) {
                    1.$$$reportNull$$$0(0);
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    NewLibraryEditor editor;
                    Object pathForDownloaded = "";
                    VirtualFile existingRootDirectory = DownloadableLibraryPropertiesEditor.this.myEditorComponent.getExistingRootDirectory();
                    if (existingRootDirectory != null) {
                        pathForDownloaded = existingRootDirectory.getPath();
                    } else {
                        VirtualFile baseDir = DownloadableLibraryPropertiesEditor.this.myEditorComponent.getBaseDirectory();
                        if (baseDir != null) {
                            pathForDownloaded = baseDir.getPath() + "/lib";
                        }
                    }
                    LibraryDownloadSettings initialSettings = new LibraryDownloadSettings(DownloadableLibraryPropertiesEditor.this.getCurrentVersion(versions), (DownloadableLibraryType)DownloadableLibraryPropertiesEditor.this.myLibraryType, LibrariesContainer.LibraryLevel.PROJECT, (String)pathForDownloaded);
                    LibraryDownloadSettings settings = DownloadingOptionsDialog.showDialog(DownloadableLibraryPropertiesEditor.this.getMainPanel(), initialSettings, versions, false);
                    if (settings != null && (editor = settings.download(DownloadableLibraryPropertiesEditor.this.getMainPanel(), null)) != null) {
                        LibraryEditorBase target = (LibraryEditorBase)DownloadableLibraryPropertiesEditor.this.myEditorComponent.getLibraryEditor();
                        target.removeAllRoots();
                        DownloadableLibraryPropertiesEditor.this.myEditorComponent.renameLibrary(editor.getName());
                        target.setType(DownloadableLibraryPropertiesEditor.this.myLibraryType);
                        editor.applyTo(target);
                        DownloadableLibraryPropertiesEditor.this.myEditorComponent.updateRootsTree();
                        DownloadableLibraryPropertiesEditor.this.myCurrentVersionString = settings.getVersion().getVersionString();
                        DownloadableLibraryPropertiesEditor.this.setModified();
                    }
                }, current);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versions", "com/intellij/framework/library/impl/DownloadableLibraryPropertiesEditor$1", "onSuccess"));
            }
        });
    }

    private FrameworkLibraryVersion getCurrentVersion(List<? extends FrameworkLibraryVersion> versions) {
        for (FrameworkLibraryVersion frameworkLibraryVersion : versions) {
            if (!frameworkLibraryVersion.getVersionString().equals(this.myCurrentVersionString)) continue;
            return frameworkLibraryVersion;
        }
        return versions.get(0);
    }

    public void apply() {
        ((LibraryVersionProperties)this.myEditorComponent.getProperties()).setVersionString(this.myCurrentVersionString);
    }
}

