/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.extractModule;

import com.intellij.ide.extractModule.ExtractModuleFileProcessor;
import com.intellij.java.analysis.bytecode.ClassFileAnalyzer;
import com.intellij.java.analysis.bytecode.JvmBytecodeAnalysis;
import com.intellij.java.analysis.bytecode.JvmBytecodeReferenceProcessor;
import com.intellij.java.analysis.bytecode.JvmClassBytecodeDeclaration;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000U\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000*\u0001\r\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J$\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00042\u0014\b\u0002\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001e0\u001dR\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R#\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00120\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ide/extractModule/ExtractModuleFileProcessor;", "", "classpathToSearchImplicitReferences", "", "Ljava/nio/file/Path;", "<init>", "(Ljava/util/List;)V", "mutableReferencedClasses", "", "", "mutableGatheredClassLinks", "", "referenceProcessor", "com/intellij/ide/extractModule/ExtractModuleFileProcessor$referenceProcessor$1", "Lcom/intellij/ide/extractModule/ExtractModuleFileProcessor$referenceProcessor$1;", "classFileAnalyzer", "Lcom/intellij/java/analysis/bytecode/ClassFileAnalyzer;", "referencedClasses", "", "getReferencedClasses", "()Ljava/util/Set;", "gatheredClassLinks", "", "getGatheredClassLinks", "()Ljava/util/Map;", "processClassFiles", "", "root", "relativePathFilter", "Lkotlin/Function1;", "", "intellij.java.ui"})
public final class ExtractModuleFileProcessor {
    @NotNull
    private final Set<String> mutableReferencedClasses;
    @NotNull
    private final Map<String, Set<String>> mutableGatheredClassLinks;
    @NotNull
    private final referenceProcessor.1 referenceProcessor;
    @NotNull
    private final ClassFileAnalyzer classFileAnalyzer;

    public ExtractModuleFileProcessor(@NotNull List<? extends Path> classpathToSearchImplicitReferences) {
        Intrinsics.checkNotNullParameter(classpathToSearchImplicitReferences, (String)"classpathToSearchImplicitReferences");
        this.mutableReferencedClasses = new HashSet();
        this.mutableGatheredClassLinks = new HashMap();
        this.referenceProcessor = new JvmBytecodeReferenceProcessor(this){
            final /* synthetic */ ExtractModuleFileProcessor this$0;
            {
                this.this$0 = $receiver;
            }

            public void processClassReference(JvmClassBytecodeDeclaration targetClass, JvmClassBytecodeDeclaration sourceClass) {
                Intrinsics.checkNotNullParameter((Object)targetClass, (String)"targetClass");
                Intrinsics.checkNotNullParameter((Object)sourceClass, (String)"sourceClass");
                String targetClassName = targetClass.getTopLevelSourceClassName();
                if (StringsKt.startsWith$default((String)targetClassName, (String)"[L", (boolean)false, (int)2, null)) {
                    return;
                }
                String sourceClassName = sourceClass.getTopLevelSourceClassName();
                if (!Intrinsics.areEqual((Object)sourceClassName, (Object)targetClassName)) {
                    ExtractModuleFileProcessor.access$getMutableReferencedClasses$p(this.this$0).add(targetClassName);
                    ExtractModuleFileProcessor.access$getMutableGatheredClassLinks$p(this.this$0).computeIfAbsent(sourceClassName, arg_0 -> referenceProcessor.1.processClassReference$lambda$1(referenceProcessor.1::processClassReference$lambda$0, arg_0)).add(targetClassName);
                }
            }

            private static final Set processClassReference$lambda$0(String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new HashSet<E>();
            }

            private static final Set processClassReference$lambda$1(Function1 $tmp0, Object p0) {
                return (Set)$tmp0.invoke(p0);
            }
        };
        this.classFileAnalyzer = classpathToSearchImplicitReferences.isEmpty() ? JvmBytecodeAnalysis.Companion.getInstance().createReferenceAnalyzer((JvmBytecodeReferenceProcessor)this.referenceProcessor) : JvmBytecodeAnalysis.Companion.getInstance().createReferenceAnalyzerWithImplicitSuperclassReferences((JvmBytecodeReferenceProcessor)this.referenceProcessor, classpathToSearchImplicitReferences);
    }

    public /* synthetic */ ExtractModuleFileProcessor(List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(list2);
    }

    @NotNull
    public final Set<String> getReferencedClasses() {
        return this.mutableReferencedClasses;
    }

    @NotNull
    public final Map<String, Set<String>> getGatheredClassLinks() {
        return this.mutableGatheredClassLinks;
    }

    public final void processClassFiles(@NotNull Path root, @NotNull Function1<? super String, Boolean> relativePathFilter) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(relativePathFilter, (String)"relativePathFilter");
        this.classFileAnalyzer.processClassFiles(root, relativePathFilter);
    }

    public static /* synthetic */ void processClassFiles$default(ExtractModuleFileProcessor extractModuleFileProcessor, Path path, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = ExtractModuleFileProcessor::processClassFiles$lambda$0;
        }
        extractModuleFileProcessor.processClassFiles(path, (Function1<? super String, Boolean>)function1);
    }

    private static final boolean processClassFiles$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    public ExtractModuleFileProcessor() {
        this(null, 1, null);
    }

    public static final /* synthetic */ Set access$getMutableReferencedClasses$p(ExtractModuleFileProcessor $this) {
        return $this.mutableReferencedClasses;
    }

    public static final /* synthetic */ Map access$getMutableGatheredClassLinks$p(ExtractModuleFileProcessor $this) {
        return $this.mutableGatheredClassLinks;
    }
}

