/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.extractModule;

import com.intellij.ide.extractModule.ExtractModuleFromPackageDialog;
import com.intellij.ide.extractModule.ExtractModuleService;
import com.intellij.ide.extractModule.TargetModuleCreatorImpl;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ide/extractModule/ExtractModuleFromPackageAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.java.ui"})
@SourceDebugExtension(value={"SMAP\nExtractModuleFromPackageAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtractModuleFromPackageAction.kt\ncom/intellij/ide/extractModule/ExtractModuleFromPackageAction\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,38:1\n30#2,2:39\n*S KotlinDebug\n*F\n+ 1 ExtractModuleFromPackageAction.kt\ncom/intellij/ide/extractModule/ExtractModuleFromPackageAction\n*L\n24#1:39,2\n*E\n"})
public final class ExtractModuleFromPackageAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) {
            return;
        }
        VirtualFile directory = virtualFile;
        Module module = ProjectFileIndex.getInstance((Project)project3).getModuleForFile(directory);
        if (module == null) {
            return;
        }
        Module module2 = module;
        String suggestedModuleName = module2.getName() + "." + directory.getName();
        VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)module2).getContentRoots();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRoots(...)");
        VirtualFile parentContentRoot = (VirtualFile)ArraysKt.first((Object[])virtualFileArray);
        String[] stringArray = new String[]{directory.getName(), "src"};
        ExtractModuleFromPackageDialog dialog = new ExtractModuleFromPackageDialog(project3, suggestedModuleName, ((Object)Path.of(parentContentRoot.getPath(), stringArray)).toString());
        if (!dialog.showAndGet()) {
            return;
        }
        ComponentManager $this$service$iv = (ComponentManager)project3;
        boolean $i$f$service = false;
        Class<ExtractModuleService> serviceClass$iv = ExtractModuleService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((ExtractModuleService)object).analyzeDependenciesAndCreateModuleInBackground(directory, module2, new TargetModuleCreatorImpl(dialog.getModuleName$intellij_java_ui(), dialog.getTargetSourceRootPath$intellij_java_ui()));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        e.getPresentation().setEnabledAndVisible(project2 != null && file != null && file.isDirectory() && ProjectFileIndex.getInstance((Project)project2).isInSourceContent(file));
    }
}

