/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.extractModule;

import com.intellij.ide.extractModule.TargetModuleCreator;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.PackageIndex;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/ide/extractModule/TargetModuleCreatorImpl;", "Lcom/intellij/ide/extractModule/TargetModuleCreator;", "moduleName", "", "targetSourceRootPath", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "createExtractedModule", "Lcom/intellij/ide/extractModule/TargetModuleCreator$ExtractedModuleData;", "originalModule", "Lcom/intellij/openapi/module/Module;", "directory", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.java.ui"})
@SourceDebugExtension(value={"SMAP\nExtractModuleService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtractModuleService.kt\ncom/intellij/ide/extractModule/TargetModuleCreatorImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,392:1\n1#2:393\n*E\n"})
public final class TargetModuleCreatorImpl
implements TargetModuleCreator {
    @NotNull
    private final String moduleName;
    @Nullable
    private final String targetSourceRootPath;

    public TargetModuleCreatorImpl(@NotNull String moduleName, @Nullable String targetSourceRootPath) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        this.moduleName = moduleName;
        this.targetSourceRootPath = targetSourceRootPath;
    }

    @Override
    @NotNull
    public TargetModuleCreator.ExtractedModuleData createExtractedModule(@NotNull Module originalModule, @NotNull VirtualFile directory) {
        Pair pair;
        VirtualFile targetSourceRoot;
        Intrinsics.checkNotNullParameter((Object)originalModule, (String)"originalModule");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        String string = PackageIndex.getInstance((Project)originalModule.getProject()).getPackageName(directory);
        if (string == null) {
            string = "";
        }
        String packagePrefix = string;
        String string2 = this.targetSourceRootPath;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            v2 = VfsUtil.createDirectories((String)it);
        } else {
            v2 = targetSourceRoot = null;
        }
        if (targetSourceRoot != null) {
            VirtualFile parent = targetSourceRoot.getParent();
            VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)originalModule).getContentRoots();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRoots(...)");
            pair = ArraysKt.contains((Object[])virtualFileArray, (Object)parent) ? TuplesKt.to((Object)targetSourceRoot, (Object)originalModule.getModuleNioFile().getParent()) : TuplesKt.to((Object)parent, (Object)parent.toNioPath());
        } else {
            pair = TuplesKt.to((Object)directory, (Object)originalModule.getModuleNioFile().getParent());
        }
        Pair pair2 = pair;
        VirtualFile contentRoot = (VirtualFile)pair2.component1();
        Path imlFileDirectory = (Path)pair2.component2();
        Project project2 = originalModule.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        ModuleManager moduleManager = ModuleManager.Companion.getInstance(project2);
        Path path = imlFileDirectory.resolve(this.moduleName + ".iml");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Module newModule = moduleManager.newModule(path, "JAVA_MODULE");
        ModuleRootModificationUtil.updateModel((Module)newModule, arg_0 -> TargetModuleCreatorImpl.createExtractedModule$lambda$2(arg_0 -> TargetModuleCreatorImpl.createExtractedModule$lambda$1(originalModule, contentRoot, targetSourceRoot, directory, packagePrefix, arg_0), arg_0));
        VirtualFile directoryToMoveClassesTo = targetSourceRoot != null ? VfsUtil.createDirectoryIfMissing((VirtualFile)targetSourceRoot, (String)StringsKt.replace$default((String)packagePrefix, (char)'.', (char)'/', (boolean)false, (int)4, null)) : null;
        return new TargetModuleCreator.ExtractedModuleData(newModule, directoryToMoveClassesTo);
    }

    private static final Unit createExtractedModule$lambda$1(Module $originalModule, VirtualFile $contentRoot, VirtualFile $targetSourceRoot, VirtualFile $directory, String $packagePrefix, ModifiableRootModel model) {
        if (ModuleRootManager.getInstance((Module)$originalModule).isSdkInherited()) {
            model.inheritSdk();
        } else {
            model.setSdk(ModuleRootManager.getInstance((Module)$originalModule).getSdk());
        }
        ContentEntry contentEntry = model.addContentEntry($contentRoot);
        Intrinsics.checkNotNullExpressionValue((Object)contentEntry, (String)"addContentEntry(...)");
        ContentEntry contentEntry2 = contentEntry;
        SourceFolder sourceFolder = $targetSourceRoot != null ? contentEntry2.addSourceFolder($targetSourceRoot, false) : contentEntry2.addSourceFolder($directory, false, $packagePrefix);
        return Unit.INSTANCE;
    }

    private static final void createExtractedModule$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

