/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectWizard.generators;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.InitialConfigImportState;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.PerProjectIndexingQueue;
import com.intellij.util.indexing.UnindexedFilesIndexer;
import com.intellij.util.indexing.roots.IndexableEntityProviderMethods;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.indexing.roots.IndexableSetContributorFilesIterator;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0006\u0010\u000f\u001a\u00020\tJ\b\u0010\u0010\u001a\u00020\tH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ide/projectWizard/generators/SdkPreIndexingService;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "currentSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "currentProgressIndicator", "Lcom/intellij/openapi/progress/impl/BackgroundableProcessIndicator;", "requestPreIndexation", "", "sdk", "getSdkAndAdditionalSetIndexableFileProviders", "Lcom/intellij/util/indexing/PerProjectIndexingQueue;", "project", "Lcom/intellij/openapi/project/Project;", "cancelCurrentPreIndexation", "dispose", "Companion", "intellij.java.ui"})
public final class SdkPreIndexingService
implements Disposable {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Nullable
    private volatile Sdk currentSdk;
    @Nullable
    private volatile BackgroundableProcessIndicator currentProgressIndicator;
    private static final boolean isEnabled = SystemProperties.getBooleanProperty((String)"sdk.pre.indexing", (boolean)false);

    public SdkPreIndexingService() {
        MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect();
        Topic topic = ProjectJdkTable.JDK_TABLE_TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"JDK_TABLE_TOPIC");
        messageBusConnection.subscribe(topic, (Object)new ProjectJdkTable.Listener(){

            public void jdkRemoved(Sdk removedSdk) {
                Intrinsics.checkNotNullParameter((Object)removedSdk, (String)"removedSdk");
                if (Intrinsics.areEqual((Object)currentSdk, (Object)removedSdk)) {
                    this.cancelCurrentPreIndexation();
                }
            }
        });
    }

    public final synchronized void requestPreIndexation(@NotNull Sdk sdk) {
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        if (!isEnabled || !InitialConfigImportState.isFirstSession()) {
            return;
        }
        if (Intrinsics.areEqual((Object)sdk, (Object)this.currentSdk)) {
            return;
        }
        this.cancelCurrentPreIndexation();
        Project defaultProject = DefaultProjectFactory.getInstance().getDefaultProject();
        Intrinsics.checkNotNull((Object)defaultProject);
        PerProjectIndexingQueue filesSource = this.getSdkAndAdditionalSetIndexableFileProviders(sdk, defaultProject);
        String string = JavaUiBundle.message("project.wizard.sdk.preindexing.progress.title", new Object[0]);
        Task.Backgroundable task2 = new Task.Backgroundable(defaultProject, filesSource, string){
            final /* synthetic */ Project $defaultProject;
            final /* synthetic */ PerProjectIndexingQueue $filesSource;
            {
                this.$defaultProject = $defaultProject;
                this.$filesSource = $filesSource;
                super(null, $super_call_param$1);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                new UnindexedFilesIndexer(this.$defaultProject, this.$filesSource, "SDK pre-indexing").perform(indicator);
            }
        };
        this.currentSdk = sdk;
        this.currentProgressIndicator = new BackgroundableProcessIndicator(task2);
        ProgressManager progressManager = ProgressManager.getInstance();
        Task.Backgroundable backgroundable = task2;
        BackgroundableProcessIndicator backgroundableProcessIndicator = this.currentProgressIndicator;
        Intrinsics.checkNotNull((Object)backgroundableProcessIndicator);
        progressManager.runProcessWithProgressAsynchronously(backgroundable, (ProgressIndicator)backgroundableProcessIndicator);
    }

    private final PerProjectIndexingQueue getSdkAndAdditionalSetIndexableFileProviders(Sdk sdk, Project project2) {
        List allIterators = new ArrayList(2);
        allIterators.addAll(IndexableSetContributorFilesIterator.Companion.createProjectUnAwareIndexableSetContributors());
        allIterators.addAll(IndexableEntityProviderMethods.INSTANCE.createIterators(sdk));
        PerProjectIndexingQueue queue = new PerProjectIndexingQueue(project2);
        for (IndexableFilesIterator iterator : allIterators) {
            iterator.iterateFiles(project2, arg_0 -> SdkPreIndexingService.getSdkAndAdditionalSetIndexableFileProviders$lambda$0(queue, arg_0), VirtualFileFilter.ALL);
        }
        return queue;
    }

    public final synchronized void cancelCurrentPreIndexation() {
        this.currentSdk = null;
        if (this.currentProgressIndicator != null) {
            BackgroundableProcessIndicator backgroundableProcessIndicator = this.currentProgressIndicator;
            Intrinsics.checkNotNull((Object)backgroundableProcessIndicator);
            backgroundableProcessIndicator.cancel();
            this.currentProgressIndicator = null;
        }
    }

    public void dispose() {
        block0: {
            BackgroundableProcessIndicator backgroundableProcessIndicator = this.currentProgressIndicator;
            if (backgroundableProcessIndicator == null) break block0;
            backgroundableProcessIndicator.cancel();
        }
    }

    private static final boolean getSdkAndAdditionalSetIndexableFileProviders$lambda$0(PerProjectIndexingQueue $queue, VirtualFile fileOrDir) {
        Intrinsics.checkNotNullParameter((Object)fileOrDir, (String)"fileOrDir");
        $queue.addFile(fileOrDir, 0L);
        return true;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ide/projectWizard/generators/SdkPreIndexingService$Companion;", "", "<init>", "()V", "isEnabled", "", "()Z", "intellij.java.ui"})
    private static final class Companion {
        private Companion() {
        }

        public final boolean isEnabled() {
            return isEnabled;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

