/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectWizard.projectTypeStep;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerConfigurableUtils;
import com.intellij.ide.projectWizard.NewProjectWizardCollector;
import com.intellij.ide.projectWizard.projectTypeStep.LanguageGeneratorItem;
import com.intellij.ide.projectWizard.projectTypeStep.ProjectTypeListKt;
import com.intellij.ide.projectWizard.projectTypeStep.TemplateGroupItem;
import com.intellij.ide.projectWizard.projectTypeStep.UserTemplateGroupItem;
import com.intellij.ide.projectWizard.projectTypeStep.WizardPlugin;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.newProjectWizard.TemplatesGroup;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.observable.util.ListenerUiUtil;
import com.intellij.openapi.observable.util.ListenerWithValueUiUtil;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListItemDescriptor;
import com.intellij.openapi.ui.popup.ListItemDescriptorAdapter;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.ui.JBColor;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SingleSelectionModel;
import com.intellij.ui.UIBundle;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.ui.speedSearch.NameFilteringListModel;
import com.intellij.ui.speedSearch.SpeedSearch;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.AbstractListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001:\u000534567B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0013J\b\u0010\u0019\u001a\u00020\u0017H\u0007J\u0014\u0010\u001a\u001a\u00020\u00152\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cJ\u000e\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u001dJ\u000e\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u0017J\u0014\u0010\"\u001a\u00020\u00152\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\u001cJ\u0014\u0010#\u001a\u00020\u00152\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020$0\u001cJ\u0014\u0010%\u001a\u00020\u00152\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00130'J\u0006\u0010(\u001a\u00020\u0015J\"\u0010)\u001a\u00020\u00152\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00170+2\u0006\u0010,\u001a\u00020-J\u0010\u0010.\u001a\u00020\u00152\u0006\u0010/\u001a\u000200H\u0002J\b\u0010.\u001a\u00020\u0015H\u0002J\b\u00101\u001a\u00020\u0015H\u0002J\u0016\u00101\u001a\u00020\u00152\f\u00102\u001a\b\u0012\u0004\u0012\u0002000\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u00068"}, d2={"Lcom/intellij/ide/projectWizard/projectTypeStep/ProjectTypeList;", "", "context", "Lcom/intellij/ide/util/projectWizard/WizardContext;", "<init>", "(Lcom/intellij/ide/util/projectWizard/WizardContext;)V", "searchTextField", "Lcom/intellij/ui/SearchTextField;", "list", "Lcom/intellij/ui/components/JBList;", "Lcom/intellij/ide/projectWizard/projectTypeStep/TemplateGroupItem;", "model", "Lcom/intellij/ide/projectWizard/projectTypeStep/ProjectTypeList$ProjectTypeListModel;", "languagePluginFooterLink", "Ljavax/swing/JComponent;", "component", "getComponent", "()Ljavax/swing/JComponent;", "getSelectedTemplateGroup", "Lcom/intellij/ide/util/newProjectWizard/TemplatesGroup;", "setSelectedTemplateGroup", "", "groupName", "", "group", "getAvailableTemplateGroups", "setLanguageGeneratorItems", "items", "", "Lcom/intellij/ide/projectWizard/projectTypeStep/LanguageGeneratorItem;", "addLanguageGeneratorItem", "item", "removeLanguageGeneratorItem", "languageName", "setTemplateGroupItems", "setUserTemplateGroupItems", "Lcom/intellij/ide/projectWizard/projectTypeStep/UserTemplateGroupItem;", "whenProjectTemplateGroupSelected", "action", "Ljava/util/function/Consumer;", "restoreSelection", "installFilteringListModel", "namer", "Ljava/util/function/Function;", "showEmptyStatus", "Ljava/lang/Runnable;", "showInstallPluginDialog", "plugin", "Lcom/intellij/ide/projectWizard/projectTypeStep/WizardPlugin;", "showInstallPluginPopup", "additionalWizardPlugins", "ProjectTypeListModel", "ProjectTypeListRenderer", "ProjectTypeListItemDescriptor", "LanguagePluginRenderer", "LanguagePluginRendererDescriptor", "intellij.java.ui"})
@SourceDebugExtension(value={"SMAP\nProjectTypeList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectTypeList.kt\ncom/intellij/ide/projectWizard/projectTypeStep/ProjectTypeList\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,439:1\n1#2:440\n11705#3:441\n12052#3,3:442\n777#4:445\n873#4,2:446\n*S KotlinDebug\n*F\n+ 1 ProjectTypeList.kt\ncom/intellij/ide/projectWizard/projectTypeStep/ProjectTypeList\n*L\n170#1:441\n170#1:442,3\n171#1:445\n171#1:446,2\n*E\n"})
public final class ProjectTypeList {
    @NotNull
    private final WizardContext context;
    @NotNull
    private final SearchTextField searchTextField;
    @NotNull
    private final JBList<TemplateGroupItem> list;
    @NotNull
    private final ProjectTypeListModel model;
    @NotNull
    private final JComponent languagePluginFooterLink;
    @NotNull
    private final JComponent component;

    public ProjectTypeList(@NotNull WizardContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.model = new ProjectTypeListModel();
        this.list = new JBList((ListModel)this.model);
        this.list.setSelectionModel((ListSelectionModel)new SingleSelectionModel());
        this.list.setCellRenderer((ListCellRenderer)((Object)new ProjectTypeListRenderer(this.context, this.model)));
        this.list.getAccessibleContext().setAccessibleName(UIBundle.message((String)"newProjectWizard.ProjectTypeStep.list.accessible.name", (Object[])new Object[0]));
        this.searchTextField = new SearchTextField(false);
        this.searchTextField.getTextEditor().setBorder((Border)JBUI.Borders.empty((int)2, (int)5, (int)2, (int)0));
        ListenerUiUtil.whenTextChangedFromUi$default((SearchTextField)this.searchTextField, null, arg_0 -> ProjectTypeList._init_$lambda$0(this, arg_0), (int)1, null);
        this.list.getEmptyText().setText(IdeBundle.message((String)"plugins.configurable.nothing.found", (Object[])new Object[0]));
        this.list.getEmptyText().appendSecondaryText(IdeBundle.message((String)"plugins.configurable.search.in.marketplace", (Object[])new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, arg_0 -> ProjectTypeList._init_$lambda$1(this, arg_0));
        JBScrollPane scrollPane = new JBScrollPane((Component)this.list);
        scrollPane.setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)1, (int)0, (int)1, (int)0));
        String string = UIBundle.message((String)"newProjectWizard.ProjectTypeStep.InstallPluginAction.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ActionLink link = new ActionLink(string, arg_0 -> ProjectTypeList._init_$lambda$2(this, arg_0));
        link.setToolTipText(UIBundle.message((String)"newProjectWizard.ProjectTypeStep.InstallPluginAction.description", (Object[])new Object[0]));
        this.languagePluginFooterLink = (JComponent)new JBPanel((LayoutManager)new BorderLayout());
        ((JBPanel)this.languagePluginFooterLink).setBorder(JBUI.CurrentTheme.Advertiser.border());
        ((JBPanel)this.languagePluginFooterLink).withMinimumHeight(JBUI.scale((int)40));
        ((JBPanel)this.languagePluginFooterLink).withPreferredHeight(JBUI.scale((int)40));
        this.languagePluginFooterLink.add((Component)link, "West");
        this.component = new JPanel(new BorderLayout());
        ((JPanel)this.component).setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)1, (int)0, (int)1, (int)0));
        this.component.add((Component)this.searchTextField, "North");
        this.component.add((Component)scrollPane, "Center");
        this.component.add((Component)this.languagePluginFooterLink, "South");
    }

    @NotNull
    public final JComponent getComponent() {
        return this.component;
    }

    @Nullable
    public final TemplatesGroup getSelectedTemplateGroup() {
        TemplateGroupItem templateGroupItem = (TemplateGroupItem)this.list.getSelectedValue();
        return templateGroupItem != null ? templateGroupItem.getGroup() : null;
    }

    public final void setSelectedTemplateGroup(@NotNull String groupName) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
            Iterable iterable = this.model.getItems();
            for (Object t : iterable) {
                TemplateGroupItem it = (TemplateGroupItem)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getGroup().getName(), (Object)groupName)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        TemplateGroupItem templateGroupItem = v0;
        if (templateGroupItem == null) {
            return;
        }
        TemplateGroupItem groupItem = templateGroupItem;
        this.list.setSelectedValue((Object)groupItem, true);
    }

    public final void setSelectedTemplateGroup(@NotNull TemplatesGroup group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        String string = group.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.setSelectedTemplateGroup(string);
    }

    @TestOnly
    @NotNull
    public final String getAvailableTemplateGroups() {
        return CollectionsKt.joinToString$default((Iterable)this.model.getItems(), null, null, null, (int)0, null, ProjectTypeList::getAvailableTemplateGroups$lambda$0, (int)31, null);
    }

    public final void setLanguageGeneratorItems(@NotNull List<LanguageGeneratorItem> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        ProjectTypeListKt.access$getLOG$p().debug("Language generator items: " + items);
        this.model.setLanguageGeneratorItems(items);
    }

    public final void addLanguageGeneratorItem(@NotNull LanguageGeneratorItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        ProjectTypeListKt.access$getLOG$p().debug("Language generator added: " + item);
        int index = this.model.addLanguageGeneratorItem(item);
        this.list.setSelectedIndex(index);
    }

    public final void removeLanguageGeneratorItem(@NotNull String languageName) {
        Intrinsics.checkNotNullParameter((Object)languageName, (String)"languageName");
        ProjectTypeListKt.access$getLOG$p().debug("Language generator removed: " + languageName);
        this.model.removeLanguageGeneratorItem(languageName);
        this.list.setSelectedIndex(0);
    }

    public final void setTemplateGroupItems(@NotNull List<? extends TemplateGroupItem> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        ProjectTypeListKt.access$getLOG$p().debug("Template group items: " + items);
        this.model.setTemplateGroupItems(items);
    }

    public final void setUserTemplateGroupItems(@NotNull List<UserTemplateGroupItem> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        ProjectTypeListKt.access$getLOG$p().debug("User template items: " + items);
        this.model.setUserTemplateGroupItems(items);
    }

    public final void whenProjectTemplateGroupSelected(@NotNull Consumer<TemplatesGroup> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.list.addListSelectionListener(arg_0 -> ProjectTypeList.whenProjectTemplateGroupSelected$lambda$0(this, action, arg_0));
    }

    public final void restoreSelection() {
        Object v0;
        block3: {
            this.whenProjectTemplateGroupSelected(ProjectTypeList::restoreSelection$lambda$0);
            String groupId = PropertiesComponent.getInstance().getValue("project.wizard.group");
            ProjectTypeListKt.access$getLOG$p().debug("Restored selection groupId=" + groupId);
            Iterable iterable = this.model.getItems();
            for (Object t : iterable) {
                TemplateGroupItem it = (TemplateGroupItem)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getGroup().getId(), (Object)groupId)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        TemplateGroupItem groupItem = v0;
        if (groupItem != null) {
            this.list.setSelectedValue((Object)groupItem, true);
        } else {
            this.list.setSelectedIndex(0);
        }
    }

    public final void installFilteringListModel(@NotNull Function<TemplateGroupItem, String> namer, @NotNull Runnable showEmptyStatus) {
        Intrinsics.checkNotNullParameter(namer, (String)"namer");
        Intrinsics.checkNotNullParameter((Object)showEmptyStatus, (String)"showEmptyStatus");
        SpeedSearch speedSearch = new SpeedSearch();
        NameFilteringListModel filteringListModel2 = new NameFilteringListModel(this.list.getModel(), arg_0 -> ProjectTypeList.installFilteringListModel$lambda$0((Function1)new Function1<TemplateGroupItem, String>(namer){

            public final String invoke(TemplateGroupItem p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return (String)((Function)this.receiver).apply(p0);
            }
        }, arg_0), arg_0 -> ProjectTypeList.installFilteringListModel$lambda$1((Function1)new Function1<String, Boolean>((Object)speedSearch){

            public final Boolean invoke(String p0) {
                return ((SpeedSearch)this.receiver).shouldBeShowing(p0);
            }
        }, arg_0), () -> ((SpeedSearch)speedSearch).getFilter());
        int modelSize = this.list.getModel().getSize();
        int selectedIndex = this.list.getSelectedIndex();
        this.list.setModel((ListModel)filteringListModel2);
        if (this.list.getModel().getSize() == modelSize) {
            this.list.setSelectedIndex(selectedIndex);
        }
        ListenerWithValueUiUtil.whenTextChanged$default((SearchTextField)this.searchTextField, null, arg_0 -> ProjectTypeList.installFilteringListModel$lambda$2(speedSearch, this, filteringListModel2, showEmptyStatus, arg_0), (int)1, null);
    }

    private final void showInstallPluginDialog(WizardPlugin plugin) {
        NewProjectWizardCollector.logInstallPluginDialogShowed((WizardContext)this.context, (String)plugin.getName());
        PluginsAdvertiser.installAndEnable(null, (Set)SetsKt.setOf((Object)PluginId.Companion.getId(plugin.getId())), (boolean)true, (boolean)true, null, ProjectTypeList::showInstallPluginDialog$lambda$0);
    }

    private final void showInstallPluginDialog() {
        NewProjectWizardCollector.logInstallPluginDialogShowed((WizardContext)this.context);
        Component component = this.component;
        String string = this.searchTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        PluginManagerConfigurableUtils.INSTANCE.showInstallPluginDialog(component, string);
    }

    /*
     * WARNING - void declaration
     */
    private final void showInstallPluginPopup() {
        void $this$filterTo$iv$iv;
        WizardPlugin it;
        void $this$mapTo$iv$iv;
        NewProjectWizardCollector.logInstallPluginPopupShowed((WizardContext)this.context);
        IdeaPluginDescriptor[] ideaPluginDescriptorArray = PluginManager.getPlugins();
        Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptorArray, (String)"getPlugins(...)");
        Object[] $this$map$iv = ideaPluginDescriptorArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            IdeaPluginDescriptor ideaPluginDescriptor = (IdeaPluginDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPluginId().getIdString());
        }
        Set installedLanguagePlugins = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$filter$iv = ProjectTypeListKt.access$getAdditionalWizardPlugins();
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (WizardPlugin)element$iv$iv;
            boolean bl = false;
            if (!(!installedLanguagePlugins.contains(it.getId()))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List additionalLanguagePlugins = (List)destination$iv$iv2;
        if (additionalLanguagePlugins.isEmpty()) {
            this.showInstallPluginDialog();
        } else {
            this.showInstallPluginPopup(additionalLanguagePlugins);
        }
    }

    private final void showInstallPluginPopup(List<WizardPlugin> additionalWizardPlugins) {
        String string = UIBundle.message((String)"newProjectWizard.ProjectTypeStep.InstallPluginAction.advertiser", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ActionLink link = new ActionLink(string, arg_0 -> ProjectTypeList.showInstallPluginPopup$lambda$2(this, arg_0));
        link.setToolTipText(null);
        JBPanel languagePluginAdvertiserLink = new JBPanel((LayoutManager)new BorderLayout());
        languagePluginAdvertiserLink.setBorder(JBUI.CurrentTheme.Advertiser.border());
        languagePluginAdvertiserLink.setForeground(JBUI.CurrentTheme.Advertiser.foreground());
        languagePluginAdvertiserLink.setBackground(JBUI.CurrentTheme.Advertiser.background());
        languagePluginAdvertiserLink.withMinimumWidth(JBUI.scale((int)220));
        languagePluginAdvertiserLink.withPreferredWidth(JBUI.scale((int)220));
        languagePluginAdvertiserLink.add((Component)link, (Object)"West");
        JBPopupFactory.getInstance().createPopupChooserBuilder(additionalWizardPlugins).setRenderer((ListCellRenderer)((Object)new LanguagePluginRenderer())).setTitle(UIBundle.message((String)"newProjectWizard.ProjectTypeStep.InstallPluginAction.title", (Object[])new Object[0])).setAutoselectOnMouseMove(true).setNamerForFiltering(arg_0 -> ProjectTypeList.showInstallPluginPopup$lambda$4(ProjectTypeList::showInstallPluginPopup$lambda$3, arg_0)).setMovable(true).setAdvertiser((JComponent)languagePluginAdvertiserLink).setResizable(false).setRequestFocus(true).setSelectionMode(0).setItemChosenCallback(arg_0 -> ProjectTypeList.showInstallPluginPopup$lambda$5((Function1)new Function1<WizardPlugin, Unit>((Object)this){

            public final void invoke(WizardPlugin p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ProjectTypeList.access$showInstallPluginDialog((ProjectTypeList)this.receiver, p0);
            }
        }, arg_0)).createPopup().show(RelativePoint.getSouthWestOf((JComponent)this.languagePluginFooterLink));
    }

    private static final CharSequence getAvailableTemplateGroups$lambda$0(TemplateGroupItem it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getGroup().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    private static final void whenProjectTemplateGroupSelected$lambda$0(ProjectTypeList this$0, Consumer $action, ListSelectionEvent event) {
        TemplatesGroup group;
        if (!event.getValueIsAdjusting() && (group = this$0.getSelectedTemplateGroup()) != null) {
            $action.accept(group);
        }
    }

    private static final void restoreSelection$lambda$0(TemplatesGroup group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        PropertiesComponent.getInstance().setValue("project.wizard.group", group.getId());
        ProjectTypeListKt.access$getLOG$p().debug("Stored selection groupId=" + group.getId(), new Throwable());
    }

    private static final String installFilteringListModel$lambda$0(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final boolean installFilteringListModel$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit installFilteringListModel$lambda$2(SpeedSearch $speedSearch, ProjectTypeList this$0, NameFilteringListModel $filteringListModel, Runnable $showEmptyStatus, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $speedSearch.updatePattern(this$0.searchTextField.getText());
        $filteringListModel.refilter();
        this$0.list.setSelectedIndex(0);
        if ($filteringListModel.getSize() == 0) {
            $showEmptyStatus.run();
        }
        return Unit.INSTANCE;
    }

    private static final void showInstallPluginDialog$lambda$0() {
    }

    private static final Unit showInstallPluginPopup$lambda$2(ProjectTypeList this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.showInstallPluginDialog();
        return Unit.INSTANCE;
    }

    private static final String showInstallPluginPopup$lambda$3(WizardPlugin it) {
        return it.getName();
    }

    private static final String showInstallPluginPopup$lambda$4(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final void showInstallPluginPopup$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit _init_$lambda$0(ProjectTypeList this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        NewProjectWizardCollector.logSearchChanged((WizardContext)this$0.context, (int)this$0.searchTextField.getText().length(), (int)this$0.list.getModel().getSize());
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(ProjectTypeList this$0, ActionEvent it) {
        this$0.showInstallPluginDialog();
    }

    private static final Unit _init_$lambda$2(ProjectTypeList this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.showInstallPluginPopup();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$showInstallPluginDialog(ProjectTypeList $this, WizardPlugin plugin) {
        $this.showInstallPluginDialog(plugin);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J8\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ide/projectWizard/projectTypeStep/ProjectTypeList$LanguagePluginRenderer;", "Lcom/intellij/ui/popup/list/GroupedItemsListRenderer;", "Lcom/intellij/ide/projectWizard/projectTypeStep/WizardPlugin;", "<init>", "()V", "customizeComponent", "", "list", "Ljavax/swing/JList;", "value", "index", "", "isSelected", "", "cellHasFocus", "intellij.java.ui"})
    private static final class LanguagePluginRenderer
    extends GroupedItemsListRenderer<WizardPlugin> {
        public LanguagePluginRenderer() {
            super((ListItemDescriptor)new LanguagePluginRendererDescriptor());
        }

        protected void customizeComponent(@NotNull JList<? extends WizardPlugin> list2, @NotNull WizardPlugin value, int index, boolean isSelected, boolean cellHasFocus) {
            Intrinsics.checkNotNullParameter(list2, (String)"list");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.myTextLabel.setBorder((Border)JBUI.Borders.empty((int)5, (int)0));
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ide/projectWizard/projectTypeStep/ProjectTypeList$LanguagePluginRendererDescriptor;", "Lcom/intellij/openapi/ui/popup/ListItemDescriptor;", "Lcom/intellij/ide/projectWizard/projectTypeStep/WizardPlugin;", "<init>", "()V", "getTextFor", "", "value", "getTooltipFor", "getIconFor", "Ljavax/swing/Icon;", "hasSeparatorAboveOf", "", "getCaptionAboveOf", "intellij.java.ui"})
    private static final class LanguagePluginRendererDescriptor
    implements ListItemDescriptor<WizardPlugin> {
        @NotNull
        public String getTextFor(@NotNull WizardPlugin value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return value.getName();
        }

        @Nullable
        public String getTooltipFor(@NotNull WizardPlugin value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return null;
        }

        @NotNull
        public Icon getIconFor(@NotNull WizardPlugin value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return value.getIcon();
        }

        public boolean hasSeparatorAboveOf(@NotNull WizardPlugin value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return false;
        }

        @Nullable
        public String getCaptionAboveOf(@NotNull WizardPlugin value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return null;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ide/projectWizard/projectTypeStep/ProjectTypeList$ProjectTypeListItemDescriptor;", "Lcom/intellij/openapi/ui/popup/ListItemDescriptorAdapter;", "Lcom/intellij/ide/projectWizard/projectTypeStep/TemplateGroupItem;", "context", "Lcom/intellij/ide/util/projectWizard/WizardContext;", "model", "Lcom/intellij/ide/projectWizard/projectTypeStep/ProjectTypeList$ProjectTypeListModel;", "<init>", "(Lcom/intellij/ide/util/projectWizard/WizardContext;Lcom/intellij/ide/projectWizard/projectTypeStep/ProjectTypeList$ProjectTypeListModel;)V", "getTextFor", "", "value", "getIconFor", "Ljavax/swing/Icon;", "getCaptionAboveOf", "hasSeparatorAboveOf", "", "intellij.java.ui"})
    private static final class ProjectTypeListItemDescriptor
    extends ListItemDescriptorAdapter<TemplateGroupItem> {
        @NotNull
        private final WizardContext context;
        @NotNull
        private final ProjectTypeListModel model;

        public ProjectTypeListItemDescriptor(@NotNull WizardContext context, @NotNull ProjectTypeListModel model) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            this.context = context;
            this.model = model;
        }

        @Nullable
        public String getTextFor(@NotNull TemplateGroupItem value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return value.getGroup().getName();
        }

        @NotNull
        public Icon getIconFor(@NotNull TemplateGroupItem value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Icon icon = value.getGroup().getIcon();
            if (icon == null) {
                Icon icon2 = EmptyIcon.ICON_16;
                icon = icon2;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"ICON_16");
            }
            return icon;
        }

        @NotNull
        public String getCaptionAboveOf(@NotNull TemplateGroupItem value) {
            String string;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            TemplateGroupItem templateGroupItem = value;
            if (templateGroupItem instanceof LanguageGeneratorItem) {
                Object[] objectArray = new Object[]{this.context.isCreatingNewProjectInt()};
                String string2 = UIBundle.message((String)"list.caption.group.newProject", (Object[])objectArray);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            } else if (templateGroupItem instanceof UserTemplateGroupItem) {
                String string3 = UIBundle.message((String)"list.caption.group.templates", (Object[])new Object[0]);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            } else {
                String string4 = UIBundle.message((String)"list.caption.group.generators", (Object[])new Object[0]);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
            }
            return string;
        }

        public boolean hasSeparatorAboveOf(@NotNull TemplateGroupItem value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            int index = this.model.getItems().indexOf(value);
            if (index < 0) {
                return false;
            }
            if (index == 0) {
                return true;
            }
            TemplateGroupItem upperItem = this.model.getItems().get(index - 1);
            if (!(value instanceof LanguageGeneratorItem) && upperItem instanceof LanguageGeneratorItem) {
                return true;
            }
            return value instanceof UserTemplateGroupItem && !(upperItem instanceof UserTemplateGroupItem);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0006\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0011H\u0016J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\rJ\u0014\u0010\u0015\u001a\u00020\u00162\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\rJ\u000e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0007J\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bJ\u0014\u0010\u001c\u001a\u00020\u00162\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\rJ\u0014\u0010\u001d\u001a\u00020\u00162\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rJ6\u0010\u001e\u001a\u00020\u0016\"\b\b\u0000\u0010\u001f*\u00020\u00022\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001f0!2\u0006\u0010\"\u001a\u00020\u00112\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u001f0\rH\u0002J5\u0010#\u001a\u00020\u0011\"\b\b\u0000\u0010\u001f*\u00020\u00022\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001f0!2\u0006\u0010\"\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u0002H\u001fH\u0002\u00a2\u0006\u0002\u0010$J0\u0010%\u001a\u00020\u0016\"\b\b\u0000\u0010\u001f*\u00020\u00022\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001f0!2\u0006\u0010\"\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\u001bH\u0002R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0006j\b\u0012\u0004\u0012\u00020\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\u0006j\b\u0012\u0004\u0012\u00020\u000b`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006'"}, d2={"Lcom/intellij/ide/projectWizard/projectTypeStep/ProjectTypeList$ProjectTypeListModel;", "Ljavax/swing/AbstractListModel;", "Lcom/intellij/ide/projectWizard/projectTypeStep/TemplateGroupItem;", "<init>", "()V", "languageGeneratorItems", "Ljava/util/ArrayList;", "Lcom/intellij/ide/projectWizard/projectTypeStep/LanguageGeneratorItem;", "Lkotlin/collections/ArrayList;", "templateGroupItems", "userTemplateGroupItems", "Lcom/intellij/ide/projectWizard/projectTypeStep/UserTemplateGroupItem;", "items", "", "getItems", "()Ljava/util/List;", "getSize", "", "getElementAt", "index", "getLanguageGeneratorItems", "setLanguageGeneratorItems", "", "addLanguageGeneratorItem", "item", "removeLanguageGeneratorItem", "languageName", "", "setTemplateGroupItems", "setUserTemplateGroupItems", "setItems", "T", "collection", "", "offset", "addItem", "(Ljava/util/List;ILcom/intellij/ide/projectWizard/projectTypeStep/TemplateGroupItem;)I", "removeItem", "name", "intellij.java.ui"})
    @SourceDebugExtension(value={"SMAP\nProjectTypeList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectTypeList.kt\ncom/intellij/ide/projectWizard/projectTypeStep/ProjectTypeList$ProjectTypeListModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,439:1\n1021#2,2:440\n363#2,7:442\n363#2,7:449\n*S KotlinDebug\n*F\n+ 1 ProjectTypeList.kt\ncom/intellij/ide/projectWizard/projectTypeStep/ProjectTypeList$ProjectTypeListModel\n*L\n290#1:440,2\n295#1:442,7\n303#1:449,7\n*E\n"})
    private static final class ProjectTypeListModel
    extends AbstractListModel<TemplateGroupItem> {
        @NotNull
        private final ArrayList<LanguageGeneratorItem> languageGeneratorItems = new ArrayList();
        @NotNull
        private final ArrayList<TemplateGroupItem> templateGroupItems = new ArrayList();
        @NotNull
        private final ArrayList<UserTemplateGroupItem> userTemplateGroupItems = new ArrayList();

        @NotNull
        public final List<TemplateGroupItem> getItems() {
            return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)this.languageGeneratorItems, (Iterable)this.templateGroupItems), (Iterable)this.userTemplateGroupItems);
        }

        @Override
        public int getSize() {
            return this.getItems().size();
        }

        @Override
        @NotNull
        public TemplateGroupItem getElementAt(int index) {
            return this.getItems().get(index);
        }

        @NotNull
        public final List<LanguageGeneratorItem> getLanguageGeneratorItems() {
            return this.languageGeneratorItems;
        }

        public final void setLanguageGeneratorItems(@NotNull List<LanguageGeneratorItem> items) {
            Intrinsics.checkNotNullParameter(items, (String)"items");
            this.setItems((List)this.languageGeneratorItems, 0, items);
        }

        public final int addLanguageGeneratorItem(@NotNull LanguageGeneratorItem item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return this.addItem((List)this.languageGeneratorItems, 0, (TemplateGroupItem)item);
        }

        public final void removeLanguageGeneratorItem(@NotNull String languageName) {
            Intrinsics.checkNotNullParameter((Object)languageName, (String)"languageName");
            this.removeItem((List)this.languageGeneratorItems, 0, languageName);
        }

        public final void setTemplateGroupItems(@NotNull List<? extends TemplateGroupItem> items) {
            Intrinsics.checkNotNullParameter(items, (String)"items");
            this.setItems((List)this.templateGroupItems, this.languageGeneratorItems.size(), items);
        }

        public final void setUserTemplateGroupItems(@NotNull List<UserTemplateGroupItem> items) {
            Intrinsics.checkNotNullParameter(items, (String)"items");
            this.setItems((List)this.userTemplateGroupItems, this.languageGeneratorItems.size() + this.templateGroupItems.size(), items);
        }

        private final <T extends TemplateGroupItem> void setItems(List<T> collection, int offset, List<? extends T> items) {
            collection.clear();
            collection.addAll((Collection)items);
            List<T> $this$sortBy$iv = collection;
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        TemplateGroupItem it = (TemplateGroupItem)a;
                        boolean bl = false;
                        Comparable comparable = it.getGroup();
                        it = (TemplateGroupItem)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getGroup());
                    }
                });
            }
            this.fireContentsChanged(this, offset, offset + collection.size() - 1);
        }

        private final <T extends TemplateGroupItem> int addItem(List<T> collection, int offset, T item) {
            int index;
            block3: {
                int n;
                List<T> $this$indexOfFirst$iv = collection;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (T item$iv : $this$indexOfFirst$iv) {
                    TemplateGroupItem it = (TemplateGroupItem)item$iv;
                    boolean bl = false;
                    if (it.getGroup().compareTo(item.getGroup()) >= 0) {
                        n = index$iv;
                        break block3;
                    }
                    ++index$iv;
                }
                n = index = -1;
            }
            if (index < 0) {
                index = 0;
            }
            collection.add(index, item);
            this.fireIntervalAdded(this, offset + index, offset + index);
            return offset + index;
        }

        private final <T extends TemplateGroupItem> void removeItem(List<T> collection, int offset, String name) {
            int index;
            block3: {
                int n;
                List<T> $this$indexOfFirst$iv = collection;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (T item$iv : $this$indexOfFirst$iv) {
                    TemplateGroupItem it = (TemplateGroupItem)item$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)name, (Object)it.getGroup().getName())) {
                        n = index$iv;
                        break block3;
                    }
                    ++index$iv;
                }
                n = index = -1;
            }
            if (index >= 0) {
                collection.remove(index);
                this.fireIntervalRemoved(this, offset + index, offset + index);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ8\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ide/projectWizard/projectTypeStep/ProjectTypeList$ProjectTypeListRenderer;", "Lcom/intellij/ui/popup/list/GroupedItemsListRenderer;", "Lcom/intellij/ide/projectWizard/projectTypeStep/TemplateGroupItem;", "context", "Lcom/intellij/ide/util/projectWizard/WizardContext;", "model", "Lcom/intellij/ide/projectWizard/projectTypeStep/ProjectTypeList$ProjectTypeListModel;", "<init>", "(Lcom/intellij/ide/util/projectWizard/WizardContext;Lcom/intellij/ide/projectWizard/projectTypeStep/ProjectTypeList$ProjectTypeListModel;)V", "customizeComponent", "", "list", "Ljavax/swing/JList;", "value", "index", "", "isSelected", "", "cellHasFocus", "createSeparator", "Lcom/intellij/ui/SeparatorWithText;", "intellij.java.ui"})
    private static final class ProjectTypeListRenderer
    extends GroupedItemsListRenderer<TemplateGroupItem> {
        public ProjectTypeListRenderer(@NotNull WizardContext context, @NotNull ProjectTypeListModel model) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            super((ListItemDescriptor)new ProjectTypeListItemDescriptor(context, model));
        }

        protected void customizeComponent(@NotNull JList<? extends TemplateGroupItem> list2, @NotNull TemplateGroupItem value, int index, boolean isSelected, boolean cellHasFocus) {
            Intrinsics.checkNotNullParameter(list2, (String)"list");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.mySeparatorComponent.setBorder(index == 0 ? (Border)JBUI.Borders.empty((int)5, (int)8, (int)5, (int)0) : (Border)JBUI.Borders.empty((int)20, (int)8, (int)5, (int)0));
            this.mySeparatorComponent.setCaptionCentered(false);
            this.mySeparatorComponent.setFont(JBFont.label().deriveFont(JBUI.scale((int)12)));
            this.myNextStepLabel.setIcon(value.getGroup().isPromo() ? AllIcons.Ultimate.Lock : null);
            this.myTextLabel.setBorder((Border)JBUI.Borders.empty((int)5, (int)0));
        }

        @NotNull
        protected SeparatorWithText createSeparator() {
            return new SeparatorWithText(){

                protected void paintLinePart(Graphics g, int xMin, int xMax, int hGap, int y) {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                }
            };
        }
    }
}

