/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starters.local;

import com.intellij.ide.starters.local.Dependency;
import com.intellij.ide.starters.local.DependencyConfig;
import com.intellij.ide.starters.local.GeneratorAsset;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0018\n\u0002\u0010\u0011\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u009d\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\u0003\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0012\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\b\b\u0002\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000e\u0010,\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\u0003J\u000e\u0010-\u001a\u00020\u00192\u0006\u0010.\u001a\u00020\u0003J\u0006\u0010/\u001a\u00020\u0019J\u001f\u00100\u001a\u00020\u00192\u0012\u00101\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000302\"\u00020\u0003\u00a2\u0006\u0002\u00103J\u001f\u00104\u001a\u00020\u00192\u0012\u00101\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000302\"\u00020\u0003\u00a2\u0006\u0002\u00103J\u0018\u0010!\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003J\u0010\u00105\u001a\u0004\u0018\u00010\u00032\u0006\u00106\u001a\u00020\u0003J\u0010\u00107\u001a\u0004\u0018\u00010\u00032\u0006\u00106\u001a\u00020\u0003J\u000e\u00108\u001a\u00020\u00032\u0006\u00106\u001a\u00020\u0003J\u000e\u00109\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001dR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001dR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001dR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001dR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001dR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001dR\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0017\u0010:\u001a\u00020\u00038F\u00a2\u0006\f\u0012\u0004\b;\u0010<\u001a\u0004\b=\u0010\u001dR\u0011\u0010>\u001a\u00020?8F\u00a2\u0006\u0006\u001a\u0004\b@\u0010A\u00a8\u0006B"}, d2={"Lcom/intellij/ide/starters/local/GeneratorContext;", "", "starterId", "", "moduleName", "group", "artifact", "version", "testRunnerId", "rootPackage", "sdkVersion", "Lcom/intellij/openapi/projectRoots/JavaSdkVersion;", "languageId", "libraryIds", "", "dependencyConfig", "Lcom/intellij/ide/starters/local/DependencyConfig;", "properties", "", "assets", "", "Lcom/intellij/ide/starters/local/GeneratorAsset;", "outputDirectory", "Ljava/nio/file/Path;", "includeExamples", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/projectRoots/JavaSdkVersion;Ljava/lang/String;Ljava/util/Set;Lcom/intellij/ide/starters/local/DependencyConfig;Ljava/util/Map;Ljava/util/List;Ljava/nio/file/Path;Z)V", "getStarterId", "()Ljava/lang/String;", "getModuleName", "getGroup", "getArtifact", "getVersion", "getTestRunnerId", "getRootPackage", "getSdkVersion", "()Lcom/intellij/openapi/projectRoots/JavaSdkVersion;", "getAssets", "()Ljava/util/List;", "getOutputDirectory", "()Ljava/nio/file/Path;", "getIncludeExamples", "()Z", "hasLanguage", "hasLibrary", "libraryId", "hasLibraries", "hasAnyLibrary", "ids", "", "([Ljava/lang/String;)Z", "hasAllLibraries", "getBomProperty", "propertyId", "getProperty", "asPlaceholder", "isSdkAtLeast", "rootPackagePath", "getRootPackagePath$annotations", "()V", "getRootPackagePath", "sdkFeatureVersion", "", "getSdkFeatureVersion", "()I", "intellij.java.ui"})
@SourceDebugExtension(value={"SMAP\nGeneratorContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeneratorContext.kt\ncom/intellij/ide/starters/local/GeneratorContext\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n13225#2,2:79\n13022#2,2:81\n1#3:83\n*S KotlinDebug\n*F\n+ 1 GeneratorContext.kt\ncom/intellij/ide/starters/local/GeneratorContext\n*L\n37#1:79,2\n41#1:81,2\n*E\n"})
public final class GeneratorContext {
    @NotNull
    private final String starterId;
    @NotNull
    private final String moduleName;
    @NotNull
    private final String group;
    @NotNull
    private final String artifact;
    @NotNull
    private final String version;
    @Nullable
    private final String testRunnerId;
    @NotNull
    private final String rootPackage;
    @Nullable
    private final JavaSdkVersion sdkVersion;
    @NotNull
    private final String languageId;
    @NotNull
    private final Set<String> libraryIds;
    @NotNull
    private final DependencyConfig dependencyConfig;
    @NotNull
    private final Map<String, String> properties;
    @NotNull
    private final List<GeneratorAsset> assets;
    @NotNull
    private final Path outputDirectory;
    private final boolean includeExamples;

    public GeneratorContext(@NotNull String starterId, @NotNull String moduleName, @NotNull String group, @NotNull String artifact, @NotNull String version, @Nullable String testRunnerId, @NotNull String rootPackage, @Nullable JavaSdkVersion sdkVersion, @NotNull String languageId, @NotNull Set<String> libraryIds, @NotNull DependencyConfig dependencyConfig, @NotNull Map<String, String> properties, @NotNull List<? extends GeneratorAsset> assets, @NotNull Path outputDirectory, boolean includeExamples) {
        Intrinsics.checkNotNullParameter((Object)starterId, (String)"starterId");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)rootPackage, (String)"rootPackage");
        Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
        Intrinsics.checkNotNullParameter(libraryIds, (String)"libraryIds");
        Intrinsics.checkNotNullParameter((Object)dependencyConfig, (String)"dependencyConfig");
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        Intrinsics.checkNotNullParameter(assets, (String)"assets");
        Intrinsics.checkNotNullParameter((Object)outputDirectory, (String)"outputDirectory");
        this.starterId = starterId;
        this.moduleName = moduleName;
        this.group = group;
        this.artifact = artifact;
        this.version = version;
        this.testRunnerId = testRunnerId;
        this.rootPackage = rootPackage;
        this.sdkVersion = sdkVersion;
        this.languageId = languageId;
        this.libraryIds = libraryIds;
        this.dependencyConfig = dependencyConfig;
        this.properties = properties;
        this.assets = assets;
        this.outputDirectory = outputDirectory;
        this.includeExamples = includeExamples;
    }

    public /* synthetic */ GeneratorContext(String string, String string2, String string3, String string4, String string5, String string6, String string7, JavaSdkVersion javaSdkVersion, String string8, Set set, DependencyConfig dependencyConfig, Map map, List list2, Path path, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x4000) != 0) {
            bl = true;
        }
        this(string, string2, string3, string4, string5, string6, string7, javaSdkVersion, string8, set, dependencyConfig, map, list2, path, bl);
    }

    @NotNull
    public final String getStarterId() {
        return this.starterId;
    }

    @NotNull
    public final String getModuleName() {
        return this.moduleName;
    }

    @NotNull
    public final String getGroup() {
        return this.group;
    }

    @NotNull
    public final String getArtifact() {
        return this.artifact;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    @Nullable
    public final String getTestRunnerId() {
        return this.testRunnerId;
    }

    @NotNull
    public final String getRootPackage() {
        return this.rootPackage;
    }

    @Nullable
    public final JavaSdkVersion getSdkVersion() {
        return this.sdkVersion;
    }

    @NotNull
    public final List<GeneratorAsset> getAssets() {
        return this.assets;
    }

    @NotNull
    public final Path getOutputDirectory() {
        return this.outputDirectory;
    }

    public final boolean getIncludeExamples() {
        return this.includeExamples;
    }

    public final boolean hasLanguage(@NotNull String languageId) {
        Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
        return Intrinsics.areEqual((Object)this.languageId, (Object)languageId);
    }

    public final boolean hasLibrary(@NotNull String libraryId) {
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        return this.libraryIds.contains(libraryId);
    }

    public final boolean hasLibraries() {
        return !((Collection)this.libraryIds).isEmpty();
    }

    public final boolean hasAnyLibrary(String ... ids) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)ids, (String)"ids");
            String[] $this$any$iv = ids;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!this.libraryIds.contains(it)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public final boolean hasAllLibraries(String ... ids) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)ids, (String)"ids");
            String[] $this$all$iv = ids;
            boolean $i$f$all = false;
            int n = $this$all$iv.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = $this$all$iv[i];
                boolean bl2 = false;
                if (this.libraryIds.contains(it)) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    @Nullable
    public final String getVersion(@NotNull String group, @NotNull String artifact) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
            Iterable iterable = this.dependencyConfig.getDependencies();
            for (Object t : iterable) {
                Dependency it = (Dependency)t;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getGroup(), (Object)group) && Intrinsics.areEqual((Object)it.getArtifact(), (Object)artifact))) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Dependency dependency = v0;
        return dependency != null ? dependency.getVersion() : null;
    }

    @Nullable
    public final String getBomProperty(@NotNull String propertyId) {
        Intrinsics.checkNotNullParameter((Object)propertyId, (String)"propertyId");
        return this.dependencyConfig.getProperties().get(propertyId);
    }

    @Nullable
    public final String getProperty(@NotNull String propertyId) {
        Intrinsics.checkNotNullParameter((Object)propertyId, (String)"propertyId");
        return this.properties.get(propertyId);
    }

    @NotNull
    public final String asPlaceholder(@NotNull String propertyId) {
        Intrinsics.checkNotNullParameter((Object)propertyId, (String)"propertyId");
        return "${" + propertyId + "}";
    }

    public final boolean isSdkAtLeast(@NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        JavaSdkVersion desiredSdkVersion = JavaSdkVersion.Companion.fromVersionString(version);
        return desiredSdkVersion != null && this.sdkVersion != null && this.sdkVersion.isAtLeast(desiredSdkVersion);
    }

    @NotNull
    public final String getRootPackagePath() {
        return StringsKt.removeSuffix((String)StringsKt.replace$default((String)this.rootPackage, (String)".", (String)"/", (boolean)false, (int)4, null), (CharSequence)"/");
    }

    public static /* synthetic */ void getRootPackagePath$annotations() {
    }

    public final int getSdkFeatureVersion() {
        JavaSdkVersion javaSdkVersion = this.sdkVersion;
        return javaSdkVersion != null && (javaSdkVersion = javaSdkVersion.getMaxLanguageLevel()) != null ? javaSdkVersion.feature() : 8;
    }
}

