/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starters.local.generator;

import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.starters.local.GeneratorAsset;
import com.intellij.ide.starters.local.GeneratorEmptyDirectory;
import com.intellij.ide.starters.local.GeneratorFile;
import com.intellij.ide.starters.local.GeneratorResourceFile;
import com.intellij.ide.starters.local.GeneratorTemplateFile;
import com.intellij.ide.starters.local.generator.AssetsProcessor;
import com.intellij.ide.starters.local.generator.EmptyDirectoryProcessingException;
import com.intellij.ide.starters.local.generator.FileProcessingException;
import com.intellij.ide.starters.local.generator.ResourceProcessingException;
import com.intellij.ide.starters.local.generator.TemplateProcessingException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.NioPathUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 !2\u00020\u0001:\u0001!B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00052\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bH\u0016J\u0018\u0010\u0004\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J,\u0010\u0004\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bH\u0002J\u0018\u0010\u0004\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0012H\u0002J\u0018\u0010\u0004\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\fH\u0014J\u0018\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0019H\u0014J\u0018\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\fH\u0014J\u0018\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\fH\u0014J\u001e\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00062\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0014\u00a8\u0006\""}, d2={"Lcom/intellij/ide/starters/local/generator/AssetsProcessorImpl;", "Lcom/intellij/ide/starters/local/generator/AssetsProcessor;", "<init>", "()V", "generateSources", "", "Ljava/nio/file/Path;", "outputDirectory", "assets", "Lcom/intellij/ide/starters/local/GeneratorAsset;", "templateProperties", "", "", "", "asset", "Lcom/intellij/ide/starters/local/GeneratorFile;", "Lcom/intellij/ide/starters/local/GeneratorTemplateFile;", "properties", "Lcom/intellij/ide/starters/local/GeneratorResourceFile;", "Lcom/intellij/ide/starters/local/GeneratorEmptyDirectory;", "writeText", "", "path", "content", "writeBytes", "", "findOrCreateFile", "relativePath", "findOrCreateDirectory", "addPosixFilePermissions", "permissions", "", "Ljava/nio/file/attribute/PosixFilePermission;", "Companion", "intellij.java.ui"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nAssetsProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AssetsProcessor.kt\ncom/intellij/ide/starters/local/generator/AssetsProcessorImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,145:1\n1586#2:146\n1661#2,3:147\n1#3:150\n13#4:151\n*S KotlinDebug\n*F\n+ 1 AssetsProcessor.kt\ncom/intellij/ide/starters/local/generator/AssetsProcessorImpl\n*L\n51#1:146\n51#1:147,3\n137#1:151\n*E\n"})
public class AssetsProcessorImpl
implements AssetsProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Path> generateSources(@NotNull Path outputDirectory, @NotNull List<? extends GeneratorAsset> assets, @NotNull Map<String, ? extends Object> templateProperties) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)outputDirectory, (String)"outputDirectory");
        Intrinsics.checkNotNullParameter(assets, (String)"assets");
        Intrinsics.checkNotNullParameter(templateProperties, (String)"templateProperties");
        Iterable $this$map$iv = assets;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Path path;
            void asset;
            GeneratorAsset generatorAsset = (GeneratorAsset)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var13_13 = asset;
            if (var13_13 instanceof GeneratorFile) {
                path = this.generateSources(outputDirectory, (GeneratorFile)asset);
            } else if (var13_13 instanceof GeneratorTemplateFile) {
                path = this.generateSources(outputDirectory, (GeneratorTemplateFile)asset, templateProperties);
            } else if (var13_13 instanceof GeneratorResourceFile) {
                path = this.generateSources(outputDirectory, (GeneratorResourceFile)asset);
            } else if (var13_13 instanceof GeneratorEmptyDirectory) {
                path = this.generateSources(outputDirectory, (GeneratorEmptyDirectory)asset);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            collection.add(path);
        }
        return (List)destination$iv$iv;
    }

    private final Path generateSources(Path outputDirectory, GeneratorFile asset) {
        try {
            Path file = this.findOrCreateFile(outputDirectory, asset.getRelativePath());
            this.addPosixFilePermissions(file, asset.getPermissions());
            this.writeBytes(file, asset.getContent());
            return file;
        }
        catch (IOException e) {
            throw new FileProcessingException(e);
        }
    }

    private final Path generateSources(Path outputDirectory, GeneratorTemplateFile asset, Map<String, ? extends Object> properties) {
        try {
            FileTemplateManager templateManager = FileTemplateManager.getDefaultInstance();
            Properties properties2 = templateManager.getDefaultProperties();
            Intrinsics.checkNotNullExpressionValue((Object)properties2, (String)"getDefaultProperties(...)");
            Properties defaultProperties = properties2;
            String string = asset.getTemplate().getText(MapsKt.plus((Map)defaultProperties, properties));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String content = string;
            Path file = this.findOrCreateFile(outputDirectory, asset.getRelativePath());
            this.addPosixFilePermissions(file, asset.getPermissions());
            this.writeText(file, content);
            return file;
        }
        catch (IOException e) {
            throw new TemplateProcessingException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Path generateSources(Path outputDirectory, GeneratorResourceFile asset) {
        try {
            byte[] byArray;
            Closeable closeable = asset.getResource().openStream();
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                byArray = ByteStreamsKt.readBytes((InputStream)it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            byte[] content = byArray;
            Path file = this.findOrCreateFile(outputDirectory, asset.getRelativePath());
            this.addPosixFilePermissions(file, asset.getPermissions());
            this.writeBytes(file, content);
            return file;
        }
        catch (IOException e) {
            throw new ResourceProcessingException(e);
        }
    }

    private final Path generateSources(Path outputDirectory, GeneratorEmptyDirectory asset) {
        try {
            Path file = this.findOrCreateDirectory(outputDirectory, asset.getRelativePath());
            this.addPosixFilePermissions(file, asset.getPermissions());
            return file;
        }
        catch (IOException e) {
            throw new EmptyDirectoryProcessingException(e);
        }
    }

    protected void writeText(@NotNull Path path, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        PathsKt.writeText$default((Path)path, (CharSequence)content, null, (OpenOption[])new OpenOption[0], (int)2, null);
    }

    protected void writeBytes(@NotNull Path path, @NotNull byte[] content) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        OpenOption[] openOptionArray = new OpenOption[]{};
        Files.write(path, content, Arrays.copyOf(openOptionArray, openOptionArray.length));
    }

    @NotNull
    protected Path findOrCreateFile(@NotNull Path path, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        LOG.info("Creating file " + relativePath + " in " + path);
        return NioPathUtil.findOrCreateFile((Path)path, (String)relativePath);
    }

    @NotNull
    protected Path findOrCreateDirectory(@NotNull Path path, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        LOG.info("Creating directory " + relativePath + " in " + path);
        return NioPathUtil.findOrCreateDirectory((Path)path, (String)relativePath);
    }

    protected void addPosixFilePermissions(@NotNull Path path, @NotNull Set<? extends PosixFilePermission> permissions) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        FileStore fileStore = Files.getFileStore(path);
        Intrinsics.checkNotNullExpressionValue((Object)fileStore, (String)"getFileStore(...)");
        if (fileStore.supportsFileAttributeView(PosixFileAttributeView.class)) {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            Set<PosixFilePermission> set = Files.getPosixFilePermissions(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
            Intrinsics.checkNotNullExpressionValue(set, (String)"getPosixFilePermissions(...)");
            Intrinsics.checkNotNullExpressionValue((Object)Files.setPosixFilePermissions(path, SetsKt.plus(set, (Iterable)permissions)), (String)"setPosixFilePermissions(...)");
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AssetsProcessor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ide/starters/local/generator/AssetsProcessorImpl$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.java.ui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

