/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starters.local.generator;

import com.intellij.ide.starters.local.generator.AssetsProcessorImpl;
import com.intellij.ide.starters.local.generator.TestFileSystemLocation;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0014J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\tH\u0014J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\tH\u0014J\u001e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0014\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ide/starters/local/generator/TestAssetsProcessorImpl;", "Lcom/intellij/ide/starters/local/generator/AssetsProcessorImpl;", "<init>", "()V", "writeText", "", "path", "Ljava/nio/file/Path;", "content", "", "writeBytes", "", "findOrCreateFile", "relativePath", "findOrCreateDirectory", "addPosixFilePermissions", "permissions", "", "Ljava/nio/file/attribute/PosixFilePermission;", "intellij.java.ui"})
@TestOnly
public final class TestAssetsProcessorImpl
extends AssetsProcessorImpl {
    @Override
    protected void writeText(@NotNull Path path, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        if (path instanceof TestFileSystemLocation) {
            WriteAction.runAndWait(() -> TestAssetsProcessorImpl.writeText$lambda$0(path, content));
            return;
        }
        super.writeText(path, content);
    }

    @Override
    protected void writeBytes(@NotNull Path path, @NotNull byte[] content) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        if (path instanceof TestFileSystemLocation) {
            WriteAction.runAndWait(() -> TestAssetsProcessorImpl.writeBytes$lambda$0(path, content));
            return;
        }
        super.writeBytes(path, content);
    }

    @Override
    @NotNull
    protected Path findOrCreateFile(@NotNull Path path, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        if (path instanceof TestFileSystemLocation) {
            VirtualFile vFile = (VirtualFile)WriteAction.computeAndWait(() -> TestAssetsProcessorImpl.findOrCreateFile$lambda$0(path, relativePath));
            Path debugPath = NioPathUtil.getResolvedPath((Path)((TestFileSystemLocation)path).getDebugPath(), (String)relativePath);
            Intrinsics.checkNotNull((Object)vFile);
            return new TestFileSystemLocation(vFile, debugPath);
        }
        return super.findOrCreateFile(path, relativePath);
    }

    @Override
    @NotNull
    protected Path findOrCreateDirectory(@NotNull Path path, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        if (path instanceof TestFileSystemLocation) {
            VirtualFile vFile = (VirtualFile)WriteAction.computeAndWait(() -> TestAssetsProcessorImpl.findOrCreateDirectory$lambda$0(path, relativePath));
            Path debugPath = NioPathUtil.getResolvedPath((Path)((TestFileSystemLocation)path).getDebugPath(), (String)relativePath);
            Intrinsics.checkNotNull((Object)vFile);
            return new TestFileSystemLocation(vFile, debugPath);
        }
        return super.findOrCreateDirectory(path, relativePath);
    }

    @Override
    protected void addPosixFilePermissions(@NotNull Path path, @NotNull Set<? extends PosixFilePermission> permissions) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        if (!(path instanceof TestFileSystemLocation)) {
            super.addPosixFilePermissions(path, permissions);
        }
    }

    private static final void writeText$lambda$0(Path $path, String $content) {
        VirtualFileUtil.writeText((VirtualFile)((TestFileSystemLocation)$path).getVirtualFile(), (String)$content);
    }

    private static final void writeBytes$lambda$0(Path $path, byte[] $content) {
        VirtualFileUtil.writeBytes((VirtualFile)((TestFileSystemLocation)$path).getVirtualFile(), (byte[])$content);
    }

    private static final VirtualFile findOrCreateFile$lambda$0(Path $path, String $relativePath) {
        return VirtualFileUtil.findOrCreateFile((VirtualFile)((TestFileSystemLocation)$path).getVirtualFile(), (String)$relativePath);
    }

    private static final VirtualFile findOrCreateDirectory$lambda$0(Path $path, String $relativePath) {
        return VirtualFileUtil.findOrCreateDirectory((VirtualFile)((TestFileSystemLocation)$path).getVirtualFile(), (String)$relativePath);
    }
}

